/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.util.AttributeSet;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class LayoutIncludeDetector {
    private final Deque<WeakReference<XmlPullParser>> mXmlParserStack = new ArrayDeque<WeakReference<XmlPullParser>>();

    LayoutIncludeDetector() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isParserOutdated(XmlPullParser xmlPullParser) {
        boolean bl;
        boolean bl2 = bl = true;
        if (xmlPullParser == null) return bl2;
        bl2 = bl;
        try {
            if (xmlPullParser.getEventType() == 3) return bl2;
            int n = xmlPullParser.getEventType();
            if (n != 1) return false;
            return bl;
        }
        catch (XmlPullParserException xmlPullParserException) {
            return bl;
        }
    }

    private static XmlPullParser popOutdatedAttrHolders(Deque<WeakReference<XmlPullParser>> deque) {
        while (!deque.isEmpty()) {
            XmlPullParser xmlPullParser = (XmlPullParser)deque.peek().get();
            if (LayoutIncludeDetector.isParserOutdated(xmlPullParser)) {
                deque.pop();
                continue;
            }
            return xmlPullParser;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldInheritContext(XmlPullParser xmlPullParser, XmlPullParser xmlPullParser2) {
        if (xmlPullParser2 == null) return false;
        if (xmlPullParser == xmlPullParser2) return false;
        try {
            if (xmlPullParser2.getEventType() != 2) return false;
            return "include".equals(xmlPullParser2.getName());
        }
        catch (XmlPullParserException xmlPullParserException) {
            return false;
        }
    }

    boolean detect(AttributeSet attributeSet) {
        XmlPullParser xmlPullParser;
        if (attributeSet instanceof XmlPullParser && (xmlPullParser = (XmlPullParser)attributeSet).getDepth() == 1) {
            attributeSet = LayoutIncludeDetector.popOutdatedAttrHolders(this.mXmlParserStack);
            this.mXmlParserStack.push(new WeakReference<XmlPullParser>(xmlPullParser));
            if (LayoutIncludeDetector.shouldInheritContext(xmlPullParser, (XmlPullParser)attributeSet)) {
                return true;
            }
        }
        return false;
    }
}

