/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.view;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import androidx.appcompat.R;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuItemWrapperICS;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.view.ActionProvider;
import androidx.core.view.MenuItemCompat;
import java.io.IOException;
import java.lang.reflect.Method;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SupportMenuInflater
extends MenuInflater {
    static final Class<?>[] ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE;
    static final Class<?>[] ACTION_VIEW_CONSTRUCTOR_SIGNATURE;
    static final String LOG_TAG = "SupportMenuInflater";
    static final int NO_ID = 0;
    private static final String XML_GROUP = "group";
    private static final String XML_ITEM = "item";
    private static final String XML_MENU = "menu";
    final Object[] mActionProviderConstructorArguments;
    final Object[] mActionViewConstructorArguments;
    Context mContext;
    private Object mRealOwner;

    static {
        Class[] classArray = new Class[]{Context.class};
        ACTION_VIEW_CONSTRUCTOR_SIGNATURE = classArray;
        ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE = classArray;
    }

    public SupportMenuInflater(Context context) {
        super(context);
        this.mContext = context;
        Object[] objectArray = new Object[]{context};
        this.mActionViewConstructorArguments = objectArray;
        this.mActionProviderConstructorArguments = objectArray;
    }

    private Object findRealOwner(Object object) {
        if (object instanceof Activity) {
            return object;
        }
        Object object2 = object;
        if (object instanceof ContextWrapper) {
            object2 = this.findRealOwner(((ContextWrapper)object).getBaseContext());
        }
        return object2;
    }

    private void parseMenu(XmlPullParser object, AttributeSet attributeSet, Menu object2) throws XmlPullParserException, IOException {
        int n;
        int n2;
        MenuState menuState;
        block27: {
            menuState = new MenuState((Menu)object2);
            n2 = object.getEventType();
            do {
                if (n2 == 2) {
                    object2 = object.getName();
                    if (((String)object2).equals(XML_MENU)) {
                        n2 = object.next();
                        break block27;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Expecting menu, got ");
                    ((StringBuilder)object).append((String)object2);
                    throw new RuntimeException(((StringBuilder)object).toString());
                }
                n2 = n = object.next();
            } while (n != 1);
            n2 = n;
        }
        Object object3 = null;
        boolean bl = false;
        n = 0;
        while (!bl) {
            if (n2 != 1) {
                boolean bl2;
                if (n2 != 2) {
                    if (n2 != 3) {
                        bl2 = bl;
                        n2 = n;
                        object2 = object3;
                    } else {
                        String string2 = object.getName();
                        if (n != 0 && string2.equals(object3)) {
                            object2 = null;
                            n2 = 0;
                            bl2 = bl;
                        } else if (string2.equals(XML_GROUP)) {
                            menuState.resetGroup();
                            bl2 = bl;
                            n2 = n;
                            object2 = object3;
                        } else if (string2.equals(XML_ITEM)) {
                            bl2 = bl;
                            n2 = n;
                            object2 = object3;
                            if (!menuState.hasAddedItem()) {
                                if (menuState.itemActionProvider != null && menuState.itemActionProvider.hasSubMenu()) {
                                    menuState.addSubMenuItem();
                                    bl2 = bl;
                                    n2 = n;
                                    object2 = object3;
                                } else {
                                    menuState.addItem();
                                    bl2 = bl;
                                    n2 = n;
                                    object2 = object3;
                                }
                            }
                        } else {
                            bl2 = bl;
                            n2 = n;
                            object2 = object3;
                            if (string2.equals(XML_MENU)) {
                                bl2 = true;
                                n2 = n;
                                object2 = object3;
                            }
                        }
                    }
                } else if (n != 0) {
                    bl2 = bl;
                    n2 = n;
                    object2 = object3;
                } else {
                    object2 = object.getName();
                    if (((String)object2).equals(XML_GROUP)) {
                        menuState.readGroup(attributeSet);
                        bl2 = bl;
                        n2 = n;
                        object2 = object3;
                    } else if (((String)object2).equals(XML_ITEM)) {
                        menuState.readItem(attributeSet);
                        bl2 = bl;
                        n2 = n;
                        object2 = object3;
                    } else if (((String)object2).equals(XML_MENU)) {
                        this.parseMenu((XmlPullParser)object, attributeSet, (Menu)menuState.addSubMenuItem());
                        bl2 = bl;
                        n2 = n;
                        object2 = object3;
                    } else {
                        n2 = 1;
                        bl2 = bl;
                    }
                }
                int n3 = object.next();
                bl = bl2;
                n = n2;
                object3 = object2;
                n2 = n3;
                continue;
            }
            throw new RuntimeException("Unexpected end of document");
        }
    }

    Object getRealOwner() {
        if (this.mRealOwner == null) {
            this.mRealOwner = this.findRealOwner(this.mContext);
        }
        return this.mRealOwner;
    }

    /*
     * Exception decompiling
     */
    public void inflate(int var1_1, Menu var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6 : 79->84)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class InflatedOnMenuItemClickListener
    implements MenuItem.OnMenuItemClickListener {
        private static final Class<?>[] PARAM_TYPES = new Class[]{MenuItem.class};
        private Method mMethod;
        private Object mRealOwner;

        public InflatedOnMenuItemClickListener(Object object, String string2) {
            this.mRealOwner = object;
            Class<?> clazz = object.getClass();
            try {
                this.mMethod = clazz.getMethod(string2, PARAM_TYPES);
                return;
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Couldn't resolve menu item onClick handler ");
                stringBuilder.append(string2);
                stringBuilder.append(" in class ");
                stringBuilder.append(clazz.getName());
                string2 = new InflateException(stringBuilder.toString());
                string2.initCause((Throwable)exception);
                throw string2;
            }
        }

        public boolean onMenuItemClick(MenuItem menuItem) {
            try {
                if (this.mMethod.getReturnType() == Boolean.TYPE) {
                    return (Boolean)this.mMethod.invoke(this.mRealOwner, menuItem);
                }
                this.mMethod.invoke(this.mRealOwner, menuItem);
                return true;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private class MenuState {
        private static final int defaultGroupId = 0;
        private static final int defaultItemCategory = 0;
        private static final int defaultItemCheckable = 0;
        private static final boolean defaultItemChecked = false;
        private static final boolean defaultItemEnabled = true;
        private static final int defaultItemId = 0;
        private static final int defaultItemOrder = 0;
        private static final boolean defaultItemVisible = true;
        private int groupCategory;
        private int groupCheckable;
        private boolean groupEnabled;
        private int groupId;
        private int groupOrder;
        private boolean groupVisible;
        ActionProvider itemActionProvider;
        private String itemActionProviderClassName;
        private String itemActionViewClassName;
        private int itemActionViewLayout;
        private boolean itemAdded;
        private int itemAlphabeticModifiers;
        private char itemAlphabeticShortcut;
        private int itemCategoryOrder;
        private int itemCheckable;
        private boolean itemChecked;
        private CharSequence itemContentDescription;
        private boolean itemEnabled;
        private int itemIconResId;
        private ColorStateList itemIconTintList = null;
        private PorterDuff.Mode itemIconTintMode = null;
        private int itemId;
        private String itemListenerMethodName;
        private int itemNumericModifiers;
        private char itemNumericShortcut;
        private int itemShowAsAction;
        private CharSequence itemTitle;
        private CharSequence itemTitleCondensed;
        private CharSequence itemTooltipText;
        private boolean itemVisible;
        private Menu menu;

        public MenuState(Menu menu2) {
            this.menu = menu2;
            this.resetGroup();
        }

        private char getShortcut(String string2) {
            if (string2 == null) {
                return '\u0000';
            }
            return string2.charAt(0);
        }

        private <T> T newInstance(String string2, Class<?>[] object, Object[] objectArray) {
            try {
                object = Class.forName(string2, false, SupportMenuInflater.this.mContext.getClassLoader()).getConstructor((Class<?>)object);
                object.setAccessible(true);
                object = object.newInstance(objectArray);
            }
            catch (Exception exception) {
                object = new StringBuilder();
                object.append("Cannot instantiate class: ");
                object.append(string2);
                Log.w((String)SupportMenuInflater.LOG_TAG, (String)object.toString(), (Throwable)exception);
                return null;
            }
            return (T)object;
        }

        private void setItem(MenuItem menuItem) {
            Object object = menuItem.setChecked(this.itemChecked).setVisible(this.itemVisible).setEnabled(this.itemEnabled);
            int n = this.itemCheckable;
            boolean bl = false;
            boolean bl2 = n >= 1;
            object.setCheckable(bl2).setTitleCondensed(this.itemTitleCondensed).setIcon(this.itemIconResId);
            n = this.itemShowAsAction;
            if (n >= 0) {
                menuItem.setShowAsAction(n);
            }
            if (this.itemListenerMethodName != null) {
                if (!SupportMenuInflater.this.mContext.isRestricted()) {
                    menuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)new InflatedOnMenuItemClickListener(SupportMenuInflater.this.getRealOwner(), this.itemListenerMethodName));
                } else {
                    throw new IllegalStateException("The android:onClick attribute cannot be used within a restricted context");
                }
            }
            if (this.itemCheckable >= 2) {
                if (menuItem instanceof MenuItemImpl) {
                    ((MenuItemImpl)menuItem).setExclusiveCheckable(true);
                } else if (menuItem instanceof MenuItemWrapperICS) {
                    ((MenuItemWrapperICS)menuItem).setExclusiveCheckable(true);
                }
            }
            if ((object = this.itemActionViewClassName) != null) {
                menuItem.setActionView((View)this.newInstance((String)object, ACTION_VIEW_CONSTRUCTOR_SIGNATURE, SupportMenuInflater.this.mActionViewConstructorArguments));
                bl = true;
            }
            if ((n = this.itemActionViewLayout) > 0) {
                if (!bl) {
                    menuItem.setActionView(n);
                } else {
                    Log.w((String)SupportMenuInflater.LOG_TAG, (String)"Ignoring attribute 'itemActionViewLayout'. Action view already specified.");
                }
            }
            if ((object = this.itemActionProvider) != null) {
                MenuItemCompat.setActionProvider(menuItem, (ActionProvider)object);
            }
            MenuItemCompat.setContentDescription(menuItem, this.itemContentDescription);
            MenuItemCompat.setTooltipText(menuItem, this.itemTooltipText);
            MenuItemCompat.setAlphabeticShortcut(menuItem, this.itemAlphabeticShortcut, this.itemAlphabeticModifiers);
            MenuItemCompat.setNumericShortcut(menuItem, this.itemNumericShortcut, this.itemNumericModifiers);
            object = this.itemIconTintMode;
            if (object != null) {
                MenuItemCompat.setIconTintMode(menuItem, (PorterDuff.Mode)object);
            }
            if ((object = this.itemIconTintList) != null) {
                MenuItemCompat.setIconTintList(menuItem, (ColorStateList)object);
            }
        }

        public void addItem() {
            this.itemAdded = true;
            this.setItem(this.menu.add(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle));
        }

        public SubMenu addSubMenuItem() {
            this.itemAdded = true;
            SubMenu subMenu = this.menu.addSubMenu(this.groupId, this.itemId, this.itemCategoryOrder, this.itemTitle);
            this.setItem(subMenu.getItem());
            return subMenu;
        }

        public boolean hasAddedItem() {
            return this.itemAdded;
        }

        public void readGroup(AttributeSet attributeSet) {
            attributeSet = SupportMenuInflater.this.mContext.obtainStyledAttributes(attributeSet, R.styleable.MenuGroup);
            this.groupId = attributeSet.getResourceId(R.styleable.MenuGroup_android_id, 0);
            this.groupCategory = attributeSet.getInt(R.styleable.MenuGroup_android_menuCategory, 0);
            this.groupOrder = attributeSet.getInt(R.styleable.MenuGroup_android_orderInCategory, 0);
            this.groupCheckable = attributeSet.getInt(R.styleable.MenuGroup_android_checkableBehavior, 0);
            this.groupVisible = attributeSet.getBoolean(R.styleable.MenuGroup_android_visible, true);
            this.groupEnabled = attributeSet.getBoolean(R.styleable.MenuGroup_android_enabled, true);
            attributeSet.recycle();
        }

        public void readItem(AttributeSet object) {
            String string2;
            object = TintTypedArray.obtainStyledAttributes(SupportMenuInflater.this.mContext, (AttributeSet)object, R.styleable.MenuItem);
            this.itemId = ((TintTypedArray)object).getResourceId(R.styleable.MenuItem_android_id, 0);
            this.itemCategoryOrder = ((TintTypedArray)object).getInt(R.styleable.MenuItem_android_menuCategory, this.groupCategory) & 0xFFFF0000 | ((TintTypedArray)object).getInt(R.styleable.MenuItem_android_orderInCategory, this.groupOrder) & 0xFFFF;
            this.itemTitle = ((TintTypedArray)object).getText(R.styleable.MenuItem_android_title);
            this.itemTitleCondensed = ((TintTypedArray)object).getText(R.styleable.MenuItem_android_titleCondensed);
            this.itemIconResId = ((TintTypedArray)object).getResourceId(R.styleable.MenuItem_android_icon, 0);
            this.itemAlphabeticShortcut = this.getShortcut(((TintTypedArray)object).getString(R.styleable.MenuItem_android_alphabeticShortcut));
            this.itemAlphabeticModifiers = ((TintTypedArray)object).getInt(R.styleable.MenuItem_alphabeticModifiers, 4096);
            this.itemNumericShortcut = this.getShortcut(((TintTypedArray)object).getString(R.styleable.MenuItem_android_numericShortcut));
            this.itemNumericModifiers = ((TintTypedArray)object).getInt(R.styleable.MenuItem_numericModifiers, 4096);
            this.itemCheckable = ((TintTypedArray)object).hasValue(R.styleable.MenuItem_android_checkable) ? (int)(((TintTypedArray)object).getBoolean(R.styleable.MenuItem_android_checkable, false) ? 1 : 0) : this.groupCheckable;
            this.itemChecked = ((TintTypedArray)object).getBoolean(R.styleable.MenuItem_android_checked, false);
            this.itemVisible = ((TintTypedArray)object).getBoolean(R.styleable.MenuItem_android_visible, this.groupVisible);
            this.itemEnabled = ((TintTypedArray)object).getBoolean(R.styleable.MenuItem_android_enabled, this.groupEnabled);
            this.itemShowAsAction = ((TintTypedArray)object).getInt(R.styleable.MenuItem_showAsAction, -1);
            this.itemListenerMethodName = ((TintTypedArray)object).getString(R.styleable.MenuItem_android_onClick);
            this.itemActionViewLayout = ((TintTypedArray)object).getResourceId(R.styleable.MenuItem_actionLayout, 0);
            this.itemActionViewClassName = ((TintTypedArray)object).getString(R.styleable.MenuItem_actionViewClass);
            this.itemActionProviderClassName = string2 = ((TintTypedArray)object).getString(R.styleable.MenuItem_actionProviderClass);
            boolean bl = string2 != null;
            if (bl && this.itemActionViewLayout == 0 && this.itemActionViewClassName == null) {
                this.itemActionProvider = (ActionProvider)this.newInstance(string2, ACTION_PROVIDER_CONSTRUCTOR_SIGNATURE, SupportMenuInflater.this.mActionProviderConstructorArguments);
            } else {
                if (bl) {
                    Log.w((String)SupportMenuInflater.LOG_TAG, (String)"Ignoring attribute 'actionProviderClass'. Action view already specified.");
                }
                this.itemActionProvider = null;
            }
            this.itemContentDescription = ((TintTypedArray)object).getText(R.styleable.MenuItem_contentDescription);
            this.itemTooltipText = ((TintTypedArray)object).getText(R.styleable.MenuItem_tooltipText);
            this.itemIconTintMode = ((TintTypedArray)object).hasValue(R.styleable.MenuItem_iconTintMode) ? DrawableUtils.parseTintMode(((TintTypedArray)object).getInt(R.styleable.MenuItem_iconTintMode, -1), this.itemIconTintMode) : null;
            this.itemIconTintList = ((TintTypedArray)object).hasValue(R.styleable.MenuItem_iconTint) ? ((TintTypedArray)object).getColorStateList(R.styleable.MenuItem_iconTint) : null;
            ((TintTypedArray)object).recycle();
            this.itemAdded = false;
        }

        public void resetGroup() {
            this.groupId = 0;
            this.groupCategory = 0;
            this.groupOrder = 0;
            this.groupCheckable = 0;
            this.groupVisible = true;
            this.groupEnabled = true;
        }
    }
}

