/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.view.menu.BaseMenuPresenter;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuPresenter;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.ActionMenuPresenter;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.appcompat.widget.ViewUtils;

public class ActionMenuView
extends LinearLayoutCompat
implements MenuBuilder.ItemInvoker,
MenuView {
    static final int GENERATED_ITEM_PADDING = 4;
    static final int MIN_CELL_SIZE = 56;
    private static final String TAG = "ActionMenuView";
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    private boolean mFormatItems;
    private int mFormatItemsWidth;
    private int mGeneratedItemPadding;
    private MenuBuilder mMenu;
    MenuBuilder.Callback mMenuBuilderCallback;
    private int mMinCellSize;
    OnMenuItemClickListener mOnMenuItemClickListener;
    private Context mPopupContext;
    private int mPopupTheme;
    private ActionMenuPresenter mPresenter;
    private boolean mReserveOverflow;

    public ActionMenuView(Context context) {
        this(context, null);
    }

    public ActionMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setBaselineAligned(false);
        float f = context.getResources().getDisplayMetrics().density;
        this.mMinCellSize = (int)(56.0f * f);
        this.mGeneratedItemPadding = (int)(f * 4.0f);
        this.mPopupContext = context;
        this.mPopupTheme = 0;
    }

    static int measureChildForCells(View view, int n, int n2, int n3, int n4) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n5 = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)n3) - n4), (int)View.MeasureSpec.getMode((int)n3));
        ActionMenuItemView actionMenuItemView = view instanceof ActionMenuItemView ? (ActionMenuItemView)view : null;
        boolean bl = true;
        n3 = actionMenuItemView != null && actionMenuItemView.hasText() ? 1 : 0;
        n4 = 2;
        if (n2 > 0 && (n3 == 0 || n2 >= 2)) {
            int n6;
            view.measure(View.MeasureSpec.makeMeasureSpec((int)(n2 * n), (int)Integer.MIN_VALUE), n5);
            int n7 = view.getMeasuredWidth();
            n2 = n6 = n7 / n;
            if (n7 % n != 0) {
                n2 = n6 + 1;
            }
            if (n3 != 0 && n2 < 2) {
                n2 = n4;
            }
        } else {
            n2 = 0;
        }
        if (layoutParams.isOverflowButton || n3 == 0) {
            bl = false;
        }
        layoutParams.expandable = bl;
        layoutParams.cellsUsed = n2;
        view.measure(View.MeasureSpec.makeMeasureSpec((int)(n * n2), (int)0x40000000), n5);
        return n2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void onMeasureExactFormat(int var1_1, int var2_2) {
        block34: {
            block35: {
                block33: {
                    var3_3 = View.MeasureSpec.getMode((int)var2_2);
                    var4_4 = View.MeasureSpec.getSize((int)var1_1);
                    var5_5 = View.MeasureSpec.getSize((int)var2_2);
                    var1_1 = this.getPaddingLeft();
                    var6_6 = this.getPaddingRight();
                    var7_7 = this.getPaddingTop() + this.getPaddingBottom();
                    var8_8 = ActionMenuView.getChildMeasureSpec((int)var2_2, (int)var7_7, (int)-2);
                    var9_9 = var4_4 - (var1_1 + var6_6);
                    var2_2 = this.mMinCellSize;
                    if ((var1_1 = var9_9 / var2_2) == 0) {
                        this.setMeasuredDimension(var9_9, 0);
                        return;
                    }
                    var10_10 = var2_2 + var9_9 % var2_2 / var1_1;
                    var11_11 = this.getChildCount();
                    var4_4 = 0;
                    var6_6 = 0;
                    var13_13 = 0;
                    var14_14 = 0;
                    var15_15 = 0;
                    var16_16 = 0L;
                    for (var12_12 = 0; var12_12 < var11_11; ++var12_12) {
                        var18_17 /* !! */  = this.getChildAt(var12_12);
                        if (var18_17 /* !! */ .getVisibility() == 8) {
                            var2_2 = var15_15;
                        } else {
                            var19_18 = var18_17 /* !! */  instanceof ActionMenuItemView;
                            ++var13_13;
                            if (var19_18) {
                                var2_2 = this.mGeneratedItemPadding;
                                var18_17 /* !! */ .setPadding(var2_2, 0, var2_2, 0);
                            }
                            var20_19 = (LayoutParams)var18_17 /* !! */ .getLayoutParams();
                            var20_19.expanded = false;
                            var20_19.extraPixels = 0;
                            var20_19.cellsUsed = 0;
                            var20_19.expandable = false;
                            var20_19.leftMargin = 0;
                            var20_19.rightMargin = 0;
                            var19_18 = var19_18 != false && ((ActionMenuItemView)var18_17 /* !! */ ).hasText() != false;
                            var20_19.preventEdgeOffset = var19_18;
                            var2_2 = var20_19.isOverflowButton != false ? 1 : var1_1;
                            var21_20 = ActionMenuView.measureChildForCells(var18_17 /* !! */ , var10_10, var2_2, var8_8, var7_7);
                            var14_14 = Math.max(var14_14, var21_20);
                            var2_2 = var15_15;
                            if (var20_19.expandable) {
                                var2_2 = var15_15 + 1;
                            }
                            if (var20_19.isOverflowButton) {
                                var6_6 = 1;
                            }
                            var1_1 -= var21_20;
                            var4_4 = Math.max(var4_4, var18_17 /* !! */ .getMeasuredHeight());
                            if (var21_20 == 1) {
                                var16_16 |= (long)(1 << var12_12);
                            }
                        }
                        var15_15 = var2_2;
                    }
                    var12_12 = var6_6 != 0 && var13_13 == 2 ? 1 : 0;
                    var2_2 = 0;
                    var7_7 = var1_1;
                    var21_20 = var12_12;
                    var12_12 = var9_9;
                    while (var15_15 > 0 && var7_7 > 0) {
                        var22_21 = 0;
                        var9_9 = 0x7FFFFFFF;
                        var24_23 = 0L;
                        for (var23_22 = 0; var23_22 < var11_11; ++var23_22) {
                            var20_19 = (LayoutParams)this.getChildAt(var23_22).getLayoutParams();
                            if (!var20_19.expandable) {
                                var1_1 = var22_21;
                                var26_24 = var9_9;
                                var27_25 = var24_23;
                            } else if (var20_19.cellsUsed < var9_9) {
                                var26_24 = var20_19.cellsUsed;
                                var27_25 = 1L << var23_22;
                                var1_1 = 1;
                            } else {
                                var1_1 = var22_21;
                                var26_24 = var9_9;
                                var27_25 = var24_23;
                                if (var20_19.cellsUsed == var9_9) {
                                    var1_1 = var22_21 + 1;
                                    var27_25 = var24_23 | 1L << var23_22;
                                    var26_24 = var9_9;
                                }
                            }
                            var22_21 = var1_1;
                            var9_9 = var26_24;
                            var24_23 = var27_25;
                        }
                        var1_1 = var2_2;
                        var2_2 = var4_4;
                        var16_16 |= var24_23;
                        if (var22_21 <= var7_7) {
                            for (var1_1 = 0; var1_1 < var11_11; ++var1_1) {
                                var20_19 = this.getChildAt(var1_1);
                                var18_17 /* !! */  = (LayoutParams)var20_19.getLayoutParams();
                                var29_26 = 1 << var1_1;
                                if ((var24_23 & var29_26) == 0L) {
                                    var27_25 = var16_16;
                                    if (var18_17 /* !! */ .cellsUsed == var9_9 + 1) {
                                        var27_25 = var16_16 | var29_26;
                                    }
                                    var16_16 = var27_25;
                                    continue;
                                }
                                if (var21_20 != 0 && var18_17 /* !! */ .preventEdgeOffset && var7_7 == 1) {
                                    var4_4 = this.mGeneratedItemPadding;
                                    var20_19.setPadding(var4_4 + var10_10, 0, var4_4, 0);
                                }
                                ++var18_17 /* !! */ .cellsUsed;
                                var18_17 /* !! */ .expanded = true;
                                --var7_7;
                            }
                            var4_4 = var2_2;
                            var2_2 = 1;
                            continue;
                        }
                        break block33;
                    }
                    var1_1 = var2_2;
                    var2_2 = var4_4;
                }
                var4_4 = var6_6 == 0 && var13_13 == 1 ? 1 : 0;
                if (var7_7 <= 0 || var16_16 == 0L || var7_7 >= var13_13 - 1 && var4_4 == 0 && var14_14 <= true) break block35;
                var31_27 = Long.bitCount(var16_16);
                if (var4_4 == 0) {
                    var32_28 = var31_27;
                    if ((var16_16 & 1L) != 0L) {
                        var32_28 = var31_27;
                        if (!((LayoutParams)this.getChildAt((int)0).getLayoutParams()).preventEdgeOffset) {
                            var32_28 = var31_27 - 0.5f;
                        }
                    }
                    var4_4 = var11_11 - 1;
                    var31_27 = var32_28;
                    if ((var16_16 & (long)(1 << var4_4)) != 0L) {
                        var31_27 = var32_28;
                        if (!((LayoutParams)this.getChildAt((int)var4_4).getLayoutParams()).preventEdgeOffset) {
                            var31_27 = var32_28 - 0.5f;
                        }
                    }
                }
                var4_4 = var31_27 > 0.0f ? (int)((float)(var7_7 * var10_10) / var31_27) : 0;
                var6_6 = 0;
                while (true) {
                    block37: {
                        block38: {
                            block36: {
                                var15_15 = var1_1;
                                if (var6_6 >= var11_11) break block34;
                                if ((var16_16 & (long)(1 << var6_6)) != 0L) break block36;
                                var15_15 = var1_1;
                                break block37;
                            }
                            var18_17 /* !! */  = this.getChildAt(var6_6);
                            var20_19 = (LayoutParams)var18_17 /* !! */ .getLayoutParams();
                            if (!(var18_17 /* !! */  instanceof ActionMenuItemView)) break block38;
                            var20_19.extraPixels = var4_4;
                            var20_19.expanded = true;
                            if (var6_6 == 0 && !var20_19.preventEdgeOffset) {
                                var20_19.leftMargin = -var4_4 / 2;
                            }
                            ** GOTO lbl151
                        }
                        if (var20_19.isOverflowButton) {
                            var20_19.extraPixels = var4_4;
                            var20_19.expanded = true;
                            var20_19.rightMargin = -var4_4 / 2;
lbl151:
                            // 2 sources

                            var15_15 = 1;
                        } else {
                            if (var6_6 != 0) {
                                var20_19.leftMargin = var4_4 / 2;
                            }
                            var15_15 = var1_1;
                            if (var6_6 != var11_11 - 1) {
                                var20_19.rightMargin = var4_4 / 2;
                                var15_15 = var1_1;
                            }
                        }
                    }
                    ++var6_6;
                    var1_1 = var15_15;
                }
            }
            var15_15 = var1_1;
        }
        if (var15_15 != 0) {
            for (var1_1 = 0; var1_1 < var11_11; ++var1_1) {
                var20_19 = this.getChildAt(var1_1);
                var18_17 /* !! */  = (LayoutParams)var20_19.getLayoutParams();
                if (!var18_17 /* !! */ .expanded) continue;
                var20_19.measure(View.MeasureSpec.makeMeasureSpec((int)(var18_17 /* !! */ .cellsUsed * var10_10 + var18_17 /* !! */ .extraPixels), (int)0x40000000), var8_8);
            }
        }
        var1_1 = var3_3 != 0x40000000 ? var2_2 : var5_5;
        this.setMeasuredDimension(var12_12, var1_1);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void dismissPopupMenus() {
        ActionMenuPresenter actionMenuPresenter = this.mPresenter;
        if (actionMenuPresenter != null) {
            actionMenuPresenter.dismissPopupMenus();
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return false;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        LayoutParams layoutParams = new LayoutParams(-2, -2);
        layoutParams.gravity = 16;
        return layoutParams;
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams object) {
        if (object != null) {
            object = object instanceof LayoutParams ? new LayoutParams((LayoutParams)((Object)object)) : new LayoutParams((ViewGroup.LayoutParams)object);
            if (object.gravity <= 0) {
                object.gravity = 16;
            }
            return object;
        }
        return this.generateDefaultLayoutParams();
    }

    public LayoutParams generateOverflowButtonLayoutParams() {
        LayoutParams layoutParams = this.generateDefaultLayoutParams();
        layoutParams.isOverflowButton = true;
        return layoutParams;
    }

    public Menu getMenu() {
        if (this.mMenu == null) {
            Object object = this.getContext();
            Object object2 = new MenuBuilder((Context)object);
            this.mMenu = object2;
            ((MenuBuilder)object2).setCallback(new MenuBuilderCallback());
            this.mPresenter = object2 = new ActionMenuPresenter((Context)object);
            ((ActionMenuPresenter)object2).setReserveOverflow(true);
            object = this.mPresenter;
            object2 = this.mActionMenuPresenterCallback;
            if (object2 == null) {
                object2 = new ActionMenuPresenterCallback();
            }
            ((BaseMenuPresenter)object).setCallback((MenuPresenter.Callback)object2);
            this.mMenu.addMenuPresenter(this.mPresenter, this.mPopupContext);
            this.mPresenter.setMenuView(this);
        }
        return this.mMenu;
    }

    public Drawable getOverflowIcon() {
        this.getMenu();
        return this.mPresenter.getOverflowIcon();
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    @Override
    public int getWindowAnimations() {
        return 0;
    }

    protected boolean hasSupportDividerBeforeChildAt(int n) {
        boolean bl = false;
        if (n == 0) {
            return false;
        }
        View view = this.getChildAt(n - 1);
        View view2 = this.getChildAt(n);
        boolean bl2 = bl;
        if (n < this.getChildCount()) {
            bl2 = bl;
            if (view instanceof ActionMenuChildView) {
                bl2 = false | ((ActionMenuChildView)view).needsDividerAfter();
            }
        }
        bl = bl2;
        if (n > 0) {
            bl = bl2;
            if (view2 instanceof ActionMenuChildView) {
                bl = bl2 | ((ActionMenuChildView)view2).needsDividerBefore();
            }
        }
        return bl;
    }

    public boolean hideOverflowMenu() {
        ActionMenuPresenter actionMenuPresenter = this.mPresenter;
        boolean bl = actionMenuPresenter != null && actionMenuPresenter.hideOverflowMenu();
        return bl;
    }

    @Override
    public void initialize(MenuBuilder menuBuilder) {
        this.mMenu = menuBuilder;
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    public boolean isOverflowMenuShowPending() {
        ActionMenuPresenter actionMenuPresenter = this.mPresenter;
        boolean bl = actionMenuPresenter != null && actionMenuPresenter.isOverflowMenuShowPending();
        return bl;
    }

    public boolean isOverflowMenuShowing() {
        ActionMenuPresenter actionMenuPresenter = this.mPresenter;
        boolean bl = actionMenuPresenter != null && actionMenuPresenter.isOverflowMenuShowing();
        return bl;
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    public void onConfigurationChanged(Configuration object) {
        super.onConfigurationChanged((Configuration)object);
        object = this.mPresenter;
        if (object != null) {
            ((ActionMenuPresenter)object).updateMenuView(false);
            if (this.mPresenter.isOverflowMenuShowing()) {
                this.mPresenter.hideOverflowMenu();
                this.mPresenter.showOverflowMenu();
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissPopupMenus();
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Object object;
        Object object2;
        if (!this.mFormatItems) {
            super.onLayout(bl, n, n2, n3, n4);
            return;
        }
        int n7 = this.getChildCount();
        int n8 = (n4 - n2) / 2;
        int n9 = this.getDividerWidth();
        int n10 = n3 - n;
        n = n10 - this.getPaddingRight() - this.getPaddingLeft();
        bl = ViewUtils.isLayoutRtl((View)this);
        n4 = 0;
        n2 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            object2 = this.getChildAt(n3);
            if (object2.getVisibility() == 8) continue;
            object = (LayoutParams)object2.getLayoutParams();
            if (object.isOverflowButton) {
                n4 = n6 = object2.getMeasuredWidth();
                if (this.hasSupportDividerBeforeChildAt(n3)) {
                    n4 = n6 + n9;
                }
                int n11 = object2.getMeasuredHeight();
                if (bl) {
                    n6 = this.getPaddingLeft() + object.leftMargin;
                    n5 = n6 + n4;
                } else {
                    n5 = this.getWidth() - this.getPaddingRight() - object.rightMargin;
                    n6 = n5 - n4;
                }
                int n12 = n8 - n11 / 2;
                object2.layout(n6, n12, n5, n11 + n12);
                n -= n4;
                n4 = 1;
                continue;
            }
            n -= object2.getMeasuredWidth() + object.leftMargin + object.rightMargin;
            this.hasSupportDividerBeforeChildAt(n3);
            ++n2;
        }
        if (n7 == 1 && n4 == 0) {
            object = this.getChildAt(0);
            n2 = object.getMeasuredWidth();
            n = object.getMeasuredHeight();
            n3 = n10 / 2 - n2 / 2;
            n4 = n8 - n / 2;
            object.layout(n3, n4, n2 + n3, n + n4);
            return;
        }
        n = (n2 -= n4 ^ 1) > 0 ? (n /= n2) : 0;
        n4 = Math.max(0, n);
        if (bl) {
            n3 = this.getWidth() - this.getPaddingRight();
            for (n = 0; n < n7; ++n) {
                object = this.getChildAt(n);
                object2 = (LayoutParams)object.getLayoutParams();
                n2 = n3;
                if (object.getVisibility() != 8) {
                    if (object2.isOverflowButton) {
                        n2 = n3;
                    } else {
                        n2 = n3 - object2.rightMargin;
                        n3 = object.getMeasuredWidth();
                        n6 = object.getMeasuredHeight();
                        n5 = n8 - n6 / 2;
                        object.layout(n2 - n3, n5, n2, n6 + n5);
                        n2 -= n3 + object2.leftMargin + n4;
                    }
                }
                n3 = n2;
            }
        } else {
            n2 = this.getPaddingLeft();
            for (n = 0; n < n7; ++n) {
                object = this.getChildAt(n);
                object2 = (LayoutParams)object.getLayoutParams();
                n3 = n2;
                if (object.getVisibility() != 8) {
                    if (object2.isOverflowButton) {
                        n3 = n2;
                    } else {
                        n6 = object.getMeasuredWidth();
                        n5 = object.getMeasuredHeight();
                        n3 = n8 - n5 / 2;
                        object.layout(n2 += object2.leftMargin, n3, n2 + n6, n5 + n3);
                        n3 = n2 + (n6 + object2.rightMargin + n4);
                    }
                }
                n2 = n3;
            }
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        Object object;
        boolean bl = this.mFormatItems;
        boolean bl2 = View.MeasureSpec.getMode((int)n) == 0x40000000;
        this.mFormatItems = bl2;
        if (bl != bl2) {
            this.mFormatItemsWidth = 0;
        }
        int n3 = View.MeasureSpec.getSize((int)n);
        if (this.mFormatItems && (object = this.mMenu) != null && n3 != this.mFormatItemsWidth) {
            this.mFormatItemsWidth = n3;
            object.onItemsChanged(true);
        }
        int n4 = this.getChildCount();
        if (this.mFormatItems && n4 > 0) {
            this.onMeasureExactFormat(n, n2);
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                object = (LayoutParams)this.getChildAt(n3).getLayoutParams();
                ((LayoutParams)((Object)object)).rightMargin = 0;
                ((LayoutParams)((Object)object)).leftMargin = 0;
            }
            super.onMeasure(n, n2);
        }
    }

    public MenuBuilder peekMenu() {
        return this.mMenu;
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        this.mPresenter.setExpandedActionViewsExclusive(bl);
    }

    public void setMenuCallbacks(MenuPresenter.Callback callback, MenuBuilder.Callback callback2) {
        this.mActionMenuPresenterCallback = callback;
        this.mMenuBuilderCallback = callback2;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mOnMenuItemClickListener = onMenuItemClickListener;
    }

    public void setOverflowIcon(Drawable drawable2) {
        this.getMenu();
        this.mPresenter.setOverflowIcon(drawable2);
    }

    public void setOverflowReserved(boolean bl) {
        this.mReserveOverflow = bl;
    }

    public void setPopupTheme(int n) {
        if (this.mPopupTheme != n) {
            this.mPopupTheme = n;
            this.mPopupContext = n == 0 ? this.getContext() : new ContextThemeWrapper(this.getContext(), n);
        }
    }

    public void setPresenter(ActionMenuPresenter actionMenuPresenter) {
        this.mPresenter = actionMenuPresenter;
        actionMenuPresenter.setMenuView(this);
    }

    public boolean showOverflowMenu() {
        ActionMenuPresenter actionMenuPresenter = this.mPresenter;
        boolean bl = actionMenuPresenter != null && actionMenuPresenter.showOverflowMenu();
        return bl;
    }

    public static interface ActionMenuChildView {
        public boolean needsDividerAfter();

        public boolean needsDividerBefore();
    }

    private static class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        ActionMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return false;
        }
    }

    public static class LayoutParams
    extends LinearLayoutCompat.LayoutParams {
        @ViewDebug.ExportedProperty
        public int cellsUsed;
        @ViewDebug.ExportedProperty
        public boolean expandable;
        boolean expanded;
        @ViewDebug.ExportedProperty
        public int extraPixels;
        @ViewDebug.ExportedProperty
        public boolean isOverflowButton;
        @ViewDebug.ExportedProperty
        public boolean preventEdgeOffset;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.isOverflowButton = false;
        }

        LayoutParams(int n, int n2, boolean bl) {
            super(n, n2);
            this.isOverflowButton = bl;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.LayoutParams)layoutParams);
            this.isOverflowButton = layoutParams.isOverflowButton;
        }
    }

    private class MenuBuilderCallback
    implements MenuBuilder.Callback {
        MenuBuilderCallback() {
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
            boolean bl = ActionMenuView.this.mOnMenuItemClickListener != null && ActionMenuView.this.mOnMenuItemClickListener.onMenuItemClick(menuItem);
            return bl;
        }

        @Override
        public void onMenuModeChange(MenuBuilder menuBuilder) {
            if (ActionMenuView.this.mMenuBuilderCallback != null) {
                ActionMenuView.this.mMenuBuilderCallback.onMenuModeChange(menuBuilder);
            }
        }
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

