/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.ResourceManagerInternal;
import androidx.appcompat.widget.ThemeUtils;
import androidx.appcompat.widget.TintInfo;
import androidx.appcompat.widget.VectorEnabledTintResources;
import androidx.core.graphics.ColorUtils;

public final class AppCompatDrawableManager {
    private static final boolean DEBUG = false;
    private static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static AppCompatDrawableManager INSTANCE;
    private static final String TAG = "AppCompatDrawableManag";
    private ResourceManagerInternal mResourceManager;

    public static AppCompatDrawableManager get() {
        synchronized (AppCompatDrawableManager.class) {
            if (INSTANCE == null) {
                AppCompatDrawableManager.preload();
            }
            AppCompatDrawableManager appCompatDrawableManager = INSTANCE;
            return appCompatDrawableManager;
        }
    }

    public static PorterDuffColorFilter getPorterDuffColorFilter(int n, PorterDuff.Mode mode) {
        synchronized (AppCompatDrawableManager.class) {
            mode = ResourceManagerInternal.getPorterDuffColorFilter(n, mode);
            return mode;
        }
    }

    public static void preload() {
        synchronized (AppCompatDrawableManager.class) {
            if (INSTANCE == null) {
                Object object = new AppCompatDrawableManager();
                INSTANCE = object;
                ((AppCompatDrawableManager)object).mResourceManager = ResourceManagerInternal.get();
                object = AppCompatDrawableManager.INSTANCE.mResourceManager;
                ResourceManagerInternal.ResourceManagerHooks resourceManagerHooks = new ResourceManagerInternal.ResourceManagerHooks(){
                    private final int[] COLORFILTER_COLOR_BACKGROUND_MULTIPLY;
                    private final int[] COLORFILTER_COLOR_CONTROL_ACTIVATED;
                    private final int[] COLORFILTER_TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha, R.drawable.abc_ab_share_pack_mtrl_alpha};
                    private final int[] TINT_CHECKABLE_BUTTON_LIST;
                    private final int[] TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_seekbar_tick_mark_material, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha};
                    private final int[] TINT_COLOR_CONTROL_STATE_LIST;
                    {
                        this.COLORFILTER_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha, R.drawable.abc_text_cursor_material, R.drawable.abc_text_select_handle_left_mtrl, R.drawable.abc_text_select_handle_middle_mtrl, R.drawable.abc_text_select_handle_right_mtrl};
                        this.COLORFILTER_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
                        this.TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material};
                        this.TINT_CHECKABLE_BUTTON_LIST = new int[]{R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material, R.drawable.abc_btn_check_material_anim, R.drawable.abc_btn_radio_material_anim};
                    }

                    private boolean arrayContains(int[] nArray, int n) {
                        int n2 = nArray.length;
                        for (int i = 0; i < n2; ++i) {
                            if (nArray[i] != n) continue;
                            return true;
                        }
                        return false;
                    }

                    private ColorStateList createBorderlessButtonColorStateList(Context context) {
                        return this.createButtonColorStateList(context, 0);
                    }

                    private ColorStateList createButtonColorStateList(Context object, int n) {
                        int n2 = ThemeUtils.getThemeAttrColor(object, R.attr.colorControlHighlight);
                        int n3 = ThemeUtils.getDisabledThemeAttrColor(object, R.attr.colorButtonNormal);
                        object = ThemeUtils.DISABLED_STATE_SET;
                        int[] nArray = ThemeUtils.PRESSED_STATE_SET;
                        int n4 = ColorUtils.compositeColors(n2, n);
                        int[] nArray2 = ThemeUtils.FOCUSED_STATE_SET;
                        n2 = ColorUtils.compositeColors(n2, n);
                        return new ColorStateList((int[][])new int[][]{(int[])object, nArray, nArray2, ThemeUtils.EMPTY_STATE_SET}, new int[]{n3, n4, n2, n});
                    }

                    private ColorStateList createColoredButtonColorStateList(Context context) {
                        return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorAccent));
                    }

                    private ColorStateList createDefaultButtonColorStateList(Context context) {
                        return this.createButtonColorStateList(context, ThemeUtils.getThemeAttrColor(context, R.attr.colorButtonNormal));
                    }

                    private ColorStateList createSwitchThumbColorStateList(Context context) {
                        int[][] nArrayArray = new int[3][];
                        int[] nArray = new int[3];
                        ColorStateList colorStateList = ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorSwitchThumbNormal);
                        if (colorStateList != null && colorStateList.isStateful()) {
                            nArrayArray[0] = ThemeUtils.DISABLED_STATE_SET;
                            nArray[0] = colorStateList.getColorForState(nArrayArray[0], 0);
                            nArrayArray[1] = ThemeUtils.CHECKED_STATE_SET;
                            nArray[1] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
                            nArrayArray[2] = ThemeUtils.EMPTY_STATE_SET;
                            nArray[2] = colorStateList.getDefaultColor();
                        } else {
                            nArrayArray[0] = ThemeUtils.DISABLED_STATE_SET;
                            nArray[0] = ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
                            nArrayArray[1] = ThemeUtils.CHECKED_STATE_SET;
                            nArray[1] = ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated);
                            nArrayArray[2] = ThemeUtils.EMPTY_STATE_SET;
                            nArray[2] = ThemeUtils.getThemeAttrColor(context, R.attr.colorSwitchThumbNormal);
                        }
                        return new ColorStateList((int[][])nArrayArray, nArray);
                    }

                    private LayerDrawable getRatingBarLayerDrawable(ResourceManagerInternal resourceManagerInternal, Context context, int n) {
                        n = context.getResources().getDimensionPixelSize(n);
                        Drawable drawable2 = resourceManagerInternal.getDrawable(context, R.drawable.abc_star_black_48dp);
                        Drawable drawable3 = resourceManagerInternal.getDrawable(context, R.drawable.abc_star_half_black_48dp);
                        if (drawable2 instanceof BitmapDrawable && drawable2.getIntrinsicWidth() == n && drawable2.getIntrinsicHeight() == n) {
                            context = (BitmapDrawable)drawable2;
                            resourceManagerInternal = new BitmapDrawable(context.getBitmap());
                        } else {
                            resourceManagerInternal = Bitmap.createBitmap((int)n, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                            context = new Canvas((Bitmap)resourceManagerInternal);
                            drawable2.setBounds(0, 0, n, n);
                            drawable2.draw((Canvas)context);
                            context = new BitmapDrawable((Bitmap)resourceManagerInternal);
                            resourceManagerInternal = new BitmapDrawable((Bitmap)resourceManagerInternal);
                        }
                        resourceManagerInternal.setTileModeX(Shader.TileMode.REPEAT);
                        if (drawable3 instanceof BitmapDrawable && drawable3.getIntrinsicWidth() == n && drawable3.getIntrinsicHeight() == n) {
                            drawable3 = (BitmapDrawable)drawable3;
                        } else {
                            drawable2 = Bitmap.createBitmap((int)n, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                            Canvas canvas = new Canvas((Bitmap)drawable2);
                            drawable3.setBounds(0, 0, n, n);
                            drawable3.draw(canvas);
                            drawable3 = new BitmapDrawable((Bitmap)drawable2);
                        }
                        resourceManagerInternal = new LayerDrawable(new Drawable[]{context, drawable3, resourceManagerInternal});
                        resourceManagerInternal.setId(0, 0x1020000);
                        resourceManagerInternal.setId(1, 16908303);
                        resourceManagerInternal.setId(2, 16908301);
                        return resourceManagerInternal;
                    }

                    private void setPorterDuffColorFilter(Drawable drawable2, int n, PorterDuff.Mode mode) {
                        Drawable drawable3 = drawable2;
                        if (DrawableUtils.canSafelyMutateDrawable(drawable2)) {
                            drawable3 = drawable2.mutate();
                        }
                        drawable2 = mode;
                        if (mode == null) {
                            drawable2 = DEFAULT_MODE;
                        }
                        drawable3.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(n, (PorterDuff.Mode)drawable2));
                    }

                    @Override
                    public Drawable createDrawableFor(ResourceManagerInternal resourceManagerInternal, Context context, int n) {
                        if (n == R.drawable.abc_cab_background_top_material) {
                            return new LayerDrawable(new Drawable[]{resourceManagerInternal.getDrawable(context, R.drawable.abc_cab_background_internal_bg), resourceManagerInternal.getDrawable(context, R.drawable.abc_cab_background_top_mtrl_alpha)});
                        }
                        if (n == R.drawable.abc_ratingbar_material) {
                            return this.getRatingBarLayerDrawable(resourceManagerInternal, context, R.dimen.abc_star_big);
                        }
                        if (n == R.drawable.abc_ratingbar_indicator_material) {
                            return this.getRatingBarLayerDrawable(resourceManagerInternal, context, R.dimen.abc_star_medium);
                        }
                        if (n == R.drawable.abc_ratingbar_small_material) {
                            return this.getRatingBarLayerDrawable(resourceManagerInternal, context, R.dimen.abc_star_small);
                        }
                        return null;
                    }

                    @Override
                    public ColorStateList getTintListForDrawableRes(Context context, int n) {
                        if (n == R.drawable.abc_edit_text_material) {
                            return AppCompatResources.getColorStateList(context, R.color.abc_tint_edittext);
                        }
                        if (n == R.drawable.abc_switch_track_mtrl_alpha) {
                            return AppCompatResources.getColorStateList(context, R.color.abc_tint_switch_track);
                        }
                        if (n == R.drawable.abc_switch_thumb_material) {
                            return this.createSwitchThumbColorStateList(context);
                        }
                        if (n == R.drawable.abc_btn_default_mtrl_shape) {
                            return this.createDefaultButtonColorStateList(context);
                        }
                        if (n == R.drawable.abc_btn_borderless_material) {
                            return this.createBorderlessButtonColorStateList(context);
                        }
                        if (n == R.drawable.abc_btn_colored_material) {
                            return this.createColoredButtonColorStateList(context);
                        }
                        if (n != R.drawable.abc_spinner_mtrl_am_alpha && n != R.drawable.abc_spinner_textfield_background_material) {
                            if (this.arrayContains(this.TINT_COLOR_CONTROL_NORMAL, n)) {
                                return ThemeUtils.getThemeAttrColorStateList(context, R.attr.colorControlNormal);
                            }
                            if (this.arrayContains(this.TINT_COLOR_CONTROL_STATE_LIST, n)) {
                                return AppCompatResources.getColorStateList(context, R.color.abc_tint_default);
                            }
                            if (this.arrayContains(this.TINT_CHECKABLE_BUTTON_LIST, n)) {
                                return AppCompatResources.getColorStateList(context, R.color.abc_tint_btn_checkable);
                            }
                            if (n == R.drawable.abc_seekbar_thumb_material) {
                                return AppCompatResources.getColorStateList(context, R.color.abc_tint_seek_thumb);
                            }
                            return null;
                        }
                        return AppCompatResources.getColorStateList(context, R.color.abc_tint_spinner);
                    }

                    @Override
                    public PorterDuff.Mode getTintModeForDrawableRes(int n) {
                        Object object = n == R.drawable.abc_switch_thumb_material ? PorterDuff.Mode.MULTIPLY : null;
                        return object;
                    }

                    @Override
                    public boolean tintDrawable(Context context, int n, Drawable drawable2) {
                        if (n == R.drawable.abc_seekbar_track_material) {
                            drawable2 = (LayerDrawable)drawable2;
                            this.setPorterDuffColorFilter(drawable2.findDrawableByLayerId(0x1020000), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                            this.setPorterDuffColorFilter(drawable2.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                            this.setPorterDuffColorFilter(drawable2.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                            return true;
                        }
                        if (n != R.drawable.abc_ratingbar_material && n != R.drawable.abc_ratingbar_indicator_material && n != R.drawable.abc_ratingbar_small_material) {
                            return false;
                        }
                        drawable2 = (LayerDrawable)drawable2;
                        this.setPorterDuffColorFilter(drawable2.findDrawableByLayerId(0x1020000), ThemeUtils.getDisabledThemeAttrColor(context, R.attr.colorControlNormal), DEFAULT_MODE);
                        this.setPorterDuffColorFilter(drawable2.findDrawableByLayerId(16908303), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                        this.setPorterDuffColorFilter(drawable2.findDrawableByLayerId(16908301), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), DEFAULT_MODE);
                        return true;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean tintDrawableUsingColorFilter(Context var1_1, int var2_2, Drawable var3_3) {
                        block8: {
                            block10: {
                                block9: {
                                    var4_4 = AppCompatDrawableManager.access$000();
                                    var5_5 = this.arrayContains(this.COLORFILTER_TINT_COLOR_CONTROL_NORMAL, var2_2);
                                    var6_6 = 0x1010031;
                                    if (var5_5) {
                                        var2_2 = R.attr.colorControlNormal;
lbl6:
                                        // 4 sources

                                        while (true) {
                                            var6_6 = -1;
lbl8:
                                            // 2 sources

                                            while (true) {
                                                var7_7 = true;
                                                break block8;
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    if (!this.arrayContains(this.COLORFILTER_COLOR_CONTROL_ACTIVATED, var2_2)) break block9;
                                    var2_2 = R.attr.colorControlActivated;
                                    ** GOTO lbl6
                                }
                                if (!this.arrayContains(this.COLORFILTER_COLOR_BACKGROUND_MULTIPLY, var2_2)) break block10;
                                var4_4 = PorterDuff.Mode.MULTIPLY;
                                var2_2 = var6_6;
                                ** GOTO lbl6
                            }
                            if (var2_2 == R.drawable.abc_list_divider_mtrl_alpha) {
                                var2_2 = 0x1010030;
                                var6_6 = Math.round(40.8f);
                                ** continue;
                            }
                            if (var2_2 == R.drawable.abc_dialog_material_background) {
                                var2_2 = var6_6;
                                ** continue;
                            }
                            var6_6 = -1;
                            var7_7 = false;
                            var2_2 = 0;
                        }
                        if (var7_7) {
                            var8_8 = var3_3;
                            if (DrawableUtils.canSafelyMutateDrawable(var3_3)) {
                                var8_8 = var3_3.mutate();
                            }
                            var8_8.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter(ThemeUtils.getThemeAttrColor(var1_1, var2_2), var4_4));
                            if (var6_6 != -1) {
                                var8_8.setAlpha(var6_6);
                            }
                            return true;
                        }
                        return false;
                    }
                };
                ((ResourceManagerInternal)object).setHooks(resourceManagerHooks);
            }
            return;
        }
    }

    static void tintDrawable(Drawable drawable2, TintInfo tintInfo, int[] nArray) {
        ResourceManagerInternal.tintDrawable(drawable2, tintInfo, nArray);
    }

    public Drawable getDrawable(Context context, int n) {
        synchronized (this) {
            context = this.mResourceManager.getDrawable(context, n);
            return context;
        }
    }

    Drawable getDrawable(Context context, int n, boolean bl) {
        synchronized (this) {
            context = this.mResourceManager.getDrawable(context, n, bl);
            return context;
        }
    }

    ColorStateList getTintList(Context context, int n) {
        synchronized (this) {
            context = this.mResourceManager.getTintList(context, n);
            return context;
        }
    }

    public void onConfigurationChanged(Context context) {
        synchronized (this) {
            this.mResourceManager.onConfigurationChanged(context);
            return;
        }
    }

    Drawable onDrawableLoadedFromResources(Context context, VectorEnabledTintResources vectorEnabledTintResources, int n) {
        synchronized (this) {
            context = this.mResourceManager.onDrawableLoadedFromResources(context, vectorEnabledTintResources, n);
            return context;
        }
    }

    boolean tintDrawableUsingColorFilter(Context context, int n, Drawable drawable2) {
        return this.mResourceManager.tintDrawableUsingColorFilter(context, n, drawable2);
    }
}

