/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.res.TypedArray;
import android.text.method.KeyListener;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.EditText;
import androidx.appcompat.R;
import androidx.emoji2.viewsintegration.EmojiEditTextHelper;

class AppCompatEmojiEditTextHelper {
    private final EmojiEditTextHelper mEmojiEditTextHelper;
    private final EditText mView;

    AppCompatEmojiEditTextHelper(EditText editText) {
        this.mView = editText;
        this.mEmojiEditTextHelper = new EmojiEditTextHelper(editText, false);
    }

    KeyListener getKeyListener(KeyListener keyListener) {
        KeyListener keyListener2 = keyListener;
        if (this.isEmojiCapableKeyListener(keyListener)) {
            keyListener2 = this.mEmojiEditTextHelper.getKeyListener(keyListener);
        }
        return keyListener2;
    }

    boolean isEmojiCapableKeyListener(KeyListener keyListener) {
        return keyListener instanceof NumberKeyListener ^ true;
    }

    boolean isEnabled() {
        return this.mEmojiEditTextHelper.isEnabled();
    }

    void loadFromAttributes(AttributeSet attributeSet, int n) {
        boolean bl;
        TypedArray typedArray;
        block4: {
            typedArray = this.mView.getContext().obtainStyledAttributes(attributeSet, R.styleable.AppCompatTextView, n, 0);
            boolean bl2 = typedArray.hasValue(R.styleable.AppCompatTextView_emojiCompatEnabled);
            bl = true;
            if (!bl2) break block4;
            bl = typedArray.getBoolean(R.styleable.AppCompatTextView_emojiCompatEnabled, true);
        }
        this.setEnabled(bl);
        return;
        finally {
            typedArray.recycle();
        }
    }

    InputConnection onCreateInputConnection(InputConnection inputConnection, EditorInfo editorInfo) {
        return this.mEmojiEditTextHelper.onCreateInputConnection(inputConnection, editorInfo);
    }

    void setEnabled(boolean bl) {
        this.mEmojiEditTextHelper.setEnabled(bl);
    }
}

