/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Shader;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.graphics.drawable.WrappedDrawable;

class AppCompatProgressBarHelper {
    private static final int[] TINT_ATTRS = new int[]{16843067, 16843068};
    private Bitmap mSampleTile;
    private final ProgressBar mView;

    AppCompatProgressBarHelper(ProgressBar progressBar) {
        this.mView = progressBar;
    }

    private Shape getDrawableShape() {
        return new RoundRectShape(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f}, null, null);
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        Drawable drawable3 = drawable2;
        if (drawable2 instanceof AnimationDrawable) {
            drawable2 = (AnimationDrawable)drawable2;
            int n = drawable2.getNumberOfFrames();
            drawable3 = new AnimationDrawable();
            drawable3.setOneShot(drawable2.isOneShot());
            for (int i = 0; i < n; ++i) {
                Drawable drawable4 = this.tileify(drawable2.getFrame(i), true);
                drawable4.setLevel(10000);
                drawable3.addFrame(drawable4, drawable2.getDuration(i));
            }
            drawable3.setLevel(10000);
        }
        return drawable3;
    }

    Bitmap getSampleTile() {
        return this.mSampleTile;
    }

    void loadFromAttributes(AttributeSet object, int n) {
        object = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), (AttributeSet)object, TINT_ATTRS, n, 0);
        Drawable drawable2 = ((TintTypedArray)object).getDrawableIfKnown(0);
        if (drawable2 != null) {
            this.mView.setIndeterminateDrawable(this.tileifyIndeterminate(drawable2));
        }
        if ((drawable2 = ((TintTypedArray)object).getDrawableIfKnown(1)) != null) {
            this.mView.setProgressDrawable(this.tileify(drawable2, false));
        }
        ((TintTypedArray)object).recycle();
    }

    Drawable tileify(Drawable drawable2, boolean bl) {
        if (drawable2 instanceof WrappedDrawable) {
            WrappedDrawable wrappedDrawable = (WrappedDrawable)drawable2;
            Drawable drawable3 = wrappedDrawable.getWrappedDrawable();
            if (drawable3 != null) {
                wrappedDrawable.setWrappedDrawable(this.tileify(drawable3, bl));
            }
        } else {
            if (drawable2 instanceof LayerDrawable) {
                int n;
                drawable2 = (LayerDrawable)drawable2;
                int n2 = drawable2.getNumberOfLayers();
                LayerDrawable layerDrawable = new Drawable[n2];
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    int n4 = drawable2.getId(n);
                    Drawable drawable4 = drawable2.getDrawable(n);
                    bl = n4 == 16908301 || n4 == 16908303;
                    layerDrawable[n] = this.tileify(drawable4, bl);
                }
                layerDrawable = new LayerDrawable((Drawable[])layerDrawable);
                for (n = n3; n < n2; ++n) {
                    layerDrawable.setId(n, drawable2.getId(n));
                    if (Build.VERSION.SDK_INT < 23) continue;
                    Api23Impl.transferLayerProperties((LayerDrawable)drawable2, layerDrawable, n);
                }
                return layerDrawable;
            }
            if (drawable2 instanceof BitmapDrawable) {
                drawable2 = (BitmapDrawable)drawable2;
                Bitmap bitmap = drawable2.getBitmap();
                if (this.mSampleTile == null) {
                    this.mSampleTile = bitmap;
                }
                ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
                bitmap = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
                shapeDrawable.getPaint().setShader((Shader)bitmap);
                shapeDrawable.getPaint().setColorFilter(drawable2.getPaint().getColorFilter());
                drawable2 = shapeDrawable;
                if (bl) {
                    drawable2 = new ClipDrawable((Drawable)shapeDrawable, 3, 1);
                }
                return drawable2;
            }
        }
        return drawable2;
    }

    private static class Api23Impl {
        private Api23Impl() {
        }

        public static void transferLayerProperties(LayerDrawable layerDrawable, LayerDrawable layerDrawable2, int n) {
            layerDrawable2.setLayerGravity(n, layerDrawable.getLayerGravity(n));
            layerDrawable2.setLayerWidth(n, layerDrawable.getLayerWidth(n));
            layerDrawable2.setLayerHeight(n, layerDrawable.getLayerHeight(n));
            layerDrawable2.setLayerInsetLeft(n, layerDrawable.getLayerInsetLeft(n));
            layerDrawable2.setLayerInsetRight(n, layerDrawable.getLayerInsetRight(n));
            layerDrawable2.setLayerInsetTop(n, layerDrawable.getLayerInsetTop(n));
            layerDrawable2.setLayerInsetBottom(n, layerDrawable.getLayerInsetBottom(n));
            layerDrawable2.setLayerInsetStart(n, layerDrawable.getLayerInsetStart(n));
            layerDrawable2.setLayerInsetEnd(n, layerDrawable.getLayerInsetEnd(n));
        }
    }
}

