/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.LocaleList;
import android.text.method.PasswordTransformationMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.TextView;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatDrawableManager;
import androidx.appcompat.widget.AppCompatTextViewAutoSizeHelper;
import androidx.appcompat.widget.DrawableUtils;
import androidx.appcompat.widget.TintInfo;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.inputmethod.EditorInfoCompat;
import androidx.core.widget.AutoSizeableTextView;
import androidx.core.widget.TextViewCompat;
import java.lang.ref.WeakReference;
import java.util.Locale;

class AppCompatTextHelper {
    private static final int MONOSPACE = 3;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int TEXT_FONT_WEIGHT_UNSPECIFIED = -1;
    private boolean mAsyncFontPending;
    private final AppCompatTextViewAutoSizeHelper mAutoSizeTextHelper;
    private TintInfo mDrawableBottomTint;
    private TintInfo mDrawableEndTint;
    private TintInfo mDrawableLeftTint;
    private TintInfo mDrawableRightTint;
    private TintInfo mDrawableStartTint;
    private TintInfo mDrawableTint;
    private TintInfo mDrawableTopTint;
    private Typeface mFontTypeface;
    private int mFontWeight = -1;
    private int mStyle = 0;
    private final TextView mView;

    AppCompatTextHelper(TextView textView) {
        this.mView = textView;
        this.mAutoSizeTextHelper = new AppCompatTextViewAutoSizeHelper(textView);
    }

    private void applyCompoundDrawableTint(Drawable drawable2, TintInfo tintInfo) {
        if (drawable2 != null && tintInfo != null) {
            AppCompatDrawableManager.tintDrawable(drawable2, tintInfo, this.mView.getDrawableState());
        }
    }

    private static TintInfo createTintInfo(Context object, AppCompatDrawableManager appCompatDrawableManager, int n) {
        if ((appCompatDrawableManager = appCompatDrawableManager.getTintList((Context)object, n)) != null) {
            object = new TintInfo();
            object.mHasTintList = true;
            object.mTintList = appCompatDrawableManager;
            return object;
        }
        return null;
    }

    private void setCompoundDrawables(Drawable drawable2, Drawable drawable3, Drawable textView, Drawable drawable4, Drawable textView2, Drawable textView3) {
        if (Build.VERSION.SDK_INT >= 17 && (textView2 != null || textView3 != null)) {
            textView = this.mView.getCompoundDrawablesRelative();
            drawable2 = this.mView;
            if (textView2 == null) {
                textView2 = textView[0];
            }
            if (drawable3 == null) {
                drawable3 = textView[1];
            }
            if (textView3 == null) {
                textView3 = textView[2];
            }
            if (drawable4 == null) {
                drawable4 = textView[3];
            }
            drawable2.setCompoundDrawablesRelativeWithIntrinsicBounds((Drawable)textView2, drawable3, (Drawable)textView3, drawable4);
        } else if (drawable2 != null || drawable3 != null || textView != null || drawable4 != null) {
            if (Build.VERSION.SDK_INT >= 17 && ((textView2 = this.mView.getCompoundDrawablesRelative())[0] != null || textView2[2] != null)) {
                textView = this.mView;
                drawable2 = textView2[0];
                if (drawable3 == null) {
                    drawable3 = textView2[1];
                }
                textView3 = textView2[2];
                if (drawable4 == null) {
                    drawable4 = textView2[3];
                }
                textView.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable2, drawable3, (Drawable)textView3, drawable4);
                return;
            }
            textView3 = this.mView.getCompoundDrawables();
            textView2 = this.mView;
            if (drawable2 == null) {
                drawable2 = textView3[0];
            }
            if (drawable3 == null) {
                drawable3 = textView3[1];
            }
            if (textView == null) {
                textView = textView3[2];
            }
            if (drawable4 == null) {
                drawable4 = textView3[3];
            }
            textView2.setCompoundDrawablesWithIntrinsicBounds(drawable2, drawable3, (Drawable)textView, drawable4);
        }
    }

    private void setCompoundTints() {
        TintInfo tintInfo;
        this.mDrawableLeftTint = tintInfo = this.mDrawableTint;
        this.mDrawableTopTint = tintInfo;
        this.mDrawableRightTint = tintInfo;
        this.mDrawableBottomTint = tintInfo;
        this.mDrawableStartTint = tintInfo;
        this.mDrawableEndTint = tintInfo;
    }

    private void setTextSizeInternal(int n, float f) {
        this.mAutoSizeTextHelper.setTextSizeInternal(n, f);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTypefaceAndStyle(Context object, TintTypedArray tintTypedArray) {
        boolean bl;
        void var2_10;
        this.mStyle = var2_10.getInt(R.styleable.TextAppearance_android_textStyle, this.mStyle);
        int n = Build.VERSION.SDK_INT;
        boolean bl2 = false;
        if (n >= 28) {
            this.mFontWeight = n = var2_10.getInt(R.styleable.TextAppearance_android_textFontWeight, -1);
            if (n != -1) {
                this.mStyle = this.mStyle & 2 | 0;
            }
        }
        if (!var2_10.hasValue(R.styleable.TextAppearance_android_fontFamily) && !var2_10.hasValue(R.styleable.TextAppearance_fontFamily)) {
            if (!var2_10.hasValue(R.styleable.TextAppearance_android_typeface)) return;
            this.mAsyncFontPending = false;
            n = var2_10.getInt(R.styleable.TextAppearance_android_typeface, 1);
            if (n == 1) {
                this.mFontTypeface = Typeface.SANS_SERIF;
                return;
            }
            if (n == 2) {
                this.mFontTypeface = Typeface.SERIF;
                return;
            }
            if (n != 3) {
                return;
            }
            this.mFontTypeface = Typeface.MONOSPACE;
            return;
        }
        this.mFontTypeface = null;
        n = var2_10.hasValue(R.styleable.TextAppearance_fontFamily) ? R.styleable.TextAppearance_fontFamily : R.styleable.TextAppearance_android_fontFamily;
        final int n2 = this.mFontWeight;
        final int n3 = this.mStyle;
        if (!object.isRestricted()) {
            ResourcesCompat.FontCallback fontCallback = new ResourcesCompat.FontCallback(new WeakReference<TextView>(this.mView)){
                final /* synthetic */ WeakReference val$textViewWeak;
                {
                    this.val$textViewWeak = weakReference;
                }

                @Override
                public void onFontRetrievalFailed(int n) {
                }

                @Override
                public void onFontRetrieved(Typeface typeface) {
                    Typeface typeface2 = typeface;
                    if (Build.VERSION.SDK_INT >= 28) {
                        int n = n2;
                        typeface2 = typeface;
                        if (n != -1) {
                            boolean bl = (n3 & 2) != 0;
                            typeface2 = Typeface.create((Typeface)typeface, (int)n, (boolean)bl);
                        }
                    }
                    AppCompatTextHelper.this.onAsyncTypefaceReceived(this.val$textViewWeak, typeface2);
                }
            };
            try {
                Typeface typeface = var2_10.getFont(n, this.mStyle, fontCallback);
                if (typeface != null) {
                    if (Build.VERSION.SDK_INT >= 28 && this.mFontWeight != -1) {
                        Typeface typeface2 = Typeface.create((Typeface)typeface, (int)0);
                        n2 = this.mFontWeight;
                        bl = (this.mStyle & 2) != 0;
                        this.mFontTypeface = Typeface.create((Typeface)typeface2, (int)n2, (boolean)bl);
                    } else {
                        this.mFontTypeface = typeface;
                    }
                }
                bl = this.mFontTypeface == null;
                this.mAsyncFontPending = bl;
            }
            catch (Resources.NotFoundException | UnsupportedOperationException throwable) {
                // empty catch block
            }
        }
        if (this.mFontTypeface != null) return;
        String string2 = var2_10.getString(n);
        if (string2 == null) return;
        if (Build.VERSION.SDK_INT >= 28 && this.mFontWeight != -1) {
            Typeface typeface = Typeface.create((String)string2, (int)0);
            n = this.mFontWeight;
            bl = bl2;
            if ((this.mStyle & 2) != 0) {
                bl = true;
            }
            this.mFontTypeface = Typeface.create((Typeface)typeface, (int)n, (boolean)bl);
            return;
        }
        this.mFontTypeface = Typeface.create((String)string2, (int)this.mStyle);
    }

    void applyCompoundDrawablesTints() {
        Drawable[] drawableArray;
        if (this.mDrawableLeftTint != null || this.mDrawableTopTint != null || this.mDrawableRightTint != null || this.mDrawableBottomTint != null) {
            drawableArray = this.mView.getCompoundDrawables();
            this.applyCompoundDrawableTint(drawableArray[0], this.mDrawableLeftTint);
            this.applyCompoundDrawableTint(drawableArray[1], this.mDrawableTopTint);
            this.applyCompoundDrawableTint(drawableArray[2], this.mDrawableRightTint);
            this.applyCompoundDrawableTint(drawableArray[3], this.mDrawableBottomTint);
        }
        if (Build.VERSION.SDK_INT >= 17 && (this.mDrawableStartTint != null || this.mDrawableEndTint != null)) {
            drawableArray = this.mView.getCompoundDrawablesRelative();
            this.applyCompoundDrawableTint(drawableArray[0], this.mDrawableStartTint);
            this.applyCompoundDrawableTint(drawableArray[2], this.mDrawableEndTint);
        }
    }

    void autoSizeText() {
        this.mAutoSizeTextHelper.autoSizeText();
    }

    int getAutoSizeMaxTextSize() {
        return this.mAutoSizeTextHelper.getAutoSizeMaxTextSize();
    }

    int getAutoSizeMinTextSize() {
        return this.mAutoSizeTextHelper.getAutoSizeMinTextSize();
    }

    int getAutoSizeStepGranularity() {
        return this.mAutoSizeTextHelper.getAutoSizeStepGranularity();
    }

    int[] getAutoSizeTextAvailableSizes() {
        return this.mAutoSizeTextHelper.getAutoSizeTextAvailableSizes();
    }

    int getAutoSizeTextType() {
        return this.mAutoSizeTextHelper.getAutoSizeTextType();
    }

    ColorStateList getCompoundDrawableTintList() {
        TintInfo tintInfo = this.mDrawableTint;
        tintInfo = tintInfo != null ? tintInfo.mTintList : null;
        return tintInfo;
    }

    PorterDuff.Mode getCompoundDrawableTintMode() {
        TintInfo tintInfo = this.mDrawableTint;
        tintInfo = tintInfo != null ? tintInfo.mTintMode : null;
        return tintInfo;
    }

    boolean isAutoSizeEnabled() {
        return this.mAutoSizeTextHelper.isAutoSizeEnabled();
    }

    void loadFromAttributes(AttributeSet object, int n) {
        String string2;
        String string3;
        Object object2;
        boolean bl;
        TintTypedArray tintTypedArray;
        Context context = this.mView.getContext();
        AppCompatDrawableManager appCompatDrawableManager = AppCompatDrawableManager.get();
        Object object3 = TintTypedArray.obtainStyledAttributes(context, object, R.styleable.AppCompatTextHelper, n, 0);
        Object object4 = this.mView;
        ViewCompat.saveAttributeDataForStyleable((View)object4, object4.getContext(), R.styleable.AppCompatTextHelper, object, ((TintTypedArray)object3).getWrappedTypeArray(), n, 0);
        int n2 = ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_textAppearance, -1);
        if (((TintTypedArray)object3).hasValue(R.styleable.AppCompatTextHelper_android_drawableLeft)) {
            this.mDrawableLeftTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_drawableLeft, 0));
        }
        if (((TintTypedArray)object3).hasValue(R.styleable.AppCompatTextHelper_android_drawableTop)) {
            this.mDrawableTopTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_drawableTop, 0));
        }
        if (((TintTypedArray)object3).hasValue(R.styleable.AppCompatTextHelper_android_drawableRight)) {
            this.mDrawableRightTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_drawableRight, 0));
        }
        if (((TintTypedArray)object3).hasValue(R.styleable.AppCompatTextHelper_android_drawableBottom)) {
            this.mDrawableBottomTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_drawableBottom, 0));
        }
        if (Build.VERSION.SDK_INT >= 17) {
            if (((TintTypedArray)object3).hasValue(R.styleable.AppCompatTextHelper_android_drawableStart)) {
                this.mDrawableStartTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_drawableStart, 0));
            }
            if (((TintTypedArray)object3).hasValue(R.styleable.AppCompatTextHelper_android_drawableEnd)) {
                this.mDrawableEndTint = AppCompatTextHelper.createTintInfo(context, appCompatDrawableManager, ((TintTypedArray)object3).getResourceId(R.styleable.AppCompatTextHelper_android_drawableEnd, 0));
            }
        }
        ((TintTypedArray)object3).recycle();
        boolean bl2 = this.mView.getTransformationMethod() instanceof PasswordTransformationMethod;
        if (n2 != -1) {
            tintTypedArray = TintTypedArray.obtainStyledAttributes(context, n2, R.styleable.TextAppearance);
            if (!bl2 && tintTypedArray.hasValue(R.styleable.TextAppearance_textAllCaps)) {
                bl = tintTypedArray.getBoolean(R.styleable.TextAppearance_textAllCaps, false);
                n2 = 1;
            } else {
                bl = false;
                n2 = 0;
            }
            this.updateTypefaceAndStyle(context, tintTypedArray);
            if (Build.VERSION.SDK_INT < 23) {
                object2 = tintTypedArray.hasValue(R.styleable.TextAppearance_android_textColor) ? tintTypedArray.getColorStateList(R.styleable.TextAppearance_android_textColor) : null;
                object3 = tintTypedArray.hasValue(R.styleable.TextAppearance_android_textColorHint) ? tintTypedArray.getColorStateList(R.styleable.TextAppearance_android_textColorHint) : null;
                object4 = tintTypedArray.hasValue(R.styleable.TextAppearance_android_textColorLink) ? tintTypedArray.getColorStateList(R.styleable.TextAppearance_android_textColorLink) : null;
            } else {
                object3 = null;
                object4 = null;
                object2 = null;
            }
            string3 = tintTypedArray.hasValue(R.styleable.TextAppearance_textLocale) ? tintTypedArray.getString(R.styleable.TextAppearance_textLocale) : null;
            string2 = Build.VERSION.SDK_INT >= 26 && tintTypedArray.hasValue(R.styleable.TextAppearance_fontVariationSettings) ? tintTypedArray.getString(R.styleable.TextAppearance_fontVariationSettings) : null;
            tintTypedArray.recycle();
            tintTypedArray = object4;
            object4 = object2;
        } else {
            object3 = null;
            string2 = null;
            bl = false;
            n2 = 0;
            tintTypedArray = null;
            string3 = null;
            object4 = null;
        }
        TintTypedArray tintTypedArray2 = TintTypedArray.obtainStyledAttributes(context, object, R.styleable.TextAppearance, n, 0);
        if (!bl2 && tintTypedArray2.hasValue(R.styleable.TextAppearance_textAllCaps)) {
            bl = tintTypedArray2.getBoolean(R.styleable.TextAppearance_textAllCaps, false);
            n2 = 1;
        }
        Object object5 = object3;
        TintTypedArray tintTypedArray3 = tintTypedArray;
        object2 = object4;
        if (Build.VERSION.SDK_INT < 23) {
            if (tintTypedArray2.hasValue(R.styleable.TextAppearance_android_textColor)) {
                object4 = tintTypedArray2.getColorStateList(R.styleable.TextAppearance_android_textColor);
            }
            if (tintTypedArray2.hasValue(R.styleable.TextAppearance_android_textColorHint)) {
                object3 = tintTypedArray2.getColorStateList(R.styleable.TextAppearance_android_textColorHint);
            }
            object5 = object3;
            tintTypedArray3 = tintTypedArray;
            object2 = object4;
            if (tintTypedArray2.hasValue(R.styleable.TextAppearance_android_textColorLink)) {
                tintTypedArray3 = tintTypedArray2.getColorStateList(R.styleable.TextAppearance_android_textColorLink);
                object2 = object4;
                object5 = object3;
            }
        }
        if (tintTypedArray2.hasValue(R.styleable.TextAppearance_textLocale)) {
            string3 = tintTypedArray2.getString(R.styleable.TextAppearance_textLocale);
        }
        object3 = string2;
        if (Build.VERSION.SDK_INT >= 26) {
            object3 = string2;
            if (tintTypedArray2.hasValue(R.styleable.TextAppearance_fontVariationSettings)) {
                object3 = tintTypedArray2.getString(R.styleable.TextAppearance_fontVariationSettings);
            }
        }
        if (Build.VERSION.SDK_INT >= 28 && tintTypedArray2.hasValue(R.styleable.TextAppearance_android_textSize) && tintTypedArray2.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, -1) == 0) {
            this.mView.setTextSize(0, 0.0f);
        }
        this.updateTypefaceAndStyle(context, tintTypedArray2);
        tintTypedArray2.recycle();
        if (object2 != null) {
            this.mView.setTextColor((ColorStateList)object2);
        }
        if (object5 != null) {
            this.mView.setHintTextColor((ColorStateList)object5);
        }
        if (tintTypedArray3 != null) {
            this.mView.setLinkTextColor((ColorStateList)tintTypedArray3);
        }
        if (!bl2 && n2 != 0) {
            this.setAllCaps(bl);
        }
        if ((object4 = this.mFontTypeface) != null) {
            if (this.mFontWeight == -1) {
                this.mView.setTypeface((Typeface)object4, this.mStyle);
            } else {
                this.mView.setTypeface((Typeface)object4);
            }
        }
        if (object3 != null) {
            this.mView.setFontVariationSettings((String)object3);
        }
        if (string3 != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mView.setTextLocales(LocaleList.forLanguageTags((String)string3));
            } else if (Build.VERSION.SDK_INT >= 21) {
                object3 = string3.substring(0, string3.indexOf(44));
                this.mView.setTextLocale(Locale.forLanguageTag((String)object3));
            }
        }
        this.mAutoSizeTextHelper.loadFromAttributes((AttributeSet)object, n);
        if (AutoSizeableTextView.PLATFORM_SUPPORTS_AUTOSIZE && this.mAutoSizeTextHelper.getAutoSizeTextType() != 0 && ((Object)(object3 = (Object)this.mAutoSizeTextHelper.getAutoSizeTextAvailableSizes())).length > 0) {
            if ((float)this.mView.getAutoSizeStepGranularity() != -1.0f) {
                this.mView.setAutoSizeTextTypeUniformWithConfiguration(this.mAutoSizeTextHelper.getAutoSizeMinTextSize(), this.mAutoSizeTextHelper.getAutoSizeMaxTextSize(), this.mAutoSizeTextHelper.getAutoSizeStepGranularity(), 0);
            } else {
                this.mView.setAutoSizeTextTypeUniformWithPresetSizes((int[])object3, 0);
            }
        }
        object = (n = ((TintTypedArray)(object2 = TintTypedArray.obtainStyledAttributes(context, object, R.styleable.AppCompatTextView))).getResourceId(R.styleable.AppCompatTextView_drawableLeftCompat, -1)) != -1 ? appCompatDrawableManager.getDrawable(context, n) : null;
        n = ((TintTypedArray)object2).getResourceId(R.styleable.AppCompatTextView_drawableTopCompat, -1);
        object3 = n != -1 ? appCompatDrawableManager.getDrawable(context, n) : null;
        n = ((TintTypedArray)object2).getResourceId(R.styleable.AppCompatTextView_drawableRightCompat, -1);
        object4 = n != -1 ? appCompatDrawableManager.getDrawable(context, n) : null;
        n = ((TintTypedArray)object2).getResourceId(R.styleable.AppCompatTextView_drawableBottomCompat, -1);
        string2 = n != -1 ? appCompatDrawableManager.getDrawable(context, n) : null;
        n = ((TintTypedArray)object2).getResourceId(R.styleable.AppCompatTextView_drawableStartCompat, -1);
        string3 = n != -1 ? appCompatDrawableManager.getDrawable(context, n) : null;
        n = ((TintTypedArray)object2).getResourceId(R.styleable.AppCompatTextView_drawableEndCompat, -1);
        tintTypedArray = n != -1 ? appCompatDrawableManager.getDrawable(context, n) : null;
        this.setCompoundDrawables((Drawable)object, (Drawable)object3, (Drawable)object4, (Drawable)string2, (Drawable)string3, (Drawable)tintTypedArray);
        if (((TintTypedArray)object2).hasValue(R.styleable.AppCompatTextView_drawableTint)) {
            object = ((TintTypedArray)object2).getColorStateList(R.styleable.AppCompatTextView_drawableTint);
            TextViewCompat.setCompoundDrawableTintList(this.mView, (ColorStateList)object);
        }
        if (((TintTypedArray)object2).hasValue(R.styleable.AppCompatTextView_drawableTintMode)) {
            object = DrawableUtils.parseTintMode(((TintTypedArray)object2).getInt(R.styleable.AppCompatTextView_drawableTintMode, -1), null);
            TextViewCompat.setCompoundDrawableTintMode(this.mView, (PorterDuff.Mode)object);
        }
        n = ((TintTypedArray)object2).getDimensionPixelSize(R.styleable.AppCompatTextView_firstBaselineToTopHeight, -1);
        n2 = ((TintTypedArray)object2).getDimensionPixelSize(R.styleable.AppCompatTextView_lastBaselineToBottomHeight, -1);
        int n3 = ((TintTypedArray)object2).getDimensionPixelSize(R.styleable.AppCompatTextView_lineHeight, -1);
        ((TintTypedArray)object2).recycle();
        if (n != -1) {
            TextViewCompat.setFirstBaselineToTopHeight(this.mView, n);
        }
        if (n2 != -1) {
            TextViewCompat.setLastBaselineToBottomHeight(this.mView, n2);
        }
        if (n3 != -1) {
            TextViewCompat.setLineHeight(this.mView, n3);
        }
    }

    void onAsyncTypefaceReceived(final WeakReference<TextView> textView, final Typeface typeface) {
        if (this.mAsyncFontPending) {
            this.mFontTypeface = typeface;
            if ((textView = (TextView)textView.get()) != null) {
                if (ViewCompat.isAttachedToWindow((View)textView)) {
                    textView.post(new Runnable(){

                        @Override
                        public void run() {
                            textView.setTypeface(typeface, mStyle);
                        }
                    });
                } else {
                    textView.setTypeface(typeface, this.mStyle);
                }
            }
        }
    }

    void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (!AutoSizeableTextView.PLATFORM_SUPPORTS_AUTOSIZE) {
            this.autoSizeText();
        }
    }

    void onSetCompoundDrawables() {
        this.applyCompoundDrawablesTints();
    }

    void onSetTextAppearance(Context object, int n) {
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes(object, n, R.styleable.TextAppearance);
        if (tintTypedArray.hasValue(R.styleable.TextAppearance_textAllCaps)) {
            this.setAllCaps(tintTypedArray.getBoolean(R.styleable.TextAppearance_textAllCaps, false));
        }
        if (Build.VERSION.SDK_INT < 23) {
            ColorStateList colorStateList;
            if (tintTypedArray.hasValue(R.styleable.TextAppearance_android_textColor) && (colorStateList = tintTypedArray.getColorStateList(R.styleable.TextAppearance_android_textColor)) != null) {
                this.mView.setTextColor(colorStateList);
            }
            if (tintTypedArray.hasValue(R.styleable.TextAppearance_android_textColorLink) && (colorStateList = tintTypedArray.getColorStateList(R.styleable.TextAppearance_android_textColorLink)) != null) {
                this.mView.setLinkTextColor(colorStateList);
            }
            if (tintTypedArray.hasValue(R.styleable.TextAppearance_android_textColorHint) && (colorStateList = tintTypedArray.getColorStateList(R.styleable.TextAppearance_android_textColorHint)) != null) {
                this.mView.setHintTextColor(colorStateList);
            }
        }
        if (tintTypedArray.hasValue(R.styleable.TextAppearance_android_textSize) && tintTypedArray.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, -1) == 0) {
            this.mView.setTextSize(0, 0.0f);
        }
        this.updateTypefaceAndStyle((Context)object, tintTypedArray);
        if (Build.VERSION.SDK_INT >= 26 && tintTypedArray.hasValue(R.styleable.TextAppearance_fontVariationSettings) && (object = tintTypedArray.getString(R.styleable.TextAppearance_fontVariationSettings)) != null) {
            this.mView.setFontVariationSettings((String)object);
        }
        tintTypedArray.recycle();
        object = this.mFontTypeface;
        if (object != null) {
            this.mView.setTypeface((Typeface)object, this.mStyle);
        }
    }

    void populateSurroundingTextIfNeeded(TextView textView, InputConnection inputConnection, EditorInfo editorInfo) {
        if (Build.VERSION.SDK_INT < 30 && inputConnection != null) {
            EditorInfoCompat.setInitialSurroundingText(editorInfo, textView.getText());
        }
    }

    void setAllCaps(boolean bl) {
        this.mView.setAllCaps(bl);
    }

    void setAutoSizeTextTypeUniformWithConfiguration(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        this.mAutoSizeTextHelper.setAutoSizeTextTypeUniformWithConfiguration(n, n2, n3, n4);
    }

    void setAutoSizeTextTypeUniformWithPresetSizes(int[] nArray, int n) throws IllegalArgumentException {
        this.mAutoSizeTextHelper.setAutoSizeTextTypeUniformWithPresetSizes(nArray, n);
    }

    void setAutoSizeTextTypeWithDefaults(int n) {
        this.mAutoSizeTextHelper.setAutoSizeTextTypeWithDefaults(n);
    }

    void setCompoundDrawableTintList(ColorStateList colorStateList) {
        if (this.mDrawableTint == null) {
            this.mDrawableTint = new TintInfo();
        }
        this.mDrawableTint.mTintList = colorStateList;
        TintInfo tintInfo = this.mDrawableTint;
        boolean bl = colorStateList != null;
        tintInfo.mHasTintList = bl;
        this.setCompoundTints();
    }

    void setCompoundDrawableTintMode(PorterDuff.Mode mode) {
        if (this.mDrawableTint == null) {
            this.mDrawableTint = new TintInfo();
        }
        this.mDrawableTint.mTintMode = mode;
        TintInfo tintInfo = this.mDrawableTint;
        boolean bl = mode != null;
        tintInfo.mHasTintMode = bl;
        this.setCompoundTints();
    }

    void setTextSize(int n, float f) {
        if (!AutoSizeableTextView.PLATFORM_SUPPORTS_AUTOSIZE && !this.isAutoSizeEnabled()) {
            this.setTextSizeInternal(n, f);
        }
    }
}

