/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;

public class ContentFrameLayout
extends FrameLayout {
    private OnAttachListener mAttachListener;
    private final Rect mDecorPadding = new Rect();
    private TypedValue mFixedHeightMajor;
    private TypedValue mFixedHeightMinor;
    private TypedValue mFixedWidthMajor;
    private TypedValue mFixedWidthMinor;
    private TypedValue mMinWidthMajor;
    private TypedValue mMinWidthMinor;

    public ContentFrameLayout(Context context) {
        this(context, null);
    }

    public ContentFrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ContentFrameLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    public void dispatchFitSystemWindows(Rect rect) {
        this.fitSystemWindows(rect);
    }

    public TypedValue getFixedHeightMajor() {
        if (this.mFixedHeightMajor == null) {
            this.mFixedHeightMajor = new TypedValue();
        }
        return this.mFixedHeightMajor;
    }

    public TypedValue getFixedHeightMinor() {
        if (this.mFixedHeightMinor == null) {
            this.mFixedHeightMinor = new TypedValue();
        }
        return this.mFixedHeightMinor;
    }

    public TypedValue getFixedWidthMajor() {
        if (this.mFixedWidthMajor == null) {
            this.mFixedWidthMajor = new TypedValue();
        }
        return this.mFixedWidthMajor;
    }

    public TypedValue getFixedWidthMinor() {
        if (this.mFixedWidthMinor == null) {
            this.mFixedWidthMinor = new TypedValue();
        }
        return this.mFixedWidthMinor;
    }

    public TypedValue getMinWidthMajor() {
        if (this.mMinWidthMajor == null) {
            this.mMinWidthMajor = new TypedValue();
        }
        return this.mMinWidthMajor;
    }

    public TypedValue getMinWidthMinor() {
        if (this.mMinWidthMinor == null) {
            this.mMinWidthMinor = new TypedValue();
        }
        return this.mMinWidthMinor;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        OnAttachListener onAttachListener = this.mAttachListener;
        if (onAttachListener != null) {
            onAttachListener.onAttachedFromWindow();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        OnAttachListener onAttachListener = this.mAttachListener;
        if (onAttachListener != null) {
            onAttachListener.onDetachedFromWindow();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        var3_3 = this.getContext().getResources().getDisplayMetrics();
        var4_4 = var3_3.widthPixels;
        var5_5 = var3_3.heightPixels;
        var6_6 = 1;
        var4_4 = var4_4 < var5_5 ? 1 : 0;
        var7_7 = View.MeasureSpec.getMode((int)var1_1);
        var8_8 = View.MeasureSpec.getMode((int)var2_2);
        if (var7_7 != -2147483648 || (var9_9 = var4_4 != 0 ? this.mFixedWidthMinor : this.mFixedWidthMajor) == null || var9_9.type == 0) ** GOTO lbl-1000
        if (var9_9.type == 5) {
            var10_10 = var9_9.getDimension(var3_3);
lbl11:
            // 2 sources

            while (true) {
                var5_5 = (int)var10_10;
                break;
            }
        } else {
            if (var9_9.type == 6) {
                var10_10 = var9_9.getFraction((float)var3_3.widthPixels, (float)var3_3.widthPixels);
                ** continue;
            }
            var5_5 = 0;
        }
        if (var5_5 > 0) {
            var11_11 = View.MeasureSpec.makeMeasureSpec((int)Math.min(var5_5 - (this.mDecorPadding.left + this.mDecorPadding.right), View.MeasureSpec.getSize((int)var1_1)), (int)0x40000000);
            var1_1 = 1;
        } else lbl-1000:
        // 2 sources

        {
            var5_5 = 0;
            var11_11 = var1_1;
            var1_1 = var5_5;
        }
        var5_5 = var2_2;
        if (var8_8 == -2147483648) {
            var9_9 = var4_4 != 0 ? this.mFixedHeightMajor : this.mFixedHeightMinor;
            var5_5 = var2_2;
            if (var9_9 != null) {
                var5_5 = var2_2;
                if (var9_9.type != 0) {
                    if (var9_9.type == 5) {
                        var10_10 = var9_9.getDimension(var3_3);
lbl34:
                        // 2 sources

                        while (true) {
                            var8_8 = (int)var10_10;
                            break;
                        }
                    } else {
                        if (var9_9.type == 6) {
                            var10_10 = var9_9.getFraction((float)var3_3.heightPixels, (float)var3_3.heightPixels);
                            ** continue;
                        }
                        var8_8 = 0;
                    }
                    var5_5 = var2_2;
                    if (var8_8 > 0) {
                        var5_5 = View.MeasureSpec.makeMeasureSpec((int)Math.min(var8_8 - (this.mDecorPadding.top + this.mDecorPadding.bottom), View.MeasureSpec.getSize((int)var2_2)), (int)0x40000000);
                    }
                }
            }
        }
        super.onMeasure(var11_11, var5_5);
        var8_8 = this.getMeasuredWidth();
        var11_11 = View.MeasureSpec.makeMeasureSpec((int)var8_8, (int)0x40000000);
        if (var1_1 != 0 || var7_7 != -2147483648 || (var9_9 = var4_4 != 0 ? this.mMinWidthMinor : this.mMinWidthMajor) == null || var9_9.type == 0) ** GOTO lbl-1000
        if (var9_9.type == 5) {
            var10_10 = var9_9.getDimension(var3_3);
lbl50:
            // 2 sources

            while (true) {
                var1_1 = (int)var10_10;
                break;
            }
        } else {
            if (var9_9.type == 6) {
                var10_10 = var9_9.getFraction((float)var3_3.widthPixels, (float)var3_3.widthPixels);
                ** continue;
            }
            var1_1 = 0;
        }
        var2_2 = var1_1;
        if (var1_1 > 0) {
            var2_2 = var1_1 - (this.mDecorPadding.left + this.mDecorPadding.right);
        }
        if (var8_8 < var2_2) {
            var1_1 = View.MeasureSpec.makeMeasureSpec((int)var2_2, (int)0x40000000);
            var2_2 = var6_6;
        } else lbl-1000:
        // 2 sources

        {
            var2_2 = 0;
            var1_1 = var11_11;
        }
        if (var2_2 != 0) {
            super.onMeasure(var1_1, var5_5);
        }
    }

    public void setAttachListener(OnAttachListener onAttachListener) {
        this.mAttachListener = onAttachListener;
    }

    public void setDecorPadding(int n, int n2, int n3, int n4) {
        this.mDecorPadding.set(n, n2, n3, n4);
        if (ViewCompat.isLaidOut((View)this)) {
            this.requestLayout();
        }
    }

    public static interface OnAttachListener {
        public void onAttachedFromWindow();

        public void onDetachedFromWindow();
    }
}

