/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import androidx.appcompat.graphics.drawable.DrawableWrapper;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.graphics.drawable.WrappedDrawable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DrawableUtils {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] EMPTY_STATE_SET = new int[0];
    public static final Rect INSETS_NONE = new Rect();

    private DrawableUtils() {
    }

    public static boolean canSafelyMutateDrawable(Drawable drawableArray) {
        if (Build.VERSION.SDK_INT < 15 && drawableArray instanceof InsetDrawable) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 15 && drawableArray instanceof GradientDrawable) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 17 && drawableArray instanceof LayerDrawable) {
            return false;
        }
        if (drawableArray instanceof DrawableContainer) {
            if ((drawableArray = drawableArray.getConstantState()) instanceof DrawableContainer.DrawableContainerState) {
                drawableArray = ((DrawableContainer.DrawableContainerState)drawableArray).getChildren();
                int n = drawableArray.length;
                for (int i = 0; i < n; ++i) {
                    if (DrawableUtils.canSafelyMutateDrawable(drawableArray[i])) continue;
                    return false;
                }
            }
        } else {
            if (drawableArray instanceof WrappedDrawable) {
                return DrawableUtils.canSafelyMutateDrawable(((WrappedDrawable)drawableArray).getWrappedDrawable());
            }
            if (drawableArray instanceof DrawableWrapper) {
                return DrawableUtils.canSafelyMutateDrawable(((DrawableWrapper)drawableArray).getWrappedDrawable());
            }
            if (drawableArray instanceof ScaleDrawable) {
                return DrawableUtils.canSafelyMutateDrawable(((ScaleDrawable)drawableArray).getDrawable());
            }
        }
        return true;
    }

    static void fixDrawable(Drawable drawable2) {
        String string2 = drawable2.getClass().getName();
        if (Build.VERSION.SDK_INT == 21 && "android.graphics.drawable.VectorDrawable".equals(string2)) {
            DrawableUtils.forceDrawableStateChange(drawable2);
        } else if (Build.VERSION.SDK_INT >= 29 && Build.VERSION.SDK_INT < 31 && "android.graphics.drawable.ColorStateListDrawable".equals(string2)) {
            DrawableUtils.forceDrawableStateChange(drawable2);
        }
    }

    private static void forceDrawableStateChange(Drawable drawable2) {
        int[] nArray = drawable2.getState();
        if (nArray != null && nArray.length != 0) {
            drawable2.setState(EMPTY_STATE_SET);
        } else {
            drawable2.setState(CHECKED_STATE_SET);
        }
        drawable2.setState(nArray);
    }

    public static Rect getOpticalBounds(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 29) {
            drawable2 = Api29Impl.getOpticalInsets(drawable2);
            return new Rect(drawable2.left, drawable2.top, drawable2.right, drawable2.bottom);
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return Api18Impl.getOpticalInsets(DrawableCompat.unwrap(drawable2));
        }
        return INSETS_NONE;
    }

    public static PorterDuff.Mode parseTintMode(int n, PorterDuff.Mode mode) {
        if (n != 3) {
            if (n != 5) {
                if (n != 9) {
                    switch (n) {
                        default: {
                            return mode;
                        }
                        case 16: {
                            return PorterDuff.Mode.ADD;
                        }
                        case 15: {
                            return PorterDuff.Mode.SCREEN;
                        }
                        case 14: 
                    }
                    return PorterDuff.Mode.MULTIPLY;
                }
                return PorterDuff.Mode.SRC_ATOP;
            }
            return PorterDuff.Mode.SRC_IN;
        }
        return PorterDuff.Mode.SRC_OVER;
    }

    static class Api18Impl {
        private static final Field sBottom;
        private static final Method sGetOpticalInsets;
        private static final Field sLeft;
        private static final boolean sReflectionSuccessful;
        private static final Field sRight;
        private static final Field sTop;

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            boolean bl;
            Field field;
            block17: {
                block18: {
                    void var0_17;
                    void var1_37;
                    block19: {
                        block22: {
                            void var1_32;
                            block21: {
                                void var1_28;
                                block20: {
                                    Class<?> clazz = Class.forName("android.graphics.Insets");
                                    Method method = Drawable.class.getMethod("getOpticalInsets", new Class[0]);
                                    field = clazz.getField("left");
                                    Field field2 = clazz.getField("top");
                                    Field field3 = clazz.getField("right");
                                    Field field4 = clazz.getField("bottom");
                                    bl = true;
                                    break block17;
                                    catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
                                        Object var4_45 = null;
                                        break block18;
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        Object var4_46 = null;
                                        Method method2 = method;
                                        Object var1_23 = var4_46;
                                        break block19;
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        Object var4_47 = null;
                                        Method method3 = method;
                                        Object var1_24 = var4_47;
                                        break block19;
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        Object var4_48 = null;
                                        Method method4 = method;
                                        Object var1_25 = var4_48;
                                        break block19;
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        break block20;
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        break block21;
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        Method method5 = method;
                                        break block22;
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        Object var1_27 = null;
                                    }
                                }
                                field = null;
                                Object var4_49 = null;
                                void var0_13 = var1_28;
                                Object var1_29 = var4_49;
                                break block19;
                                catch (ClassNotFoundException classNotFoundException) {
                                    Object var1_31 = null;
                                }
                            }
                            field = null;
                            Object var4_50 = null;
                            void var0_14 = var1_32;
                            Object var1_33 = var4_50;
                            break block19;
                            catch (NoSuchMethodException noSuchMethodException) {
                                Object var0_15 = null;
                            }
                        }
                        field = null;
                        Object var1_36 = null;
                    }
                    void var4_52 = var1_37;
                    void var3_42 = var1_37;
                    void var1_38 = var0_17;
                    break block18;
                    catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {}
                }
                Object var0_19 = null;
                bl = false;
            }
            if (bl) {
                void var0_20;
                void var4_53;
                void var3_43;
                void var1_39;
                sGetOpticalInsets = var1_39;
                sLeft = field;
                sTop = var3_43;
                sRight = var4_53;
                sBottom = var0_20;
                sReflectionSuccessful = true;
                return;
            }
            sGetOpticalInsets = null;
            sLeft = null;
            sTop = null;
            sRight = null;
            sBottom = null;
            sReflectionSuccessful = false;
        }

        private Api18Impl() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Rect getOpticalInsets(Drawable object) {
            if (Build.VERSION.SDK_INT >= 29) return INSETS_NONE;
            if (!sReflectionSuccessful) return INSETS_NONE;
            Object object2 = sGetOpticalInsets.invoke(object, new Object[0]);
            if (object2 == null) return INSETS_NONE;
            try {
                return new Rect(sLeft.getInt(object2), sTop.getInt(object2), sRight.getInt(object2), sBottom.getInt(object2));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return INSETS_NONE;
            }
        }
    }

    static class Api29Impl {
        private Api29Impl() {
        }

        static Insets getOpticalInsets(Drawable drawable2) {
            return drawable2.getOpticalInsets();
        }
    }
}

