/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.view.inspector.InspectionCompanion;
import android.view.inspector.PropertyMapper;
import android.view.inspector.PropertyReader;
import androidx.appcompat.R;
import androidx.appcompat.widget.LinearLayoutCompat;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntFunction;

public final class LinearLayoutCompat$InspectionCompanion
implements InspectionCompanion<LinearLayoutCompat> {
    private int mBaselineAlignedChildIndexId;
    private int mBaselineAlignedId;
    private int mDividerId;
    private int mDividerPaddingId;
    private int mGravityId;
    private int mMeasureWithLargestChildId;
    private int mOrientationId;
    private boolean mPropertiesMapped = false;
    private int mShowDividersId;
    private int mWeightSumId;

    public void mapProperties(PropertyMapper propertyMapper) {
        this.mBaselineAlignedId = propertyMapper.mapBoolean("baselineAligned", 16843046);
        this.mBaselineAlignedChildIndexId = propertyMapper.mapInt("baselineAlignedChildIndex", 16843047);
        this.mGravityId = propertyMapper.mapGravity("gravity", 16842927);
        this.mOrientationId = propertyMapper.mapIntEnum("orientation", 16842948, (IntFunction)new IntFunction<String>(){

            @Override
            public String apply(int n) {
                if (n != 0) {
                    if (n != 1) {
                        return String.valueOf(n);
                    }
                    return "vertical";
                }
                return "horizontal";
            }
        });
        this.mWeightSumId = propertyMapper.mapFloat("weightSum", 16843048);
        this.mDividerId = propertyMapper.mapObject("divider", R.attr.divider);
        this.mDividerPaddingId = propertyMapper.mapInt("dividerPadding", R.attr.dividerPadding);
        this.mMeasureWithLargestChildId = propertyMapper.mapBoolean("measureWithLargestChild", R.attr.measureWithLargestChild);
        this.mShowDividersId = propertyMapper.mapIntFlag("showDividers", R.attr.showDividers, (IntFunction)new IntFunction<Set<String>>(){

            @Override
            public Set<String> apply(int n) {
                HashSet<String> hashSet = new HashSet<String>();
                if (n == 0) {
                    hashSet.add("none");
                }
                if (n == 1) {
                    hashSet.add("beginning");
                }
                if (n == 2) {
                    hashSet.add("middle");
                }
                if (n == 4) {
                    hashSet.add("end");
                }
                return hashSet;
            }
        });
        this.mPropertiesMapped = true;
    }

    public void readProperties(LinearLayoutCompat linearLayoutCompat, PropertyReader propertyReader) {
        if (this.mPropertiesMapped) {
            propertyReader.readBoolean(this.mBaselineAlignedId, linearLayoutCompat.isBaselineAligned());
            propertyReader.readInt(this.mBaselineAlignedChildIndexId, linearLayoutCompat.getBaselineAlignedChildIndex());
            propertyReader.readGravity(this.mGravityId, linearLayoutCompat.getGravity());
            propertyReader.readIntEnum(this.mOrientationId, linearLayoutCompat.getOrientation());
            propertyReader.readFloat(this.mWeightSumId, linearLayoutCompat.getWeightSum());
            propertyReader.readObject(this.mDividerId, (Object)linearLayoutCompat.getDividerDrawable());
            propertyReader.readInt(this.mDividerPaddingId, linearLayoutCompat.getDividerPadding());
            propertyReader.readBoolean(this.mMeasureWithLargestChildId, linearLayoutCompat.isMeasureWithLargestChildEnabled());
            propertyReader.readIntFlag(this.mShowDividersId, linearLayoutCompat.getShowDividers());
            return;
        }
        throw new InspectionCompanion.UninitializedPropertyMapException();
    }
}

