/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import androidx.appcompat.R;
import androidx.appcompat.widget.TintTypedArray;
import androidx.appcompat.widget.ViewUtils;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LinearLayoutCompat
extends ViewGroup {
    private static final String ACCESSIBILITY_CLASS_NAME = "androidx.appcompat.widget.LinearLayoutCompat";
    public static final int HORIZONTAL = 0;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_FILL = 3;
    private static final int INDEX_TOP = 1;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int VERTICAL = 1;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    private boolean mBaselineAligned = true;
    private int mBaselineAlignedChildIndex = -1;
    private int mBaselineChildTop = 0;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    private int mGravity = 0x800033;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    private int mOrientation;
    private int mShowDividers;
    private int mTotalLength;
    private boolean mUseLargestChild;
    private float mWeightSum;

    public LinearLayoutCompat(Context context) {
        this(context, null);
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LinearLayoutCompat(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes(context, attributeSet, R.styleable.LinearLayoutCompat, n, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this, context, R.styleable.LinearLayoutCompat, attributeSet, tintTypedArray.getWrappedTypeArray(), n, 0);
        n = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_android_orientation, -1);
        if (n >= 0) {
            this.setOrientation(n);
        }
        if ((n = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_android_gravity, -1)) >= 0) {
            this.setGravity(n);
        }
        if (!(bl = tintTypedArray.getBoolean(R.styleable.LinearLayoutCompat_android_baselineAligned, true))) {
            this.setBaselineAligned(bl);
        }
        this.mWeightSum = tintTypedArray.getFloat(R.styleable.LinearLayoutCompat_android_weightSum, -1.0f);
        this.mBaselineAlignedChildIndex = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_android_baselineAlignedChildIndex, -1);
        this.mUseLargestChild = tintTypedArray.getBoolean(R.styleable.LinearLayoutCompat_measureWithLargestChild, false);
        this.setDividerDrawable(tintTypedArray.getDrawable(R.styleable.LinearLayoutCompat_divider));
        this.mShowDividers = tintTypedArray.getInt(R.styleable.LinearLayoutCompat_showDividers, 0);
        this.mDividerPadding = tintTypedArray.getDimensionPixelSize(R.styleable.LinearLayoutCompat_dividerPadding, 0);
        tintTypedArray.recycle();
    }

    private void forceUniformHeight(int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000);
        for (int i = 0; i < n; ++i) {
            View view = this.getVirtualChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.height != -1) continue;
            int n4 = layoutParams.width;
            layoutParams.width = view.getMeasuredWidth();
            this.measureChildWithMargins(view, n2, 0, n3, 0);
            layoutParams.width = n4;
        }
    }

    private void forceUniformWidth(int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        for (int i = 0; i < n; ++i) {
            View view = this.getVirtualChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.width != -1) continue;
            int n4 = layoutParams.height;
            layoutParams.height = view.getMeasuredHeight();
            this.measureChildWithMargins(view, n3, 0, n2, 0);
            layoutParams.height = n4;
        }
    }

    private void setChildFrame(View view, int n, int n2, int n3, int n4) {
        view.layout(n, n2, n3 + n, n4 + n2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void drawDividersHorizontal(Canvas var1_1) {
        block3: {
            block6: {
                block4: {
                    block5: {
                        var2_2 = this.getVirtualChildCount();
                        var3_3 = ViewUtils.isLayoutRtl((View)this);
                        for (var4_4 = 0; var4_4 < var2_2; ++var4_4) {
                            var5_5 /* !! */  = this.getVirtualChildAt(var4_4);
                            if (var5_5 /* !! */  == null || var5_5 /* !! */ .getVisibility() == 8 || !this.hasDividerBeforeChildAt(var4_4)) continue;
                            var6_6 /* !! */  = (LayoutParams)var5_5 /* !! */ .getLayoutParams();
                            var7_7 = var3_3 != false ? var5_5 /* !! */ .getRight() + var6_6 /* !! */ .rightMargin : var5_5 /* !! */ .getLeft() - var6_6 /* !! */ .leftMargin - this.mDividerWidth;
                            this.drawVerticalDivider(var1_1, var7_7);
                        }
                        if (!this.hasDividerBeforeChildAt(var2_2)) break block3;
                        var6_6 /* !! */  = this.getVirtualChildAt(var2_2 - 1);
                        if (var6_6 /* !! */  != null) break block4;
                        if (!var3_3) break block5;
                        var4_4 = this.getPaddingLeft();
                        break block6;
                    }
                    var7_7 = this.getWidth() - this.getPaddingRight();
                    var4_4 = this.mDividerWidth;
                    ** GOTO lbl25
                }
                var5_5 /* !! */  = (LayoutParams)var6_6 /* !! */ .getLayoutParams();
                if (var3_3) {
                    var7_7 = var6_6 /* !! */ .getLeft() - var5_5 /* !! */ .leftMargin;
                    var4_4 = this.mDividerWidth;
lbl25:
                    // 2 sources

                    var4_4 = var7_7 - var4_4;
                } else {
                    var4_4 = var6_6 /* !! */ .getRight() + var5_5 /* !! */ .rightMargin;
                }
            }
            this.drawVerticalDivider(var1_1, var4_4);
        }
    }

    void drawDividersVertical(Canvas canvas) {
        LayoutParams layoutParams;
        View view;
        int n;
        int n2 = this.getVirtualChildCount();
        for (n = 0; n < n2; ++n) {
            view = this.getVirtualChildAt(n);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(n)) continue;
            layoutParams = (LayoutParams)view.getLayoutParams();
            this.drawHorizontalDivider(canvas, view.getTop() - layoutParams.topMargin - this.mDividerHeight);
        }
        if (this.hasDividerBeforeChildAt(n2)) {
            view = this.getVirtualChildAt(n2 - 1);
            if (view == null) {
                n = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                layoutParams = (LayoutParams)view.getLayoutParams();
                n = view.getBottom() + layoutParams.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, n);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int n) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, n, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, this.mDividerHeight + n);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int n) {
        this.mDivider.setBounds(n, this.getPaddingTop() + this.mDividerPadding, this.mDividerWidth + n, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        int n = this.mOrientation;
        if (n == 0) {
            return new LayoutParams(-2, -2);
        }
        if (n == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public int getBaseline() {
        int n;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        int n2 = this.getChildCount();
        if (n2 > (n = this.mBaselineAlignedChildIndex)) {
            View view = this.getChildAt(n);
            int n3 = view.getBaseline();
            if (n3 == -1) {
                if (this.mBaselineAlignedChildIndex == 0) {
                    return -1;
                }
                throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
            }
            n = n2 = this.mBaselineChildTop;
            if (this.mOrientation == 1) {
                int n4 = this.mGravity & 0x70;
                n = n2;
                if (n4 != 48) {
                    n = n4 != 16 ? (n4 != 80 ? n2 : this.getBottom() - this.getTop() - this.getPaddingBottom() - this.mTotalLength) : n2 + (this.getBottom() - this.getTop() - this.getPaddingTop() - this.getPaddingBottom() - this.mTotalLength) / 2;
                }
            }
            return n + ((LayoutParams)view.getLayoutParams()).topMargin + n3;
        }
        throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    int getChildrenSkipCount(View view, int n) {
        return 0;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getGravity() {
        return this.mGravity;
    }

    int getLocationOffset(View view) {
        return 0;
    }

    int getNextLocationOffset(View view) {
        return 0;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    View getVirtualChildAt(int n) {
        return this.getChildAt(n);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    protected boolean hasDividerBeforeChildAt(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == 0) {
            if ((this.mShowDividers & 1) != 0) {
                bl3 = true;
            }
            return bl3;
        }
        if (n == this.getChildCount()) {
            bl3 = bl;
            if ((this.mShowDividers & 4) != 0) {
                bl3 = true;
            }
            return bl3;
        }
        bl3 = bl2;
        if ((this.mShowDividers & 2) != 0) {
            --n;
            while (true) {
                bl3 = bl2;
                if (n < 0) break;
                if (this.getChildAt(n).getVisibility() != 8) {
                    bl3 = true;
                    break;
                }
                --n;
            }
        }
        return bl3;
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    void layoutHorizontal(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl = ViewUtils.isLayoutRtl((View)this);
        int n7 = this.getPaddingTop();
        int n8 = n4 - n2;
        int n9 = this.getPaddingBottom();
        int n10 = this.getPaddingBottom();
        int n11 = this.getVirtualChildCount();
        n2 = this.mGravity;
        n4 = n2 & 0x70;
        boolean bl2 = this.mBaselineAligned;
        int[] nArray = this.mMaxAscent;
        int[] nArray2 = this.mMaxDescent;
        n2 = (n2 = GravityCompat.getAbsoluteGravity(0x800007 & n2, ViewCompat.getLayoutDirection((View)this))) != 1 ? (n2 != 5 ? this.getPaddingLeft() : this.getPaddingLeft() + n3 - n - this.mTotalLength) : this.getPaddingLeft() + (n3 - n - this.mTotalLength) / 2;
        if (bl) {
            n6 = n11 - 1;
            n5 = -1;
        } else {
            n6 = 0;
            n5 = 1;
        }
        n3 = n4;
        n4 = n7;
        for (int i = 0; i < n11; ++i) {
            int n12;
            int n13 = n6 + n5 * i;
            View view = this.getVirtualChildAt(n13);
            if (view == null) {
                n2 += this.measureNullChild(n13);
                continue;
            }
            if (view.getVisibility() == 8) continue;
            int n14 = view.getMeasuredWidth();
            int n15 = view.getMeasuredHeight();
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n16 = bl2 && layoutParams.height != -1 ? view.getBaseline() : -1;
            n = n12 = layoutParams.gravity;
            if (n12 < 0) {
                n = n3;
            }
            if ((n &= 0x70) != 16) {
                if (n != 48) {
                    if (n != 80) {
                        n = n4;
                    } else {
                        n = n12 = n8 - n9 - n15 - layoutParams.bottomMargin;
                        if (n16 != -1) {
                            n = view.getMeasuredHeight();
                            n = n12 - (nArray2[2] - (n - n16));
                        }
                    }
                } else {
                    n = n12 = layoutParams.topMargin + n4;
                    if (n16 != -1) {
                        n = n12 + (nArray[1] - n16);
                    }
                }
            } else {
                n = (n8 - n7 - n10 - n15) / 2 + n4 + layoutParams.topMargin - layoutParams.bottomMargin;
            }
            n16 = n2;
            if (this.hasDividerBeforeChildAt(n13)) {
                n16 = n2 + this.mDividerWidth;
            }
            n2 = layoutParams.leftMargin + n16;
            this.setChildFrame(view, n2 + this.getLocationOffset(view), n, n14, n15);
            n16 = layoutParams.rightMargin;
            n = this.getNextLocationOffset(view);
            i += this.getChildrenSkipCount(view, n13);
            n2 += n14 + n16 + n;
        }
    }

    void layoutVertical(int n, int n2, int n3, int n4) {
        int n5 = this.getPaddingLeft();
        int n6 = n3 - n;
        int n7 = this.getPaddingRight();
        int n8 = this.getPaddingRight();
        int n9 = this.getVirtualChildCount();
        int n10 = this.mGravity;
        n = n10 & 0x70;
        n = n != 16 ? (n != 80 ? this.getPaddingTop() : this.getPaddingTop() + n4 - n2 - this.mTotalLength) : this.getPaddingTop() + (n4 - n2 - this.mTotalLength) / 2;
        n2 = 0;
        while (n2 < n9) {
            block4: {
                LayoutParams layoutParams;
                int n11;
                int n12;
                View view;
                block7: {
                    block8: {
                        block5: {
                            block6: {
                                block3: {
                                    view = this.getVirtualChildAt(n2);
                                    if (view != null) break block3;
                                    n3 = n + this.measureNullChild(n2);
                                    n4 = n2;
                                    break block4;
                                }
                                n3 = n;
                                n4 = n2;
                                if (view.getVisibility() == 8) break block4;
                                n12 = view.getMeasuredWidth();
                                n11 = view.getMeasuredHeight();
                                layoutParams = (LayoutParams)view.getLayoutParams();
                                n3 = n4 = layoutParams.gravity;
                                if (n4 < 0) {
                                    n3 = n10 & 0x800007;
                                }
                                if ((n3 = GravityCompat.getAbsoluteGravity(n3, ViewCompat.getLayoutDirection((View)this)) & 7) == 1) break block5;
                                if (n3 == 5) break block6;
                                n3 = layoutParams.leftMargin + n5;
                                break block7;
                            }
                            n4 = n6 - n7 - n12;
                            n3 = layoutParams.rightMargin;
                            break block8;
                        }
                        n4 = (n6 - n5 - n8 - n12) / 2 + n5 + layoutParams.leftMargin;
                        n3 = layoutParams.rightMargin;
                    }
                    n3 = n4 - n3;
                }
                n4 = n;
                if (this.hasDividerBeforeChildAt(n2)) {
                    n4 = n + this.mDividerHeight;
                }
                n = n4 + layoutParams.topMargin;
                this.setChildFrame(view, n3, n + this.getLocationOffset(view), n12, n11);
                n12 = layoutParams.bottomMargin;
                n3 = this.getNextLocationOffset(view);
                n4 = n2 + this.getChildrenSkipCount(view, n2);
                n3 = n + (n11 + n12 + n3);
            }
            n2 = n4 + 1;
            n = n3;
        }
    }

    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        this.measureChildWithMargins(view, n2, n3, n4, n5);
    }

    void measureHorizontal(int n, int n2) {
        int n3;
        int n4;
        int n5;
        LayoutParams layoutParams;
        Object object;
        int n6;
        boolean bl;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        float f;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Object object2;
        int[] nArray;
        int n14;
        int n15;
        int n16;
        block50: {
            block51: {
                this.mTotalLength = 0;
                n16 = this.getVirtualChildCount();
                n15 = View.MeasureSpec.getMode((int)n);
                n14 = View.MeasureSpec.getMode((int)n2);
                if (this.mMaxAscent == null || this.mMaxDescent == null) {
                    this.mMaxAscent = new int[4];
                    this.mMaxDescent = new int[4];
                }
                nArray = this.mMaxAscent;
                object2 = this.mMaxDescent;
                nArray[3] = -1;
                nArray[2] = -1;
                nArray[1] = -1;
                nArray[0] = -1;
                object2[3] = -1;
                object2[2] = -1;
                object2[1] = -1;
                object2[0] = -1;
                bl4 = this.mBaselineAligned;
                bl3 = this.mUseLargestChild;
                bl2 = n15 == 0x40000000;
                f = 0.0f;
                n13 = 0;
                n12 = 0;
                n11 = 0;
                n10 = 0;
                n9 = 0;
                n8 = 0;
                n7 = 1;
                bl = false;
                for (n6 = 0; n6 < n16; ++n6) {
                    int n17;
                    block49: {
                        block48: {
                            block46: {
                                block47: {
                                    object = this.getVirtualChildAt(n6);
                                    if (object == null) {
                                        this.mTotalLength += this.measureNullChild(n6);
                                        continue;
                                    }
                                    if (object.getVisibility() == 8) {
                                        n6 += this.getChildrenSkipCount((View)object, n6);
                                        continue;
                                    }
                                    if (this.hasDividerBeforeChildAt(n6)) {
                                        this.mTotalLength += this.mDividerWidth;
                                    }
                                    layoutParams = (LayoutParams)object.getLayoutParams();
                                    f += layoutParams.weight;
                                    if (n15 != 0x40000000 || layoutParams.width != 0 || !(layoutParams.weight > 0.0f)) break block46;
                                    if (bl2) {
                                        this.mTotalLength += layoutParams.leftMargin + layoutParams.rightMargin;
                                    } else {
                                        n5 = this.mTotalLength;
                                        this.mTotalLength = Math.max(n5, layoutParams.leftMargin + n5 + layoutParams.rightMargin);
                                    }
                                    if (!bl4) break block47;
                                    n5 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                                    object.measure(n5, n5);
                                    n5 = n13;
                                    break block48;
                                }
                                n9 = 1;
                                break block49;
                            }
                            if (layoutParams.width == 0 && layoutParams.weight > 0.0f) {
                                layoutParams.width = -2;
                                n5 = 0;
                            } else {
                                n5 = Integer.MIN_VALUE;
                            }
                            n4 = f == 0.0f ? this.mTotalLength : 0;
                            this.measureChildBeforeLayout((View)object, n6, n, n4, n2, 0);
                            if (n5 != Integer.MIN_VALUE) {
                                layoutParams.width = n5;
                            }
                            n4 = object.getMeasuredWidth();
                            if (bl2) {
                                this.mTotalLength += layoutParams.leftMargin + n4 + layoutParams.rightMargin + this.getNextLocationOffset((View)object);
                            } else {
                                n5 = this.mTotalLength;
                                this.mTotalLength = Math.max(n5, n5 + n4 + layoutParams.leftMargin + layoutParams.rightMargin + this.getNextLocationOffset((View)object));
                            }
                            n5 = n13;
                            if (bl3) {
                                n5 = Math.max(n4, n13);
                            }
                        }
                        n13 = n5;
                    }
                    n3 = n6;
                    if (n14 != 0x40000000 && layoutParams.height == -1) {
                        n6 = 1;
                        bl = true;
                    } else {
                        n6 = 0;
                    }
                    n5 = layoutParams.topMargin + layoutParams.bottomMargin;
                    n4 = object.getMeasuredHeight() + n5;
                    int n18 = View.combineMeasuredStates((int)n8, (int)object.getMeasuredState());
                    if (bl4 && (n17 = object.getBaseline()) != -1) {
                        n8 = layoutParams.gravity < 0 ? this.mGravity : layoutParams.gravity;
                        n8 = ((n8 & 0x70) >> 4 & 0xFFFFFFFE) >> 1;
                        nArray[n8] = Math.max(nArray[n8], n17);
                        object2[n8] = Math.max(object2[n8], n4 - n17);
                    }
                    n12 = Math.max(n12, n4);
                    n7 = n7 != 0 && layoutParams.height == -1 ? 1 : 0;
                    if (layoutParams.weight > 0.0f) {
                        if (n6 == 0) {
                            n5 = n4;
                        }
                        n6 = Math.max(n10, n5);
                    } else {
                        if (n6 == 0) {
                            n5 = n4;
                        }
                        n11 = Math.max(n11, n5);
                        n6 = n10;
                    }
                    n5 = this.getChildrenSkipCount((View)object, n3) + n3;
                    n8 = n18;
                    n10 = n6;
                    n6 = n5;
                }
                if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(n16)) {
                    this.mTotalLength += this.mDividerWidth;
                }
                n6 = nArray[1] == -1 && nArray[0] == -1 && nArray[2] == -1 && nArray[3] == -1 ? n12 : Math.max(n12, Math.max(nArray[3], Math.max(nArray[0], Math.max(nArray[1], nArray[2]))) + Math.max(object2[3], Math.max(object2[0], Math.max(object2[1], object2[2]))));
                n12 = n8;
                n5 = n6;
                if (!bl3) break block50;
                if (n15 == Integer.MIN_VALUE) break block51;
                n5 = n6;
                if (n15 != 0) break block50;
            }
            this.mTotalLength = 0;
            n8 = 0;
            while (true) {
                n5 = n6;
                if (n8 >= n16) break;
                layoutParams = this.getVirtualChildAt(n8);
                if (layoutParams == null) {
                    this.mTotalLength += this.measureNullChild(n8);
                } else if (layoutParams.getVisibility() == 8) {
                    n8 += this.getChildrenSkipCount((View)layoutParams, n8);
                } else {
                    object = (LayoutParams)layoutParams.getLayoutParams();
                    if (bl2) {
                        this.mTotalLength += object.leftMargin + n13 + object.rightMargin + this.getNextLocationOffset((View)layoutParams);
                    } else {
                        n5 = this.mTotalLength;
                        this.mTotalLength = Math.max(n5, n5 + n13 + object.leftMargin + object.rightMargin + this.getNextLocationOffset((View)layoutParams));
                    }
                }
                ++n8;
            }
        }
        this.mTotalLength = n6 = this.mTotalLength + (this.getPaddingLeft() + this.getPaddingRight());
        n3 = View.resolveSizeAndState((int)Math.max(n6, this.getSuggestedMinimumWidth()), (int)n, (int)0);
        n4 = (0xFFFFFF & n3) - this.mTotalLength;
        if (!(n9 != 0 || n4 != 0 && f > 0.0f)) {
            n8 = Math.max(n11, n10);
            if (bl3 && n15 != 0x40000000) {
                for (n11 = 0; n11 < n16; ++n11) {
                    object2 = this.getVirtualChildAt(n11);
                    if (object2 == null || object2.getVisibility() == 8 || !(((LayoutParams)object2.getLayoutParams()).weight > 0.0f)) continue;
                    object2.measure(View.MeasureSpec.makeMeasureSpec((int)n13, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)object2.getMeasuredHeight(), (int)0x40000000));
                }
            }
            n6 = n16;
            n11 = n5;
            n13 = n8;
        } else {
            float f2 = this.mWeightSum;
            if (f2 > 0.0f) {
                f = f2;
            }
            nArray[3] = -1;
            nArray[2] = -1;
            nArray[1] = -1;
            nArray[0] = -1;
            object2[3] = -1;
            object2[2] = -1;
            object2[1] = -1;
            object2[0] = -1;
            this.mTotalLength = 0;
            n8 = n12;
            n10 = -1;
            n6 = n7;
            n13 = n16;
            n7 = n8;
            n8 = n11;
            n11 = n4;
            for (n12 = 0; n12 < n13; ++n12) {
                object = this.getVirtualChildAt(n12);
                if (object == null || object.getVisibility() == 8) continue;
                layoutParams = (LayoutParams)object.getLayoutParams();
                f2 = layoutParams.weight;
                if (f2 > 0.0f) {
                    n5 = (int)((float)n11 * f2 / f);
                    n4 = LinearLayoutCompat.getChildMeasureSpec((int)n2, (int)(this.getPaddingTop() + this.getPaddingBottom() + layoutParams.topMargin + layoutParams.bottomMargin), (int)layoutParams.height);
                    if (layoutParams.width == 0 && n15 == 0x40000000) {
                        n9 = n5 > 0 ? n5 : 0;
                        object.measure(View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000), n4);
                    } else {
                        n9 = n16 = object.getMeasuredWidth() + n5;
                        if (n16 < 0) {
                            n9 = 0;
                        }
                        object.measure(View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000), n4);
                    }
                    n7 = View.combineMeasuredStates((int)n7, (int)(object.getMeasuredState() & 0xFF000000));
                    f -= f2;
                    n11 -= n5;
                }
                if (bl2) {
                    this.mTotalLength += object.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin + this.getNextLocationOffset((View)object);
                } else {
                    n9 = this.mTotalLength;
                    this.mTotalLength = Math.max(n9, object.getMeasuredWidth() + n9 + layoutParams.leftMargin + layoutParams.rightMargin + this.getNextLocationOffset((View)object));
                }
                n9 = n14 != 0x40000000 && layoutParams.height == -1 ? 1 : 0;
                n4 = layoutParams.topMargin + layoutParams.bottomMargin;
                n16 = object.getMeasuredHeight() + n4;
                n5 = Math.max(n10, n16);
                n10 = n9 != 0 ? n4 : n16;
                n10 = Math.max(n8, n10);
                n6 = n6 != 0 && layoutParams.height == -1 ? 1 : 0;
                if (bl4 && (n9 = object.getBaseline()) != -1) {
                    n8 = layoutParams.gravity < 0 ? this.mGravity : layoutParams.gravity;
                    n8 = ((n8 & 0x70) >> 4 & 0xFFFFFFFE) >> 1;
                    nArray[n8] = Math.max(nArray[n8], n9);
                    object2[n8] = Math.max(object2[n8], n16 - n9);
                }
                n8 = n10;
                n10 = n5;
            }
            this.mTotalLength += this.getPaddingLeft() + this.getPaddingRight();
            n11 = nArray[1] == -1 && nArray[0] == -1 && nArray[2] == -1 && nArray[3] == -1 ? n10 : Math.max(n10, Math.max(nArray[3], Math.max(nArray[0], Math.max(nArray[1], nArray[2]))) + Math.max(object2[3], Math.max(object2[0], Math.max(object2[1], object2[2]))));
            n12 = n7;
            n7 = n6;
            n6 = n13;
            n13 = n8;
        }
        if (n7 == 0 && n14 != 0x40000000) {
            n11 = n13;
        }
        this.setMeasuredDimension(n3 | n12 & 0xFF000000, View.resolveSizeAndState((int)Math.max(n11 + (this.getPaddingTop() + this.getPaddingBottom()), this.getSuggestedMinimumHeight()), (int)n2, (int)(n12 << 16)));
        if (bl) {
            this.forceUniformHeight(n6, n);
        }
    }

    int measureNullChild(int n) {
        return 0;
    }

    void measureVertical(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        LayoutParams layoutParams;
        Object object;
        int n7;
        this.mTotalLength = 0;
        int n8 = this.getVirtualChildCount();
        int n9 = View.MeasureSpec.getMode((int)n);
        int n10 = View.MeasureSpec.getMode((int)n2);
        int n11 = this.mBaselineAlignedChildIndex;
        boolean bl = this.mUseLargestChild;
        float f = 0.0f;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 1;
        boolean bl2 = false;
        for (n7 = 0; n7 < n8; ++n7) {
            object = this.getVirtualChildAt(n7);
            if (object == null) {
                this.mTotalLength += this.measureNullChild(n7);
                continue;
            }
            if (object.getVisibility() == 8) {
                n7 += this.getChildrenSkipCount((View)object, n7);
                continue;
            }
            if (this.hasDividerBeforeChildAt(n7)) {
                this.mTotalLength += this.mDividerHeight;
            }
            layoutParams = (LayoutParams)object.getLayoutParams();
            f += layoutParams.weight;
            if (n10 == 0x40000000 && layoutParams.height == 0 && layoutParams.weight > 0.0f) {
                n17 = this.mTotalLength;
                this.mTotalLength = Math.max(n17, layoutParams.topMargin + n17 + layoutParams.bottomMargin);
                n17 = 1;
            } else {
                if (layoutParams.height == 0 && layoutParams.weight > 0.0f) {
                    layoutParams.height = -2;
                    n6 = 0;
                } else {
                    n6 = Integer.MIN_VALUE;
                }
                n5 = f == 0.0f ? this.mTotalLength : 0;
                this.measureChildBeforeLayout((View)object, n7, n, 0, n2, n5);
                if (n6 != Integer.MIN_VALUE) {
                    layoutParams.height = n6;
                }
                n6 = object.getMeasuredHeight();
                n5 = this.mTotalLength;
                this.mTotalLength = Math.max(n5, n5 + n6 + layoutParams.topMargin + layoutParams.bottomMargin + this.getNextLocationOffset((View)object));
                if (bl) {
                    n14 = Math.max(n6, n14);
                }
            }
            n4 = n7;
            if (n11 >= 0 && n11 == n4 + 1) {
                this.mBaselineChildTop = this.mTotalLength;
            }
            if (n4 < n11 && layoutParams.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            if (n9 != 0x40000000 && layoutParams.width == -1) {
                n7 = 1;
                bl2 = true;
            } else {
                n7 = 0;
            }
            n5 = layoutParams.leftMargin + layoutParams.rightMargin;
            n6 = object.getMeasuredWidth() + n5;
            n13 = Math.max(n13, n6);
            n3 = View.combineMeasuredStates((int)n12, (int)object.getMeasuredState());
            n12 = n18 != 0 && layoutParams.width == -1 ? 1 : 0;
            if (layoutParams.weight > 0.0f) {
                if (n7 != 0) {
                    n6 = n5;
                }
                n15 = Math.max(n15, n6);
                n18 = n16;
            } else {
                if (n7 == 0) {
                    n5 = n6;
                }
                n18 = Math.max(n16, n5);
            }
            n7 = this.getChildrenSkipCount((View)object, n4);
            n16 = n18;
            n6 = n3;
            n7 += n4;
            n18 = n12;
            n12 = n6;
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(n8)) {
            this.mTotalLength += this.mDividerHeight;
        }
        if (bl && (n10 == Integer.MIN_VALUE || n10 == 0)) {
            this.mTotalLength = 0;
            for (n7 = 0; n7 < n8; ++n7) {
                layoutParams = this.getVirtualChildAt(n7);
                if (layoutParams == null) {
                    this.mTotalLength += this.measureNullChild(n7);
                    continue;
                }
                if (layoutParams.getVisibility() == 8) {
                    n7 += this.getChildrenSkipCount((View)layoutParams, n7);
                    continue;
                }
                object = (LayoutParams)layoutParams.getLayoutParams();
                n6 = this.mTotalLength;
                this.mTotalLength = Math.max(n6, n6 + n14 + object.topMargin + object.bottomMargin + this.getNextLocationOffset((View)layoutParams));
            }
        }
        this.mTotalLength = n7 = this.mTotalLength + (this.getPaddingTop() + this.getPaddingBottom());
        n5 = View.resolveSizeAndState((int)Math.max(n7, this.getSuggestedMinimumHeight()), (int)n2, (int)0);
        n7 = (0xFFFFFF & n5) - this.mTotalLength;
        if (!(n17 != 0 || n7 != 0 && f > 0.0f)) {
            n16 = Math.max(n16, n15);
            if (bl && n10 != 0x40000000) {
                for (n15 = 0; n15 < n8; ++n15) {
                    object = this.getVirtualChildAt(n15);
                    if (object == null || object.getVisibility() == 8 || !(((LayoutParams)object.getLayoutParams()).weight > 0.0f)) continue;
                    object.measure(View.MeasureSpec.makeMeasureSpec((int)object.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n14, (int)0x40000000));
                }
            }
            n15 = n12;
            n12 = n16;
            n14 = n13;
        } else {
            float f2 = this.mWeightSum;
            if (f2 > 0.0f) {
                f = f2;
            }
            this.mTotalLength = 0;
            n15 = n7;
            n14 = n13;
            for (n7 = 0; n7 < n8; ++n7) {
                layoutParams = this.getVirtualChildAt(n7);
                if (layoutParams.getVisibility() == 8) continue;
                object = (LayoutParams)layoutParams.getLayoutParams();
                f2 = object.weight;
                if (f2 > 0.0f) {
                    n13 = (int)((float)n15 * f2 / f);
                    n11 = this.getPaddingLeft();
                    int n19 = this.getPaddingRight();
                    n6 = object.leftMargin;
                    n3 = object.rightMargin;
                    n4 = object.width;
                    n17 = n15 - n13;
                    n6 = LinearLayoutCompat.getChildMeasureSpec((int)n, (int)(n11 + n19 + n6 + n3), (int)n4);
                    if (object.height == 0 && n10 == 0x40000000) {
                        n15 = n13 > 0 ? n13 : 0;
                        layoutParams.measure(n6, View.MeasureSpec.makeMeasureSpec((int)n15, (int)0x40000000));
                    } else {
                        n15 = n13 = layoutParams.getMeasuredHeight() + n13;
                        if (n13 < 0) {
                            n15 = 0;
                        }
                        layoutParams.measure(n6, View.MeasureSpec.makeMeasureSpec((int)n15, (int)0x40000000));
                    }
                    n12 = View.combineMeasuredStates((int)n12, (int)(layoutParams.getMeasuredState() & 0xFFFFFF00));
                    f -= f2;
                    n15 = n17;
                }
                n6 = object.leftMargin + object.rightMargin;
                n13 = layoutParams.getMeasuredWidth() + n6;
                n17 = Math.max(n14, n13);
                n14 = n9 != 0x40000000 && object.width == -1 ? 1 : 0;
                n14 = n14 != 0 ? n6 : n13;
                n16 = Math.max(n16, n14);
                n18 = n18 != 0 && object.width == -1 ? 1 : 0;
                n14 = this.mTotalLength;
                this.mTotalLength = Math.max(n14, layoutParams.getMeasuredHeight() + n14 + object.topMargin + object.bottomMargin + this.getNextLocationOffset((View)layoutParams));
                n14 = n17;
            }
            this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
            n15 = n12;
            n12 = n16;
        }
        if (n18 != 0 || n9 == 0x40000000) {
            n12 = n14;
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)Math.max(n12 + (this.getPaddingLeft() + this.getPaddingRight()), this.getSuggestedMinimumWidth()), (int)n, (int)n15), n5);
        if (bl2) {
            this.forceUniformWidth(n8, n2);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersHorizontal(canvas);
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)ACCESSIBILITY_CLASS_NAME);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.mOrientation == 1) {
            this.layoutVertical(n, n2, n3, n4);
        } else {
            this.layoutHorizontal(n, n2, n3, n4);
        }
    }

    protected void onMeasure(int n, int n2) {
        if (this.mOrientation == 1) {
            this.measureVertical(n, n2);
        } else {
            this.measureHorizontal(n, n2);
        }
    }

    public void setBaselineAligned(boolean bl) {
        this.mBaselineAligned = bl;
    }

    public void setBaselineAlignedChildIndex(int n) {
        if (n >= 0 && n < this.getChildCount()) {
            this.mBaselineAlignedChildIndex = n;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("base aligned child index out of range (0, ");
        stringBuilder.append(this.getChildCount());
        stringBuilder.append(")");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setDividerDrawable(Drawable drawable2) {
        if (drawable2 == this.mDivider) {
            return;
        }
        this.mDivider = drawable2;
        boolean bl = false;
        if (drawable2 != null) {
            this.mDividerWidth = drawable2.getIntrinsicWidth();
            this.mDividerHeight = drawable2.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        if (drawable2 == null) {
            bl = true;
        }
        this.setWillNotDraw(bl);
        this.requestLayout();
    }

    public void setDividerPadding(int n) {
        this.mDividerPadding = n;
    }

    public void setGravity(int n) {
        if (this.mGravity != n) {
            int n2 = n;
            if ((0x800007 & n) == 0) {
                n2 = n | 0x800003;
            }
            n = n2;
            if ((n2 & 0x70) == 0) {
                n = n2 | 0x30;
            }
            this.mGravity = n;
            this.requestLayout();
        }
    }

    public void setHorizontalGravity(int n) {
        n = this.mGravity;
        int n2 = n & 0x800007;
        if ((0x800007 & n) != n2) {
            this.mGravity = n2 | 0xFF7FFFF8 & n;
            this.requestLayout();
        }
    }

    public void setMeasureWithLargestChildEnabled(boolean bl) {
        this.mUseLargestChild = bl;
    }

    public void setOrientation(int n) {
        if (this.mOrientation != n) {
            this.mOrientation = n;
            this.requestLayout();
        }
    }

    public void setShowDividers(int n) {
        if (n != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = n;
    }

    public void setVerticalGravity(int n) {
        int n2 = this.mGravity;
        if ((n2 & 0x70) != (n &= 0x70)) {
            this.mGravity = n | n2 & 0xFFFFFF8F;
            this.requestLayout();
        }
    }

    public void setWeightSum(float f) {
        this.mWeightSum = Math.max(0.0f, f);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerMode {
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

