/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import androidx.appcompat.widget.TintResources;
import androidx.appcompat.widget.VectorEnabledTintResources;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TintContextWrapper
extends ContextWrapper {
    private static final Object CACHE_LOCK = new Object();
    private static ArrayList<WeakReference<TintContextWrapper>> sCache;
    private final Resources mResources;
    private final Resources.Theme mTheme;

    private TintContextWrapper(Context context) {
        super(context);
        if (VectorEnabledTintResources.shouldBeUsed()) {
            VectorEnabledTintResources vectorEnabledTintResources = new VectorEnabledTintResources((Context)this, context.getResources());
            this.mResources = vectorEnabledTintResources;
            vectorEnabledTintResources = vectorEnabledTintResources.newTheme();
            this.mTheme = vectorEnabledTintResources;
            vectorEnabledTintResources.setTo(context.getTheme());
        } else {
            this.mResources = new TintResources((Context)this, context.getResources());
            this.mTheme = null;
        }
    }

    private static boolean shouldWrap(Context context) {
        boolean bl;
        block2: {
            block4: {
                boolean bl2;
                block3: {
                    boolean bl3 = context instanceof TintContextWrapper;
                    bl = bl2 = false;
                    if (bl3) break block2;
                    bl = bl2;
                    if (context.getResources() instanceof TintResources) break block2;
                    if (!(context.getResources() instanceof VectorEnabledTintResources)) break block3;
                    bl = bl2;
                    break block2;
                }
                if (Build.VERSION.SDK_INT < 21) break block4;
                bl = bl2;
                if (!VectorEnabledTintResources.shouldBeUsed()) break block2;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Context wrap(Context object) {
        if (!TintContextWrapper.shouldWrap(object)) {
            return object;
        }
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            Object object3 = sCache;
            if (object3 == null) {
                object3 = new Object();
                sCache = object3;
            } else {
                int n;
                for (n = object3.size() - 1; n >= 0; --n) {
                    object3 = sCache.get(n);
                    if (object3 != null && ((Reference)object3).get() != null) continue;
                    sCache.remove(n);
                }
                for (n = sCache.size() - 1; n >= 0; --n) {
                    object3 = sCache.get(n);
                    object3 = object3 != null ? (TintContextWrapper)((Object)((Reference)object3).get()) : null;
                    if (object3 == null || object3.getBaseContext() != object) continue;
                    return object3;
                }
            }
            object3 = new Object((Context)object);
            ArrayList<WeakReference<TintContextWrapper>> arrayList = sCache;
            object = new WeakReference(object3);
            arrayList.add((WeakReference<TintContextWrapper>)object);
            return object3;
        }
    }

    public AssetManager getAssets() {
        return this.mResources.getAssets();
    }

    public Resources getResources() {
        return this.mResources;
    }

    public Resources.Theme getTheme() {
        Resources.Theme theme;
        Resources.Theme theme2 = theme = this.mTheme;
        if (theme == null) {
            theme2 = super.getTheme();
        }
        return theme2;
    }

    public void setTheme(int n) {
        Resources.Theme theme = this.mTheme;
        if (theme == null) {
            super.setTheme(n);
        } else {
            theme.applyStyle(n, true);
        }
    }
}

