/*
 * Decompiled with CFR 0.152.
 */
package androidx.concurrent.futures;

import androidx.concurrent.futures.AbstractResolvableFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0;
import androidx.concurrent.futures.DirectExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractResolvableFuture<V>
implements ListenableFuture<V> {
    static final AtomicHelper ATOMIC_HELPER;
    static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Object NULL;
    private static final long SPIN_THRESHOLD_NANOS = 1000L;
    private static final Logger log;
    volatile Listener listeners;
    volatile Object value;
    volatile Waiter waiters;

    static {
        Object var1_1;
        AtomicHelper atomicHelper;
        GENERATE_CANCELLATION_CAUSES = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        log = Logger.getLogger(AbstractResolvableFuture.class.getName());
        try {
            atomicHelper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractResolvableFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractResolvableFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractResolvableFuture.class, Object.class, "value"));
            var1_1 = null;
        }
        catch (Throwable throwable) {
            atomicHelper = new SynchronizedHelper();
        }
        ATOMIC_HELPER = atomicHelper;
        if (var1_1 != null) {
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", (Throwable)var1_1);
        }
        NULL = new Object();
    }

    protected AbstractResolvableFuture() {
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            V v = AbstractResolvableFuture.getUninterruptibly(this);
            stringBuilder.append("SUCCESS, result=[");
            stringBuilder.append(this.userObjectToString(v));
            stringBuilder.append("]");
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[");
            stringBuilder.append(runtimeException.getClass());
            stringBuilder.append(" thrown from get()]");
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[");
            stringBuilder.append(executionException.getCause());
            stringBuilder.append("]");
        }
    }

    private static CancellationException cancellationExceptionWithCause(String object, Throwable throwable) {
        object = new CancellationException((String)object);
        ((Throwable)object).initCause(throwable);
        return object;
    }

    static <T> T checkNotNull(T t) {
        Objects.requireNonNull(t);
        return t;
    }

    private Listener clearListeners(Listener listener) {
        Listener listener2;
        while (!ATOMIC_HELPER.casListeners(this, listener2 = this.listeners, Listener.TOMBSTONE)) {
        }
        Listener listener3 = listener;
        listener = listener2;
        while (listener != null) {
            listener2 = listener.next;
            listener.next = listener3;
            listener3 = listener;
            listener = listener2;
        }
        return listener3;
    }

    static void complete(AbstractResolvableFuture<?> object) {
        Runnable runnable = null;
        Object object2 = object;
        object = runnable;
        block0: while (true) {
            super.releaseWaiters();
            ((AbstractResolvableFuture)object2).afterDone();
            object2 = super.clearListeners((Listener)object);
            while (object2 != null) {
                object = ((Listener)object2).next;
                runnable = ((Listener)object2).task;
                if (runnable instanceof SetFuture) {
                    Object object3;
                    runnable = (SetFuture)runnable;
                    object2 = ((SetFuture)runnable).owner;
                    if (((AbstractResolvableFuture)object2).value == runnable && ATOMIC_HELPER.casValue((AbstractResolvableFuture<?>)object2, runnable, object3 = AbstractResolvableFuture.getFutureValue(((SetFuture)runnable).future))) {
                        continue block0;
                    }
                } else {
                    AbstractResolvableFuture.executeListener(runnable, ((Listener)object2).executor);
                }
                object2 = object;
            }
            break;
        }
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RuntimeException while executing runnable ");
            stringBuilder.append(runnable);
            stringBuilder.append(" with executor ");
            stringBuilder.append(executor);
            logger.log(level, stringBuilder.toString(), runtimeException);
        }
    }

    private V getDoneValue(Object object) throws ExecutionException {
        if (!(object instanceof Cancellation)) {
            if (!(object instanceof Failure)) {
                Object object2 = object;
                if (object == NULL) {
                    object2 = null;
                }
                return (V)object2;
            }
            throw new ExecutionException(((Failure)object).exception);
        }
        throw AbstractResolvableFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)object).cause);
    }

    static Object getFutureValue(ListenableFuture<?> object) {
        Object object2;
        block10: {
            if (object instanceof AbstractResolvableFuture) {
                Object object3 = ((AbstractResolvableFuture)object).value;
                object = object3;
                if (object3 instanceof Cancellation) {
                    Cancellation cancellation = (Cancellation)object3;
                    object = object3;
                    if (cancellation.wasInterrupted) {
                        object = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                    }
                }
                return object;
            }
            boolean bl = object.isCancelled();
            if ((GENERATE_CANCELLATION_CAUSES ^ true) & bl) {
                return Cancellation.CAUSELESS_CANCELLED;
            }
            Object object4 = AbstractResolvableFuture.getUninterruptibly(object);
            object2 = object4;
            if (object4 != null) break block10;
            try {
                object2 = NULL;
            }
            catch (Throwable throwable) {
                return new Failure(throwable);
            }
            catch (CancellationException cancellationException) {
                if (!bl) {
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("get() threw CancellationException, despite reporting isCancelled() == false: ");
                    ((StringBuilder)object4).append(object);
                    return new Failure(new IllegalArgumentException(((StringBuilder)object4).toString(), cancellationException));
                }
                return new Cancellation(false, cancellationException);
            }
            catch (ExecutionException executionException) {
                return new Failure(executionException.getCause());
            }
        }
        return object2;
    }

    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v;
            block5: {
                try {
                    v = future.get();
                    if (!bl) break block5;
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
            }
            return v;
            break;
        }
    }

    private void releaseWaiters() {
        Waiter waiter;
        while (!ATOMIC_HELPER.casWaiters(this, waiter = this.waiters, Waiter.TOMBSTONE)) {
        }
        while (waiter != null) {
            waiter.unpark();
            waiter = waiter.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            if ((var1_1 = this.waiters) == Waiter.TOMBSTONE) {
                return;
            }
            var2_2 = null;
            while (var1_1 != null) {
                var3_3 = var1_1.next;
                if (var1_1.thread != null) {
                    var4_4 = var1_1;
                } else if (var2_2 != null) {
                    var2_2.next = var3_3;
                    var4_4 = var2_2;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    var4_4 = var2_2;
                    if (AbstractResolvableFuture.ATOMIC_HELPER.casWaiters(this, var1_1, var3_3)) ** break;
                    continue block0;
                }
                var1_1 = var3_3;
                var2_2 = var4_4;
            }
            break;
        }
    }

    private String userObjectToString(Object object) {
        if (object == this) {
            return "this future";
        }
        return String.valueOf(object);
    }

    public final void addListener(Runnable runnable, Executor executor) {
        AbstractResolvableFuture.checkNotNull(runnable);
        AbstractResolvableFuture.checkNotNull(executor);
        Listener listener = this.listeners;
        if (listener != Listener.TOMBSTONE) {
            Listener listener2;
            Listener listener3 = new Listener(runnable, executor);
            do {
                listener3.next = listener;
                if (ATOMIC_HELPER.casListeners(this, listener, listener3)) {
                    return;
                }
                listener = listener2 = this.listeners;
            } while (listener2 != Listener.TOMBSTONE);
        }
        AbstractResolvableFuture.executeListener(runnable, executor);
    }

    protected void afterDone() {
    }

    public final boolean cancel(boolean bl) {
        boolean bl2;
        Object object = this.value;
        boolean bl3 = true;
        boolean bl4 = object == null;
        if (bl4 | object instanceof SetFuture) {
            Cancellation cancellation = GENERATE_CANCELLATION_CAUSES ? new Cancellation(bl, new CancellationException("Future.cancel() was called.")) : (bl ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED);
            bl2 = false;
            AbstractResolvableFuture abstractResolvableFuture = this;
            while (true) {
                if (ATOMIC_HELPER.casValue(abstractResolvableFuture, object, cancellation)) {
                    if (bl) {
                        abstractResolvableFuture.interruptTask();
                    }
                    AbstractResolvableFuture.complete(abstractResolvableFuture);
                    bl2 = bl3;
                    if (object instanceof SetFuture) {
                        object = ((SetFuture)object).future;
                        if (object instanceof AbstractResolvableFuture) {
                            abstractResolvableFuture = (AbstractResolvableFuture)object;
                            object = abstractResolvableFuture.value;
                            bl4 = object == null;
                            bl2 = bl3;
                            if (bl4 | object instanceof SetFuture) {
                                bl2 = true;
                                continue;
                            }
                        } else {
                            object.cancel(bl);
                            bl2 = bl3;
                        }
                    }
                    break;
                }
                Object object2 = abstractResolvableFuture.value;
                object = object2;
                if (!(object2 instanceof SetFuture)) break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public final V get() throws InterruptedException, ExecutionException {
        if (!Thread.interrupted()) {
            Object object = this.value;
            boolean bl = object != null;
            if (bl & (object instanceof SetFuture ^ true)) {
                return this.getDoneValue(object);
            }
            object = this.waiters;
            if (object != Waiter.TOMBSTONE) {
                Waiter waiter;
                Waiter waiter2 = new Waiter();
                do {
                    waiter2.setNext((Waiter)object);
                    if (ATOMIC_HELPER.casWaiters(this, (Waiter)object, waiter2)) {
                        block6: {
                            do {
                                LockSupport.park(this);
                                if (Thread.interrupted()) break block6;
                            } while (!((bl = (object = this.value) != null) & (object instanceof SetFuture ^ true)));
                            return this.getDoneValue(object);
                        }
                        this.removeWaiter(waiter2);
                        throw new InterruptedException();
                    }
                    waiter = this.waiters;
                    object = waiter;
                } while (waiter != Waiter.TOMBSTONE);
            }
            return this.getDoneValue(this.value);
        }
        throw new InterruptedException();
    }

    public final V get(long l, TimeUnit object) throws InterruptedException, TimeoutException, ExecutionException {
        long l2 = ((TimeUnit)((Object)object)).toNanos(l);
        if (!Thread.interrupted()) {
            Object object2;
            Object object3;
            long l3;
            long l4;
            boolean bl;
            Object object4;
            block17: {
                object4 = this.value;
                bl = object4 != null;
                if (bl & (object4 instanceof SetFuture ^ true)) {
                    return this.getDoneValue(object4);
                }
                l4 = l2 > 0L ? System.nanoTime() + l2 : 0L;
                l3 = l2;
                if (l2 >= 1000L) {
                    object4 = this.waiters;
                    if (object4 != Waiter.TOMBSTONE) {
                        object3 = new Waiter();
                        do {
                            ((Waiter)object3).setNext((Waiter)object4);
                            if (ATOMIC_HELPER.casWaiters(this, (Waiter)object4, (Waiter)object3)) {
                                block16: {
                                    do {
                                        LockSupport.parkNanos(this, l2);
                                        if (Thread.interrupted()) break block16;
                                        object4 = this.value;
                                        bl = object4 != null;
                                        if (bl & (object4 instanceof SetFuture ^ true)) {
                                            return this.getDoneValue(object4);
                                        }
                                        l2 = l3 = l4 - System.nanoTime();
                                    } while (l3 >= 1000L);
                                    this.removeWaiter((Waiter)object3);
                                    break block17;
                                }
                                this.removeWaiter((Waiter)object3);
                                throw new InterruptedException();
                            }
                            object4 = object2 = this.waiters;
                        } while (object2 != Waiter.TOMBSTONE);
                    }
                    return this.getDoneValue(this.value);
                }
            }
            while (l3 > 0L) {
                object4 = this.value;
                bl = object4 != null;
                if (bl & (object4 instanceof SetFuture ^ true)) {
                    return this.getDoneValue(object4);
                }
                if (!Thread.interrupted()) {
                    l3 = l4 - System.nanoTime();
                    continue;
                }
                throw new InterruptedException();
            }
            object3 = this.toString();
            String string2 = ((Enum)object).toString().toLowerCase(Locale.ROOT);
            object4 = new StringBuilder();
            ((StringBuilder)object4).append("Waited ");
            ((StringBuilder)object4).append(l);
            ((StringBuilder)object4).append(" ");
            ((StringBuilder)object4).append(((Enum)object).toString().toLowerCase(Locale.ROOT));
            object4 = object2 = ((StringBuilder)object4).toString();
            if (l3 + 1000L < 0L) {
                object4 = new StringBuilder();
                ((StringBuilder)object4).append((String)object2);
                ((StringBuilder)object4).append(" (plus ");
                object4 = ((StringBuilder)object4).toString();
                l3 = -l3;
                l = ((TimeUnit)((Object)object)).convert(l3, TimeUnit.NANOSECONDS);
                long l5 = l - 0L;
                long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                bl = l6 == false || (l3 -= ((TimeUnit)((Object)object)).toNanos(l)) > 1000L;
                object = object4;
                if (l6 > 0) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append((String)object4);
                    ((StringBuilder)object).append(l);
                    ((StringBuilder)object).append(" ");
                    ((StringBuilder)object).append(string2);
                    object = object4 = ((StringBuilder)object).toString();
                    if (bl) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append((String)object4);
                        ((StringBuilder)object).append(",");
                        object = ((StringBuilder)object).toString();
                    }
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append((String)object);
                    ((StringBuilder)object4).append(" ");
                    object = ((StringBuilder)object4).toString();
                }
                object4 = object;
                if (bl) {
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append((String)object);
                    ((StringBuilder)object4).append(l3);
                    ((StringBuilder)object4).append(" nanoseconds ");
                    object4 = ((StringBuilder)object4).toString();
                }
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object4);
                ((StringBuilder)object).append("delay)");
                object4 = ((StringBuilder)object).toString();
            }
            if (this.isDone()) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object4);
                ((StringBuilder)object).append(" but future completed as timeout expired");
                throw new TimeoutException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object4);
            ((StringBuilder)object).append(" for ");
            ((StringBuilder)object).append((String)object3);
            throw new TimeoutException(((StringBuilder)object).toString());
        }
        throw new InterruptedException();
    }

    protected void interruptTask() {
    }

    public final boolean isCancelled() {
        return this.value instanceof Cancellation;
    }

    public final boolean isDone() {
        Object object = this.value;
        boolean bl = object != null;
        return (object instanceof SetFuture ^ true) & bl;
    }

    final void maybePropagateCancellationTo(Future<?> future) {
        boolean bl = future != null;
        if (bl & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    protected String pendingToString() {
        Object object = this.value;
        if (object instanceof SetFuture) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("setFuture=[");
            stringBuilder.append(this.userObjectToString(((SetFuture)object).future));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (this instanceof ScheduledFuture) {
            object = new StringBuilder();
            ((StringBuilder)object).append("remaining delay=[");
            ((StringBuilder)object).append(((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS));
            ((StringBuilder)object).append(" ms]");
            return ((StringBuilder)object).toString();
        }
        return null;
    }

    protected boolean set(V v) {
        Object object = v;
        if (v == null) {
            object = NULL;
        }
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractResolvableFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable object) {
        if (ATOMIC_HELPER.casValue(this, null, object = new Failure(AbstractResolvableFuture.checkNotNull(object)))) {
            AbstractResolvableFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setFuture(ListenableFuture<? extends V> object) {
        AbstractResolvableFuture.checkNotNull(object);
        SetFuture<? extends V> setFuture = this.value;
        SetFuture<? extends V> setFuture2 = setFuture;
        if (setFuture == null) {
            if (object.isDone()) {
                if (ATOMIC_HELPER.casValue(this, null, object = AbstractResolvableFuture.getFutureValue(object))) {
                    AbstractResolvableFuture.complete(this);
                    return true;
                }
                return false;
            }
            setFuture2 = new SetFuture<V>(this, object);
            if (ATOMIC_HELPER.casValue(this, null, setFuture2)) {
                try {
                    object.addListener(setFuture2, (Executor)DirectExecutor.INSTANCE);
                }
                catch (Throwable throwable) {
                    try {
                        object = new Object(throwable);
                    }
                    catch (Throwable throwable2) {
                        object = Failure.FALLBACK_INSTANCE;
                    }
                    ATOMIC_HELPER.casValue(this, setFuture2, object);
                }
                return true;
            }
            setFuture2 = this.value;
        }
        if (setFuture2 instanceof Cancellation) {
            object.cancel(((Cancellation)((Object)setFuture2)).wasInterrupted);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(stringBuilder);
        } else {
            String string2;
            try {
                string2 = this.pendingToString();
            }
            catch (RuntimeException runtimeException) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("Exception thrown from implementation: ");
                stringBuilder2.append(runtimeException.getClass());
                string2 = stringBuilder2.toString();
            }
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append("PENDING, info=[");
                stringBuilder.append(string2);
                stringBuilder.append("]");
            } else if (this.isDone()) {
                this.addDoneString(stringBuilder);
            } else {
                stringBuilder.append("PENDING");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        boolean bl = object instanceof Cancellation && ((Cancellation)object).wasInterrupted;
        return bl;
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract boolean casListeners(AbstractResolvableFuture<?> var1, Listener var2, Listener var3);

        abstract boolean casValue(AbstractResolvableFuture<?> var1, Object var2, Object var3);

        abstract boolean casWaiters(AbstractResolvableFuture<?> var1, Waiter var2, Waiter var3);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract void putThread(Waiter var1, Thread var2);
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_CANCELLED;
        static final Cancellation CAUSELESS_INTERRUPTED;
        final Throwable cause;
        final boolean wasInterrupted;

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                CAUSELESS_CANCELLED = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = new Cancellation(true, null);
            }
        }

        Cancellation(boolean bl, Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE = new Failure(new Throwable("Failure occurred while trying to finish a future."){

            /*
             * Enabled aggressive block sorting
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Throwable fillInStackTrace() {
                // MONITORENTER : this
                // MONITOREXIT : this
                return this;
            }
        });
        final Throwable exception;

        Failure(Throwable throwable) {
            this.exception = AbstractResolvableFuture.checkNotNull(throwable);
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE = new Listener(null, null);
        final Executor executor;
        Listener next;
        final Runnable task;

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<AbstractResolvableFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractResolvableFuture, Object> valueUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<AbstractResolvableFuture, Waiter> waitersUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater<Waiter, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<Waiter, Waiter> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<AbstractResolvableFuture, Waiter> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<AbstractResolvableFuture, Listener> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<AbstractResolvableFuture, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        boolean casListeners(AbstractResolvableFuture<?> abstractResolvableFuture, Listener listener, Listener listener2) {
            return AbstractResolvableFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.listenersUpdater, abstractResolvableFuture, listener, listener2);
        }

        @Override
        boolean casValue(AbstractResolvableFuture<?> abstractResolvableFuture, Object object, Object object2) {
            return AbstractResolvableFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.valueUpdater, abstractResolvableFuture, object, object2);
        }

        @Override
        boolean casWaiters(AbstractResolvableFuture<?> abstractResolvableFuture, Waiter waiter, Waiter waiter2) {
            return AbstractResolvableFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.waitersUpdater, abstractResolvableFuture, waiter, waiter2);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }
    }

    private static final class SetFuture<V>
    implements Runnable {
        final ListenableFuture<? extends V> future;
        final AbstractResolvableFuture<V> owner;

        SetFuture(AbstractResolvableFuture<V> abstractResolvableFuture, ListenableFuture<? extends V> listenableFuture) {
            this.owner = abstractResolvableFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (this.owner.value != this) {
                return;
            }
            Object object = AbstractResolvableFuture.getFutureValue(this.future);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractResolvableFuture.complete(this.owner);
            }
        }
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        SynchronizedHelper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casListeners(AbstractResolvableFuture<?> abstractResolvableFuture, Listener listener, Listener listener2) {
            synchronized (abstractResolvableFuture) {
                if (abstractResolvableFuture.listeners == listener) {
                    abstractResolvableFuture.listeners = listener2;
                    return true;
                }
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casValue(AbstractResolvableFuture<?> abstractResolvableFuture, Object object, Object object2) {
            synchronized (abstractResolvableFuture) {
                if (abstractResolvableFuture.value == object) {
                    abstractResolvableFuture.value = object2;
                    return true;
                }
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casWaiters(AbstractResolvableFuture<?> abstractResolvableFuture, Waiter waiter, Waiter waiter2) {
            synchronized (abstractResolvableFuture) {
                if (abstractResolvableFuture.waiters == waiter) {
                    abstractResolvableFuture.waiters = waiter2;
                    return true;
                }
                return false;
            }
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE = new Waiter(false);
        volatile Waiter next;
        volatile Thread thread;

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        Waiter(boolean bl) {
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
        }
    }
}

