/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.PriorityGoalRow;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.SolverVariableValues;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;

public class LinearSystem {
    public static long ARRAY_ROW_CREATION = 0L;
    public static final boolean DEBUG = false;
    private static final boolean DEBUG_CONSTRAINTS = false;
    public static final boolean FULL_DEBUG = false;
    public static final boolean MEASURE = false;
    public static long OPTIMIZED_ARRAY_ROW_CREATION = 0L;
    public static boolean OPTIMIZED_ENGINE = false;
    private static int POOL_SIZE = 1000;
    public static boolean SIMPLIFY_SYNONYMS = true;
    public static boolean SKIP_COLUMNS = true;
    public static boolean USE_BASIC_SYNONYMS = true;
    public static boolean USE_DEPENDENCY_ORDERING = false;
    public static boolean USE_SYNONYMS = true;
    public static Metrics sMetrics;
    private int TABLE_SIZE = 32;
    public boolean graphOptimizer = false;
    public boolean hasSimpleDefinition = false;
    private boolean[] mAlreadyTestedCandidates = new boolean[32];
    final Cache mCache;
    private Row mGoal;
    private int mMaxColumns = 32;
    private int mMaxRows = 32;
    int mNumColumns = 1;
    int mNumRows = 0;
    private SolverVariable[] mPoolVariables = new SolverVariable[POOL_SIZE];
    private int mPoolVariablesCount = 0;
    ArrayRow[] mRows = new ArrayRow[32];
    private Row mTempGoal;
    private HashMap<String, SolverVariable> mVariables = null;
    int mVariablesID = 0;
    public boolean newgraphOptimizer = false;

    public LinearSystem() {
        Cache cache;
        this.releaseRows();
        this.mCache = cache = new Cache();
        this.mGoal = new PriorityGoalRow(cache);
        this.mTempGoal = OPTIMIZED_ENGINE ? new ValuesRow(cache) : new ArrayRow(cache);
    }

    private SolverVariable acquireSolverVariable(SolverVariable.Type object, String solverVariableArray) {
        SolverVariable solverVariable = this.mCache.solverVariablePool.acquire();
        if (solverVariable == null) {
            solverVariable = new SolverVariable((SolverVariable.Type)((Object)object), (String)solverVariableArray);
            solverVariable.setType((SolverVariable.Type)((Object)object), (String)solverVariableArray);
            object = solverVariable;
        } else {
            solverVariable.reset();
            solverVariable.setType((SolverVariable.Type)((Object)object), (String)solverVariableArray);
            object = solverVariable;
        }
        int n = this.mPoolVariablesCount;
        int n2 = POOL_SIZE;
        if (n >= n2) {
            POOL_SIZE = n2 *= 2;
            this.mPoolVariables = Arrays.copyOf(this.mPoolVariables, n2);
        }
        solverVariableArray = this.mPoolVariables;
        n2 = this.mPoolVariablesCount;
        this.mPoolVariablesCount = n2 + 1;
        solverVariableArray[n2] = object;
        return object;
    }

    private void addError(ArrayRow arrayRow) {
        arrayRow.addError(this, 0);
    }

    private final void addRow(ArrayRow object) {
        if (SIMPLIFY_SYNONYMS && object.isSimpleDefinition) {
            object.variable.setFinalValue(this, object.constantValue);
        } else {
            this.mRows[this.mNumRows] = object;
            object.variable.definitionId = this.mNumRows++;
            object.variable.updateReferencesWithNewDefinition(this, (ArrayRow)object);
        }
        if (SIMPLIFY_SYNONYMS && this.hasSimpleDefinition) {
            int n = 0;
            while (n < this.mNumRows) {
                if (this.mRows[n] == null) {
                    System.out.println("WTF");
                }
                object = this.mRows;
                int n2 = n;
                if (object[n] != null) {
                    n2 = n;
                    if (object[n].isSimpleDefinition) {
                        int n3;
                        object = this.mRows[n];
                        object.variable.setFinalValue(this, object.constantValue);
                        if (OPTIMIZED_ENGINE) {
                            this.mCache.optimizedArrayRowPool.release((ArrayRow)object);
                        } else {
                            this.mCache.arrayRowPool.release((ArrayRow)object);
                        }
                        this.mRows[n] = null;
                        int n4 = n2 = n + 1;
                        while (n2 < (n3 = this.mNumRows)) {
                            object = this.mRows;
                            n4 = n2 - 1;
                            object[n4] = object[n2];
                            if (object[n4].variable.definitionId == n2) {
                                this.mRows[n4].variable.definitionId = n4;
                            }
                            n4 = n2++;
                        }
                        if (n4 < n3) {
                            this.mRows[n4] = null;
                        }
                        this.mNumRows = n3 - 1;
                        n2 = n - 1;
                    }
                }
                n = n2 + 1;
            }
            this.hasSimpleDefinition = false;
        }
    }

    private void addSingleError(ArrayRow arrayRow, int n) {
        this.addSingleError(arrayRow, n, 0);
    }

    private void computeValues() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow arrayRow = this.mRows[i];
            arrayRow.variable.computedValue = arrayRow.constantValue;
        }
    }

    public static ArrayRow createRowDimensionPercent(LinearSystem linearSystem, SolverVariable solverVariable, SolverVariable solverVariable2, float f) {
        return linearSystem.createRow().createRowDimensionPercent(solverVariable, solverVariable2, f);
    }

    private SolverVariable createVariable(String string2, SolverVariable.Type object) {
        int n;
        Metrics metrics = sMetrics;
        if (metrics != null) {
            ++metrics.variables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        object = this.acquireSolverVariable((SolverVariable.Type)((Object)object), null);
        ((SolverVariable)object).setName(string2);
        this.mVariablesID = n = this.mVariablesID + 1;
        ++this.mNumColumns;
        ((SolverVariable)object).id = n;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        this.mVariables.put(string2, (SolverVariable)object);
        this.mCache.mIndexedVariables[this.mVariablesID] = object;
        return object;
    }

    private void displayRows() {
        StringBuilder stringBuilder;
        this.displaySolverVariables();
        String string2 = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(this.mRows[i]);
            string2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("\n");
            string2 = stringBuilder.toString();
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(this.mGoal);
        stringBuilder.append("\n");
        string2 = stringBuilder.toString();
        System.out.println(string2);
    }

    private void displaySolverVariables() {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("Display Rows (");
        charSequence.append(this.mNumRows);
        charSequence.append("x");
        charSequence.append(this.mNumColumns);
        charSequence.append(")\n");
        charSequence = charSequence.toString();
        System.out.println((String)charSequence);
    }

    private int enforceBFS(Row object) throws Exception {
        int n;
        block31: {
            block19: {
                block17: {
                    for (n = 0; n < this.mNumRows; ++n) {
                        if (this.mRows[n].variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[n].constantValue < 0.0f)) continue;
                        n = 1;
                        break block17;
                    }
                    n = 0;
                }
                if (n == 0) break block19;
                boolean bl = false;
                n = 0;
                while (!bl) {
                    Object object2;
                    object = sMetrics;
                    if (object != null) {
                        ++((Metrics)object).bfs;
                    }
                    int n2 = n + 1;
                    float f = Float.MAX_VALUE;
                    int n3 = -1;
                    int n4 = -1;
                    int n5 = 0;
                    for (n = 0; n < this.mNumRows; ++n) {
                        int n6;
                        int n7;
                        int n8;
                        float f2;
                        block18: {
                            int n9;
                            float f3;
                            int n10;
                            block22: {
                                block21: {
                                    block20: {
                                        object = this.mRows[n];
                                        if (((ArrayRow)object).variable.mType != SolverVariable.Type.UNRESTRICTED) break block20;
                                        f2 = f;
                                        n8 = n3;
                                        n7 = n4;
                                        n6 = n5;
                                        break block18;
                                    }
                                    if (!((ArrayRow)object).isSimpleDefinition) break block21;
                                    f2 = f;
                                    n8 = n3;
                                    n7 = n4;
                                    n6 = n5;
                                    break block18;
                                }
                                f2 = f;
                                n8 = n3;
                                n7 = n4;
                                n6 = n5;
                                if (!(((ArrayRow)object).constantValue < 0.0f)) break block18;
                                if (!SKIP_COLUMNS) break block22;
                                int n11 = ((ArrayRow)object).variables.getCurrentSize();
                                n10 = 0;
                                while (true) {
                                    block24: {
                                        block23: {
                                            f2 = f;
                                            n8 = n3;
                                            n7 = n4;
                                            n6 = n5;
                                            if (n10 >= n11) break block18;
                                            object2 = ((ArrayRow)object).variables.getVariable(n10);
                                            f3 = ((ArrayRow)object).variables.get((SolverVariable)object2);
                                            if (!(f3 <= 0.0f)) break block23;
                                            f2 = f;
                                            n6 = n3;
                                            n8 = n4;
                                            n7 = n5;
                                            break block24;
                                        }
                                        n8 = 0;
                                        n9 = n5;
                                        n5 = n8;
                                        while (true) {
                                            block26: {
                                                block25: {
                                                    f2 = f;
                                                    n6 = n3;
                                                    n8 = n4;
                                                    n7 = n9;
                                                    if (n5 >= 9) break;
                                                    f2 = ((SolverVariable)object2).strengthVector[n5] / f3;
                                                    if (f2 < f && n5 == n9) break block25;
                                                    n8 = n9;
                                                    if (n5 <= n9) break block26;
                                                }
                                                n4 = ((SolverVariable)object2).id;
                                                n8 = n5;
                                                n3 = n;
                                                f = f2;
                                            }
                                            ++n5;
                                            n9 = n8;
                                        }
                                    }
                                    ++n10;
                                    f = f2;
                                    n3 = n6;
                                    n4 = n8;
                                    n5 = n7;
                                }
                            }
                            n9 = 1;
                            while (true) {
                                block28: {
                                    block27: {
                                        f2 = f;
                                        n8 = n3;
                                        n7 = n4;
                                        n6 = n5;
                                        if (n9 >= this.mNumColumns) break;
                                        object2 = this.mCache.mIndexedVariables[n9];
                                        f3 = ((ArrayRow)object).variables.get((SolverVariable)object2);
                                        if (!(f3 <= 0.0f)) break block27;
                                        f2 = f;
                                        n6 = n3;
                                        n10 = n4;
                                        n7 = n5;
                                        break block28;
                                    }
                                    n6 = 0;
                                    n8 = n5;
                                    n5 = n6;
                                    while (true) {
                                        block30: {
                                            block29: {
                                                f2 = f;
                                                n6 = n3;
                                                n10 = n4;
                                                n7 = n8;
                                                if (n5 >= 9) break;
                                                f2 = ((SolverVariable)object2).strengthVector[n5] / f3;
                                                if (f2 < f && n5 == n8) break block29;
                                                n6 = n8;
                                                if (n5 <= n8) break block30;
                                            }
                                            n4 = n9;
                                            n6 = n5;
                                            n3 = n;
                                            f = f2;
                                        }
                                        ++n5;
                                        n8 = n6;
                                    }
                                }
                                ++n9;
                                f = f2;
                                n3 = n6;
                                n4 = n10;
                                n5 = n7;
                            }
                        }
                        f = f2;
                        n3 = n8;
                        n4 = n7;
                        n5 = n6;
                    }
                    if (n3 != -1) {
                        object = this.mRows[n3];
                        ((ArrayRow)object).variable.definitionId = -1;
                        object2 = sMetrics;
                        if (object2 != null) {
                            ++((Metrics)object2).pivots;
                        }
                        ((ArrayRow)object).pivot(this.mCache.mIndexedVariables[n4]);
                        ((ArrayRow)object).variable.definitionId = n3;
                        ((ArrayRow)object).variable.updateReferencesWithNewDefinition(this, (ArrayRow)object);
                    } else {
                        bl = true;
                    }
                    n = n2;
                    if (n2 <= this.mNumColumns / 2) continue;
                    bl = true;
                    n = n2;
                }
                break block31;
            }
            n = 0;
        }
        return n;
    }

    private String getDisplaySize(int n) {
        int n2 = n * 4;
        int n3 = (n = n2 / 1024) / 1024;
        if (n3 > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("");
            stringBuilder.append(n3);
            stringBuilder.append(" Mb");
            return stringBuilder.toString();
        }
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("");
            stringBuilder.append(n);
            stringBuilder.append(" Kb");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("");
        stringBuilder.append(n2);
        stringBuilder.append(" bytes");
        return stringBuilder.toString();
    }

    private String getDisplayStrength(int n) {
        if (n == 1) {
            return "LOW";
        }
        if (n == 2) {
            return "MEDIUM";
        }
        if (n == 3) {
            return "HIGH";
        }
        if (n == 4) {
            return "HIGHEST";
        }
        if (n == 5) {
            return "EQUALITY";
        }
        if (n == 8) {
            return "FIXED";
        }
        if (n == 6) {
            return "BARRIER";
        }
        return "NONE";
    }

    public static Metrics getMetrics() {
        return sMetrics;
    }

    private void increaseTableSize() {
        int n;
        this.TABLE_SIZE = n = this.TABLE_SIZE * 2;
        this.mRows = Arrays.copyOf(this.mRows, n);
        Object object = this.mCache;
        ((Cache)object).mIndexedVariables = Arrays.copyOf(((Cache)object).mIndexedVariables, this.TABLE_SIZE);
        n = this.TABLE_SIZE;
        this.mAlreadyTestedCandidates = new boolean[n];
        this.mMaxColumns = n;
        this.mMaxRows = n;
        object = sMetrics;
        if (object != null) {
            ++((Metrics)object).tableSizeIncrease;
            object = sMetrics;
            ((Metrics)object).maxTableSize = Math.max(((Metrics)object).maxTableSize, (long)this.TABLE_SIZE);
            object = sMetrics;
            ((Metrics)object).lastTableSize = ((Metrics)object).maxTableSize;
        }
    }

    private final int optimize(Row row, boolean bl) {
        int n;
        Object object = sMetrics;
        if (object != null) {
            ++((Metrics)object).optimize;
        }
        for (n = 0; n < this.mNumColumns; ++n) {
            this.mAlreadyTestedCandidates[n] = false;
        }
        boolean bl2 = false;
        n = 0;
        while (!bl2) {
            int n2;
            object = sMetrics;
            if (object != null) {
                ++((Metrics)object).iterations;
            }
            if ((n2 = n + 1) >= this.mNumColumns * 2) {
                return n2;
            }
            if (row.getKey() != null) {
                this.mAlreadyTestedCandidates[row.getKey().id] = true;
            }
            if ((object = row.getPivotCandidate(this, this.mAlreadyTestedCandidates)) != null) {
                if (this.mAlreadyTestedCandidates[((SolverVariable)object).id]) {
                    return n2;
                }
                this.mAlreadyTestedCandidates[((SolverVariable)object).id] = true;
            }
            if (object != null) {
                ArrayRow arrayRow;
                float f = Float.MAX_VALUE;
                int n3 = -1;
                for (n = 0; n < this.mNumRows; ++n) {
                    int n4;
                    float f2;
                    arrayRow = this.mRows[n];
                    if (arrayRow.variable.mType == SolverVariable.Type.UNRESTRICTED) {
                        f2 = f;
                        n4 = n3;
                    } else if (arrayRow.isSimpleDefinition) {
                        f2 = f;
                        n4 = n3;
                    } else {
                        f2 = f;
                        n4 = n3;
                        if (arrayRow.hasVariable((SolverVariable)object)) {
                            float f3 = arrayRow.variables.get((SolverVariable)object);
                            f2 = f;
                            n4 = n3;
                            if (f3 < 0.0f) {
                                f3 = -arrayRow.constantValue / f3;
                                f2 = f;
                                n4 = n3;
                                if (f3 < f) {
                                    n4 = n;
                                    f2 = f3;
                                }
                            }
                        }
                    }
                    f = f2;
                    n3 = n4;
                }
                n = n2;
                if (n3 <= -1) continue;
                arrayRow = this.mRows[n3];
                arrayRow.variable.definitionId = -1;
                Metrics metrics = sMetrics;
                if (metrics != null) {
                    ++metrics.pivots;
                }
                arrayRow.pivot((SolverVariable)object);
                arrayRow.variable.definitionId = n3;
                arrayRow.variable.updateReferencesWithNewDefinition(this, arrayRow);
                n = n2;
                continue;
            }
            bl2 = true;
            n = n2;
        }
        return n;
    }

    private void releaseRows() {
        int n;
        boolean bl = OPTIMIZED_ENGINE;
        int n2 = 0;
        if (bl) {
            for (n = n2; n < this.mNumRows; ++n) {
                ArrayRow arrayRow = this.mRows[n];
                if (arrayRow != null) {
                    this.mCache.optimizedArrayRowPool.release(arrayRow);
                }
                this.mRows[n] = null;
            }
        } else {
            for (n = 0; n < this.mNumRows; ++n) {
                ArrayRow arrayRow = this.mRows[n];
                if (arrayRow != null) {
                    this.mCache.arrayRowPool.release(arrayRow);
                }
                this.mRows[n] = null;
            }
        }
    }

    public void addCenterPoint(ConstraintWidget object, ConstraintWidget object2, float f, int n) {
        SolverVariable solverVariable = this.createObjectVariable(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable solverVariable2 = this.createObjectVariable(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable solverVariable3 = this.createObjectVariable(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable solverVariable4 = this.createObjectVariable(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.BOTTOM));
        object = this.createObjectVariable(((ConstraintWidget)object2).getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable solverVariable5 = this.createObjectVariable(((ConstraintWidget)object2).getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable solverVariable6 = this.createObjectVariable(((ConstraintWidget)object2).getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable solverVariable7 = this.createObjectVariable(((ConstraintWidget)object2).getAnchor(ConstraintAnchor.Type.BOTTOM));
        object2 = this.createRow();
        double d = f;
        double d2 = Math.sin(d);
        double d3 = n;
        ((ArrayRow)object2).createRowWithAngle(solverVariable2, solverVariable4, solverVariable5, solverVariable7, (float)(d2 * d3));
        this.addConstraint((ArrayRow)object2);
        object2 = this.createRow();
        ((ArrayRow)object2).createRowWithAngle(solverVariable, solverVariable3, (SolverVariable)object, solverVariable6, (float)(Math.cos(d) * d3));
        this.addConstraint((ArrayRow)object2);
    }

    public void addCentering(SolverVariable solverVariable, SolverVariable solverVariable2, int n, float f, SolverVariable solverVariable3, SolverVariable solverVariable4, int n2, int n3) {
        ArrayRow arrayRow = this.createRow();
        arrayRow.createRowCentering(solverVariable, solverVariable2, n, f, solverVariable3, solverVariable4, n2);
        if (n3 != 8) {
            arrayRow.addError(this, n3);
        }
        this.addConstraint(arrayRow);
    }

    /*
     * Unable to fully structure code
     */
    public void addConstraint(ArrayRow var1_1) {
        block15: {
            if (var1_1 == null) {
                return;
            }
            var2_2 = LinearSystem.sMetrics;
            if (var2_2 != null) {
                ++var2_2.constraints;
                if (var1_1.isSimpleDefinition) {
                    var2_2 = LinearSystem.sMetrics;
                    ++var2_2.simpleconstraints;
                }
            }
            var3_3 = this.mNumRows;
            var4_4 = 1;
            if (var3_3 + 1 >= this.mMaxRows || this.mNumColumns + 1 >= this.mMaxColumns) {
                this.increaseTableSize();
            }
            var3_3 = 0;
            if (var1_1.isSimpleDefinition) break block15;
            var1_1.updateFromSystem(this);
            if (var1_1.isEmpty()) {
                return;
            }
            var1_1.ensurePositiveConstant();
            if (!var1_1.chooseSubject(this)) ** GOTO lbl-1000
            var1_1.variable = var2_2 = this.createExtraVariable();
            var3_3 = this.mNumRows;
            this.addRow(var1_1);
            if (this.mNumRows == var3_3 + 1) {
                this.mTempGoal.initFromRow(var1_1);
                this.optimize(this.mTempGoal, true);
                var3_3 = var4_4;
                if (var2_2.definitionId == -1) {
                    if (var1_1.variable == var2_2 && (var5_5 = var1_1.pickPivot((SolverVariable)var2_2)) != null) {
                        var2_2 = LinearSystem.sMetrics;
                        if (var2_2 != null) {
                            ++var2_2.pivots;
                        }
                        var1_1.pivot(var5_5);
                    }
                    if (!var1_1.isSimpleDefinition) {
                        var1_1.variable.updateReferencesWithNewDefinition(this, var1_1);
                    }
                    if (LinearSystem.OPTIMIZED_ENGINE) {
                        this.mCache.optimizedArrayRowPool.release(var1_1);
                    } else {
                        this.mCache.arrayRowPool.release(var1_1);
                    }
                    --this.mNumRows;
                    var3_3 = var4_4;
                }
            } else lbl-1000:
            // 2 sources

            {
                var3_3 = 0;
            }
            if (!var1_1.hasKeyVariable()) {
                return;
            }
        }
        if (var3_3 == 0) {
            this.addRow(var1_1);
        }
    }

    public ArrayRow addEquality(SolverVariable solverVariable, SolverVariable solverVariable2, int n, int n2) {
        if (USE_BASIC_SYNONYMS && n2 == 8 && solverVariable2.isFinalValue && solverVariable.definitionId == -1) {
            solverVariable.setFinalValue(this, solverVariable2.computedValue + (float)n);
            return null;
        }
        ArrayRow arrayRow = this.createRow();
        arrayRow.createRowEquals(solverVariable, solverVariable2, n);
        if (n2 != 8) {
            arrayRow.addError(this, n2);
        }
        this.addConstraint(arrayRow);
        return arrayRow;
    }

    public void addEquality(SolverVariable solverVariable, int n) {
        if (USE_BASIC_SYNONYMS && solverVariable.definitionId == -1) {
            float f = n;
            solverVariable.setFinalValue(this, f);
            for (n = 0; n < this.mVariablesID + 1; ++n) {
                SolverVariable solverVariable2 = this.mCache.mIndexedVariables[n];
                if (solverVariable2 == null || !solverVariable2.isSynonym || solverVariable2.synonym != solverVariable.id) continue;
                solverVariable2.setFinalValue(this, solverVariable2.synonymDelta + f);
            }
            return;
        }
        int n2 = solverVariable.definitionId;
        if (solverVariable.definitionId != -1) {
            ArrayRow arrayRow = this.mRows[n2];
            if (arrayRow.isSimpleDefinition) {
                arrayRow.constantValue = n;
            } else if (arrayRow.variables.getCurrentSize() == 0) {
                arrayRow.isSimpleDefinition = true;
                arrayRow.constantValue = n;
            } else {
                arrayRow = this.createRow();
                arrayRow.createRowEquals(solverVariable, n);
                this.addConstraint(arrayRow);
            }
        } else {
            ArrayRow arrayRow = this.createRow();
            arrayRow.createRowDefinition(solverVariable, n);
            this.addConstraint(arrayRow);
        }
    }

    public void addGreaterBarrier(SolverVariable solverVariable, SolverVariable solverVariable2, int n, boolean bl) {
        ArrayRow arrayRow = this.createRow();
        SolverVariable solverVariable3 = this.createSlackVariable();
        solverVariable3.strength = 0;
        arrayRow.createRowGreaterThan(solverVariable, solverVariable2, solverVariable3, n);
        this.addConstraint(arrayRow);
    }

    public void addGreaterThan(SolverVariable solverVariable, SolverVariable solverVariable2, int n, int n2) {
        ArrayRow arrayRow = this.createRow();
        SolverVariable solverVariable3 = this.createSlackVariable();
        solverVariable3.strength = 0;
        arrayRow.createRowGreaterThan(solverVariable, solverVariable2, solverVariable3, n);
        if (n2 != 8) {
            this.addSingleError(arrayRow, (int)(arrayRow.variables.get(solverVariable3) * -1.0f), n2);
        }
        this.addConstraint(arrayRow);
    }

    public void addLowerBarrier(SolverVariable solverVariable, SolverVariable solverVariable2, int n, boolean bl) {
        ArrayRow arrayRow = this.createRow();
        SolverVariable solverVariable3 = this.createSlackVariable();
        solverVariable3.strength = 0;
        arrayRow.createRowLowerThan(solverVariable, solverVariable2, solverVariable3, n);
        this.addConstraint(arrayRow);
    }

    public void addLowerThan(SolverVariable solverVariable, SolverVariable solverVariable2, int n, int n2) {
        ArrayRow arrayRow = this.createRow();
        SolverVariable solverVariable3 = this.createSlackVariable();
        solverVariable3.strength = 0;
        arrayRow.createRowLowerThan(solverVariable, solverVariable2, solverVariable3, n);
        if (n2 != 8) {
            this.addSingleError(arrayRow, (int)(arrayRow.variables.get(solverVariable3) * -1.0f), n2);
        }
        this.addConstraint(arrayRow);
    }

    public void addRatio(SolverVariable solverVariable, SolverVariable solverVariable2, SolverVariable solverVariable3, SolverVariable solverVariable4, float f, int n) {
        ArrayRow arrayRow = this.createRow();
        arrayRow.createRowDimensionRatio(solverVariable, solverVariable2, solverVariable3, solverVariable4, f);
        if (n != 8) {
            arrayRow.addError(this, n);
        }
        this.addConstraint(arrayRow);
    }

    void addSingleError(ArrayRow arrayRow, int n, int n2) {
        arrayRow.addSingleError(this.createErrorVariable(n2, null), n);
    }

    public void addSynonym(SolverVariable solverVariable, SolverVariable solverVariable2, int n) {
        if (solverVariable.definitionId == -1 && n == 0) {
            float f;
            SolverVariable solverVariable3 = solverVariable2;
            if (solverVariable2.isSynonym) {
                f = solverVariable2.synonymDelta;
                solverVariable3 = this.mCache.mIndexedVariables[solverVariable2.synonym];
            }
            if (solverVariable.isSynonym) {
                f = solverVariable.synonymDelta;
                solverVariable = this.mCache.mIndexedVariables[solverVariable.synonym];
            } else {
                solverVariable.setSynonym(this, solverVariable3, 0.0f);
            }
        } else {
            this.addEquality(solverVariable, solverVariable2, n, 8);
        }
    }

    final void cleanupRows() {
        int n = 0;
        while (n < this.mNumRows) {
            ArrayRow arrayRow = this.mRows[n];
            if (arrayRow.variables.getCurrentSize() == 0) {
                arrayRow.isSimpleDefinition = true;
            }
            int n2 = n;
            if (arrayRow.isSimpleDefinition) {
                int n3;
                arrayRow.variable.computedValue = arrayRow.constantValue;
                arrayRow.variable.removeFromRow(arrayRow);
                n2 = n;
                while (n2 < (n3 = this.mNumRows) - 1) {
                    ArrayRow[] arrayRowArray = this.mRows;
                    n3 = n2 + 1;
                    arrayRowArray[n2] = arrayRowArray[n3];
                    n2 = n3;
                }
                this.mRows[n3 - 1] = null;
                this.mNumRows = n3 - 1;
                n2 = n - 1;
                if (OPTIMIZED_ENGINE) {
                    this.mCache.optimizedArrayRowPool.release(arrayRow);
                } else {
                    this.mCache.arrayRowPool.release(arrayRow);
                }
            }
            n = n2 + 1;
        }
    }

    public SolverVariable createErrorVariable(int n, String object) {
        int n2;
        Metrics metrics = sMetrics;
        if (metrics != null) {
            ++metrics.errors;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        object = this.acquireSolverVariable(SolverVariable.Type.ERROR, (String)object);
        this.mVariablesID = n2 = this.mVariablesID + 1;
        ++this.mNumColumns;
        ((SolverVariable)object).id = n2;
        ((SolverVariable)object).strength = n;
        this.mCache.mIndexedVariables[this.mVariablesID] = object;
        this.mGoal.addError((SolverVariable)object);
        return object;
    }

    public SolverVariable createExtraVariable() {
        int n;
        Object object = sMetrics;
        if (object != null) {
            ++((Metrics)object).extravariables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        object = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        this.mVariablesID = n = this.mVariablesID + 1;
        ++this.mNumColumns;
        ((SolverVariable)object).id = n;
        this.mCache.mIndexedVariables[this.mVariablesID] = object;
        return object;
    }

    public SolverVariable createObjectVariable(Object object) {
        Object object2;
        block7: {
            int n;
            block8: {
                object2 = null;
                if (object == null) {
                    return null;
                }
                if (this.mNumColumns + 1 >= this.mMaxColumns) {
                    this.increaseTableSize();
                }
                if (!(object instanceof ConstraintAnchor)) break block7;
                ConstraintAnchor constraintAnchor = (ConstraintAnchor)object;
                object = object2 = constraintAnchor.getSolverVariable();
                if (object2 == null) {
                    constraintAnchor.resetSolverVariable(this.mCache);
                    object = constraintAnchor.getSolverVariable();
                }
                if (((SolverVariable)object).id == -1 || ((SolverVariable)object).id > this.mVariablesID) break block8;
                object2 = object;
                if (this.mCache.mIndexedVariables[((SolverVariable)object).id] != null) break block7;
            }
            if (((SolverVariable)object).id != -1) {
                ((SolverVariable)object).reset();
            }
            this.mVariablesID = n = this.mVariablesID + 1;
            ++this.mNumColumns;
            ((SolverVariable)object).id = n;
            ((SolverVariable)object).mType = SolverVariable.Type.UNRESTRICTED;
            this.mCache.mIndexedVariables[this.mVariablesID] = object;
            object2 = object;
        }
        return object2;
    }

    public ArrayRow createRow() {
        ArrayRow arrayRow;
        if (OPTIMIZED_ENGINE) {
            arrayRow = this.mCache.optimizedArrayRowPool.acquire();
            if (arrayRow == null) {
                arrayRow = new ValuesRow(this.mCache);
                ++OPTIMIZED_ARRAY_ROW_CREATION;
            } else {
                arrayRow.reset();
            }
        } else {
            arrayRow = this.mCache.arrayRowPool.acquire();
            if (arrayRow == null) {
                arrayRow = new ArrayRow(this.mCache);
                ++ARRAY_ROW_CREATION;
            } else {
                arrayRow.reset();
            }
        }
        SolverVariable.increaseErrorId();
        return arrayRow;
    }

    public SolverVariable createSlackVariable() {
        int n;
        Object object = sMetrics;
        if (object != null) {
            ++((Metrics)object).slackvariables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        object = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        this.mVariablesID = n = this.mVariablesID + 1;
        ++this.mNumColumns;
        ((SolverVariable)object).id = n;
        this.mCache.mIndexedVariables[this.mVariablesID] = object;
        return object;
    }

    public void displayReadableRows() {
        Object object;
        SolverVariable solverVariable;
        int n;
        this.displaySolverVariables();
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(" num vars ");
        ((StringBuilder)charSequence).append(this.mVariablesID);
        ((StringBuilder)charSequence).append("\n");
        charSequence = ((StringBuilder)charSequence).toString();
        int n2 = 0;
        for (n = 0; n < this.mVariablesID + 1; ++n) {
            solverVariable = this.mCache.mIndexedVariables[n];
            object = charSequence;
            if (solverVariable != null) {
                object = charSequence;
                if (solverVariable.isFinalValue) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append((String)charSequence);
                    ((StringBuilder)object).append(" $[");
                    ((StringBuilder)object).append(n);
                    ((StringBuilder)object).append("] => ");
                    ((StringBuilder)object).append(solverVariable);
                    ((StringBuilder)object).append(" = ");
                    ((StringBuilder)object).append(solverVariable.computedValue);
                    ((StringBuilder)object).append("\n");
                    object = ((StringBuilder)object).toString();
                }
            }
            charSequence = object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append("\n");
        charSequence = ((StringBuilder)object).toString();
        for (n = 0; n < this.mVariablesID + 1; ++n) {
            solverVariable = this.mCache.mIndexedVariables[n];
            object = charSequence;
            if (solverVariable != null) {
                object = charSequence;
                if (solverVariable.isSynonym) {
                    object = this.mCache.mIndexedVariables[solverVariable.synonym];
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)charSequence);
                    stringBuilder.append(" ~[");
                    stringBuilder.append(n);
                    stringBuilder.append("] => ");
                    stringBuilder.append(solverVariable);
                    stringBuilder.append(" = ");
                    stringBuilder.append(object);
                    stringBuilder.append(" + ");
                    stringBuilder.append(solverVariable.synonymDelta);
                    stringBuilder.append("\n");
                    object = stringBuilder.toString();
                }
            }
            charSequence = object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append("\n\n #  ");
        charSequence = ((StringBuilder)object).toString();
        for (n = n2; n < this.mNumRows; ++n) {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append(this.mRows[n].toReadableString());
            object = ((StringBuilder)object).toString();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("\n #  ");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        object = charSequence;
        if (this.mGoal != null) {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append("Goal: ");
            ((StringBuilder)object).append(this.mGoal);
            ((StringBuilder)object).append("\n");
            object = ((StringBuilder)object).toString();
        }
        System.out.println((String)object);
    }

    void displaySystemInformation() {
        int n;
        Object object;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.TABLE_SIZE; ++n2) {
            object = this.mRows;
            n = n3;
            if (object[n2] != null) {
                n = n3 + object[n2].sizeInBytes();
            }
            n3 = n;
        }
        n = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            object = this.mRows;
            n2 = n;
            if (object[i] != null) {
                n2 = n + ((ArrayRow)object[i]).sizeInBytes();
            }
            n = n2;
        }
        PrintStream printStream = System.out;
        object = new StringBuilder();
        ((StringBuilder)object).append("Linear System -> Table size: ");
        ((StringBuilder)object).append(this.TABLE_SIZE);
        ((StringBuilder)object).append(" (");
        n2 = this.TABLE_SIZE;
        ((StringBuilder)object).append(this.getDisplaySize(n2 * n2));
        ((StringBuilder)object).append(") -- row sizes: ");
        ((StringBuilder)object).append(this.getDisplaySize(n3));
        ((StringBuilder)object).append(", actual size: ");
        ((StringBuilder)object).append(this.getDisplaySize(n));
        ((StringBuilder)object).append(" rows: ");
        ((StringBuilder)object).append(this.mNumRows);
        ((StringBuilder)object).append("/");
        ((StringBuilder)object).append(this.mMaxRows);
        ((StringBuilder)object).append(" cols: ");
        ((StringBuilder)object).append(this.mNumColumns);
        ((StringBuilder)object).append("/");
        ((StringBuilder)object).append(this.mMaxColumns);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(0);
        ((StringBuilder)object).append(" occupied cells, ");
        ((StringBuilder)object).append(this.getDisplaySize(0));
        printStream.println(((StringBuilder)object).toString());
    }

    public void displayVariablesReadableRows() {
        CharSequence charSequence;
        this.displaySolverVariables();
        CharSequence charSequence2 = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            charSequence = charSequence2;
            if (this.mRows[i].variable.mType == SolverVariable.Type.UNRESTRICTED) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append(this.mRows[i].toReadableString());
                charSequence2 = ((StringBuilder)charSequence).toString();
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append("\n");
                charSequence = ((StringBuilder)charSequence).toString();
            }
            charSequence2 = charSequence;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append(this.mGoal);
        ((StringBuilder)charSequence).append("\n");
        charSequence2 = ((StringBuilder)charSequence).toString();
        System.out.println((String)charSequence2);
    }

    public void fillMetrics(Metrics metrics) {
        sMetrics = metrics;
    }

    public Cache getCache() {
        return this.mCache;
    }

    Row getGoal() {
        return this.mGoal;
    }

    public int getMemoryUsed() {
        int n = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow[] arrayRowArray = this.mRows;
            int n2 = n;
            if (arrayRowArray[i] != null) {
                n2 = n + arrayRowArray[i].sizeInBytes();
            }
            n = n2;
        }
        return n;
    }

    public int getNumEquations() {
        return this.mNumRows;
    }

    public int getNumVariables() {
        return this.mVariablesID;
    }

    public int getObjectVariableValue(Object object) {
        if ((object = ((ConstraintAnchor)object).getSolverVariable()) != null) {
            return (int)(((SolverVariable)object).computedValue + 0.5f);
        }
        return 0;
    }

    ArrayRow getRow(int n) {
        return this.mRows[n];
    }

    float getValueFor(String object) {
        if ((object = this.getVariable((String)object, SolverVariable.Type.UNRESTRICTED)) == null) {
            return 0.0f;
        }
        return ((SolverVariable)object).computedValue;
    }

    SolverVariable getVariable(String string2, SolverVariable.Type type) {
        SolverVariable solverVariable;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        SolverVariable solverVariable2 = solverVariable = this.mVariables.get(string2);
        if (solverVariable == null) {
            solverVariable2 = this.createVariable(string2, type);
        }
        return solverVariable2;
    }

    public void minimize() throws Exception {
        Metrics metrics = sMetrics;
        if (metrics != null) {
            ++metrics.minimize;
        }
        if (this.mGoal.isEmpty()) {
            this.computeValues();
            return;
        }
        if (!this.graphOptimizer && !this.newgraphOptimizer) {
            this.minimizeGoal(this.mGoal);
        } else {
            int n;
            block9: {
                metrics = sMetrics;
                if (metrics != null) {
                    ++metrics.graphOptimizer;
                }
                int n2 = 0;
                for (n = 0; n < this.mNumRows; ++n) {
                    if (this.mRows[n].isSimpleDefinition) continue;
                    n = n2;
                    break block9;
                }
                n = 1;
            }
            if (n == 0) {
                this.minimizeGoal(this.mGoal);
            } else {
                metrics = sMetrics;
                if (metrics != null) {
                    ++metrics.fullySolved;
                }
                this.computeValues();
            }
        }
    }

    void minimizeGoal(Row row) throws Exception {
        Metrics metrics = sMetrics;
        if (metrics != null) {
            ++metrics.minimizeGoal;
            metrics = sMetrics;
            metrics.maxVariables = Math.max(metrics.maxVariables, (long)this.mNumColumns);
            metrics = sMetrics;
            metrics.maxRows = Math.max(metrics.maxRows, (long)this.mNumRows);
        }
        this.enforceBFS(row);
        this.optimize(row, false);
        this.computeValues();
    }

    public void removeRow(ArrayRow arrayRow) {
        if (arrayRow.isSimpleDefinition && arrayRow.variable != null) {
            if (arrayRow.variable.definitionId != -1) {
                int n;
                int n2 = arrayRow.variable.definitionId;
                while (n2 < (n = this.mNumRows) - 1) {
                    Object object = this.mRows;
                    n = n2 + 1;
                    object = object[n].variable;
                    if (object.definitionId == n) {
                        object.definitionId = n2;
                    }
                    object = this.mRows;
                    object[n2] = object[n];
                    n2 = n;
                }
                this.mNumRows = n - 1;
            }
            if (!arrayRow.variable.isFinalValue) {
                arrayRow.variable.setFinalValue(this, arrayRow.constantValue);
            }
            if (OPTIMIZED_ENGINE) {
                this.mCache.optimizedArrayRowPool.release(arrayRow);
            } else {
                this.mCache.arrayRowPool.release(arrayRow);
            }
        }
    }

    public void reset() {
        Object object;
        int n;
        for (n = 0; n < this.mCache.mIndexedVariables.length; ++n) {
            object = this.mCache.mIndexedVariables[n];
            if (object == null) continue;
            object.reset();
        }
        this.mCache.solverVariablePool.releaseAll((SolverVariable[])this.mPoolVariables, this.mPoolVariablesCount);
        this.mPoolVariablesCount = 0;
        Arrays.fill(this.mCache.mIndexedVariables, null);
        object = this.mVariables;
        if (object != null) {
            object.clear();
        }
        this.mVariablesID = 0;
        this.mGoal.clear();
        this.mNumColumns = 1;
        for (n = 0; n < this.mNumRows; ++n) {
            object = this.mRows;
            if (object[n] == null) continue;
            object[n].used = false;
        }
        this.releaseRows();
        this.mNumRows = 0;
        this.mTempGoal = OPTIMIZED_ENGINE ? new ValuesRow(this.mCache) : new ArrayRow(this.mCache);
    }

    static interface Row {
        public void addError(SolverVariable var1);

        public void clear();

        public SolverVariable getKey();

        public SolverVariable getPivotCandidate(LinearSystem var1, boolean[] var2);

        public void initFromRow(Row var1);

        public boolean isEmpty();

        public void updateFromFinalVariable(LinearSystem var1, SolverVariable var2, boolean var3);

        public void updateFromRow(LinearSystem var1, ArrayRow var2, boolean var3);

        public void updateFromSystem(LinearSystem var1);
    }

    class ValuesRow
    extends ArrayRow {
        public ValuesRow(Cache cache) {
            this.variables = new SolverVariableValues(this, cache);
        }
    }
}

