/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import java.util.Arrays;
import java.util.Comparator;

public class PriorityGoalRow
extends ArrayRow {
    private static final boolean DEBUG = false;
    static final int NOT_FOUND = -1;
    private static final float epsilon = 1.0E-4f;
    private int TABLE_SIZE = 128;
    GoalVariableAccessor accessor;
    private SolverVariable[] arrayGoals = new SolverVariable[128];
    Cache mCache;
    private int numGoals = 0;
    private SolverVariable[] sortArray = new SolverVariable[128];

    public PriorityGoalRow(Cache cache) {
        super(cache);
        this.accessor = new GoalVariableAccessor(this);
        this.mCache = cache;
    }

    private final void addToGoal(SolverVariable solverVariable) {
        int n = this.numGoals;
        SolverVariable[] solverVariableArray = this.arrayGoals;
        if (n + 1 > solverVariableArray.length) {
            this.arrayGoals = solverVariableArray = Arrays.copyOf(solverVariableArray, solverVariableArray.length * 2);
            this.sortArray = Arrays.copyOf(solverVariableArray, solverVariableArray.length * 2);
        }
        solverVariableArray = this.arrayGoals;
        n = this.numGoals;
        solverVariableArray[n] = solverVariable;
        this.numGoals = ++n;
        if (n > 1 && solverVariableArray[n - 1].id > solverVariable.id) {
            int n2;
            int n3 = 0;
            for (n = 0; n < (n2 = this.numGoals); ++n) {
                this.sortArray[n] = this.arrayGoals[n];
            }
            Arrays.sort(this.sortArray, 0, n2, new Comparator<SolverVariable>(){

                @Override
                public int compare(SolverVariable solverVariable, SolverVariable solverVariable2) {
                    return solverVariable.id - solverVariable2.id;
                }
            });
            for (n = n3; n < this.numGoals; ++n) {
                this.arrayGoals[n] = this.sortArray[n];
            }
        }
        solverVariable.inGoal = true;
        solverVariable.addToRow(this);
    }

    private final void removeGoal(SolverVariable solverVariable) {
        for (int i = 0; i < this.numGoals; ++i) {
            int n;
            if (this.arrayGoals[i] != solverVariable) continue;
            while (i < (n = this.numGoals) - 1) {
                SolverVariable[] solverVariableArray = this.arrayGoals;
                n = i + 1;
                solverVariableArray[i] = solverVariableArray[n];
                i = n;
            }
            this.numGoals = n - 1;
            solverVariable.inGoal = false;
            return;
        }
    }

    @Override
    public void addError(SolverVariable solverVariable) {
        this.accessor.init(solverVariable);
        this.accessor.reset();
        solverVariable.goalStrengthVector[solverVariable.strength] = 1.0f;
        this.addToGoal(solverVariable);
    }

    @Override
    public void clear() {
        this.numGoals = 0;
        this.constantValue = 0.0f;
    }

    @Override
    public SolverVariable getPivotCandidate(LinearSystem object, boolean[] blArray) {
        int n = -1;
        for (int i = 0; i < this.numGoals; ++i) {
            int n2;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            object = this.arrayGoals[i];
                            if (!blArray[((SolverVariable)object).id]) break block5;
                            n2 = n;
                            break block6;
                        }
                        this.accessor.init((SolverVariable)object);
                        if (n != -1) break block7;
                        n2 = n;
                        if (!this.accessor.isNegative()) break block6;
                        break block8;
                    }
                    n2 = n;
                    if (!this.accessor.isSmallerThan(this.arrayGoals[n])) break block6;
                }
                n2 = i;
            }
            n = n2;
        }
        if (n == -1) {
            return null;
        }
        return this.arrayGoals[n];
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.numGoals == 0;
        return bl;
    }

    @Override
    public String toString() {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("");
        charSequence.append(" goal -> (");
        charSequence.append(this.constantValue);
        charSequence.append(") : ");
        charSequence = charSequence.toString();
        for (int i = 0; i < this.numGoals; ++i) {
            Comparable<SolverVariable> comparable = this.arrayGoals[i];
            this.accessor.init((SolverVariable)comparable);
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append((String)charSequence);
            ((StringBuilder)comparable).append(this.accessor);
            ((StringBuilder)comparable).append(" ");
            charSequence = ((StringBuilder)comparable).toString();
        }
        return charSequence;
    }

    @Override
    public void updateFromRow(LinearSystem object, ArrayRow arrayRow, boolean bl) {
        SolverVariable solverVariable = arrayRow.variable;
        if (solverVariable == null) {
            return;
        }
        object = arrayRow.variables;
        int n = object.getCurrentSize();
        for (int i = 0; i < n; ++i) {
            SolverVariable solverVariable2 = object.getVariable(i);
            float f = object.getVariableValue(i);
            this.accessor.init(solverVariable2);
            if (this.accessor.addToGoal(solverVariable, f)) {
                this.addToGoal(solverVariable2);
            }
            this.constantValue += arrayRow.constantValue * f;
        }
        this.removeGoal(solverVariable);
    }

    class GoalVariableAccessor {
        PriorityGoalRow row;
        SolverVariable variable;

        public GoalVariableAccessor(PriorityGoalRow priorityGoalRow2) {
            this.row = priorityGoalRow2;
        }

        public void add(SolverVariable solverVariable) {
            for (int i = 0; i < 9; ++i) {
                float[] fArray = this.variable.goalStrengthVector;
                fArray[i] = fArray[i] + solverVariable.goalStrengthVector[i];
                if (!(Math.abs(this.variable.goalStrengthVector[i]) < 1.0E-4f)) continue;
                this.variable.goalStrengthVector[i] = 0.0f;
            }
        }

        public boolean addToGoal(SolverVariable solverVariable, float f) {
            int n;
            boolean bl = this.variable.inGoal;
            boolean bl2 = true;
            if (bl) {
                for (n = 0; n < 9; ++n) {
                    float[] fArray = this.variable.goalStrengthVector;
                    fArray[n] = fArray[n] + solverVariable.goalStrengthVector[n] * f;
                    if (Math.abs(this.variable.goalStrengthVector[n]) < 1.0E-4f) {
                        this.variable.goalStrengthVector[n] = 0.0f;
                        continue;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    PriorityGoalRow.this.removeGoal(this.variable);
                }
                return false;
            }
            for (n = 0; n < 9; ++n) {
                float f2 = solverVariable.goalStrengthVector[n];
                if (f2 != 0.0f) {
                    float f3;
                    f2 = f3 = f2 * f;
                    if (Math.abs(f3) < 1.0E-4f) {
                        f2 = 0.0f;
                    }
                    this.variable.goalStrengthVector[n] = f2;
                    continue;
                }
                this.variable.goalStrengthVector[n] = 0.0f;
            }
            return true;
        }

        public void init(SolverVariable solverVariable) {
            this.variable = solverVariable;
        }

        public final boolean isNegative() {
            for (int i = 8; i >= 0; --i) {
                float f = this.variable.goalStrengthVector[i];
                if (f > 0.0f) {
                    return false;
                }
                if (!(f < 0.0f)) continue;
                return true;
            }
            return false;
        }

        public final boolean isNull() {
            for (int i = 0; i < 9; ++i) {
                if (this.variable.goalStrengthVector[i] == 0.0f) continue;
                return false;
            }
            return true;
        }

        public final boolean isSmallerThan(SolverVariable solverVariable) {
            for (int i = 8; i >= 0; --i) {
                float f = this.variable.goalStrengthVector[i];
                float f2 = solverVariable.goalStrengthVector[i];
                if (f == f2) {
                    continue;
                }
                if (!(f < f2)) break;
                return true;
            }
            return false;
        }

        public void reset() {
            Arrays.fill(this.variable.goalStrengthVector, 0.0f);
        }

        public String toString() {
            CharSequence charSequence;
            SolverVariable solverVariable = this.variable;
            CharSequence charSequence2 = charSequence = "[ ";
            if (solverVariable != null) {
                int n = 0;
                while (true) {
                    charSequence2 = charSequence;
                    if (n >= 9) break;
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append((String)charSequence);
                    ((StringBuilder)charSequence2).append(this.variable.goalStrengthVector[n]);
                    ((StringBuilder)charSequence2).append(" ");
                    charSequence = ((StringBuilder)charSequence2).toString();
                    ++n;
                }
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("] ");
            ((StringBuilder)charSequence).append(this.variable);
            return ((StringBuilder)charSequence).toString();
        }
    }
}

