/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

public class CustomAttribute {
    private static final String TAG = "TransitionLayout";
    boolean mBooleanValue;
    private int mColorValue;
    private float mFloatValue;
    private int mIntegerValue;
    private boolean mMethod = false;
    String mName;
    private String mStringValue;
    private AttributeType mType;

    public CustomAttribute(CustomAttribute customAttribute, Object object) {
        this.mName = customAttribute.mName;
        this.mType = customAttribute.mType;
        this.setValue(object);
    }

    public CustomAttribute(String string2, AttributeType attributeType) {
        this.mName = string2;
        this.mType = attributeType;
    }

    public CustomAttribute(String string2, AttributeType attributeType, Object object, boolean bl) {
        this.mName = string2;
        this.mType = attributeType;
        this.mMethod = bl;
        this.setValue(object);
    }

    private static int clamp(int n) {
        n = (n & n >> 31) - 255;
        return (n & n >> 31) + 255;
    }

    public static int hsvToRgb(float f, float f2, float f3) {
        int n = (int)(f *= 6.0f);
        int n2 = (int)((1.0f - f2) * (f3 *= 255.0f) + 0.5f);
        int n3 = (int)((1.0f - (f -= (float)n) * f2) * f3 + 0.5f);
        int n4 = (int)((1.0f - (1.0f - f) * f2) * f3 + 0.5f);
        int n5 = (int)(f3 + 0.5f);
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) {
                                return 0;
                            }
                            return (n5 << 16) + (n2 << 8) + n3 | 0xFF000000;
                        }
                        return (n4 << 16) + (n2 << 8) + n5 | 0xFF000000;
                    }
                    return (n2 << 16) + (n3 << 8) + n5 | 0xFF000000;
                }
                return (n2 << 16) + (n5 << 8) + n4 | 0xFF000000;
            }
            return (n3 << 16) + (n5 << 8) + n2 | 0xFF000000;
        }
        return (n5 << 16) + (n4 << 8) + n2 | 0xFF000000;
    }

    public boolean diff(CustomAttribute customAttribute) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = bl5;
        if (customAttribute != null) {
            if (this.mType != customAttribute.mType) {
                bl7 = bl5;
            } else {
                switch (1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()]) {
                    default: {
                        return false;
                    }
                    case 8: {
                        bl7 = bl6;
                        if (this.mFloatValue == customAttribute.mFloatValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 7: {
                        bl7 = bl;
                        if (this.mFloatValue == customAttribute.mFloatValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 4: 
                    case 5: {
                        bl7 = bl2;
                        if (this.mColorValue == customAttribute.mColorValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 3: {
                        bl7 = bl3;
                        if (this.mIntegerValue == customAttribute.mIntegerValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 2: {
                        bl7 = bl4;
                        if (this.mBooleanValue == customAttribute.mBooleanValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 1: 
                    case 6: 
                }
                bl7 = bl5;
                if (this.mIntegerValue == customAttribute.mIntegerValue) {
                    bl7 = true;
                }
            }
        }
        return bl7;
    }

    public AttributeType getType() {
        return this.mType;
    }

    public float getValueToInterpolate() {
        switch (1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()]) {
            default: {
                return Float.NaN;
            }
            case 8: {
                return this.mFloatValue;
            }
            case 7: {
                return this.mFloatValue;
            }
            case 6: {
                return this.mIntegerValue;
            }
            case 4: 
            case 5: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 3: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 2: 
        }
        float f = this.mBooleanValue ? 1.0f : 0.0f;
        return f;
    }

    public void getValuesToInterpolate(float[] fArray) {
        switch (1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()]) {
            default: {
                break;
            }
            case 8: {
                fArray[0] = this.mFloatValue;
                break;
            }
            case 7: {
                fArray[0] = this.mFloatValue;
                break;
            }
            case 6: {
                fArray[0] = this.mIntegerValue;
                break;
            }
            case 4: 
            case 5: {
                int n = this.mColorValue;
                float f = (float)Math.pow((float)(n >> 16 & 0xFF) / 255.0f, 2.2);
                float f2 = (float)Math.pow((float)(n >> 8 & 0xFF) / 255.0f, 2.2);
                float f3 = (float)Math.pow((float)(n & 0xFF) / 255.0f, 2.2);
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = (float)(n >> 24 & 0xFF) / 255.0f;
                break;
            }
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 2: {
                float f = this.mBooleanValue ? 1.0f : 0.0f;
                fArray[0] = f;
            }
        }
    }

    public boolean isContinuous() {
        int n = 1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()];
        return n != 1 && n != 2 && n != 3;
    }

    public int numberOfInterpolatedValues() {
        int n = 1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()];
        if (n != 4 && n != 5) {
            return 1;
        }
        return 4;
    }

    public void setColorValue(int n) {
        this.mColorValue = n;
    }

    public void setFloatValue(float f) {
        this.mFloatValue = f;
    }

    public void setIntValue(int n) {
        this.mIntegerValue = n;
    }

    public void setStringValue(String string2) {
        this.mStringValue = string2;
    }

    public void setValue(Object object) {
        switch (1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()]) {
            default: {
                break;
            }
            case 8: {
                this.mFloatValue = ((Float)object).floatValue();
                break;
            }
            case 7: {
                this.mFloatValue = ((Float)object).floatValue();
                break;
            }
            case 4: 
            case 5: {
                this.mColorValue = (Integer)object;
                break;
            }
            case 3: {
                this.mStringValue = (String)object;
                break;
            }
            case 2: {
                this.mBooleanValue = (Boolean)object;
                break;
            }
            case 1: 
            case 6: {
                this.mIntegerValue = (Integer)object;
            }
        }
    }

    public void setValue(float[] fArray) {
        int n = 1.$SwitchMap$androidx$constraintlayout$core$motion$CustomAttribute$AttributeType[this.mType.ordinal()];
        boolean bl = true;
        switch (n) {
            default: {
                break;
            }
            case 8: {
                this.mFloatValue = fArray[0];
                break;
            }
            case 7: {
                this.mFloatValue = fArray[0];
                break;
            }
            case 4: 
            case 5: {
                this.mColorValue = n = CustomAttribute.hsvToRgb(fArray[0], fArray[1], fArray[2]);
                this.mColorValue = CustomAttribute.clamp((int)(fArray[3] * 255.0f)) << 24 | n & 0xFFFFFF;
                break;
            }
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 2: {
                if (!((double)fArray[0] > 0.5)) {
                    bl = false;
                }
                this.mBooleanValue = bl;
                break;
            }
            case 1: 
            case 6: {
                this.mIntegerValue = (int)fArray[0];
            }
        }
    }

    public static final class AttributeType
    extends Enum<AttributeType> {
        private static final /* synthetic */ AttributeType[] $VALUES;
        public static final /* enum */ AttributeType BOOLEAN_TYPE;
        public static final /* enum */ AttributeType COLOR_DRAWABLE_TYPE;
        public static final /* enum */ AttributeType COLOR_TYPE;
        public static final /* enum */ AttributeType DIMENSION_TYPE;
        public static final /* enum */ AttributeType FLOAT_TYPE;
        public static final /* enum */ AttributeType INT_TYPE;
        public static final /* enum */ AttributeType REFERENCE_TYPE;
        public static final /* enum */ AttributeType STRING_TYPE;

        static {
            AttributeType attributeType;
            AttributeType attributeType2;
            AttributeType attributeType3;
            AttributeType attributeType4;
            AttributeType attributeType5;
            AttributeType attributeType6;
            AttributeType attributeType7;
            AttributeType attributeType8;
            INT_TYPE = attributeType8 = new AttributeType();
            FLOAT_TYPE = attributeType7 = new AttributeType();
            COLOR_TYPE = attributeType6 = new AttributeType();
            COLOR_DRAWABLE_TYPE = attributeType5 = new AttributeType();
            STRING_TYPE = attributeType4 = new AttributeType();
            BOOLEAN_TYPE = attributeType3 = new AttributeType();
            DIMENSION_TYPE = attributeType2 = new AttributeType();
            REFERENCE_TYPE = attributeType = new AttributeType();
            $VALUES = new AttributeType[]{attributeType8, attributeType7, attributeType6, attributeType5, attributeType4, attributeType3, attributeType2, attributeType};
        }

        public static AttributeType valueOf(String string2) {
            return Enum.valueOf(AttributeType.class, string2);
        }

        public static AttributeType[] values() {
            return (AttributeType[])$VALUES.clone();
        }
    }
}

