/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.MotionWidget;

public class CustomVariable {
    private static final String TAG = "TransitionLayout";
    boolean mBooleanValue;
    private float mFloatValue;
    private int mIntegerValue = Integer.MIN_VALUE;
    String mName;
    private String mStringValue = null;
    private int mType;

    public CustomVariable(CustomVariable customVariable) {
        this.mFloatValue = Float.NaN;
        this.mName = customVariable.mName;
        this.mType = customVariable.mType;
        this.mIntegerValue = customVariable.mIntegerValue;
        this.mFloatValue = customVariable.mFloatValue;
        this.mStringValue = customVariable.mStringValue;
        this.mBooleanValue = customVariable.mBooleanValue;
    }

    public CustomVariable(CustomVariable customVariable, Object object) {
        this.mFloatValue = Float.NaN;
        this.mName = customVariable.mName;
        this.mType = customVariable.mType;
        this.setValue(object);
    }

    public CustomVariable(String string2, int n) {
        this.mFloatValue = Float.NaN;
        this.mName = string2;
        this.mType = n;
    }

    public CustomVariable(String string2, int n, float f) {
        this.mFloatValue = Float.NaN;
        this.mName = string2;
        this.mType = n;
        this.mFloatValue = f;
    }

    public CustomVariable(String string2, int n, int n2) {
        this.mFloatValue = Float.NaN;
        this.mName = string2;
        this.mType = n;
        if (n == 901) {
            this.mFloatValue = n2;
        } else {
            this.mIntegerValue = n2;
        }
    }

    public CustomVariable(String string2, int n, Object object) {
        this.mFloatValue = Float.NaN;
        this.mName = string2;
        this.mType = n;
        this.setValue(object);
    }

    public CustomVariable(String string2, int n, String string3) {
        this.mFloatValue = Float.NaN;
        this.mName = string2;
        this.mType = n;
        this.mStringValue = string3;
    }

    public CustomVariable(String string2, int n, boolean bl) {
        this.mFloatValue = Float.NaN;
        this.mName = string2;
        this.mType = n;
        this.mBooleanValue = bl;
    }

    private static int clamp(int n) {
        n = (n & n >> 31) - 255;
        return (n & n >> 31) + 255;
    }

    public static String colorString(int n) {
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("00000000");
        ((StringBuilder)charSequence).append(Integer.toHexString(n));
        charSequence = ((StringBuilder)charSequence).toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#");
        stringBuilder.append(((String)charSequence).substring(((String)charSequence).length() - 8));
        return stringBuilder.toString();
    }

    public static int hsvToRgb(float f, float f2, float f3) {
        int n = (int)(f *= 6.0f);
        int n2 = (int)((1.0f - f2) * (f3 *= 255.0f) + 0.5f);
        int n3 = (int)((1.0f - (f -= (float)n) * f2) * f3 + 0.5f);
        int n4 = (int)((1.0f - (1.0f - f) * f2) * f3 + 0.5f);
        int n5 = (int)(f3 + 0.5f);
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) {
                                return 0;
                            }
                            return (n5 << 16) + (n2 << 8) + n3 | 0xFF000000;
                        }
                        return (n4 << 16) + (n2 << 8) + n5 | 0xFF000000;
                    }
                    return (n2 << 16) + (n3 << 8) + n5 | 0xFF000000;
                }
                return (n2 << 16) + (n5 << 8) + n4 | 0xFF000000;
            }
            return (n3 << 16) + (n5 << 8) + n2 | 0xFF000000;
        }
        return (n5 << 16) + (n4 << 8) + n2 | 0xFF000000;
    }

    public static int rgbaTocColor(float f, float f2, float f3, float f4) {
        int n = CustomVariable.clamp((int)(f * 255.0f));
        int n2 = CustomVariable.clamp((int)(f2 * 255.0f));
        int n3 = CustomVariable.clamp((int)(f3 * 255.0f));
        return n << 16 | CustomVariable.clamp((int)(f4 * 255.0f)) << 24 | n2 << 8 | n3;
    }

    public void applyToWidget(MotionWidget motionWidget) {
        int n = this.mType;
        switch (n) {
            default: {
                break;
            }
            case 904: {
                motionWidget.setCustomAttribute(this.mName, n, this.mBooleanValue);
                break;
            }
            case 903: {
                motionWidget.setCustomAttribute(this.mName, n, this.mStringValue);
                break;
            }
            case 901: 
            case 905: {
                motionWidget.setCustomAttribute(this.mName, n, this.mFloatValue);
                break;
            }
            case 900: 
            case 902: 
            case 906: {
                motionWidget.setCustomAttribute(this.mName, n, this.mIntegerValue);
            }
        }
    }

    public CustomVariable copy() {
        return new CustomVariable(this);
    }

    public boolean diff(CustomVariable customVariable) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = bl5;
        if (customVariable != null) {
            int n = this.mType;
            if (n != customVariable.mType) {
                bl7 = bl5;
            } else {
                switch (n) {
                    default: {
                        return false;
                    }
                    case 905: {
                        bl7 = bl6;
                        if (this.mFloatValue == customVariable.mFloatValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 904: {
                        bl7 = bl;
                        if (this.mBooleanValue == customVariable.mBooleanValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 903: {
                        bl7 = bl2;
                        if (this.mIntegerValue == customVariable.mIntegerValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 902: {
                        bl7 = bl3;
                        if (this.mIntegerValue == customVariable.mIntegerValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 901: {
                        bl7 = bl4;
                        if (this.mFloatValue == customVariable.mFloatValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 900: 
                    case 906: 
                }
                bl7 = bl5;
                if (this.mIntegerValue == customVariable.mIntegerValue) {
                    bl7 = true;
                }
            }
        }
        return bl7;
    }

    public boolean getBooleanValue() {
        return this.mBooleanValue;
    }

    public int getColorValue() {
        return this.mIntegerValue;
    }

    public float getFloatValue() {
        return this.mFloatValue;
    }

    public int getIntegerValue() {
        return this.mIntegerValue;
    }

    public int getInterpolatedColor(float[] fArray) {
        int n = CustomVariable.clamp((int)((float)Math.pow(fArray[0], 0.45454545454545453) * 255.0f));
        int n2 = CustomVariable.clamp((int)((float)Math.pow(fArray[1], 0.45454545454545453) * 255.0f));
        int n3 = CustomVariable.clamp((int)((float)Math.pow(fArray[2], 0.45454545454545453) * 255.0f));
        return CustomVariable.clamp((int)(fArray[3] * 255.0f)) << 24 | n << 16 | n2 << 8 | n3;
    }

    public String getName() {
        return this.mName;
    }

    public String getStringValue() {
        return this.mStringValue;
    }

    public int getType() {
        return this.mType;
    }

    public float getValueToInterpolate() {
        switch (this.mType) {
            default: {
                return Float.NaN;
            }
            case 905: {
                return this.mFloatValue;
            }
            case 904: {
                float f = this.mBooleanValue ? 1.0f : 0.0f;
                return f;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 902: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 901: {
                return this.mFloatValue;
            }
            case 900: 
        }
        return this.mIntegerValue;
    }

    public void getValuesToInterpolate(float[] fArray) {
        switch (this.mType) {
            default: {
                break;
            }
            case 905: {
                fArray[0] = this.mFloatValue;
                break;
            }
            case 904: {
                float f = this.mBooleanValue ? 1.0f : 0.0f;
                fArray[0] = f;
                break;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 902: {
                int n = this.mIntegerValue;
                float f = (float)Math.pow((float)(n >> 16 & 0xFF) / 255.0f, 2.2);
                float f2 = (float)Math.pow((float)(n >> 8 & 0xFF) / 255.0f, 2.2);
                float f3 = (float)Math.pow((float)(n & 0xFF) / 255.0f, 2.2);
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = (float)(n >> 24 & 0xFF) / 255.0f;
                break;
            }
            case 901: {
                fArray[0] = this.mFloatValue;
                break;
            }
            case 900: {
                fArray[0] = this.mIntegerValue;
            }
        }
    }

    public boolean isContinuous() {
        int n = this.mType;
        return n != 903 && n != 904 && n != 906;
    }

    public int numberOfInterpolatedValues() {
        if (this.mType != 902) {
            return 1;
        }
        return 4;
    }

    public void setBooleanValue(boolean bl) {
        this.mBooleanValue = bl;
    }

    public void setFloatValue(float f) {
        this.mFloatValue = f;
    }

    public void setIntValue(int n) {
        this.mIntegerValue = n;
    }

    public void setInterpolatedValue(MotionWidget object, float[] fArray) {
        int n = this.mType;
        boolean bl = true;
        switch (n) {
            default: {
                break;
            }
            case 904: {
                String string2 = this.mName;
                if (!(fArray[0] > 0.5f)) {
                    bl = false;
                }
                ((MotionWidget)object).setCustomAttribute(string2, n, bl);
                break;
            }
            case 903: 
            case 906: {
                object = new StringBuilder();
                ((StringBuilder)object).append("unable to interpolate ");
                ((StringBuilder)object).append(this.mName);
                throw new RuntimeException(((StringBuilder)object).toString());
            }
            case 902: {
                int n2 = CustomVariable.clamp((int)((float)Math.pow(fArray[0], 0.45454545454545453) * 255.0f));
                int n3 = CustomVariable.clamp((int)((float)Math.pow(fArray[1], 0.45454545454545453) * 255.0f));
                n = CustomVariable.clamp((int)((float)Math.pow(fArray[2], 0.45454545454545453) * 255.0f));
                int n4 = CustomVariable.clamp((int)(fArray[3] * 255.0f));
                ((MotionWidget)object).setCustomAttribute(this.mName, this.mType, n4 << 24 | n2 << 16 | n3 << 8 | n);
                break;
            }
            case 901: 
            case 905: {
                ((MotionWidget)object).setCustomAttribute(this.mName, n, fArray[0]);
                break;
            }
            case 900: {
                ((MotionWidget)object).setCustomAttribute(this.mName, n, (int)fArray[0]);
            }
        }
    }

    public void setStringValue(String string2) {
        this.mStringValue = string2;
    }

    public void setValue(Object object) {
        switch (this.mType) {
            default: {
                break;
            }
            case 905: {
                this.mFloatValue = ((Float)object).floatValue();
                break;
            }
            case 904: {
                this.mBooleanValue = (Boolean)object;
                break;
            }
            case 903: {
                this.mStringValue = (String)object;
                break;
            }
            case 902: {
                this.mIntegerValue = (Integer)object;
                break;
            }
            case 901: {
                this.mFloatValue = ((Float)object).floatValue();
                break;
            }
            case 900: 
            case 906: {
                this.mIntegerValue = (Integer)object;
            }
        }
    }

    public void setValue(float[] fArray) {
        int n = this.mType;
        boolean bl = true;
        switch (n) {
            default: {
                break;
            }
            case 904: {
                if (!((double)fArray[0] > 0.5)) {
                    bl = false;
                }
                this.mBooleanValue = bl;
                break;
            }
            case 903: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 902: {
                float f = fArray[0];
                float f2 = fArray[1];
                float f3 = fArray[2];
                int n2 = Math.round((float)Math.pow(f, 0.5) * 255.0f);
                int n3 = Math.round((float)Math.pow(f2, 0.5) * 255.0f);
                n = Math.round((float)Math.pow(f3, 0.5) * 255.0f);
                this.mIntegerValue = (Math.round(fArray[3] * 255.0f) & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n & 0xFF;
                break;
            }
            case 901: 
            case 905: {
                this.mFloatValue = fArray[0];
                break;
            }
            case 900: 
            case 906: {
                this.mIntegerValue = (int)fArray[0];
            }
        }
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.mName);
        charSequence.append(':');
        charSequence = charSequence.toString();
        switch (this.mType) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append("????");
                return stringBuilder.toString();
            }
            case 905: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append(this.mFloatValue);
                return stringBuilder.toString();
            }
            case 904: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append((Object)this.mBooleanValue);
                return stringBuilder.toString();
            }
            case 903: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append(this.mStringValue);
                return stringBuilder.toString();
            }
            case 902: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append(CustomVariable.colorString(this.mIntegerValue));
                return stringBuilder.toString();
            }
            case 901: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append(this.mFloatValue);
                return stringBuilder.toString();
            }
            case 900: 
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)charSequence);
        stringBuilder.append(this.mIntegerValue);
        return stringBuilder.toString();
    }
}

