/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionConstrainedPoint;
import androidx.constraintlayout.core.motion.MotionPaths;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.key.MotionKeyAttributes;
import androidx.constraintlayout.core.motion.key.MotionKeyCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyPosition;
import androidx.constraintlayout.core.motion.key.MotionKeyTimeCycle;
import androidx.constraintlayout.core.motion.key.MotionKeyTrigger;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.DifferentialInterpolator;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import androidx.constraintlayout.core.motion.utils.Rect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.motion.utils.Utils;
import androidx.constraintlayout.core.motion.utils.VelocityMatrix;
import androidx.constraintlayout.core.motion.utils.ViewState;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Motion
implements TypedValues {
    static final int BOUNCE = 4;
    private static final boolean DEBUG = false;
    public static final int DRAW_PATH_AS_CONFIGURED = 4;
    public static final int DRAW_PATH_BASIC = 1;
    public static final int DRAW_PATH_CARTESIAN = 3;
    public static final int DRAW_PATH_NONE = 0;
    public static final int DRAW_PATH_RECTANGLE = 5;
    public static final int DRAW_PATH_RELATIVE = 2;
    public static final int DRAW_PATH_SCREEN = 6;
    static final int EASE_IN = 1;
    static final int EASE_IN_OUT = 0;
    static final int EASE_OUT = 2;
    private static final boolean FAVOR_FIXED_SIZE_VIEWS = false;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private static final int INTERPOLATOR_UNDEFINED = -3;
    static final int LINEAR = 3;
    static final int OVERSHOOT = 5;
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int ROTATION_LEFT = 2;
    public static final int ROTATION_RIGHT = 1;
    private static final int SPLINE_STRING = -1;
    private static final String TAG = "MotionController";
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    private int MAX_DIMENSION = 4;
    String[] attributeTable;
    private CurveFit mArcSpline;
    private int[] mAttributeInterpolatorCount;
    private String[] mAttributeNames;
    private HashMap<String, SplineSet> mAttributesMap;
    String mConstraintTag;
    float mCurrentCenterX;
    float mCurrentCenterY;
    private int mCurveFitType = -1;
    private HashMap<String, KeyCycleOscillator> mCycleMap;
    private MotionPaths mEndMotionPath;
    private MotionConstrainedPoint mEndPoint;
    int mId;
    private double[] mInterpolateData;
    private int[] mInterpolateVariables;
    private double[] mInterpolateVelocity;
    private ArrayList<MotionKey> mKeyList;
    private MotionKeyTrigger[] mKeyTriggers;
    private ArrayList<MotionPaths> mMotionPaths;
    float mMotionStagger;
    private boolean mNoMovement = false;
    private int mPathMotionArc = -1;
    private DifferentialInterpolator mQuantizeMotionInterpolator = null;
    private float mQuantizeMotionPhase;
    private int mQuantizeMotionSteps = -1;
    private CurveFit[] mSpline;
    float mStaggerOffset = 0.0f;
    float mStaggerScale = 1.0f;
    private MotionPaths mStartMotionPath;
    private MotionConstrainedPoint mStartPoint;
    Rect mTempRect = new Rect();
    private HashMap<String, TimeCycleSplineSet> mTimeCycleAttributesMap;
    private int mTransformPivotTarget = -1;
    private MotionWidget mTransformPivotView = null;
    private float[] mValuesBuff;
    private float[] mVelocity;
    MotionWidget mView;

    public Motion(MotionWidget motionWidget) {
        this.mStartMotionPath = new MotionPaths();
        this.mEndMotionPath = new MotionPaths();
        this.mStartPoint = new MotionConstrainedPoint();
        this.mEndPoint = new MotionConstrainedPoint();
        this.mMotionStagger = Float.NaN;
        this.mValuesBuff = new float[4];
        this.mMotionPaths = new ArrayList();
        this.mVelocity = new float[1];
        this.mKeyList = new ArrayList();
        this.mQuantizeMotionPhase = Float.NaN;
        this.setView(motionWidget);
    }

    private float getAdjustedPosition(float f, float[] fArray) {
        float f2;
        float f3;
        float f4 = 0.0f;
        float f5 = 1.0f;
        if (fArray != null) {
            fArray[0] = 1.0f;
            f3 = f;
        } else {
            float f6 = this.mStaggerScale;
            f3 = f;
            if ((double)f6 != 1.0) {
                float f7 = this.mStaggerOffset;
                f2 = f;
                if (f < f7) {
                    f2 = 0.0f;
                }
                f3 = f2;
                if (f2 > f7) {
                    f3 = f2;
                    if ((double)f2 < 1.0) {
                        f3 = Math.min((f2 - f7) * f6, 1.0f);
                    }
                }
            }
        }
        Easing easing = this.mStartMotionPath.mKeyFrameEasing;
        f = Float.NaN;
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        f2 = f4;
        while (iterator.hasNext()) {
            MotionPaths motionPaths = iterator.next();
            if (motionPaths.mKeyFrameEasing == null) continue;
            if (motionPaths.time < f3) {
                easing = motionPaths.mKeyFrameEasing;
                f2 = motionPaths.time;
                continue;
            }
            if (!Float.isNaN(f)) continue;
            f = motionPaths.time;
        }
        f4 = f3;
        if (easing != null) {
            if (Float.isNaN(f)) {
                f = f5;
            }
            double d = (f3 - f2) / (f -= f2);
            f4 = f = (float)easing.get(d) * f + f2;
            if (fArray != null) {
                fArray[0] = (float)easing.getDiff(d);
                f4 = f;
            }
        }
        return f4;
    }

    private static DifferentialInterpolator getInterpolator(int n, String string2, int n2) {
        if (n != -1) {
            return null;
        }
        return new DifferentialInterpolator(Easing.getInterpolator(string2)){
            float mX;
            final /* synthetic */ Easing val$easing;
            {
                this.val$easing = easing;
            }

            @Override
            public float getInterpolation(float f) {
                this.mX = f;
                return (float)this.val$easing.get(f);
            }

            @Override
            public float getVelocity() {
                return (float)this.val$easing.getDiff(this.mX);
            }
        };
    }

    private float getPreCycleDistance() {
        double d;
        float[] fArray = new float[2];
        float f = 1.0f / (float)99;
        double d2 = d = 0.0;
        float f2 = 0.0f;
        for (int i = 0; i < 100; ++i) {
            float f3;
            float f4 = (float)i * f;
            double d3 = f4;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
            float f5 = Float.NaN;
            float f6 = 0.0f;
            while (iterator.hasNext()) {
                MotionPaths motionPaths = iterator.next();
                Easing easing2 = easing;
                f3 = f5;
                float f7 = f6;
                if (motionPaths.mKeyFrameEasing != null) {
                    if (motionPaths.time < f4) {
                        easing2 = motionPaths.mKeyFrameEasing;
                        f7 = motionPaths.time;
                        f3 = f5;
                    } else {
                        easing2 = easing;
                        f3 = f5;
                        f7 = f6;
                        if (Float.isNaN(f5)) {
                            f3 = motionPaths.time;
                            f7 = f6;
                            easing2 = easing;
                        }
                    }
                }
                easing = easing2;
                f5 = f3;
                f6 = f7;
            }
            if (easing != null) {
                f3 = f5;
                if (Float.isNaN(f5)) {
                    f3 = 1.0f;
                }
                f5 = f3 - f6;
                d3 = (float)easing.get((f4 - f6) / f5) * f5 + f6;
            }
            this.mSpline[0].getPos(d3, this.mInterpolateData);
            this.mStartMotionPath.getCenter(d3, this.mInterpolateVariables, this.mInterpolateData, fArray, 0);
            if (i > 0) {
                f2 = (float)((double)f2 + Math.hypot(d2 - (double)fArray[1], d - (double)fArray[0]));
            }
            d = fArray[0];
            d2 = fArray[1];
        }
        return f2;
    }

    private void insertKey(MotionPaths motionPaths) {
        int n;
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        Comparable<MotionPaths> comparable = null;
        while (iterator.hasNext()) {
            MotionPaths motionPaths2 = iterator.next();
            if (motionPaths.position != motionPaths2.position) continue;
            comparable = motionPaths2;
        }
        if (comparable != null) {
            this.mMotionPaths.remove(comparable);
        }
        if ((n = Collections.binarySearch(this.mMotionPaths, motionPaths)) == 0) {
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append(" KeyPath position \"");
            ((StringBuilder)comparable).append(motionPaths.position);
            ((StringBuilder)comparable).append("\" outside of range");
            Utils.loge(TAG, ((StringBuilder)comparable).toString());
        }
        this.mMotionPaths.add(-n - 1, motionPaths);
    }

    private void readView(MotionPaths motionPaths) {
        motionPaths.setBounds(this.mView.getX(), this.mView.getY(), this.mView.getWidth(), this.mView.getHeight());
    }

    public void addKey(MotionKey motionKey) {
        this.mKeyList.add(motionKey);
    }

    void addKeys(ArrayList<MotionKey> arrayList) {
        this.mKeyList.addAll(arrayList);
    }

    void buildBounds(float[] fArray, int n) {
        float f = 1.0f / (float)(n - 1);
        HashMap<String, SplineSet> hashMap = this.mAttributesMap;
        if (hashMap != null) {
            hashMap = hashMap.get("translationX");
        }
        hashMap = this.mAttributesMap;
        if (hashMap != null) {
            hashMap = (SplineSet)hashMap.get("translationY");
        }
        hashMap = this.mCycleMap;
        if (hashMap != null) {
            hashMap = (KeyCycleOscillator)hashMap.get("translationX");
        }
        hashMap = this.mCycleMap;
        if (hashMap != null) {
            hashMap = (KeyCycleOscillator)hashMap.get("translationY");
        }
        for (int i = 0; i < n; ++i) {
            float f2;
            float f3 = (float)i * f;
            float f4 = this.mStaggerScale;
            float f5 = 0.0f;
            float f6 = f3;
            if (f4 != 1.0f) {
                float f7 = this.mStaggerOffset;
                f2 = f3;
                if (f3 < f7) {
                    f2 = 0.0f;
                }
                f6 = f2;
                if (f2 > f7) {
                    f6 = f2;
                    if ((double)f2 < 1.0) {
                        f6 = Math.min((f2 - f7) * f4, 1.0f);
                    }
                }
            }
            double d = f6;
            hashMap = this.mStartMotionPath.mKeyFrameEasing;
            f2 = Float.NaN;
            Object object = this.mMotionPaths.iterator();
            f3 = f5;
            while (object.hasNext()) {
                MotionPaths motionPaths = object.next();
                if (motionPaths.mKeyFrameEasing == null) continue;
                if (motionPaths.time < f6) {
                    hashMap = motionPaths.mKeyFrameEasing;
                    f3 = motionPaths.time;
                    continue;
                }
                if (!Float.isNaN(f2)) continue;
                f2 = motionPaths.time;
            }
            if (hashMap != null) {
                f5 = f2;
                if (Float.isNaN(f2)) {
                    f5 = 1.0f;
                }
                f2 = f5 - f3;
                d = (float)((Easing)((Object)hashMap)).get((f6 - f3) / f2) * f2 + f3;
            }
            this.mSpline[0].getPos(d, this.mInterpolateData);
            object = this.mArcSpline;
            if (object != null && ((Object)(hashMap = (HashMap<String, SplineSet>)this.mInterpolateData)).length > 0) {
                ((CurveFit)object).getPos(d, (double[])hashMap);
            }
            this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, fArray, i * 2);
        }
    }

    int buildKeyBounds(float[] fArray, int[] nArray) {
        if (fArray != null) {
            int n;
            double[] dArray = this.mSpline[0].getTimePoints();
            if (nArray != null) {
                Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    nArray[n] = iterator.next().mMode;
                    ++n;
                }
            }
            int n2 = 0;
            for (n = 0; n < dArray.length; ++n) {
                this.mSpline[0].getPos(dArray[n], this.mInterpolateData);
                this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, fArray, n2);
                n2 += 2;
            }
            return n2 / 2;
        }
        return 0;
    }

    public int buildKeyFrames(float[] fArray, int[] object, int[] nArray) {
        if (fArray != null) {
            int n;
            double[] dArray = this.mSpline[0].getTimePoints();
            if (object != null) {
                Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    object[n] = iterator.next().mMode;
                    ++n;
                }
            }
            if (nArray != null) {
                object = this.mMotionPaths.iterator();
                n = 0;
                while (object.hasNext()) {
                    nArray[n] = (int)(((MotionPaths)object.next()).position * 100.0f);
                    ++n;
                }
            }
            n = 0;
            for (int i = 0; i < dArray.length; ++i) {
                this.mSpline[0].getPos(dArray[i], this.mInterpolateData);
                this.mStartMotionPath.getCenter(dArray[i], this.mInterpolateVariables, this.mInterpolateData, fArray, n);
                n += 2;
            }
            return n / 2;
        }
        return 0;
    }

    public void buildPath(float[] fArray, int n) {
        float f = 1.0f / (float)(n - 1);
        Object object = this.mAttributesMap;
        KeyCycleOscillator keyCycleOscillator = null;
        object = object == null ? null : ((HashMap)object).get("translationX");
        Object object2 = this.mAttributesMap;
        object2 = object2 == null ? null : ((HashMap)object2).get("translationY");
        Object object3 = this.mCycleMap;
        object3 = object3 == null ? null : ((HashMap)object3).get("translationX");
        HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
        if (hashMap != null) {
            keyCycleOscillator = hashMap.get("translationY");
        }
        for (int i = 0; i < n; ++i) {
            Object object4;
            float f2;
            float f3;
            float f4 = (float)i * f;
            float f5 = this.mStaggerScale;
            float f6 = f4;
            if (f5 != 1.0f) {
                f3 = this.mStaggerOffset;
                f2 = f4;
                if (f4 < f3) {
                    f2 = 0.0f;
                }
                f6 = f2;
                if (f2 > f3) {
                    f6 = f2;
                    if ((double)f2 < 1.0) {
                        f6 = Math.min((f2 - f3) * f5, 1.0f);
                    }
                }
            }
            double d = f6;
            hashMap = this.mStartMotionPath.mKeyFrameEasing;
            f2 = Float.NaN;
            Object object5 = this.mMotionPaths.iterator();
            f4 = 0.0f;
            while (object5.hasNext()) {
                MotionPaths motionPaths = object5.next();
                object4 = hashMap;
                f3 = f2;
                f5 = f4;
                if (motionPaths.mKeyFrameEasing != null) {
                    if (motionPaths.time < f6) {
                        object4 = motionPaths.mKeyFrameEasing;
                        f5 = motionPaths.time;
                        f3 = f2;
                    } else {
                        object4 = hashMap;
                        f3 = f2;
                        f5 = f4;
                        if (Float.isNaN(f2)) {
                            f3 = motionPaths.time;
                            f5 = f4;
                            object4 = hashMap;
                        }
                    }
                }
                hashMap = object4;
                f2 = f3;
                f4 = f5;
            }
            if (hashMap != null) {
                f3 = f2;
                if (Float.isNaN(f2)) {
                    f3 = 1.0f;
                }
                f2 = f3 - f4;
                d = (float)((Easing)((Object)hashMap)).get((f6 - f4) / f2) * f2 + f4;
            }
            this.mSpline[0].getPos(d, this.mInterpolateData);
            hashMap = this.mArcSpline;
            if (hashMap != null && ((Object)(object4 = (Object)this.mInterpolateData)).length > 0) {
                ((CurveFit)((Object)hashMap)).getPos(d, (double[])object4);
            }
            hashMap = this.mStartMotionPath;
            object5 = this.mInterpolateVariables;
            object4 = this.mInterpolateData;
            int n2 = i * 2;
            ((MotionPaths)((Object)hashMap)).getCenter(d, (int[])object5, (double[])object4, fArray, n2);
            if (object3 != null) {
                fArray[n2] = fArray[n2] + ((KeyCycleOscillator)object3).get(f6);
            } else if (object != null) {
                fArray[n2] = fArray[n2] + ((SplineSet)object).get(f6);
            }
            if (keyCycleOscillator != null) {
                fArray[++n2] = fArray[n2] + keyCycleOscillator.get(f6);
                continue;
            }
            if (object2 == null) continue;
            fArray[++n2] = fArray[n2] + ((SplineSet)object2).get(f6);
        }
    }

    public void buildRect(float f, float[] fArray, int n) {
        f = this.getAdjustedPosition(f, null);
        this.mSpline[0].getPos((double)f, this.mInterpolateData);
        this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, fArray, n);
    }

    void buildRectangles(float[] fArray, int n) {
        float f = 1.0f / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            float f2 = this.getAdjustedPosition((float)i * f, null);
            this.mSpline[0].getPos((double)f2, this.mInterpolateData);
            this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, fArray, i * 8);
        }
    }

    void endTrigger(boolean bl) {
    }

    public int getAnimateRelativeTo() {
        return this.mStartMotionPath.mAnimateRelativeTo;
    }

    int getAttributeValues(String object, float[] fArray, int n) {
        if ((object = this.mAttributesMap.get(object)) == null) {
            return -1;
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = ((SplineSet)object).get(n / (fArray.length - 1));
        }
        return fArray.length;
    }

    public void getCenter(double d, float[] fArray, float[] fArray2) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        this.mSpline[0].getPos(d, dArray);
        this.mSpline[0].getSlope(d, dArray2);
        Arrays.fill(fArray2, 0.0f);
        this.mStartMotionPath.getCenter(d, this.mInterpolateVariables, dArray, fArray, dArray2, fArray2);
    }

    public float getCenterX() {
        return this.mCurrentCenterX;
    }

    public float getCenterY() {
        return this.mCurrentCenterY;
    }

    void getDpDt(float f, float f2, float f3, float[] fArray) {
        f = this.getAdjustedPosition(f, this.mVelocity);
        Object object = this.mSpline;
        if (object != null) {
            double[] dArray;
            object = object[0];
            double d = f;
            ((CurveFit)object).getSlope(d, this.mInterpolateVelocity);
            this.mSpline[0].getPos(d, this.mInterpolateData);
            f = this.mVelocity[0];
            for (int i = 0; i < (dArray = this.mInterpolateVelocity).length; ++i) {
                dArray[i] = dArray[i] * (double)f;
            }
            object = this.mArcSpline;
            if (object != null) {
                dArray = this.mInterpolateData;
                if (dArray.length > 0) {
                    ((CurveFit)object).getPos(d, dArray);
                    this.mArcSpline.getSlope(d, this.mInterpolateVelocity);
                    this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
                }
                return;
            }
            this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, dArray, this.mInterpolateData);
            return;
        }
        float f4 = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float f5 = this.mEndMotionPath.y - this.mStartMotionPath.y;
        f = this.mEndMotionPath.width;
        float f6 = this.mStartMotionPath.width;
        float f7 = this.mEndMotionPath.height;
        float f8 = this.mStartMotionPath.height;
        fArray[0] = f4 * (1.0f - f2) + (f - f6 + f4) * f2;
        fArray[1] = f5 * (1.0f - f3) + (f7 - f8 + f5) * f3;
    }

    public int getDrawPath() {
        int n = this.mStartMotionPath.mDrawPath;
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, iterator.next().mDrawPath);
        }
        return Math.max(n, this.mEndMotionPath.mDrawPath);
    }

    public float getFinalHeight() {
        return this.mEndMotionPath.height;
    }

    public float getFinalWidth() {
        return this.mEndMotionPath.width;
    }

    public float getFinalX() {
        return this.mEndMotionPath.x;
    }

    public float getFinalY() {
        return this.mEndMotionPath.y;
    }

    @Override
    public int getId(String string2) {
        return 0;
    }

    public MotionPaths getKeyFrame(int n) {
        return this.mMotionPaths.get(n);
    }

    public int getKeyFrameInfo(int n, int[] nArray) {
        float[] fArray = new float[2];
        Iterator<MotionKey> iterator = this.mKeyList.iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            MotionKey motionKey = iterator.next();
            if (motionKey.mType != n && n == -1) continue;
            nArray[n3] = 0;
            int n4 = n3 + 1;
            nArray[n4] = motionKey.mType;
            nArray[++n4] = motionKey.mFramePosition;
            float f = (float)motionKey.mFramePosition / 100.0f;
            CurveFit curveFit = this.mSpline[0];
            double d = f;
            curveFit.getPos(d, this.mInterpolateData);
            this.mStartMotionPath.getCenter(d, this.mInterpolateVariables, this.mInterpolateData, fArray, 0);
            nArray[++n4] = Float.floatToIntBits(fArray[0]);
            int n5 = n4 + 1;
            nArray[n5] = Float.floatToIntBits(fArray[1]);
            n4 = n5;
            if (motionKey instanceof MotionKeyPosition) {
                motionKey = (MotionKeyPosition)motionKey;
                n4 = n5 + 1;
                nArray[n4] = ((MotionKeyPosition)motionKey).mPositionType;
                nArray[++n4] = Float.floatToIntBits(((MotionKeyPosition)motionKey).mPercentX);
                nArray[++n4] = Float.floatToIntBits(((MotionKeyPosition)motionKey).mPercentY);
            }
            nArray[n3] = ++n4 - n3;
            ++n2;
            n3 = n4;
        }
        return n2;
    }

    float getKeyFrameParameter(int n, float f, float f2) {
        float f3 = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float f4 = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float f5 = this.mStartMotionPath.x;
        float f6 = this.mStartMotionPath.width / 2.0f;
        float f7 = this.mStartMotionPath.y;
        float f8 = this.mStartMotionPath.height / 2.0f;
        float f9 = (float)Math.hypot(f3, f4);
        if ((double)f9 < 1.0E-7) {
            return Float.NaN;
        }
        if ((float)Math.hypot(f -= f5 + f6, f7 = f2 - (f7 + f8)) == 0.0f) {
            return 0.0f;
        }
        f2 = f * f3 + f7 * f4;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) {
                                return 0.0f;
                            }
                            return f7 / f4;
                        }
                        return f / f4;
                    }
                    return f7 / f3;
                }
                return f / f3;
            }
            return (float)Math.sqrt(f9 * f9 - f2 * f2);
        }
        return f2 / f9;
    }

    public int getKeyFramePositions(int[] nArray, float[] fArray) {
        Iterator<MotionKey> iterator = this.mKeyList.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            nArray[n] = ((MotionKey)object).mFramePosition + ((MotionKey)object).mType * 1000;
            float f = (float)((MotionKey)object).mFramePosition / 100.0f;
            object = this.mSpline[0];
            double d = f;
            ((CurveFit)object).getPos(d, this.mInterpolateData);
            this.mStartMotionPath.getCenter(d, this.mInterpolateVariables, this.mInterpolateData, fArray, n2);
            n2 += 2;
            ++n;
        }
        return n;
    }

    double[] getPos(double d) {
        double[] dArray;
        this.mSpline[0].getPos(d, this.mInterpolateData);
        CurveFit curveFit = this.mArcSpline;
        if (curveFit != null && (dArray = this.mInterpolateData).length > 0) {
            curveFit.getPos(d, dArray);
        }
        return this.mInterpolateData;
    }

    MotionKeyPosition getPositionKeyframe(int n, int n2, float f, float f2) {
        FloatRect floatRect = new FloatRect();
        floatRect.left = this.mStartMotionPath.x;
        floatRect.top = this.mStartMotionPath.y;
        floatRect.right = floatRect.left + this.mStartMotionPath.width;
        floatRect.bottom = floatRect.top + this.mStartMotionPath.height;
        FloatRect floatRect2 = new FloatRect();
        floatRect2.left = this.mEndMotionPath.x;
        floatRect2.top = this.mEndMotionPath.y;
        floatRect2.right = floatRect2.left + this.mEndMotionPath.width;
        floatRect2.bottom = floatRect2.top + this.mEndMotionPath.height;
        for (MotionKey motionKey : this.mKeyList) {
            if (!(motionKey instanceof MotionKeyPosition) || !((MotionKeyPosition)(motionKey = (MotionKeyPosition)motionKey)).intersects(n, n2, floatRect, floatRect2, f, f2)) continue;
            return motionKey;
        }
        return null;
    }

    void getPostLayoutDvDp(float f, int n, int n2, float f2, float f3, float[] fArray) {
        float f4 = this.getAdjustedPosition(f, this.mVelocity);
        Object object = this.mAttributesMap;
        KeyCycleOscillator keyCycleOscillator = null;
        object = object == null ? null : ((HashMap)object).get("translationX");
        Object object2 = this.mAttributesMap;
        object2 = object2 == null ? null : ((HashMap)object2).get("translationY");
        Object object3 = this.mAttributesMap;
        object3 = object3 == null ? null : ((HashMap)object3).get("rotationZ");
        Object object4 = this.mAttributesMap;
        object4 = object4 == null ? null : ((HashMap)object4).get("scaleX");
        Object object5 = this.mAttributesMap;
        object5 = object5 == null ? null : ((HashMap)object5).get("scaleY");
        Object object6 = this.mCycleMap;
        object6 = object6 == null ? null : ((HashMap)object6).get("translationX");
        Object object7 = this.mCycleMap;
        object7 = object7 == null ? null : ((HashMap)object7).get("translationY");
        Object object8 = this.mCycleMap;
        object8 = object8 == null ? null : ((HashMap)object8).get("rotationZ");
        Object object9 = this.mCycleMap;
        object9 = object9 == null ? null : ((HashMap)object9).get("scaleX");
        HashMap<String, KeyCycleOscillator> hashMap = this.mCycleMap;
        if (hashMap != null) {
            keyCycleOscillator = hashMap.get("scaleY");
        }
        hashMap = new VelocityMatrix();
        ((VelocityMatrix)((Object)hashMap)).clear();
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((SplineSet)object3, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((SplineSet)object, (SplineSet)object2, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((SplineSet)object4, (SplineSet)object5, f4);
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((KeyCycleOscillator)object8, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((KeyCycleOscillator)object6, (KeyCycleOscillator)object7, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((KeyCycleOscillator)object9, keyCycleOscillator, f4);
        CurveFit[] curveFitArray = this.mArcSpline;
        if (curveFitArray != null) {
            object = this.mInterpolateData;
            if (((Object)object).length > 0) {
                double d = f4;
                curveFitArray.getPos(d, (double[])object);
                this.mArcSpline.getSlope(d, this.mInterpolateVelocity);
                this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            }
            ((VelocityMatrix)((Object)hashMap)).applyTransform(f2, f3, n, n2, fArray);
            return;
        }
        curveFitArray = this.mSpline;
        if (curveFitArray != null) {
            f = this.getAdjustedPosition(f4, this.mVelocity);
            object = this.mSpline[0];
            double d = f;
            ((CurveFit)object).getSlope(d, this.mInterpolateVelocity);
            this.mSpline[0].getPos(d, this.mInterpolateData);
            f = this.mVelocity[0];
            for (int i = 0; i < ((Object)(object = (Object)this.mInterpolateVelocity)).length; ++i) {
                object[i] = object[i] * (double)f;
            }
            this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, (double[])object, this.mInterpolateData);
            ((VelocityMatrix)((Object)hashMap)).applyTransform(f2, f3, n, n2, fArray);
            return;
        }
        float f5 = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float f6 = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float f7 = this.mEndMotionPath.width;
        float f8 = this.mStartMotionPath.width;
        f = this.mEndMotionPath.height;
        float f9 = this.mStartMotionPath.height;
        fArray[0] = f5 * (1.0f - f2) + (f7 - f8 + f5) * f2;
        fArray[1] = f6 * (1.0f - f3) + (f - f9 + f6) * f3;
        ((VelocityMatrix)((Object)hashMap)).clear();
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((SplineSet)object3, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((SplineSet)object, (SplineSet)object2, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((SplineSet)object4, (SplineSet)object5, f4);
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((KeyCycleOscillator)object8, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((KeyCycleOscillator)object6, (KeyCycleOscillator)object7, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((KeyCycleOscillator)object9, keyCycleOscillator, f4);
        ((VelocityMatrix)((Object)hashMap)).applyTransform(f2, f3, n, n2, fArray);
    }

    public float getStartHeight() {
        return this.mStartMotionPath.height;
    }

    public float getStartWidth() {
        return this.mStartMotionPath.width;
    }

    public float getStartX() {
        return this.mStartMotionPath.x;
    }

    public float getStartY() {
        return this.mStartMotionPath.y;
    }

    public int getTransformPivotTarget() {
        return this.mTransformPivotTarget;
    }

    public MotionWidget getView() {
        return this.mView;
    }

    public boolean interpolate(MotionWidget motionWidget, float f, long l, KeyCache object) {
        float f2;
        Object object2;
        float f3;
        float f4;
        float f5 = this.getAdjustedPosition(f, null);
        int n = this.mQuantizeMotionSteps;
        f = f5;
        if (n != -1) {
            f4 = 1.0f / (float)n;
            f3 = (float)Math.floor(f5 / f4);
            f = f5 = f5 % f4 / f4;
            if (!Float.isNaN(this.mQuantizeMotionPhase)) {
                f = (f5 + this.mQuantizeMotionPhase) % 1.0f;
            }
            f = (object = this.mQuantizeMotionInterpolator) != null ? object.getInterpolation(f) : ((double)f > 0.5 ? 1.0f : 0.0f);
            f = f * f4 + f3 * f4;
        }
        if ((object = this.mAttributesMap) != null) {
            object = ((HashMap)object).values().iterator();
            while (object.hasNext()) {
                ((SplineSet)object.next()).setProperty(motionWidget, f);
            }
        }
        if ((object = this.mSpline) != null) {
            object = object[0];
            double d = f;
            ((CurveFit)object).getPos(d, this.mInterpolateData);
            this.mSpline[0].getSlope(d, this.mInterpolateVelocity);
            object = this.mArcSpline;
            if (object != null && ((double[])(object2 = this.mInterpolateData)).length > 0) {
                ((CurveFit)object).getPos(d, (double[])object2);
                this.mArcSpline.getSlope(d, this.mInterpolateVelocity);
            }
            if (!this.mNoMovement) {
                this.mStartMotionPath.setView(f, motionWidget, this.mInterpolateVariables, this.mInterpolateData, this.mInterpolateVelocity, null);
            }
            if (this.mTransformPivotTarget != -1) {
                if (this.mTransformPivotView == null) {
                    this.mTransformPivotView = motionWidget.getParent().findViewById(this.mTransformPivotTarget);
                }
                if ((object = this.mTransformPivotView) != null) {
                    f2 = (float)(((MotionWidget)object).getTop() + this.mTransformPivotView.getBottom()) / 2.0f;
                    f4 = (float)(this.mTransformPivotView.getLeft() + this.mTransformPivotView.getRight()) / 2.0f;
                    if (motionWidget.getRight() - motionWidget.getLeft() > 0 && motionWidget.getBottom() - motionWidget.getTop() > 0) {
                        f3 = motionWidget.getLeft();
                        f5 = motionWidget.getTop();
                        motionWidget.setPivotX(f4 - f3);
                        motionWidget.setPivotY(f2 - f5);
                    }
                }
            }
            for (n = 1; n < ((Object)(object = this.mSpline)).length; ++n) {
                ((CurveFit)object[n]).getPos(d, this.mValuesBuff);
                this.mStartMotionPath.customAttributes.get(this.mAttributeNames[n - 1]).setInterpolatedValue(motionWidget, this.mValuesBuff);
            }
            if (this.mStartPoint.mVisibilityMode == 0) {
                if (f <= 0.0f) {
                    motionWidget.setVisibility(this.mStartPoint.visibility);
                } else if (f >= 1.0f) {
                    motionWidget.setVisibility(this.mEndPoint.visibility);
                } else if (this.mEndPoint.visibility != this.mStartPoint.visibility) {
                    motionWidget.setVisibility(4);
                }
            }
            if (this.mKeyTriggers != null) {
                for (n = 0; n < ((Object)(object = this.mKeyTriggers)).length; ++n) {
                    ((MotionKeyTrigger)object[n]).conditionallyFire(f, motionWidget);
                }
            }
        } else {
            float f6 = this.mStartMotionPath.x;
            float f7 = this.mEndMotionPath.x;
            float f8 = this.mStartMotionPath.x;
            float f9 = this.mStartMotionPath.y;
            float f10 = this.mEndMotionPath.y;
            float f11 = this.mStartMotionPath.y;
            float f12 = this.mStartMotionPath.width;
            float f13 = this.mEndMotionPath.width;
            f4 = this.mStartMotionPath.width;
            f5 = this.mStartMotionPath.height;
            f2 = this.mEndMotionPath.height;
            f3 = this.mStartMotionPath.height;
            f8 = f6 + (f7 - f8) * f + 0.5f;
            n = (int)f8;
            f9 = f9 + (f10 - f11) * f + 0.5f;
            motionWidget.layout(n, (int)f9, (int)(f8 + (f12 + (f13 - f4) * f)), (int)(f9 + (f5 + (f2 - f3) * f)));
        }
        if ((object = this.mCycleMap) != null) {
            object = ((HashMap)object).values().iterator();
            while (object.hasNext()) {
                object2 = (KeyCycleOscillator)object.next();
                if (object2 instanceof KeyCycleOscillator.PathRotateSet) {
                    KeyCycleOscillator.PathRotateSet pathRotateSet = (KeyCycleOscillator.PathRotateSet)object2;
                    object2 = this.mInterpolateVelocity;
                    pathRotateSet.setPathRotate(motionWidget, f, object2[0], object2[1]);
                    continue;
                }
                object2.setProperty(motionWidget, f);
            }
        }
        return false;
    }

    String name() {
        return this.mView.getName();
    }

    void positionKeyframe(MotionWidget motionWidget, MotionKeyPosition motionKeyPosition, float f, float f2, String[] stringArray, float[] fArray) {
        FloatRect floatRect = new FloatRect();
        floatRect.left = this.mStartMotionPath.x;
        floatRect.top = this.mStartMotionPath.y;
        floatRect.right = floatRect.left + this.mStartMotionPath.width;
        floatRect.bottom = floatRect.top + this.mStartMotionPath.height;
        FloatRect floatRect2 = new FloatRect();
        floatRect2.left = this.mEndMotionPath.x;
        floatRect2.top = this.mEndMotionPath.y;
        floatRect2.right = floatRect2.left + this.mEndMotionPath.width;
        floatRect2.bottom = floatRect2.top + this.mEndMotionPath.height;
        motionKeyPosition.positionAttributes(motionWidget, floatRect, floatRect2, f, f2, stringArray, fArray);
    }

    void rotate(Rect rect, Rect rect2, int n, int n2, int n3) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        n = rect.left;
                        n3 = rect.right;
                        rect2.left = n2 - (rect.bottom + rect.top + rect.width()) / 2;
                        rect2.top = (n + n3 - rect.height()) / 2;
                        rect2.right = rect2.left + rect.width();
                        rect2.bottom = rect2.top + rect.height();
                    }
                } else {
                    n = rect.left + rect.right;
                    n2 = rect.top;
                    n2 = rect.bottom;
                    rect2.left = rect.height() / 2 + rect.top - n / 2;
                    rect2.top = n3 - (n + rect.height()) / 2;
                    rect2.right = rect2.left + rect.width();
                    rect2.bottom = rect2.top + rect.height();
                }
            } else {
                n3 = rect.left;
                n = rect.right;
                rect2.left = n2 - (rect.top + rect.bottom + rect.width()) / 2;
                rect2.top = (n3 + n - rect.height()) / 2;
                rect2.right = rect2.left + rect.width();
                rect2.bottom = rect2.top + rect.height();
            }
        } else {
            n2 = rect.left;
            n = rect.right;
            rect2.left = (rect.top + rect.bottom - rect.width()) / 2;
            rect2.top = n3 - (n2 + n + rect.height()) / 2;
            rect2.right = rect2.left + rect.width();
            rect2.bottom = rect2.top + rect.height();
        }
    }

    void setBothStates(MotionWidget motionWidget) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.mNoMovement = true;
        this.mStartMotionPath.setBounds(motionWidget.getX(), motionWidget.getY(), motionWidget.getWidth(), motionWidget.getHeight());
        this.mEndMotionPath.setBounds(motionWidget.getX(), motionWidget.getY(), motionWidget.getWidth(), motionWidget.getHeight());
        this.mStartPoint.setState(motionWidget);
        this.mEndPoint.setState(motionWidget);
    }

    public void setDrawPath(int n) {
        this.mStartMotionPath.mDrawPath = n;
    }

    public void setEnd(MotionWidget motionWidget) {
        this.mEndMotionPath.time = 1.0f;
        this.mEndMotionPath.position = 1.0f;
        this.readView(this.mEndMotionPath);
        this.mEndMotionPath.setBounds(motionWidget.getLeft(), motionWidget.getTop(), motionWidget.getWidth(), motionWidget.getHeight());
        this.mEndMotionPath.applyParameters(motionWidget);
        this.mEndPoint.setState(motionWidget);
    }

    public void setPathMotionArc(int n) {
        this.mPathMotionArc = n;
    }

    public void setStart(MotionWidget motionWidget) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.mStartMotionPath.setBounds(motionWidget.getX(), motionWidget.getY(), motionWidget.getWidth(), motionWidget.getHeight());
        this.mStartMotionPath.applyParameters(motionWidget);
        this.mStartPoint.setState(motionWidget);
    }

    public void setStartState(ViewState viewState, MotionWidget motionWidget, int n, int n2, int n3) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        Rect rect = new Rect();
        if (n != 1) {
            if (n == 2) {
                n2 = viewState.left;
                int n4 = viewState.right;
                rect.left = n3 - (viewState.top + viewState.bottom + viewState.width()) / 2;
                rect.top = (n2 + n4 - viewState.height()) / 2;
                rect.right = rect.left + viewState.width();
                rect.bottom = rect.top + viewState.height();
            }
        } else {
            int n5 = viewState.left;
            n3 = viewState.right;
            rect.left = (viewState.top + viewState.bottom - viewState.width()) / 2;
            rect.top = n2 - (n5 + n3 + viewState.height()) / 2;
            rect.right = rect.left + viewState.width();
            rect.bottom = rect.top + viewState.height();
        }
        this.mStartMotionPath.setBounds(rect.left, rect.top, rect.width(), rect.height());
        this.mStartPoint.setState(rect, motionWidget, n, viewState.rotation);
    }

    public void setTransformPivotTarget(int n) {
        this.mTransformPivotTarget = n;
        this.mTransformPivotView = null;
    }

    @Override
    public boolean setValue(int n, float f) {
        return false;
    }

    @Override
    public boolean setValue(int n, int n2) {
        if (n != 509) {
            return n == 704;
        }
        this.setPathMotionArc(n2);
        return true;
    }

    @Override
    public boolean setValue(int n, String string2) {
        if (705 == n) {
            PrintStream printStream = System.out;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("TYPE_INTERPOLATOR  ");
            stringBuilder.append(string2);
            printStream.println(stringBuilder.toString());
            this.mQuantizeMotionInterpolator = Motion.getInterpolator(-1, string2, 0);
        }
        return false;
    }

    @Override
    public boolean setValue(int n, boolean bl) {
        return false;
    }

    public void setView(MotionWidget motionWidget) {
        this.mView = motionWidget;
    }

    /*
     * WARNING - void declaration
     */
    public void setup(int n, int n2, float f, long l) {
        int[] nArray;
        String[] stringArray;
        void var14_72;
        Object object;
        Object object4 = Double.TYPE;
        new HashSet();
        Object object5 = new HashSet();
        Object[] objectArray = new HashSet();
        HashSet<String> hashSet = new HashSet<String>();
        MotionPaths[] motionPathsArray = new HashMap();
        int n3 = this.mPathMotionArc;
        if (n3 != -1) {
            this.mStartMotionPath.mPathMotionArc = n3;
        }
        this.mStartPoint.different(this.mEndPoint, (HashSet<String>)objectArray);
        ArrayList<MotionKey> object62 = this.mKeyList;
        if (object62 != null) {
            Iterator<MotionKey> iterator = object62.iterator();
            Object var12_12 = null;
            while (true) {
                void var12_13;
                void var14_66 = var12_13;
                if (iterator.hasNext()) {
                    object = iterator.next();
                    if (object instanceof MotionKeyPosition) {
                        MotionKeyPosition motionKeyPosition = (MotionKeyPosition)object;
                        this.insertKey(new MotionPaths(n, n2, motionKeyPosition, this.mStartMotionPath, this.mEndMotionPath));
                        if (motionKeyPosition.mCurveFit == -1) continue;
                        this.mCurveFitType = motionKeyPosition.mCurveFit;
                        continue;
                    }
                    if (object instanceof MotionKeyCycle) {
                        ((MotionKey)object).getAttributeNames(hashSet);
                        continue;
                    }
                    if (object instanceof MotionKeyTimeCycle) {
                        ((MotionKey)object).getAttributeNames((HashSet<String>)object5);
                        continue;
                    }
                    if (object instanceof MotionKeyTrigger) {
                        void var14_70;
                        void var14_68 = var12_13;
                        if (var12_13 == null) {
                            ArrayList arrayList = new ArrayList();
                        }
                        var14_70.add((MotionKeyTrigger)object);
                        void var12_14 = var14_70;
                        continue;
                    }
                    ((MotionKey)object).setInterpolation((HashMap<String, Integer>)motionPathsArray);
                    ((MotionKey)object).getAttributeNames((HashSet<String>)objectArray);
                    continue;
                }
                break;
            }
        } else {
            Object var14_71 = null;
        }
        if (var14_72 != null) {
            this.mKeyTriggers = var14_72.toArray(new MotionKeyTrigger[0]);
        }
        if (!objectArray.isEmpty()) {
            this.mAttributesMap = new HashMap();
            for (String string2 : objectArray) {
                void var14_77;
                if (string2.startsWith("CUSTOM,")) {
                    KeyFrameArray.CustomVar customVar = new KeyFrameArray.CustomVar();
                    object = string2.split(",")[1];
                    for (MotionKey motionKey : this.mKeyList) {
                        CustomVariable customVariable;
                        if (motionKey.mCustom == null || (customVariable = motionKey.mCustom.get(object)) == null) continue;
                        customVar.append(motionKey.mFramePosition, customVariable);
                    }
                    SplineSet splineSet = SplineSet.makeCustomSplineSet(string2, customVar);
                } else {
                    SplineSet splineSet = SplineSet.makeSpline(string2, l);
                }
                if (var14_77 == null) continue;
                var14_77.setType(string2);
                this.mAttributesMap.put(string2, (SplineSet)var14_77);
            }
            ArrayList<MotionKey> arrayList = this.mKeyList;
            if (arrayList != null) {
                for (MotionKey motionKey : arrayList) {
                    if (!(motionKey instanceof MotionKeyAttributes)) continue;
                    motionKey.addValues(this.mAttributesMap);
                }
            }
            this.mStartPoint.addValues(this.mAttributesMap, 0);
            this.mEndPoint.addValues(this.mAttributesMap, 100);
            for (String string3 : this.mAttributesMap.keySet()) {
                Integer n4;
                n = motionPathsArray.containsKey(string3) && (n4 = (Integer)motionPathsArray.get(string3)) != null ? n4 : 0;
                SplineSet splineSet = this.mAttributesMap.get(string3);
                if (splineSet == null) continue;
                splineSet.setup(n);
            }
        }
        if (!((HashSet)object5).isEmpty()) {
            if (this.mTimeCycleAttributesMap == null) {
                this.mTimeCycleAttributesMap = new HashMap();
            }
            Iterator iterator = ((HashSet)object5).iterator();
            while (iterator.hasNext()) {
                void var12_26;
                object5 = (String)iterator.next();
                if (this.mTimeCycleAttributesMap.containsKey(object5)) continue;
                if (((String)object5).startsWith("CUSTOM,")) {
                    KeyFrameArray.CustomVar customVar = new KeyFrameArray.CustomVar();
                    String string4 = ((String)object5).split(",")[1];
                    for (MotionKey motionKey : this.mKeyList) {
                        if (motionKey.mCustom == null || (object = motionKey.mCustom.get(string4)) == null) continue;
                        customVar.append(motionKey.mFramePosition, (CustomVariable)object);
                    }
                    SplineSet splineSet = SplineSet.makeCustomSplineSet((String)object5, customVar);
                } else {
                    SplineSet splineSet = SplineSet.makeSpline((String)object5, l);
                }
                if (var12_26 == null) continue;
                var12_26.setType((String)object5);
            }
            ArrayList<MotionKey> arrayList = this.mKeyList;
            if (arrayList != null) {
                for (MotionKey motionKey : arrayList) {
                    if (!(motionKey instanceof MotionKeyTimeCycle)) continue;
                    ((MotionKeyTimeCycle)motionKey).addTimeValues(this.mTimeCycleAttributesMap);
                }
            }
            for (String string5 : this.mTimeCycleAttributesMap.keySet()) {
                n = motionPathsArray.containsKey(string5) ? (Integer)motionPathsArray.get(string5) : 0;
                this.mTimeCycleAttributesMap.get(string5).setup(n);
            }
        }
        int n5 = this.mMotionPaths.size() + 2;
        motionPathsArray = new MotionPaths[n5];
        motionPathsArray[0] = this.mStartMotionPath;
        motionPathsArray[n5 - 1] = this.mEndMotionPath;
        if (this.mMotionPaths.size() > 0 && this.mCurveFitType == MotionKey.UNSET) {
            this.mCurveFitType = 0;
        }
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        n = 1;
        while (iterator.hasNext()) {
            motionPathsArray[n] = iterator.next();
            ++n;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string6 : this.mEndMotionPath.customAttributes.keySet()) {
            if (!this.mStartMotionPath.customAttributes.containsKey(string6)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CUSTOM,");
            stringBuilder.append(string6);
            if (objectArray.contains(stringBuilder.toString())) continue;
            hashSet2.add(string6);
        }
        String[] stringArray2 = hashSet2.toArray(new String[0]);
        this.mAttributeNames = stringArray2;
        this.mAttributeInterpolatorCount = new int[stringArray2.length];
        block11: for (n = 0; n < (stringArray = this.mAttributeNames).length; ++n) {
            String string7 = stringArray[n];
            this.mAttributeInterpolatorCount[n] = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                CustomVariable customVariable;
                if (!motionPathsArray[n2].customAttributes.containsKey(string7) || (customVariable = motionPathsArray[n2].customAttributes.get(string7)) == null) continue;
                int[] nArray2 = this.mAttributeInterpolatorCount;
                nArray2[n] = nArray2[n] + customVariable.numberOfInterpolatedValues();
                continue block11;
            }
        }
        boolean bl = motionPathsArray[0].mPathMotionArc != -1;
        int n6 = 18 + this.mAttributeNames.length;
        boolean[] blArray = new boolean[n6];
        for (n = 1; n < n5; ++n) {
            motionPathsArray[n].different(motionPathsArray[n - 1], blArray, this.mAttributeNames, bl);
        }
        n3 = 0;
        for (n = 1; n < n6; ++n) {
            n2 = n3;
            if (blArray[n]) {
                n2 = n3 + 1;
            }
            n3 = n2;
        }
        this.mInterpolateVariables = new int[n3];
        n = Math.max(2, n3);
        this.mInterpolateData = new double[n];
        this.mInterpolateVelocity = new double[n];
        n = 0;
        for (n2 = 1; n2 < n6; ++n2) {
            n3 = n;
            if (blArray[n2]) {
                this.mInterpolateVariables[n] = n2;
                n3 = n + 1;
            }
            n = n3;
        }
        object5 = new double[n5][this.mInterpolateVariables.length];
        double[] dArray = new double[n5];
        for (n = 0; n < n5; ++n) {
            motionPathsArray[n].fillStandard((double[])object5[n], this.mInterpolateVariables);
            dArray[n] = motionPathsArray[n].time;
        }
        for (n = 0; n < (nArray = this.mInterpolateVariables).length; ++n) {
            if (nArray[n] >= MotionPaths.names.length) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MotionPaths.names[this.mInterpolateVariables[n]]);
            stringBuilder.append(" [");
            String string8 = stringBuilder.toString();
            for (n2 = 0; n2 < n5; ++n2) {
                void var12_46;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append((String)var12_46);
                stringBuilder2.append((double)object5[n2][n]);
                String string9 = stringBuilder2.toString();
            }
        }
        this.mSpline = new CurveFit[this.mAttributeNames.length + 1];
        n = 0;
        String[] stringArray3 = object4;
        while (n < ((String[])(object4 = this.mAttributeNames)).length) {
            void var14_100;
            double[][] dArray2 = null;
            object = object4[n];
            String[] stringArray4 = object4 = null;
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (motionPathsArray[n2].hasCustomData((String)object)) {
                    objectArray = object4;
                    object4 = var14_100;
                    if (var14_100 == null) {
                        objectArray = new double[n5];
                        object4 = (double[][])Array.newInstance(stringArray3, new int[]{n5, motionPathsArray[n2].getCustomDataCount((String)object)});
                    }
                    objectArray[n3] = (String)((double)motionPathsArray[n2].time);
                    motionPathsArray[n2].getCustomData((String)object, (double[])object4[n3], 0);
                    ++n3;
                    String[] stringArray5 = object4;
                } else {
                    objectArray = object4;
                }
                object4 = objectArray;
            }
            object4 = Arrays.copyOf((double[])object4, n3);
            double[][] dArray3 = (double[][])Arrays.copyOf(var14_100, n3);
            objectArray = this.mSpline;
            objectArray[++n] = CurveFit.get(this.mCurveFitType, (double[])object4, dArray3);
        }
        this.mSpline[0] = CurveFit.get(this.mCurveFitType, dArray, (double[][])object5);
        if (motionPathsArray[0].mPathMotionArc != -1) {
            object4 = new int[n5];
            double[] dArray4 = new double[n5];
            double[][] dArray5 = (double[][])Array.newInstance(stringArray3, new int[]{n5, 2});
            for (n = 0; n < n5; ++n) {
                object4[n] = motionPathsArray[n].mPathMotionArc;
                dArray4[n] = motionPathsArray[n].time;
                dArray5[n][0] = motionPathsArray[n].x;
                dArray5[n][1] = motionPathsArray[n].y;
            }
            this.mArcSpline = CurveFit.getArc((int[])object4, dArray4, dArray5);
        }
        f = Float.NaN;
        this.mCycleMap = new HashMap();
        if (this.mKeyList != null) {
            for (String string10 : hashSet) {
                KeyCycleOscillator keyCycleOscillator = KeyCycleOscillator.makeWidgetCycle(string10);
                if (keyCycleOscillator == null) continue;
                float f2 = f;
                if (keyCycleOscillator.variesByPath()) {
                    f2 = f;
                    if (Float.isNaN(f)) {
                        f2 = this.getPreCycleDistance();
                    }
                }
                keyCycleOscillator.setType(string10);
                this.mCycleMap.put(string10, keyCycleOscillator);
                f = f2;
            }
            for (MotionKey motionKey : this.mKeyList) {
                if (!(motionKey instanceof MotionKeyCycle)) continue;
                ((MotionKeyCycle)motionKey).addCycleValues(this.mCycleMap);
            }
            Iterator<KeyCycleOscillator> iterator2 = this.mCycleMap.values().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().setup(f);
            }
        }
    }

    public void setupRelative(Motion motion) {
        this.mStartMotionPath.setupRelative(motion, motion.mStartMotionPath);
        this.mEndMotionPath.setupRelative(motion, motion.mEndMotionPath);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" start: x: ");
        stringBuilder.append(this.mStartMotionPath.x);
        stringBuilder.append(" y: ");
        stringBuilder.append(this.mStartMotionPath.y);
        stringBuilder.append(" end: x: ");
        stringBuilder.append(this.mEndMotionPath.x);
        stringBuilder.append(" y: ");
        stringBuilder.append(this.mEndMotionPath.y);
        return stringBuilder.toString();
    }
}

