/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.Rect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

class MotionConstrainedPoint
implements Comparable<MotionConstrainedPoint> {
    static final int CARTESIAN = 2;
    public static final boolean DEBUG = false;
    static final int PERPENDICULAR = 1;
    public static final String TAG = "MotionPaths";
    static String[] names = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
    private float alpha = 1.0f;
    private boolean applyElevation = false;
    private float elevation = 0.0f;
    private float height;
    private int mAnimateRelativeTo = -1;
    LinkedHashMap<String, CustomVariable> mCustomVariable;
    private int mDrawPath = 0;
    private Easing mKeyFrameEasing;
    int mMode = 0;
    private float mPathRotate;
    private float mPivotX = Float.NaN;
    private float mPivotY = Float.NaN;
    private float mProgress;
    double[] mTempDelta;
    double[] mTempValue;
    int mVisibilityMode = 0;
    private float position;
    private float rotation = 0.0f;
    private float rotationX = 0.0f;
    public float rotationY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float translationZ = 0.0f;
    int visibility;
    private float width;
    private float x;
    private float y;

    public MotionConstrainedPoint() {
        this.mPathRotate = Float.NaN;
        this.mProgress = Float.NaN;
        this.mCustomVariable = new LinkedHashMap();
        this.mTempValue = new double[18];
        this.mTempDelta = new double[18];
    }

    private boolean diff(float f, float f2) {
        boolean bl = Float.isNaN(f);
        boolean bl2 = true;
        boolean bl3 = true;
        if (!bl && !Float.isNaN(f2)) {
            if (!(Math.abs(f - f2) > 1.0E-6f)) {
                bl3 = false;
            }
            return bl3;
        }
        bl3 = Float.isNaN(f) != Float.isNaN(f2) ? bl2 : false;
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addValues(HashMap<String, SplineSet> hashMap, int n) {
        Iterator<String> iterator = hashMap.keySet().iterator();
        block45: while (iterator.hasNext()) {
            String string2 = iterator.next();
            Object object = hashMap.get(string2);
            string2.hashCode();
            int n2 = -1;
            int n3 = -1;
            switch (string2.hashCode()) {
                case 803192288: {
                    if (!string2.equals("pathRotate")) break;
                    n3 = 1;
                    break;
                }
                case 92909918: {
                    if (!string2.equals("alpha")) break;
                    n3 = 2;
                    break;
                }
                case -908189617: {
                    if (!string2.equals("scaleY")) break;
                    n3 = 3;
                    break;
                }
                case -908189618: {
                    if (!string2.equals("scaleX")) break;
                    n3 = 4;
                    break;
                }
                case -987906985: {
                    if (!string2.equals("pivotY")) break;
                    n3 = 5;
                    break;
                }
                case -987906986: {
                    if (!string2.equals("pivotX")) break;
                    n3 = 6;
                    break;
                }
                case -1001078227: {
                    if (!string2.equals("progress")) break;
                    n3 = 7;
                    break;
                }
                case -1225497655: {
                    if (!string2.equals("translationZ")) break;
                    n3 = 8;
                    break;
                }
                case -1225497656: {
                    if (!string2.equals("translationY")) break;
                    n3 = 9;
                    break;
                }
                case -1225497657: {
                    if (!string2.equals("translationX")) break;
                    n3 = 10;
                    break;
                }
                case -1249320804: {
                    if (!string2.equals("rotationZ")) break;
                    n3 = 11;
                    break;
                }
                case -1249320805: {
                    if (!string2.equals("rotationY")) break;
                    n3 = 12;
                    break;
                }
                case -1249320806: {
                    if (!string2.equals("rotationX")) break;
                    n3 = 13;
                    break;
                }
            }
            switch (n3) {
                default: {
                    break;
                }
                case 1: {
                    n2 = 12;
                    break;
                }
                case 2: {
                    n2 = 11;
                    break;
                }
                case 3: {
                    n2 = 10;
                    break;
                }
                case 4: {
                    n2 = 9;
                    break;
                }
                case 5: {
                    n2 = 8;
                    break;
                }
                case 6: {
                    n2 = 7;
                    break;
                }
                case 7: {
                    n2 = 6;
                    break;
                }
                case 8: {
                    n2 = 5;
                    break;
                }
                case 9: {
                    n2 = 4;
                    break;
                }
                case 10: {
                    n2 = 3;
                    break;
                }
                case 11: {
                    n2 = 2;
                    break;
                }
                case 12: {
                    n2 = 1;
                    break;
                }
                case 13: {
                    n2 = 0;
                }
            }
            float f = 1.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            switch (n2) {
                default: {
                    if (string2.startsWith("CUSTOM")) {
                        Object object2 = string2.split(",")[1];
                        if (!this.mCustomVariable.containsKey(object2)) continue block45;
                        object2 = this.mCustomVariable.get(object2);
                        if (object instanceof SplineSet.CustomSpline) {
                            ((SplineSet.CustomSpline)object).setPoint(n, (CustomVariable)object2);
                            continue block45;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string2);
                        stringBuilder.append(" ViewSpline not a CustomSet frame = ");
                        stringBuilder.append(n);
                        stringBuilder.append(", value");
                        stringBuilder.append(((CustomVariable)object2).getValueToInterpolate());
                        stringBuilder.append(object);
                        Utils.loge(TAG, stringBuilder.toString());
                        continue block45;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("UNKNOWN spline ");
                    ((StringBuilder)object).append(string2);
                    Utils.loge(TAG, ((StringBuilder)object).toString());
                    continue block45;
                }
                case 12: {
                    f = Float.isNaN(this.mPathRotate) ? f11 : this.mPathRotate;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 11: {
                    if (!Float.isNaN(this.alpha)) {
                        f = this.alpha;
                    }
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 10: {
                    if (!Float.isNaN(this.scaleY)) {
                        f = this.scaleY;
                    }
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 9: {
                    if (!Float.isNaN(this.scaleX)) {
                        f = this.scaleX;
                    }
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 8: {
                    f = Float.isNaN(this.mPivotY) ? f2 : this.mPivotY;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 7: {
                    f = Float.isNaN(this.mPivotX) ? f3 : this.mPivotX;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 6: {
                    f = Float.isNaN(this.mProgress) ? f4 : this.mProgress;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 5: {
                    f = Float.isNaN(this.translationZ) ? f5 : this.translationZ;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 4: {
                    f = Float.isNaN(this.translationY) ? f6 : this.translationY;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 3: {
                    f = Float.isNaN(this.translationX) ? f7 : this.translationX;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 2: {
                    f = Float.isNaN(this.rotation) ? f8 : this.rotation;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 1: {
                    f = Float.isNaN(this.rotationY) ? f9 : this.rotationY;
                    ((SplineSet)object).setPoint(n, f);
                    continue block45;
                }
                case 0: 
            }
            f = Float.isNaN(this.rotationX) ? f10 : this.rotationX;
            ((SplineSet)object).setPoint(n, f);
        }
        return;
    }

    public void applyParameters(MotionWidget motionWidget) {
        this.visibility = motionWidget.getVisibility();
        float f = motionWidget.getVisibility() != 4 ? 0.0f : motionWidget.getAlpha();
        this.alpha = f;
        this.applyElevation = false;
        this.rotation = motionWidget.getRotationZ();
        this.rotationX = motionWidget.getRotationX();
        this.rotationY = motionWidget.getRotationY();
        this.scaleX = motionWidget.getScaleX();
        this.scaleY = motionWidget.getScaleY();
        this.mPivotX = motionWidget.getPivotX();
        this.mPivotY = motionWidget.getPivotY();
        this.translationX = motionWidget.getTranslationX();
        this.translationY = motionWidget.getTranslationY();
        this.translationZ = motionWidget.getTranslationZ();
        for (String string2 : motionWidget.getCustomAttributeNames()) {
            CustomVariable customVariable = motionWidget.getCustomAttribute(string2);
            if (customVariable == null || !customVariable.isContinuous()) continue;
            this.mCustomVariable.put(string2, customVariable);
        }
    }

    @Override
    public int compareTo(MotionConstrainedPoint motionConstrainedPoint) {
        return Float.compare(this.position, motionConstrainedPoint.position);
    }

    void different(MotionConstrainedPoint motionConstrainedPoint, HashSet<String> hashSet) {
        int n;
        int n2;
        if (this.diff(this.alpha, motionConstrainedPoint.alpha)) {
            hashSet.add("alpha");
        }
        if (this.diff(this.elevation, motionConstrainedPoint.elevation)) {
            hashSet.add("translationZ");
        }
        if ((n2 = this.visibility) != (n = motionConstrainedPoint.visibility) && this.mVisibilityMode == 0 && (n2 == 4 || n == 4)) {
            hashSet.add("alpha");
        }
        if (this.diff(this.rotation, motionConstrainedPoint.rotation)) {
            hashSet.add("rotationZ");
        }
        if (!Float.isNaN(this.mPathRotate) || !Float.isNaN(motionConstrainedPoint.mPathRotate)) {
            hashSet.add("pathRotate");
        }
        if (!Float.isNaN(this.mProgress) || !Float.isNaN(motionConstrainedPoint.mProgress)) {
            hashSet.add("progress");
        }
        if (this.diff(this.rotationX, motionConstrainedPoint.rotationX)) {
            hashSet.add("rotationX");
        }
        if (this.diff(this.rotationY, motionConstrainedPoint.rotationY)) {
            hashSet.add("rotationY");
        }
        if (this.diff(this.mPivotX, motionConstrainedPoint.mPivotX)) {
            hashSet.add("pivotX");
        }
        if (this.diff(this.mPivotY, motionConstrainedPoint.mPivotY)) {
            hashSet.add("pivotY");
        }
        if (this.diff(this.scaleX, motionConstrainedPoint.scaleX)) {
            hashSet.add("scaleX");
        }
        if (this.diff(this.scaleY, motionConstrainedPoint.scaleY)) {
            hashSet.add("scaleY");
        }
        if (this.diff(this.translationX, motionConstrainedPoint.translationX)) {
            hashSet.add("translationX");
        }
        if (this.diff(this.translationY, motionConstrainedPoint.translationY)) {
            hashSet.add("translationY");
        }
        if (this.diff(this.translationZ, motionConstrainedPoint.translationZ)) {
            hashSet.add("translationZ");
        }
        if (this.diff(this.elevation, motionConstrainedPoint.elevation)) {
            hashSet.add("elevation");
        }
    }

    void different(MotionConstrainedPoint motionConstrainedPoint, boolean[] blArray, String[] stringArray) {
        blArray[0] = blArray[0] | this.diff(this.position, motionConstrainedPoint.position);
        blArray[1] = blArray[1] | this.diff(this.x, motionConstrainedPoint.x);
        blArray[2] = blArray[2] | this.diff(this.y, motionConstrainedPoint.y);
        blArray[3] = blArray[3] | this.diff(this.width, motionConstrainedPoint.width);
        boolean bl = blArray[4];
        blArray[4] = this.diff(this.height, motionConstrainedPoint.height) | bl;
    }

    void fillStandard(double[] dArray, int[] nArray) {
        float f = this.position;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.width;
        float f5 = this.height;
        float f6 = this.alpha;
        float f7 = this.elevation;
        float f8 = this.rotation;
        float f9 = this.rotationX;
        float f10 = this.rotationY;
        float f11 = this.scaleX;
        float f12 = this.scaleY;
        float f13 = this.mPivotX;
        float f14 = this.mPivotY;
        float f15 = this.translationX;
        float f16 = this.translationY;
        float f17 = this.translationZ;
        float f18 = this.mPathRotate;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n;
            if (nArray[i] < 18) {
                n2 = nArray[i];
                dArray[n] = (new float[]{f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18})[n2];
                n2 = n + 1;
            }
            n = n2;
        }
    }

    int getCustomData(String object, double[] dArray, int n) {
        if (((CustomVariable)(object = this.mCustomVariable.get(object))).numberOfInterpolatedValues() == 1) {
            dArray[n] = ((CustomVariable)object).getValueToInterpolate();
            return 1;
        }
        int n2 = ((CustomVariable)object).numberOfInterpolatedValues();
        float[] fArray = new float[n2];
        ((CustomVariable)object).getValuesToInterpolate(fArray);
        int n3 = 0;
        while (n3 < n2) {
            dArray[n] = fArray[n3];
            ++n3;
            ++n;
        }
        return n2;
    }

    int getCustomDataCount(String string2) {
        return this.mCustomVariable.get(string2).numberOfInterpolatedValues();
    }

    boolean hasCustomData(String string2) {
        return this.mCustomVariable.containsKey(string2);
    }

    void setBounds(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public void setState(MotionWidget motionWidget) {
        this.setBounds(motionWidget.getX(), motionWidget.getY(), motionWidget.getWidth(), motionWidget.getHeight());
        this.applyParameters(motionWidget);
    }

    public void setState(Rect rect, MotionWidget motionWidget, int n, float f) {
        this.setBounds(rect.left, rect.top, rect.width(), rect.height());
        this.applyParameters(motionWidget);
        this.mPivotX = Float.NaN;
        this.mPivotY = Float.NaN;
        if (n != 1) {
            if (n == 2) {
                this.rotation = f + 90.0f;
            }
        } else {
            this.rotation = f - 90.0f;
        }
    }
}

