/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.HashMap;
import java.util.HashSet;

public abstract class MotionKey
implements TypedValues {
    public static final String ALPHA = "alpha";
    public static final String CUSTOM = "CUSTOM";
    public static final String ELEVATION = "elevation";
    public static final String ROTATION = "rotationZ";
    public static final String ROTATION_X = "rotationX";
    public static final String SCALE_X = "scaleX";
    public static final String SCALE_Y = "scaleY";
    public static final String TRANSITION_PATH_ROTATE = "transitionPathRotate";
    public static final String TRANSLATION_X = "translationX";
    public static final String TRANSLATION_Y = "translationY";
    public static int UNSET = -1;
    public static final String VISIBILITY = "visibility";
    public HashMap<String, CustomVariable> mCustom;
    public int mFramePosition;
    int mTargetId;
    String mTargetString;
    public int mType;

    public MotionKey() {
        int n;
        this.mFramePosition = n = UNSET;
        this.mTargetId = n;
        this.mTargetString = null;
    }

    public abstract void addValues(HashMap<String, SplineSet> var1);

    public abstract MotionKey clone();

    public MotionKey copy(MotionKey motionKey) {
        this.mFramePosition = motionKey.mFramePosition;
        this.mTargetId = motionKey.mTargetId;
        this.mTargetString = motionKey.mTargetString;
        this.mType = motionKey.mType;
        return this;
    }

    public abstract void getAttributeNames(HashSet<String> var1);

    public int getFramePosition() {
        return this.mFramePosition;
    }

    boolean matches(String string2) {
        String string3 = this.mTargetString;
        if (string3 != null && string2 != null) {
            return string2.matches(string3);
        }
        return false;
    }

    public void setCustomAttribute(String string2, int n, float f) {
        this.mCustom.put(string2, new CustomVariable(string2, n, f));
    }

    public void setCustomAttribute(String string2, int n, int n2) {
        this.mCustom.put(string2, new CustomVariable(string2, n, n2));
    }

    public void setCustomAttribute(String string2, int n, String string3) {
        this.mCustom.put(string2, new CustomVariable(string2, n, string3));
    }

    public void setCustomAttribute(String string2, int n, boolean bl) {
        this.mCustom.put(string2, new CustomVariable(string2, n, bl));
    }

    public void setFramePosition(int n) {
        this.mFramePosition = n;
    }

    public void setInterpolation(HashMap<String, Integer> hashMap) {
    }

    @Override
    public boolean setValue(int n, float f) {
        return false;
    }

    @Override
    public boolean setValue(int n, int n2) {
        if (n != 100) {
            return false;
        }
        this.mFramePosition = n2;
        return true;
    }

    @Override
    public boolean setValue(int n, String string2) {
        if (n != 101) {
            return false;
        }
        this.mTargetString = string2;
        return true;
    }

    @Override
    public boolean setValue(int n, boolean bl) {
        return false;
    }

    public MotionKey setViewId(int n) {
        this.mTargetId = n;
        return this;
    }

    boolean toBoolean(Object object) {
        boolean bl = object instanceof Boolean ? (Boolean)object : Boolean.parseBoolean(object.toString());
        return bl;
    }

    float toFloat(Object object) {
        float f = object instanceof Float ? ((Float)object).floatValue() : Float.parseFloat(object.toString());
        return f;
    }

    int toInt(Object object) {
        int n = object instanceof Integer ? (Integer)object : Integer.parseInt(object.toString());
        return n;
    }
}

