/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues$AttributesType$_CC;
import androidx.constraintlayout.core.motion.utils.Utils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;

public class MotionKeyCycle
extends MotionKey {
    public static final int KEY_TYPE = 4;
    static final String NAME = "KeyCycle";
    public static final int SHAPE_BOUNCE = 6;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    private static final String TAG = "KeyCycle";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_PHASE = "wavePhase";
    public static final String WAVE_SHAPE = "waveShape";
    private float mAlpha;
    private int mCurveFit = 0;
    private String mCustomWaveShape = null;
    private float mElevation;
    private float mProgress;
    private float mRotation;
    private float mRotationX;
    private float mRotationY;
    private float mScaleX;
    private float mScaleY;
    private String mTransitionEasing = null;
    private float mTransitionPathRotate;
    private float mTranslationX;
    private float mTranslationY;
    private float mTranslationZ;
    private float mWaveOffset = 0.0f;
    private float mWavePeriod = Float.NaN;
    private float mWavePhase = 0.0f;
    private int mWaveShape = -1;

    public MotionKeyCycle() {
        this.mProgress = Float.NaN;
        this.mAlpha = Float.NaN;
        this.mElevation = Float.NaN;
        this.mRotation = Float.NaN;
        this.mTransitionPathRotate = Float.NaN;
        this.mRotationX = Float.NaN;
        this.mRotationY = Float.NaN;
        this.mScaleX = Float.NaN;
        this.mScaleY = Float.NaN;
        this.mTranslationX = Float.NaN;
        this.mTranslationY = Float.NaN;
        this.mTranslationZ = Float.NaN;
        this.mType = 4;
        this.mCustom = new HashMap();
    }

    public void addCycleValues(HashMap<String, KeyCycleOscillator> hashMap) {
        for (String string2 : hashMap.keySet()) {
            KeyCycleOscillator keyCycleOscillator;
            if (string2.startsWith("CUSTOM")) {
                KeyCycleOscillator keyCycleOscillator2;
                Object object = string2.substring(7);
                if ((object = (CustomVariable)this.mCustom.get(object)) == null || ((CustomVariable)object).getType() != 901 || (keyCycleOscillator2 = hashMap.get(string2)) == null) continue;
                keyCycleOscillator2.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, -1, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, ((CustomVariable)object).getValueToInterpolate(), object);
                continue;
            }
            float f = this.getValue(string2);
            if (Float.isNaN(f) || (keyCycleOscillator = hashMap.get(string2)) == null) continue;
            keyCycleOscillator.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, -1, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, f);
        }
    }

    @Override
    public void addValues(HashMap<String, SplineSet> hashMap) {
    }

    @Override
    public MotionKey clone() {
        return null;
    }

    public void dump() {
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MotionKeyCycle{mWaveShape=");
        stringBuilder.append(this.mWaveShape);
        stringBuilder.append(", mWavePeriod=");
        stringBuilder.append(this.mWavePeriod);
        stringBuilder.append(", mWaveOffset=");
        stringBuilder.append(this.mWaveOffset);
        stringBuilder.append(", mWavePhase=");
        stringBuilder.append(this.mWavePhase);
        stringBuilder.append(", mRotation=");
        stringBuilder.append(this.mRotation);
        stringBuilder.append('}');
        printStream.println(stringBuilder.toString());
    }

    @Override
    public void getAttributeNames(HashSet<String> hashSet) {
        if (!Float.isNaN(this.mAlpha)) {
            hashSet.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            hashSet.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            hashSet.add("rotationZ");
        }
        if (!Float.isNaN(this.mRotationX)) {
            hashSet.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            hashSet.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            hashSet.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            hashSet.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            hashSet.add("pathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            hashSet.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            hashSet.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            hashSet.add("translationZ");
        }
        if (this.mCustom.size() > 0) {
            for (String string2 : this.mCustom.keySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CUSTOM,");
                stringBuilder.append(string2);
                hashSet.add(stringBuilder.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getId(String string2) {
        int n;
        string2.hashCode();
        int n2 = -1;
        switch (string2.hashCode()) {
            case 1941332754: {
                if (!string2.equals("visibility")) break;
                n2 = 1;
                break;
            }
            case 1532805160: {
                if (!string2.equals(WAVE_SHAPE)) break;
                n2 = 2;
                break;
            }
            case 803192288: {
                if (!string2.equals("pathRotate")) break;
                n2 = 3;
                break;
            }
            case 579057826: {
                if (!string2.equals("curveFit")) break;
                n2 = 4;
                break;
            }
            case 106629499: {
                if (!string2.equals("phase")) break;
                n2 = 5;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 6;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 7;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 8;
                break;
            }
            case -987906985: {
                if (!string2.equals("pivotY")) break;
                n2 = 9;
                break;
            }
            case -987906986: {
                if (!string2.equals("pivotX")) break;
                n2 = 10;
                break;
            }
            case -991726143: {
                if (!string2.equals("period")) break;
                n2 = 11;
                break;
            }
            case -1001078227: {
                if (!string2.equals("progress")) break;
                n2 = 12;
                break;
            }
            case -1019779949: {
                if (!string2.equals("offset")) break;
                n2 = 13;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 14;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 15;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 16;
                break;
            }
            case -1249320804: {
                if (!string2.equals("rotationZ")) break;
                n2 = 17;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 18;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 19;
                break;
            }
            case -1310311125: {
                if (!string2.equals("easing")) break;
                n2 = 20;
                break;
            }
            case -1581616630: {
                if (!string2.equals("customWave")) break;
                n2 = 21;
                break;
            }
        }
        switch (n2) {
            default: {
                n = -1;
                break;
            }
            case 1: {
                n = 20;
                break;
            }
            case 2: {
                n = 19;
                break;
            }
            case 3: {
                n = 18;
                break;
            }
            case 4: {
                n = 17;
                break;
            }
            case 5: {
                n = 16;
                break;
            }
            case 6: {
                n = 15;
                break;
            }
            case 7: {
                n = 14;
                break;
            }
            case 8: {
                n = 13;
                break;
            }
            case 9: {
                n = 12;
                break;
            }
            case 10: {
                n = 11;
                break;
            }
            case 11: {
                n = 10;
                break;
            }
            case 12: {
                n = 9;
                break;
            }
            case 13: {
                n = 8;
                break;
            }
            case 14: {
                n = 7;
                break;
            }
            case 15: {
                n = 6;
                break;
            }
            case 16: {
                n = 5;
                break;
            }
            case 17: {
                n = 4;
                break;
            }
            case 18: {
                n = 3;
                break;
            }
            case 19: {
                n = 2;
                break;
            }
            case 20: {
                n = 1;
                break;
            }
            case 21: {
                n = 0;
            }
        }
        switch (n) {
            default: {
                return -1;
            }
            case 20: {
                return 402;
            }
            case 19: {
                return 421;
            }
            case 18: {
                return 416;
            }
            case 17: {
                return 401;
            }
            case 16: {
                return 425;
            }
            case 15: {
                return 403;
            }
            case 14: {
                return 312;
            }
            case 13: {
                return 311;
            }
            case 12: {
                return 314;
            }
            case 11: {
                return 313;
            }
            case 10: {
                return 423;
            }
            case 9: {
                return 315;
            }
            case 8: {
                return 424;
            }
            case 7: {
                return 306;
            }
            case 6: {
                return 305;
            }
            case 5: {
                return 304;
            }
            case 4: {
                return 310;
            }
            case 3: {
                return 309;
            }
            case 2: {
                return 308;
            }
            case 1: {
                return 420;
            }
            case 0: 
        }
        return 422;
    }

    public float getValue(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 803192288: {
                if (!string2.equals("pathRotate")) break;
                n2 = 13;
                break;
            }
            case 106629499: {
                if (!string2.equals("phase")) break;
                n2 = 12;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 11;
                break;
            }
            case -4379043: {
                if (!string2.equals("elevation")) break;
                n2 = 10;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 9;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 8;
                break;
            }
            case -1001078227: {
                if (!string2.equals("progress")) break;
                n2 = 7;
                break;
            }
            case -1019779949: {
                if (!string2.equals("offset")) break;
                n2 = 6;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 5;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 4;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 3;
                break;
            }
            case -1249320804: {
                if (!string2.equals("rotationZ")) break;
                n2 = 2;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 1;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return Float.NaN;
            }
            case 13: {
                return this.mTransitionPathRotate;
            }
            case 12: {
                return this.mWavePhase;
            }
            case 11: {
                return this.mAlpha;
            }
            case 10: {
                return this.mElevation;
            }
            case 9: {
                return this.mScaleY;
            }
            case 8: {
                return this.mScaleX;
            }
            case 7: {
                return this.mProgress;
            }
            case 6: {
                return this.mWaveOffset;
            }
            case 5: {
                return this.mTranslationZ;
            }
            case 4: {
                return this.mTranslationY;
            }
            case 3: {
                return this.mTranslationX;
            }
            case 2: {
                return this.mRotation;
            }
            case 1: {
                return this.mRotationY;
            }
            case 0: 
        }
        return this.mRotationX;
    }

    public void printAttributes() {
        String[] stringArray = new HashSet();
        this.getAttributeNames((HashSet<String>)stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" ------------- ");
        stringBuilder.append(this.mFramePosition);
        stringBuilder.append(" -------------");
        Utils.log(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("MotionKeyCycle{Shape=");
        stringBuilder.append(this.mWaveShape);
        stringBuilder.append(", Period=");
        stringBuilder.append(this.mWavePeriod);
        stringBuilder.append(", Offset=");
        stringBuilder.append(this.mWaveOffset);
        stringBuilder.append(", Phase=");
        stringBuilder.append(this.mWavePhase);
        stringBuilder.append('}');
        Utils.log(stringBuilder.toString());
        stringArray = stringArray.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            TypedValues$AttributesType$_CC.getId(stringArray[i]);
            stringBuilder = new StringBuilder();
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(":");
            stringBuilder.append(this.getValue(stringArray[i]));
            Utils.log(stringBuilder.toString());
        }
    }

    @Override
    public boolean setValue(int n, float f) {
        if (n != 315) {
            if (n != 403) {
                if (n != 416) {
                    block0 : switch (n) {
                        default: {
                            switch (n) {
                                default: {
                                    return super.setValue(n, f);
                                }
                                case 425: {
                                    this.mWavePhase = f;
                                    break block0;
                                }
                                case 424: {
                                    this.mWaveOffset = f;
                                    break block0;
                                }
                                case 423: 
                            }
                            this.mWavePeriod = f;
                            break;
                        }
                        case 312: {
                            this.mScaleY = f;
                            break;
                        }
                        case 311: {
                            this.mScaleX = f;
                            break;
                        }
                        case 310: {
                            this.mRotation = f;
                            break;
                        }
                        case 309: {
                            this.mRotationY = f;
                            break;
                        }
                        case 308: {
                            this.mRotationX = f;
                            break;
                        }
                        case 307: {
                            this.mElevation = f;
                            break;
                        }
                        case 306: {
                            this.mTranslationZ = f;
                            break;
                        }
                        case 305: {
                            this.mTranslationY = f;
                            break;
                        }
                        case 304: {
                            this.mTranslationX = f;
                            break;
                        }
                    }
                } else {
                    this.mTransitionPathRotate = f;
                }
            } else {
                this.mAlpha = f;
            }
        } else {
            this.mProgress = f;
        }
        return true;
    }

    @Override
    public boolean setValue(int n, int n2) {
        if (n != 401) {
            if (n != 421) {
                if (this.setValue(n, (float)n2)) {
                    return true;
                }
                return super.setValue(n, n2);
            }
            this.mWaveShape = n2;
            return true;
        }
        this.mCurveFit = n2;
        return true;
    }

    @Override
    public boolean setValue(int n, String string2) {
        if (n != 420) {
            if (n != 422) {
                return super.setValue(n, string2);
            }
            this.mCustomWaveShape = string2;
            return true;
        }
        this.mTransitionEasing = string2;
        return true;
    }
}

