/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues$PositionType$_CC;
import java.util.HashMap;
import java.util.HashSet;

public class MotionKeyPosition
extends MotionKey {
    static final int KEY_TYPE = 2;
    static final String NAME = "KeyPosition";
    protected static final float SELECTION_SLOPE = 20.0f;
    public static final int TYPE_CARTESIAN = 0;
    public static final int TYPE_PATH = 1;
    public static final int TYPE_SCREEN = 2;
    public float mAltPercentX;
    public float mAltPercentY;
    private float mCalculatedPositionX;
    private float mCalculatedPositionY;
    public int mCurveFit = UNSET;
    public int mDrawPath = 0;
    public int mPathMotionArc = UNSET;
    public float mPercentHeight;
    public float mPercentWidth = Float.NaN;
    public float mPercentX;
    public float mPercentY;
    public int mPositionType = 0;
    public String mTransitionEasing = null;

    public MotionKeyPosition() {
        this.mPercentHeight = Float.NaN;
        this.mPercentX = Float.NaN;
        this.mPercentY = Float.NaN;
        this.mAltPercentX = Float.NaN;
        this.mAltPercentY = Float.NaN;
        this.mCalculatedPositionX = Float.NaN;
        this.mCalculatedPositionY = Float.NaN;
        this.mType = 2;
    }

    private void calcCartesianPosition(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        boolean bl = Float.isNaN(this.mPercentX);
        float f7 = 0.0f;
        f3 = bl ? 0.0f : this.mPercentX;
        f4 = Float.isNaN(this.mAltPercentY) ? 0.0f : this.mAltPercentY;
        float f8 = Float.isNaN(this.mPercentY) ? 0.0f : this.mPercentY;
        if (!Float.isNaN(this.mAltPercentX)) {
            f7 = this.mAltPercentX;
        }
        this.mCalculatedPositionX = (int)(f + f3 * f5 + f7 * f6);
        this.mCalculatedPositionY = (int)(f2 + f5 * f4 + f6 * f8);
    }

    private void calcPathPosition(float f, float f2, float f3, float f4) {
        float f5 = f4 - f2;
        f4 = -f5;
        float f6 = this.mPercentX;
        float f7 = this.mPercentY;
        this.mCalculatedPositionX = f + (f3 -= f) * f6 + f4 * f7;
        this.mCalculatedPositionY = f2 + f5 * f6 + f3 * f7;
    }

    private void calcScreenPosition(int n, int n2) {
        float f = n - 0;
        float f2 = this.mPercentX;
        float f3 = 0.0f;
        this.mCalculatedPositionX = f * f2 + f3;
        this.mCalculatedPositionY = (float)(n2 - 0) * f2 + f3;
    }

    @Override
    public void addValues(HashMap<String, SplineSet> hashMap) {
    }

    void calcPosition(int n, int n2, float f, float f2, float f3, float f4) {
        int n3 = this.mPositionType;
        if (n3 != 1) {
            if (n3 != 2) {
                this.calcCartesianPosition(f, f2, f3, f4);
                return;
            }
            this.calcScreenPosition(n, n2);
            return;
        }
        this.calcPathPosition(f, f2, f3, f4);
    }

    @Override
    public MotionKey clone() {
        return new MotionKeyPosition().copy(this);
    }

    @Override
    public MotionKey copy(MotionKey motionKey) {
        super.copy(motionKey);
        motionKey = (MotionKeyPosition)motionKey;
        this.mTransitionEasing = ((MotionKeyPosition)motionKey).mTransitionEasing;
        this.mPathMotionArc = ((MotionKeyPosition)motionKey).mPathMotionArc;
        this.mDrawPath = ((MotionKeyPosition)motionKey).mDrawPath;
        this.mPercentWidth = ((MotionKeyPosition)motionKey).mPercentWidth;
        this.mPercentHeight = Float.NaN;
        this.mPercentX = ((MotionKeyPosition)motionKey).mPercentX;
        this.mPercentY = ((MotionKeyPosition)motionKey).mPercentY;
        this.mAltPercentX = ((MotionKeyPosition)motionKey).mAltPercentX;
        this.mAltPercentY = ((MotionKeyPosition)motionKey).mAltPercentY;
        this.mCalculatedPositionX = ((MotionKeyPosition)motionKey).mCalculatedPositionX;
        this.mCalculatedPositionY = ((MotionKeyPosition)motionKey).mCalculatedPositionY;
        return this;
    }

    @Override
    public void getAttributeNames(HashSet<String> hashSet) {
    }

    @Override
    public int getId(String string2) {
        return TypedValues$PositionType$_CC.getId(string2);
    }

    float getPositionX() {
        return this.mCalculatedPositionX;
    }

    float getPositionY() {
        return this.mCalculatedPositionY;
    }

    public boolean intersects(int n, int n2, FloatRect floatRect, FloatRect floatRect2, float f, float f2) {
        this.calcPosition(n, n2, floatRect.centerX(), floatRect.centerY(), floatRect2.centerX(), floatRect2.centerY());
        return Math.abs(f - this.mCalculatedPositionX) < 20.0f && Math.abs(f2 - this.mCalculatedPositionY) < 20.0f;
    }

    public void positionAttributes(MotionWidget motionWidget, FloatRect floatRect, FloatRect floatRect2, float f, float f2, String[] stringArray, float[] fArray) {
        int n = this.mPositionType;
        if (n != 1) {
            if (n != 2) {
                this.positionCartAttributes(floatRect, floatRect2, f, f2, stringArray, fArray);
                return;
            }
            this.positionScreenAttributes(motionWidget, floatRect, floatRect2, f, f2, stringArray, fArray);
            return;
        }
        this.positionPathAttributes(floatRect, floatRect2, f, f2, stringArray, fArray);
    }

    void positionCartAttributes(FloatRect floatRect, FloatRect floatRect2, float f, float f2, String[] stringArray, float[] fArray) {
        float f3 = floatRect.centerX();
        float f4 = floatRect.centerY();
        float f5 = floatRect2.centerX();
        float f6 = floatRect2.centerY();
        f5 -= f3;
        f6 -= f4;
        if (stringArray[0] != null) {
            if ("percentX".equals(stringArray[0])) {
                fArray[0] = (f - f3) / f5;
                fArray[1] = (f2 - f4) / f6;
            } else {
                fArray[1] = (f - f3) / f5;
                fArray[0] = (f2 - f4) / f6;
            }
        } else {
            stringArray[0] = "percentX";
            fArray[0] = (f - f3) / f5;
            stringArray[1] = "percentY";
            fArray[1] = (f2 - f4) / f6;
        }
    }

    void positionPathAttributes(FloatRect floatRect, FloatRect floatRect2, float f, float f2, String[] stringArray, float[] fArray) {
        float f3 = floatRect.centerX();
        float f4 = floatRect.centerY();
        float f5 = floatRect2.centerX();
        float f6 = floatRect2.centerY();
        float f7 = f6 - f4;
        if ((double)(f6 = (float)Math.hypot(f5 -= f3, f7)) < 1.0E-4) {
            System.out.println("distance ~ 0");
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            return;
        }
        f3 = f - f3;
        f = ((f5 /= f6) * (f2 -= f4) - f3 * (f7 /= f6)) / f6;
        f2 = (f5 * f3 + f7 * f2) / f6;
        if (stringArray[0] != null) {
            if ("percentX".equals(stringArray[0])) {
                fArray[0] = f2;
                fArray[1] = f;
            }
        } else {
            stringArray[0] = "percentX";
            stringArray[1] = "percentY";
            fArray[0] = f2;
            fArray[1] = f;
        }
    }

    void positionScreenAttributes(MotionWidget motionWidget, FloatRect floatRect, FloatRect floatRect2, float f, float f2, String[] stringArray, float[] fArray) {
        floatRect.centerX();
        floatRect.centerY();
        floatRect2.centerX();
        floatRect2.centerY();
        motionWidget = motionWidget.getParent();
        int n = motionWidget.getWidth();
        int n2 = motionWidget.getHeight();
        if (stringArray[0] != null) {
            if ("percentX".equals(stringArray[0])) {
                fArray[0] = f / (float)n;
                fArray[1] = f2 / (float)n2;
            } else {
                fArray[1] = f / (float)n;
                fArray[0] = f2 / (float)n2;
            }
        } else {
            stringArray[0] = "percentX";
            fArray[0] = f / (float)n;
            stringArray[1] = "percentY";
            fArray[1] = f2 / (float)n2;
        }
    }

    @Override
    public boolean setValue(int n, float f) {
        switch (n) {
            default: {
                return super.setValue(n, f);
            }
            case 507: {
                this.mPercentY = f;
                break;
            }
            case 506: {
                this.mPercentX = f;
                break;
            }
            case 505: {
                this.mPercentWidth = f;
                this.mPercentHeight = f;
                break;
            }
            case 504: {
                this.mPercentHeight = f;
                break;
            }
            case 503: {
                this.mPercentWidth = f;
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int n, int n2) {
        if (n != 100) {
            if (n != 508) {
                if (n != 510) {
                    return super.setValue(n, n2);
                }
                this.mPositionType = n2;
            } else {
                this.mCurveFit = n2;
            }
        } else {
            this.mFramePosition = n2;
        }
        return true;
    }

    @Override
    public boolean setValue(int n, String string2) {
        if (n != 501) {
            return super.setValue(n, string2);
        }
        this.mTransitionEasing = string2.toString();
        return true;
    }
}

