/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class MotionKeyTrigger
extends MotionKey {
    public static final String CROSS = "CROSS";
    public static final int KEY_TYPE = 5;
    public static final String NEGATIVE_CROSS = "negativeCross";
    public static final String POSITIVE_CROSS = "positiveCross";
    public static final String POST_LAYOUT = "postLayout";
    private static final String TAG = "KeyTrigger";
    public static final String TRIGGER_COLLISION_ID = "triggerCollisionId";
    public static final String TRIGGER_COLLISION_VIEW = "triggerCollisionView";
    public static final String TRIGGER_ID = "triggerID";
    public static final String TRIGGER_RECEIVER = "triggerReceiver";
    public static final String TRIGGER_SLACK = "triggerSlack";
    public static final int TYPE_CROSS = 312;
    public static final int TYPE_NEGATIVE_CROSS = 310;
    public static final int TYPE_POSITIVE_CROSS = 309;
    public static final int TYPE_POST_LAYOUT = 304;
    public static final int TYPE_TRIGGER_COLLISION_ID = 307;
    public static final int TYPE_TRIGGER_COLLISION_VIEW = 306;
    public static final int TYPE_TRIGGER_ID = 308;
    public static final int TYPE_TRIGGER_RECEIVER = 311;
    public static final int TYPE_TRIGGER_SLACK = 305;
    public static final int TYPE_VIEW_TRANSITION_ON_CROSS = 301;
    public static final int TYPE_VIEW_TRANSITION_ON_NEGATIVE_CROSS = 303;
    public static final int TYPE_VIEW_TRANSITION_ON_POSITIVE_CROSS = 302;
    public static final String VIEW_TRANSITION_ON_CROSS = "viewTransitionOnCross";
    public static final String VIEW_TRANSITION_ON_NEGATIVE_CROSS = "viewTransitionOnNegativeCross";
    public static final String VIEW_TRANSITION_ON_POSITIVE_CROSS = "viewTransitionOnPositiveCross";
    FloatRect mCollisionRect;
    private String mCross = null;
    private int mCurveFit = -1;
    private boolean mFireCrossReset = true;
    private float mFireLastPos;
    private boolean mFireNegativeReset = true;
    private boolean mFirePositiveReset = true;
    private float mFireThreshold;
    private String mNegativeCross = null;
    private String mPositiveCross = null;
    private boolean mPostLayout = false;
    FloatRect mTargetRect;
    private int mTriggerCollisionId;
    private int mTriggerID;
    private int mTriggerReceiver = UNSET;
    float mTriggerSlack = 0.1f;
    int mViewTransitionOnCross;
    int mViewTransitionOnNegativeCross;
    int mViewTransitionOnPositiveCross;

    public MotionKeyTrigger() {
        this.mTriggerID = UNSET;
        this.mTriggerCollisionId = UNSET;
        this.mFireThreshold = Float.NaN;
        this.mViewTransitionOnNegativeCross = UNSET;
        this.mViewTransitionOnPositiveCross = UNSET;
        this.mViewTransitionOnCross = UNSET;
        this.mCollisionRect = new FloatRect();
        this.mTargetRect = new FloatRect();
        this.mType = 5;
        this.mCustom = new HashMap();
    }

    private void fireCustom(String object, MotionWidget motionWidget) {
        boolean bl = ((String)object).length() == 1;
        String string2 = object;
        if (!bl) {
            string2 = ((String)object).substring(1).toLowerCase(Locale.ROOT);
        }
        for (String string3 : this.mCustom.keySet()) {
            Object object2 = string3.toLowerCase(Locale.ROOT);
            if (!bl && !((String)object2).matches(string2) || (object2 = (CustomVariable)this.mCustom.get(string3)) == null) continue;
            ((CustomVariable)object2).applyToWidget(motionWidget);
        }
    }

    @Override
    public void addValues(HashMap<String, SplineSet> hashMap) {
    }

    @Override
    public MotionKey clone() {
        return new MotionKeyTrigger().copy(this);
    }

    public void conditionallyFire(float f, MotionWidget motionWidget) {
    }

    @Override
    public MotionKeyTrigger copy(MotionKey motionKey) {
        super.copy(motionKey);
        motionKey = (MotionKeyTrigger)motionKey;
        this.mCurveFit = ((MotionKeyTrigger)motionKey).mCurveFit;
        this.mCross = ((MotionKeyTrigger)motionKey).mCross;
        this.mTriggerReceiver = ((MotionKeyTrigger)motionKey).mTriggerReceiver;
        this.mNegativeCross = ((MotionKeyTrigger)motionKey).mNegativeCross;
        this.mPositiveCross = ((MotionKeyTrigger)motionKey).mPositiveCross;
        this.mTriggerID = ((MotionKeyTrigger)motionKey).mTriggerID;
        this.mTriggerCollisionId = ((MotionKeyTrigger)motionKey).mTriggerCollisionId;
        this.mTriggerSlack = ((MotionKeyTrigger)motionKey).mTriggerSlack;
        this.mFireCrossReset = ((MotionKeyTrigger)motionKey).mFireCrossReset;
        this.mFireNegativeReset = ((MotionKeyTrigger)motionKey).mFireNegativeReset;
        this.mFirePositiveReset = ((MotionKeyTrigger)motionKey).mFirePositiveReset;
        this.mFireThreshold = ((MotionKeyTrigger)motionKey).mFireThreshold;
        this.mFireLastPos = ((MotionKeyTrigger)motionKey).mFireLastPos;
        this.mPostLayout = ((MotionKeyTrigger)motionKey).mPostLayout;
        this.mCollisionRect = ((MotionKeyTrigger)motionKey).mCollisionRect;
        this.mTargetRect = ((MotionKeyTrigger)motionKey).mTargetRect;
        return this;
    }

    @Override
    public void getAttributeNames(HashSet<String> hashSet) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getId(String string2) {
        int n;
        string2.hashCode();
        int n2 = -1;
        switch (string2.hashCode()) {
            case 1535404999: {
                if (!string2.equals(TRIGGER_RECEIVER)) break;
                n2 = 1;
                break;
            }
            case 1401391082: {
                if (!string2.equals(POST_LAYOUT)) break;
                n2 = 2;
                break;
            }
            case 1301930599: {
                if (!string2.equals(VIEW_TRANSITION_ON_CROSS)) break;
                n2 = 3;
                break;
            }
            case 364489912: {
                if (!string2.equals(TRIGGER_SLACK)) break;
                n2 = 4;
                break;
            }
            case -9754574: {
                if (!string2.equals(VIEW_TRANSITION_ON_NEGATIVE_CROSS)) break;
                n2 = 5;
                break;
            }
            case -76025313: {
                if (!string2.equals(TRIGGER_COLLISION_VIEW)) break;
                n2 = 6;
                break;
            }
            case -638126837: {
                if (!string2.equals(NEGATIVE_CROSS)) break;
                n2 = 7;
                break;
            }
            case -648752941: {
                if (!string2.equals(TRIGGER_ID)) break;
                n2 = 8;
                break;
            }
            case -786670827: {
                if (!string2.equals(TRIGGER_COLLISION_ID)) break;
                n2 = 9;
                break;
            }
            case -966421266: {
                if (!string2.equals(VIEW_TRANSITION_ON_POSITIVE_CROSS)) break;
                n2 = 10;
                break;
            }
            case -1594793529: {
                if (!string2.equals(POSITIVE_CROSS)) break;
                n2 = 11;
                break;
            }
        }
        switch (n2) {
            default: {
                n = -1;
                break;
            }
            case 1: {
                n = 10;
                break;
            }
            case 2: {
                n = 9;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 3;
                break;
            }
            case 9: {
                n = 2;
                break;
            }
            case 10: {
                n = 1;
                break;
            }
            case 11: {
                n = 0;
            }
        }
        switch (n) {
            default: {
                return -1;
            }
            case 10: {
                return 311;
            }
            case 9: {
                return 304;
            }
            case 8: {
                return 301;
            }
            case 7: {
                return 305;
            }
            case 6: {
                return 303;
            }
            case 5: {
                return 306;
            }
            case 4: {
                return 310;
            }
            case 3: {
                return 308;
            }
            case 2: {
                return 307;
            }
            case 1: {
                return 302;
            }
            case 0: 
        }
        return 309;
    }

    @Override
    public boolean setValue(int n, float f) {
        if (n != 305) {
            return super.setValue(n, f);
        }
        this.mTriggerSlack = f;
        return true;
    }

    @Override
    public boolean setValue(int n, int n2) {
        if (n != 307) {
            if (n != 308) {
                if (n != 311) {
                    switch (n) {
                        default: {
                            return super.setValue(n, n2);
                        }
                        case 303: {
                            this.mViewTransitionOnNegativeCross = n2;
                            break;
                        }
                        case 302: {
                            this.mViewTransitionOnPositiveCross = n2;
                            break;
                        }
                        case 301: {
                            this.mViewTransitionOnCross = n2;
                            break;
                        }
                    }
                } else {
                    this.mTriggerReceiver = n2;
                }
            } else {
                this.mTriggerID = this.toInt(n2);
            }
        } else {
            this.mTriggerCollisionId = n2;
        }
        return true;
    }

    @Override
    public boolean setValue(int n, String string2) {
        if (n != 309) {
            if (n != 310) {
                if (n != 312) {
                    return super.setValue(n, string2);
                }
                this.mCross = string2;
            } else {
                this.mNegativeCross = string2;
            }
        } else {
            this.mPositiveCross = string2;
        }
        return true;
    }

    @Override
    public boolean setValue(int n, boolean bl) {
        if (n != 304) {
            return super.setValue(n, bl);
        }
        this.mPostLayout = bl;
        return true;
    }
}

