/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;
import java.util.Arrays;

public class ArcCurveFit
extends CurveFit {
    public static final int ARC_START_FLIP = 3;
    public static final int ARC_START_HORIZONTAL = 2;
    public static final int ARC_START_LINEAR = 0;
    public static final int ARC_START_VERTICAL = 1;
    private static final int START_HORIZONTAL = 2;
    private static final int START_LINEAR = 3;
    private static final int START_VERTICAL = 1;
    Arc[] mArcs;
    private boolean mExtrapolate = true;
    private final double[] mTime;

    public ArcCurveFit(int[] nArray, double[] dArray, double[][] dArray2) {
        Arc[] arcArray;
        this.mTime = dArray;
        this.mArcs = new Arc[dArray.length - 1];
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        while (n < (arcArray = this.mArcs).length) {
            int n4 = nArray[n];
            if (n4 != 0) {
                if (n4 != 1) {
                    if (n4 != 2) {
                        if (n4 == 3) {
                            n2 = n2 == 1 ? 2 : 1;
                            n3 = n2;
                        }
                    } else {
                        n2 = 2;
                        n3 = 2;
                    }
                } else {
                    n2 = 1;
                    n3 = 1;
                }
            } else {
                n3 = 3;
            }
            double d = dArray[n];
            n4 = n + 1;
            arcArray[n] = new Arc(n3, d, dArray[n4], dArray2[n][0], dArray2[n][1], dArray2[n4][0], dArray2[n4][1]);
            n = n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double getPos(double d, int n) {
        int n2;
        Arc[] arcArray;
        double d2;
        boolean bl = this.mExtrapolate;
        int n3 = 0;
        if (bl) {
            double d3;
            if (d < this.mArcs[0].mTime1) {
                double d4;
                double d5 = this.mArcs[0].mTime1;
                d3 = d - this.mArcs[0].mTime1;
                if (this.mArcs[0].linear) {
                    if (n == 0) {
                        d2 = this.mArcs[0].getLinearX(d5);
                        d = this.mArcs[0].getLinearDX(d5);
                        return d2 + d3 * d;
                    }
                    d2 = this.mArcs[0].getLinearY(d5);
                    d = this.mArcs[0].getLinearDY(d5);
                    return d2 + d3 * d;
                }
                this.mArcs[0].setPoint(d5);
                if (n == 0) {
                    d4 = this.mArcs[0].getX();
                    d = this.mArcs[0].getDX();
                    return d4 + d3 * d;
                }
                d4 = this.mArcs[0].getY();
                d = this.mArcs[0].getDY();
                return d4 + d3 * d;
            }
            arcArray = this.mArcs;
            n2 = n3;
            d2 = d;
            if (d > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                double d6 = arcArray[arcArray.length - 1].mTime2;
                d3 = d - d6;
                arcArray = this.mArcs;
                n2 = arcArray.length - 1;
                if (n == 0) {
                    d2 = arcArray[n2].getLinearX(d6);
                    d = this.mArcs[n2].getLinearDX(d6);
                    return d2 + d3 * d;
                }
                d2 = arcArray[n2].getLinearY(d6);
                d = this.mArcs[n2].getLinearDY(d6);
                return d2 + d3 * d;
            }
        } else if (d < this.mArcs[0].mTime1) {
            d2 = this.mArcs[0].mTime1;
            n2 = n3;
        } else {
            arcArray = this.mArcs;
            n2 = n3;
            d2 = d;
            if (d > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                d2 = arcArray[arcArray.length - 1].mTime2;
                n2 = n3;
            }
        }
        while (n2 < (arcArray = this.mArcs).length) {
            if (d2 <= arcArray[n2].mTime2) {
                if (this.mArcs[n2].linear) {
                    if (n != 0) return this.mArcs[n2].getLinearY(d2);
                    return this.mArcs[n2].getLinearX(d2);
                }
                this.mArcs[n2].setPoint(d2);
                if (n != 0) return this.mArcs[n2].getY();
                return this.mArcs[n2].getX();
            }
            ++n2;
        }
        return Double.NaN;
    }

    @Override
    public void getPos(double d, double[] dArray) {
        double d2;
        Arc[] arcArray;
        if (this.mExtrapolate) {
            if (d < this.mArcs[0].mTime1) {
                double d3 = this.mArcs[0].mTime1;
                d -= this.mArcs[0].mTime1;
                if (this.mArcs[0].linear) {
                    dArray[0] = this.mArcs[0].getLinearX(d3) + this.mArcs[0].getLinearDX(d3) * d;
                    dArray[1] = this.mArcs[0].getLinearY(d3) + d * this.mArcs[0].getLinearDY(d3);
                } else {
                    this.mArcs[0].setPoint(d3);
                    dArray[0] = this.mArcs[0].getX() + this.mArcs[0].getDX() * d;
                    dArray[1] = this.mArcs[0].getY() + d * this.mArcs[0].getDY();
                }
                return;
            }
            arcArray = this.mArcs;
            d2 = d;
            if (d > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                double d4 = arcArray[arcArray.length - 1].mTime2;
                d2 = d - d4;
                arcArray = this.mArcs;
                int n = arcArray.length - 1;
                if (arcArray[n].linear) {
                    dArray[0] = this.mArcs[n].getLinearX(d4) + this.mArcs[n].getLinearDX(d4) * d2;
                    dArray[1] = this.mArcs[n].getLinearY(d4) + d2 * this.mArcs[n].getLinearDY(d4);
                } else {
                    this.mArcs[n].setPoint(d);
                    dArray[0] = this.mArcs[n].getX() + this.mArcs[n].getDX() * d2;
                    dArray[1] = this.mArcs[n].getY() + d2 * this.mArcs[n].getDY();
                }
                return;
            }
        } else {
            double d5 = d;
            if (d < this.mArcs[0].mTime1) {
                d5 = this.mArcs[0].mTime1;
            }
            arcArray = this.mArcs;
            d2 = d5;
            if (d5 > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                d2 = arcArray[arcArray.length - 1].mTime2;
            }
        }
        for (int i = 0; i < (arcArray = this.mArcs).length; ++i) {
            if (!(d2 <= arcArray[i].mTime2)) continue;
            if (this.mArcs[i].linear) {
                dArray[0] = this.mArcs[i].getLinearX(d2);
                dArray[1] = this.mArcs[i].getLinearY(d2);
                return;
            }
            this.mArcs[i].setPoint(d2);
            dArray[0] = this.mArcs[i].getX();
            dArray[1] = this.mArcs[i].getY();
            return;
        }
    }

    @Override
    public void getPos(double d, float[] fArray) {
        double d2;
        Arc[] arcArray;
        if (this.mExtrapolate) {
            if (d < this.mArcs[0].mTime1) {
                double d3 = this.mArcs[0].mTime1;
                d -= this.mArcs[0].mTime1;
                if (this.mArcs[0].linear) {
                    fArray[0] = (float)(this.mArcs[0].getLinearX(d3) + this.mArcs[0].getLinearDX(d3) * d);
                    fArray[1] = (float)(this.mArcs[0].getLinearY(d3) + d * this.mArcs[0].getLinearDY(d3));
                } else {
                    this.mArcs[0].setPoint(d3);
                    fArray[0] = (float)(this.mArcs[0].getX() + this.mArcs[0].getDX() * d);
                    fArray[1] = (float)(this.mArcs[0].getY() + d * this.mArcs[0].getDY());
                }
                return;
            }
            arcArray = this.mArcs;
            d2 = d;
            if (d > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                d2 = arcArray[arcArray.length - 1].mTime2;
                double d4 = d - d2;
                arcArray = this.mArcs;
                int n = arcArray.length - 1;
                if (arcArray[n].linear) {
                    fArray[0] = (float)(this.mArcs[n].getLinearX(d2) + this.mArcs[n].getLinearDX(d2) * d4);
                    fArray[1] = (float)(this.mArcs[n].getLinearY(d2) + d4 * this.mArcs[n].getLinearDY(d2));
                } else {
                    this.mArcs[n].setPoint(d);
                    fArray[0] = (float)this.mArcs[n].getX();
                    fArray[1] = (float)this.mArcs[n].getY();
                }
                return;
            }
        } else if (d < this.mArcs[0].mTime1) {
            d2 = this.mArcs[0].mTime1;
        } else {
            arcArray = this.mArcs;
            d2 = d;
            if (d > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                d2 = arcArray[arcArray.length - 1].mTime2;
            }
        }
        for (int i = 0; i < (arcArray = this.mArcs).length; ++i) {
            if (!(d2 <= arcArray[i].mTime2)) continue;
            if (this.mArcs[i].linear) {
                fArray[0] = (float)this.mArcs[i].getLinearX(d2);
                fArray[1] = (float)this.mArcs[i].getLinearY(d2);
                return;
            }
            this.mArcs[i].setPoint(d2);
            fArray[0] = (float)this.mArcs[i].getX();
            fArray[1] = (float)this.mArcs[i].getY();
            return;
        }
    }

    @Override
    public double getSlope(double d, int n) {
        Arc[] arcArray = this.mArcs;
        int n2 = 0;
        double d2 = d;
        if (d < arcArray[0].mTime1) {
            d2 = this.mArcs[0].mTime1;
        }
        arcArray = this.mArcs;
        int n3 = n2;
        d = d2;
        if (d2 > arcArray[arcArray.length - 1].mTime2) {
            arcArray = this.mArcs;
            d = arcArray[arcArray.length - 1].mTime2;
            n3 = n2;
        }
        while (n3 < (arcArray = this.mArcs).length) {
            if (d <= arcArray[n3].mTime2) {
                if (this.mArcs[n3].linear) {
                    if (n == 0) {
                        return this.mArcs[n3].getLinearDX(d);
                    }
                    return this.mArcs[n3].getLinearDY(d);
                }
                this.mArcs[n3].setPoint(d);
                if (n == 0) {
                    return this.mArcs[n3].getDX();
                }
                return this.mArcs[n3].getDY();
            }
            ++n3;
        }
        return Double.NaN;
    }

    @Override
    public void getSlope(double d, double[] dArray) {
        Arc[] arcArray;
        double d2;
        if (d < this.mArcs[0].mTime1) {
            d2 = this.mArcs[0].mTime1;
        } else {
            arcArray = this.mArcs;
            d2 = d;
            if (d > arcArray[arcArray.length - 1].mTime2) {
                arcArray = this.mArcs;
                d2 = arcArray[arcArray.length - 1].mTime2;
            }
        }
        for (int i = 0; i < (arcArray = this.mArcs).length; ++i) {
            if (!(d2 <= arcArray[i].mTime2)) continue;
            if (this.mArcs[i].linear) {
                dArray[0] = this.mArcs[i].getLinearDX(d2);
                dArray[1] = this.mArcs[i].getLinearDY(d2);
                return;
            }
            this.mArcs[i].setPoint(d2);
            dArray[0] = this.mArcs[i].getDX();
            dArray[1] = this.mArcs[i].getDY();
            return;
        }
    }

    @Override
    public double[] getTimePoints() {
        return this.mTime;
    }

    private static class Arc {
        private static final double EPSILON = 0.001;
        private static final String TAG = "Arc";
        private static double[] ourPercent = new double[91];
        boolean linear;
        double mArcDistance;
        double mArcVelocity;
        double mEllipseA;
        double mEllipseB;
        double mEllipseCenterX;
        double mEllipseCenterY;
        double[] mLut;
        double mOneOverDeltaTime;
        double mTime1;
        double mTime2;
        double mTmpCosAngle;
        double mTmpSinAngle;
        boolean mVertical;
        double mX1;
        double mX2;
        double mY1;
        double mY2;

        Arc(int n, double d, double d2, double d3, double d4, double d5, double d6) {
            boolean bl = false;
            this.linear = false;
            int n2 = 1;
            if (n == 1) {
                bl = true;
            }
            this.mVertical = bl;
            this.mTime1 = d;
            this.mTime2 = d2;
            this.mOneOverDeltaTime = 1.0 / (d2 - d);
            if (3 == n) {
                this.linear = true;
            }
            d = d5 - d3;
            d2 = d6 - d4;
            if (!(this.linear || Math.abs(d) < 0.001 || Math.abs(d2) < 0.001)) {
                this.mLut = new double[101];
                bl = this.mVertical;
                n = bl ? -1 : 1;
                this.mEllipseA = d * (double)n;
                n = bl ? n2 : -1;
                this.mEllipseB = d2 * (double)n;
                d = bl ? d5 : d3;
                this.mEllipseCenterX = d;
                d = bl ? d4 : d6;
                this.mEllipseCenterY = d;
                this.buildTable(d3, d4, d5, d6);
                this.mArcVelocity = this.mArcDistance * this.mOneOverDeltaTime;
                return;
            }
            this.linear = true;
            this.mX1 = d3;
            this.mX2 = d5;
            this.mY1 = d4;
            this.mY2 = d6;
            this.mArcDistance = d3 = Math.hypot(d2, d);
            this.mArcVelocity = d3 * this.mOneOverDeltaTime;
            d3 = this.mTime2;
            d4 = this.mTime1;
            this.mEllipseCenterX = d / (d3 - d4);
            this.mEllipseCenterY = d2 / (d3 - d4);
        }

        private void buildTable(double d, double d2, double d3, double d4) {
            double[] dArray;
            int n;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            for (n = 0; n < (dArray = ourPercent).length; ++n) {
                double d8 = Math.toRadians((double)n * 90.0 / (double)(dArray.length - 1));
                double d9 = Math.sin(d8);
                d8 = Math.cos(d8);
                d9 *= d3 - d;
                d8 *= d2 - d4;
                if (n > 0) {
                    Arc.ourPercent[n] = d5 = Math.hypot(d9 - d6, d8 - d7) + d5;
                }
                d7 = d8;
                d6 = d9;
            }
            this.mArcDistance = d5;
            for (n = 0; n < (dArray = ourPercent).length; ++n) {
                dArray[n] = dArray[n] / d5;
            }
            for (n = 0; n < (dArray = this.mLut).length; ++n) {
                d2 = (double)n / (double)(dArray.length - 1);
                int n2 = Arrays.binarySearch(ourPercent, d2);
                if (n2 >= 0) {
                    this.mLut[n] = (double)n2 / (double)(ourPercent.length - 1);
                    continue;
                }
                if (n2 == -1) {
                    this.mLut[n] = 0.0;
                    continue;
                }
                int n3 = -n2;
                n2 = n3 - 2;
                d = n2;
                dArray = ourPercent;
                this.mLut[n] = d = (d + (d2 - dArray[n2]) / (dArray[n3 - 1] - dArray[n2])) / (double)(dArray.length - 1);
            }
        }

        double getDX() {
            double d = this.mEllipseA * this.mTmpCosAngle;
            double d2 = -this.mEllipseB;
            double d3 = this.mTmpSinAngle;
            d3 = this.mArcVelocity / Math.hypot(d, d2 * d3);
            d2 = d;
            if (this.mVertical) {
                d2 = -d;
            }
            return d2 * d3;
        }

        double getDY() {
            double d = this.mEllipseA;
            double d2 = this.mTmpCosAngle;
            double d3 = -this.mEllipseB * this.mTmpSinAngle;
            d = this.mArcVelocity / Math.hypot(d * d2, d3);
            d3 = this.mVertical ? -d3 * d : (d3 *= d);
            return d3;
        }

        public double getLinearDX(double d) {
            return this.mEllipseCenterX;
        }

        public double getLinearDY(double d) {
            return this.mEllipseCenterY;
        }

        public double getLinearX(double d) {
            double d2 = this.mTime1;
            double d3 = this.mOneOverDeltaTime;
            double d4 = this.mX1;
            return d4 + (d - d2) * d3 * (this.mX2 - d4);
        }

        public double getLinearY(double d) {
            double d2 = this.mTime1;
            double d3 = this.mOneOverDeltaTime;
            double d4 = this.mY1;
            return d4 + (d - d2) * d3 * (this.mY2 - d4);
        }

        double getX() {
            return this.mEllipseCenterX + this.mEllipseA * this.mTmpSinAngle;
        }

        double getY() {
            return this.mEllipseCenterY + this.mEllipseB * this.mTmpCosAngle;
        }

        double lookup(double d) {
            if (d <= 0.0) {
                return 0.0;
            }
            if (d >= 1.0) {
                return 1.0;
            }
            double[] dArray = this.mLut;
            double d2 = d * (double)(dArray.length - 1);
            int n = (int)d2;
            d = n;
            return dArray[n] + (d2 - d) * (dArray[n + 1] - dArray[n]);
        }

        void setPoint(double d) {
            d = this.mVertical ? this.mTime2 - d : (d -= this.mTime1);
            d = this.lookup(d * this.mOneOverDeltaTime) * 1.5707963267948966;
            this.mTmpSinAngle = Math.sin(d);
            this.mTmpCosAngle = Math.cos(d);
        }
    }
}

