/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

public class HyperSpline {
    double[][] mCtl;
    Cubic[][] mCurve;
    double[] mCurveLength;
    int mDimensionality;
    int mPoints;
    double mTotalLength;

    public HyperSpline() {
    }

    public HyperSpline(double[][] dArray) {
        this.setup(dArray);
    }

    static Cubic[] calcNaturalCubic(int n, double[] dArray) {
        double d;
        Object[] objectArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = n - 1;
        int n3 = 0;
        objectArray[0] = 0.5;
        int n4 = 1;
        for (n = 1; n < n2; ++n) {
            objectArray[n] = 1.0 / (4.0 - objectArray[n - 1]);
        }
        int n5 = n2 - 1;
        objectArray[n2] = 1.0 / (2.0 - objectArray[n5]);
        dArray2[0] = (dArray[1] - dArray[0]) * 3.0 * objectArray[0];
        n = n4;
        while (n < n2) {
            n4 = n + 1;
            d = dArray[n4];
            int n6 = n - 1;
            dArray2[n] = ((d - dArray[n6]) * 3.0 - dArray2[n6]) * objectArray[n];
            n = n4;
        }
        dArray2[n2] = ((dArray[n2] - dArray[n5]) * 3.0 - dArray2[n5]) * objectArray[n2];
        dArray3[n2] = dArray2[n2];
        for (n = n5; n >= 0; --n) {
            dArray3[n] = dArray2[n] - objectArray[n] * dArray3[n + 1];
        }
        objectArray = new Cubic[n2];
        n = n3;
        while (n < n2) {
            double d2 = (float)dArray[n];
            d = dArray3[n];
            n3 = n + 1;
            objectArray[n] = (double)new Cubic(d2, d, (dArray[n3] - dArray[n]) * 3.0 - dArray3[n] * 2.0 - dArray3[n3], (dArray[n] - dArray[n3]) * 2.0 + dArray3[n] + dArray3[n3]);
            n = n3;
        }
        return objectArray;
    }

    public double approxLength(Cubic[] cubicArray) {
        double d;
        double d2;
        double d3;
        int n = cubicArray.length;
        double[] dArray = new double[cubicArray.length];
        double d4 = 0.0;
        double d5 = d3 = 0.0;
        while (true) {
            int n2 = 0;
            d2 = d4;
            if (!(d3 < 1.0)) break;
            d2 = 0.0;
            for (n = n2; n < cubicArray.length; ++n) {
                double d6;
                d = dArray[n];
                dArray[n] = d6 = cubicArray[n].eval(d3);
                d2 += (d -= d6) * d;
            }
            d = d5;
            if (d3 > 0.0) {
                d = d5 + Math.sqrt(d2);
            }
            d3 += 0.1;
            d5 = d;
        }
        for (n = 0; n < cubicArray.length; ++n) {
            d = dArray[n];
            dArray[n] = d3 = cubicArray[n].eval(1.0);
            d3 = d - d3;
            d2 += d3 * d3;
        }
        return d5 + Math.sqrt(d2);
    }

    public double getPos(double d, int n) {
        int n2;
        double[] dArray;
        d *= this.mTotalLength;
        for (n2 = 0; n2 < (dArray = this.mCurveLength).length - 1 && dArray[n2] < d; d -= dArray[n2], ++n2) {
        }
        return this.mCurve[n][n2].eval(d / dArray[n2]);
    }

    public void getPos(double d, double[] dArray) {
        int n;
        d *= this.mTotalLength;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            double[] dArray2 = this.mCurveLength;
            n = n2;
            if (n3 >= dArray2.length - 1) break;
            n = n2;
            if (!(dArray2[n3] < d)) break;
            d -= dArray2[n3];
            ++n3;
        }
        while (n < dArray.length) {
            dArray[n] = this.mCurve[n][n3].eval(d / this.mCurveLength[n3]);
            ++n;
        }
    }

    public void getPos(double d, float[] fArray) {
        int n;
        d *= this.mTotalLength;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            double[] dArray = this.mCurveLength;
            n = n2;
            if (n3 >= dArray.length - 1) break;
            n = n2;
            if (!(dArray[n3] < d)) break;
            d -= dArray[n3];
            ++n3;
        }
        while (n < fArray.length) {
            fArray[n] = (float)this.mCurve[n][n3].eval(d / this.mCurveLength[n3]);
            ++n;
        }
    }

    public void getVelocity(double d, double[] dArray) {
        int n;
        d *= this.mTotalLength;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            double[] dArray2 = this.mCurveLength;
            n = n2;
            if (n3 >= dArray2.length - 1) break;
            n = n2;
            if (!(dArray2[n3] < d)) break;
            d -= dArray2[n3];
            ++n3;
        }
        while (n < dArray.length) {
            dArray[n] = this.mCurve[n][n3].vel(d / this.mCurveLength[n3]);
            ++n;
        }
    }

    public void setup(double[][] object) {
        Cubic[][] cubicArray;
        int n;
        int n2;
        this.mDimensionality = n2 = object[0].length;
        this.mPoints = n = ((double[][])object).length;
        this.mCtl = new double[n2][n];
        this.mCurve = new Cubic[this.mDimensionality][];
        for (n = 0; n < this.mDimensionality; ++n) {
            for (n2 = 0; n2 < this.mPoints; ++n2) {
                this.mCtl[n][n2] = object[n2][n];
            }
        }
        for (n = 0; n < (n2 = this.mDimensionality); ++n) {
            cubicArray = this.mCurve;
            object = this.mCtl;
            cubicArray[n] = HyperSpline.calcNaturalCubic(object[n].length, object[n]);
        }
        this.mCurveLength = new double[this.mPoints - 1];
        this.mTotalLength = 0.0;
        cubicArray = new Cubic[n2];
        for (n = 0; n < this.mCurveLength.length; ++n) {
            for (n2 = 0; n2 < this.mDimensionality; ++n2) {
                cubicArray[n2] = this.mCurve[n2][n];
            }
            double d = this.mTotalLength;
            object = this.mCurveLength;
            double d2 = this.approxLength((Cubic[])cubicArray);
            object[n] = (double[])d2;
            this.mTotalLength = d + d2;
        }
    }

    public static class Cubic {
        double mA;
        double mB;
        double mC;
        double mD;

        public Cubic(double d, double d2, double d3, double d4) {
            this.mA = d;
            this.mB = d2;
            this.mC = d3;
            this.mD = d4;
        }

        public double eval(double d) {
            return ((this.mD * d + this.mC) * d + this.mB) * d + this.mA;
        }

        public double vel(double d) {
            return (this.mD * 3.0 * d + this.mC * 2.0) * d + this.mB;
        }
    }
}

