/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.Oscillator;
import androidx.constraintlayout.core.motion.utils.TypedValues$CycleType$_CC;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public abstract class KeyCycleOscillator {
    private static final String TAG = "KeyCycleOscillator";
    private CurveFit mCurveFit;
    private CycleOscillator mCycleOscillator;
    private String mType;
    public int mVariesBy = 0;
    ArrayList<WavePoint> mWavePoints = new ArrayList();
    private int mWaveShape = 0;
    private String mWaveString = null;

    public static KeyCycleOscillator makeWidgetCycle(String string2) {
        if (string2.equals("pathRotate")) {
            return new PathRotateSet(string2);
        }
        return new CoreSpline(string2);
    }

    public float get(float f) {
        return (float)this.mCycleOscillator.getValues(f);
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    public float getSlope(float f) {
        return (float)this.mCycleOscillator.getSlope(f);
    }

    protected void setCustom(Object object) {
    }

    public void setPoint(int n, int n2, String string2, int n3, float f, float f2, float f3, float f4) {
        this.mWavePoints.add(new WavePoint(n, f, f2, f3, f4));
        if (n3 != -1) {
            this.mVariesBy = n3;
        }
        this.mWaveShape = n2;
        this.mWaveString = string2;
    }

    public void setPoint(int n, int n2, String string2, int n3, float f, float f2, float f3, float f4, Object object) {
        this.mWavePoints.add(new WavePoint(n, f, f2, f3, f4));
        if (n3 != -1) {
            this.mVariesBy = n3;
        }
        this.mWaveShape = n2;
        this.setCustom(object);
        this.mWaveString = string2;
    }

    public void setProperty(MotionWidget motionWidget, float f) {
    }

    public void setType(String string2) {
        this.mType = string2;
    }

    public void setup(float f) {
        int n = this.mWavePoints.size();
        if (n == 0) {
            return;
        }
        Collections.sort(this.mWavePoints, new Comparator<WavePoint>(){

            @Override
            public int compare(WavePoint wavePoint, WavePoint wavePoint2) {
                return Integer.compare(wavePoint.mPosition, wavePoint2.mPosition);
            }
        });
        double[] dArray = new double[n];
        double[][] dArray2 = new double[n][3];
        this.mCycleOscillator = new CycleOscillator(this.mWaveShape, this.mWaveString, this.mVariesBy, n);
        Iterator<WavePoint> iterator = this.mWavePoints.iterator();
        n = 0;
        while (iterator.hasNext()) {
            WavePoint wavePoint = iterator.next();
            dArray[n] = (double)wavePoint.mPeriod * 0.01;
            dArray2[n][0] = wavePoint.mValue;
            dArray2[n][1] = wavePoint.mOffset;
            dArray2[n][2] = wavePoint.mPhase;
            this.mCycleOscillator.setPoint(n, wavePoint.mPosition, wavePoint.mPeriod, wavePoint.mOffset, wavePoint.mPhase, wavePoint.mValue);
            ++n;
        }
        this.mCycleOscillator.setup(f);
        this.mCurveFit = CurveFit.get(0, dArray, dArray2);
    }

    public String toString() {
        String string2 = this.mType;
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        for (WavePoint wavePoint : this.mWavePoints) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("[");
            stringBuilder.append(wavePoint.mPosition);
            stringBuilder.append(" , ");
            stringBuilder.append(decimalFormat.format(wavePoint.mValue));
            stringBuilder.append("] ");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public boolean variesByPath() {
        int n = this.mVariesBy;
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        return bl;
    }

    private static class CoreSpline
    extends KeyCycleOscillator {
        String type;
        int typeId;

        public CoreSpline(String string2) {
            this.type = string2;
            this.typeId = TypedValues$CycleType$_CC.getId(string2);
        }

        @Override
        public void setProperty(MotionWidget motionWidget, float f) {
            motionWidget.setValue(this.typeId, this.get(f));
        }
    }

    static class CycleOscillator {
        private static final String TAG = "CycleOscillator";
        static final int UNSET = -1;
        private final int OFFST;
        private final int PHASE;
        private final int VALUE;
        CurveFit mCurveFit;
        float[] mOffset;
        Oscillator mOscillator;
        float mPathLength;
        float[] mPeriod;
        float[] mPhase;
        double[] mPosition;
        float[] mScale;
        double[] mSplineSlopeCache;
        double[] mSplineValueCache;
        float[] mValues;
        private final int mVariesBy;
        int mWaveShape;

        CycleOscillator(int n, String string2, int n2, int n3) {
            Oscillator oscillator;
            this.mOscillator = oscillator = new Oscillator();
            this.OFFST = 0;
            this.PHASE = 1;
            this.VALUE = 2;
            this.mWaveShape = n;
            this.mVariesBy = n2;
            oscillator.setType(n, string2);
            this.mValues = new float[n3];
            this.mPosition = new double[n3];
            this.mPeriod = new float[n3];
            this.mOffset = new float[n3];
            this.mPhase = new float[n3];
            this.mScale = new float[n3];
        }

        public double getLastPhase() {
            return this.mSplineValueCache[1];
        }

        public double getSlope(float f) {
            double d;
            Object object = this.mCurveFit;
            if (object != null) {
                d = f;
                ((CurveFit)object).getSlope(d, this.mSplineSlopeCache);
                this.mCurveFit.getPos(d, this.mSplineValueCache);
            } else {
                object = this.mSplineSlopeCache;
                object[0] = 0.0;
                object[1] = 0.0;
                object[2] = 0.0;
            }
            object = this.mOscillator;
            double d2 = f;
            d = ((Oscillator)object).getValue(d2, this.mSplineValueCache[1]);
            d2 = this.mOscillator.getSlope(d2, this.mSplineValueCache[1], this.mSplineSlopeCache[1]);
            object = this.mSplineSlopeCache;
            return (double)(object[0] + d * object[2] + d2 * this.mSplineValueCache[2]);
        }

        public double getValues(float f) {
            Object object = this.mCurveFit;
            if (object != null) {
                ((CurveFit)object).getPos((double)f, this.mSplineValueCache);
            } else {
                object = this.mSplineValueCache;
                object[0] = (double)this.mOffset[0];
                object[1] = (double)this.mPhase[0];
                object[2] = (double)this.mValues[0];
            }
            object = this.mSplineValueCache;
            Object object2 = object[0];
            Object object3 = object[1];
            return (double)(object2 + this.mOscillator.getValue(f, (double)object3) * this.mSplineValueCache[2]);
        }

        public void setPoint(int n, int n2, float f, float f2, float f3, float f4) {
            this.mPosition[n] = (double)n2 / 100.0;
            this.mPeriod[n] = f;
            this.mOffset[n] = f2;
            this.mPhase[n] = f3;
            this.mValues[n] = f4;
        }

        public void setup(float f) {
            int n;
            this.mPathLength = f;
            double[][] dArray = new double[this.mPosition.length][3];
            Object[] objectArray = this.mValues;
            this.mSplineValueCache = new double[objectArray.length + 2];
            this.mSplineSlopeCache = new double[objectArray.length + 2];
            if (this.mPosition[0] > 0.0) {
                this.mOscillator.addPoint(0.0, this.mPeriod[0]);
            }
            if ((objectArray = (Object[])this.mPosition)[n = objectArray.length - 1] < 1.0) {
                this.mOscillator.addPoint(1.0, this.mPeriod[n]);
            }
            for (n = 0; n < dArray.length; ++n) {
                dArray[n][0] = this.mOffset[n];
                dArray[n][1] = this.mPhase[n];
                dArray[n][2] = this.mValues[n];
                this.mOscillator.addPoint(this.mPosition[n], this.mPeriod[n]);
            }
            this.mOscillator.normalize();
            objectArray = this.mPosition;
            this.mCurveFit = objectArray.length > 1 ? CurveFit.get(0, objectArray, dArray) : null;
        }
    }

    private static class IntDoubleSort {
        private IntDoubleSort() {
        }

        private static int partition(int[] nArray, float[] fArray, int n, int n2) {
            int n3 = nArray[n2];
            int n4 = n;
            while (n < n2) {
                int n5 = n4;
                if (nArray[n] <= n3) {
                    IntDoubleSort.swap(nArray, fArray, n4, n);
                    n5 = n4 + 1;
                }
                ++n;
                n4 = n5;
            }
            IntDoubleSort.swap(nArray, fArray, n4, n2);
            return n4;
        }

        static void sort(int[] nArray, float[] fArray, int n, int n2) {
            int[] nArray2 = new int[nArray.length + 10];
            nArray2[0] = n2;
            nArray2[1] = n;
            n = 2;
            while (n > 0) {
                int n3 = nArray2[--n];
                n2 = n - 1;
                int n4 = nArray2[n2];
                n = n2;
                if (n3 >= n4) continue;
                int n5 = IntDoubleSort.partition(nArray, fArray, n3, n4);
                n = n2 + 1;
                nArray2[n2] = n5 - 1;
                n2 = n + 1;
                nArray2[n] = n3;
                n3 = n2 + 1;
                nArray2[n2] = n4;
                n = n3 + 1;
                nArray2[n3] = n5 + 1;
            }
        }

        private static void swap(int[] nArray, float[] fArray, int n, int n2) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
        }
    }

    private static class IntFloatFloatSort {
        private IntFloatFloatSort() {
        }

        private static int partition(int[] nArray, float[] fArray, float[] fArray2, int n, int n2) {
            int n3 = nArray[n2];
            int n4 = n;
            while (n < n2) {
                int n5 = n4;
                if (nArray[n] <= n3) {
                    IntFloatFloatSort.swap(nArray, fArray, fArray2, n4, n);
                    n5 = n4 + 1;
                }
                ++n;
                n4 = n5;
            }
            IntFloatFloatSort.swap(nArray, fArray, fArray2, n4, n2);
            return n4;
        }

        static void sort(int[] nArray, float[] fArray, float[] fArray2, int n, int n2) {
            int[] nArray2 = new int[nArray.length + 10];
            nArray2[0] = n2;
            nArray2[1] = n;
            n = 2;
            while (n > 0) {
                int n3 = nArray2[--n];
                n2 = n - 1;
                int n4 = nArray2[n2];
                n = n2;
                if (n3 >= n4) continue;
                int n5 = IntFloatFloatSort.partition(nArray, fArray, fArray2, n3, n4);
                n = n2 + 1;
                nArray2[n2] = n5 - 1;
                n2 = n + 1;
                nArray2[n] = n3;
                n3 = n2 + 1;
                nArray2[n2] = n4;
                n = n3 + 1;
                nArray2[n3] = n5 + 1;
            }
        }

        private static void swap(int[] nArray, float[] fArray, float[] fArray2, int n, int n2) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
            f = fArray2[n];
            fArray2[n] = fArray2[n2];
            fArray2[n2] = f;
        }
    }

    public static class PathRotateSet
    extends KeyCycleOscillator {
        String type;
        int typeId;

        public PathRotateSet(String string2) {
            this.type = string2;
            this.typeId = TypedValues$CycleType$_CC.getId(string2);
        }

        public void setPathRotate(MotionWidget motionWidget, float f, double d, double d2) {
            motionWidget.setRotationZ(this.get(f) + (float)Math.toDegrees(Math.atan2(d2, d)));
        }

        @Override
        public void setProperty(MotionWidget motionWidget, float f) {
            motionWidget.setValue(this.typeId, this.get(f));
        }
    }

    static class WavePoint {
        float mOffset;
        float mPeriod;
        float mPhase;
        int mPosition;
        float mValue;

        public WavePoint(int n, float f, float f2, float f3, float f4) {
            this.mPosition = n;
            this.mValue = f4;
            this.mOffset = f2;
            this.mPeriod = f;
            this.mPhase = f3;
        }
    }
}

