/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;

public class LinearCurveFit
extends CurveFit {
    private static final String TAG = "LinearCurveFit";
    private boolean mExtrapolate = true;
    double[] mSlopeTemp;
    private double[] mT;
    private double mTotalLength = Double.NaN;
    private double[][] mY;

    public LinearCurveFit(double[] dArray, double[][] dArray2) {
        int n = dArray.length;
        n = dArray2[0].length;
        this.mSlopeTemp = new double[n];
        this.mT = dArray;
        this.mY = dArray2;
        if (n > 2) {
            double d;
            double d2 = d = 0.0;
            for (n = 0; n < dArray.length; ++n) {
                double d3 = dArray2[n][0];
                double d4 = dArray2[n][0];
                if (n > 0) {
                    Math.hypot(d3 - d, d4 - d2);
                }
                d = d3;
                d2 = d4;
            }
            this.mTotalLength = 0.0;
        }
    }

    private double getLength2D(double d) {
        double d2;
        double d3;
        if (Double.isNaN(this.mTotalLength)) {
            return 0.0;
        }
        Object object = this.mT;
        int n = ((double[])object).length;
        if (d <= object[0]) {
            return 0.0;
        }
        int n2 = n - 1;
        if (d >= object[n2]) {
            return this.mTotalLength;
        }
        double d4 = d3 = (d2 = 0.0);
        n = 0;
        double d5 = d3;
        while (n < n2) {
            object = this.mY;
            void var14_11 = object[n][0];
            void var16_9 = object[n][1];
            d3 = d2;
            if (n > 0) {
                d3 = d2 + Math.hypot((double)(var14_11 - d5), (double)(var16_9 - d4));
            }
            if (d == (object = this.mT)[n]) {
                return d3;
            }
            int n3 = n + 1;
            if (d < object[n3]) {
                d5 = object[n3];
                d4 = object[n];
                d5 = (d - object[n]) / (d5 - d4);
                object = this.mY;
                d2 = object[n][0];
                d4 = object[n3][0];
                d = object[n][1];
                void var19_12 = object[n3][1];
                double d6 = 1.0 - d5;
                return d3 + Math.hypot((double)(var16_9 - (d * d6 + var19_12 * d5)), (double)(var14_11 - (d2 * d6 + d4 * d5)));
            }
            n = n3;
            d5 = var14_11;
            d4 = var16_9;
            d2 = d3;
        }
        return 0.0;
    }

    @Override
    public double getPos(double d, int n) {
        int n2;
        Object object = this.mT;
        int n3 = ((double[])object).length;
        boolean bl = this.mExtrapolate;
        int n4 = 0;
        if (bl) {
            if (d <= object[0]) {
                return this.mY[0][n] + (d - object[0]) * this.getSlope(object[0], n);
            }
            n2 = n3 - 1;
            if (d >= object[n2]) {
                return this.mY[n2][n] + (d - object[n2]) * this.getSlope(object[n2], n);
            }
        } else {
            if (d <= object[0]) {
                return this.mY[0][n];
            }
            n2 = n3 - 1;
            if (d >= object[n2]) {
                return this.mY[n2][n];
            }
        }
        while (n4 < n3 - 1) {
            object = this.mT;
            if (d == object[n4]) {
                return this.mY[n4][n];
            }
            n2 = n4 + 1;
            if (d < object[n2]) {
                double d2 = object[n2];
                double d3 = object[n4];
                d = (d - object[n4]) / (d2 - d3);
                object = this.mY;
                return (double)(object[n4][n] * (1.0 - d) + object[n2][n] * d);
            }
            n4 = n2;
        }
        return 0.0;
    }

    @Override
    public void getPos(double d, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = this.mT;
        int n3 = dArray2.length;
        Object object = this.mY;
        int n4 = 0;
        int n5 = 0;
        int n6 = object[0].length;
        if (this.mExtrapolate) {
            if (d <= dArray2[0]) {
                this.getSlope(dArray2[0], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[0][n2] + (d - this.mT[0]) * this.mSlopeTemp[n2];
                }
                return;
            }
            n4 = n3 - 1;
            if (d >= dArray2[n4]) {
                this.getSlope(dArray2[n4], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[n4][n2] + (d - this.mT[n4]) * this.mSlopeTemp[n2];
                }
                return;
            }
        } else {
            if (d <= dArray2[0]) {
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[0][n2];
                }
                return;
            }
            n = n3 - 1;
            if (d >= dArray2[n]) {
                for (n2 = n4; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[n][n2];
                }
                return;
            }
        }
        n2 = 0;
        while (n2 < n3 - 1) {
            if (d == this.mT[n2]) {
                for (n4 = 0; n4 < n6; ++n4) {
                    dArray[n4] = this.mY[n2][n4];
                }
            }
            if (d < (object = (Object)this.mT)[n = n2 + 1]) {
                double[] dArray3 = object[n];
                double[] dArray4 = object[n2];
                d = (d - object[n2]) / (dArray3 - dArray4);
                for (n4 = n5; n4 < n6; ++n4) {
                    object = this.mY;
                    dArray[n4] = object[n2][n4] * (1.0 - d) + object[n][n4] * d;
                }
                return;
            }
            n2 = n;
        }
    }

    @Override
    public void getPos(double d, float[] fArray) {
        int n;
        int n2;
        double[] dArray = this.mT;
        int n3 = dArray.length;
        Object object = this.mY;
        int n4 = 0;
        int n5 = 0;
        int n6 = object[0].length;
        if (this.mExtrapolate) {
            if (d <= dArray[0]) {
                this.getSlope(dArray[0], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    fArray[n2] = (float)(this.mY[0][n2] + (d - this.mT[0]) * this.mSlopeTemp[n2]);
                }
                return;
            }
            n4 = n3 - 1;
            if (d >= dArray[n4]) {
                this.getSlope(dArray[n4], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    fArray[n2] = (float)(this.mY[n4][n2] + (d - this.mT[n4]) * this.mSlopeTemp[n2]);
                }
                return;
            }
        } else {
            if (d <= dArray[0]) {
                for (n2 = 0; n2 < n6; ++n2) {
                    fArray[n2] = (float)this.mY[0][n2];
                }
                return;
            }
            n = n3 - 1;
            if (d >= dArray[n]) {
                for (n2 = n4; n2 < n6; ++n2) {
                    fArray[n2] = (float)this.mY[n][n2];
                }
                return;
            }
        }
        n2 = 0;
        while (n2 < n3 - 1) {
            if (d == this.mT[n2]) {
                for (n4 = 0; n4 < n6; ++n4) {
                    fArray[n4] = (float)this.mY[n2][n4];
                }
            }
            if (d < (object = (Object)this.mT)[n = n2 + 1]) {
                double[] dArray2 = object[n];
                double[] dArray3 = object[n2];
                d = (d - object[n2]) / (dArray2 - dArray3);
                for (n4 = n5; n4 < n6; ++n4) {
                    object = this.mY;
                    fArray[n4] = (float)(object[n2][n4] * (1.0 - d) + object[n][n4] * d);
                }
                return;
            }
            n2 = n;
        }
    }

    @Override
    public double getSlope(double d, int n) {
        int n2;
        double d2;
        Object object = this.mT;
        int n3 = ((double[])object).length;
        int n4 = 0;
        if (d < object[0]) {
            d2 = object[0];
            n2 = n4;
        } else {
            int n5 = n3 - 1;
            n2 = n4;
            d2 = d;
            if (d >= object[n5]) {
                d2 = object[n5];
                n2 = n4;
            }
        }
        while (n2 < n3 - 1) {
            object = this.mT;
            n4 = n2 + 1;
            if (d2 <= object[n4]) {
                d2 = object[n4];
                d = object[n2];
                double d3 = object[n2];
                object = this.mY;
                d3 = object[n2][n];
                return (double)((object[n4][n] - d3) / (d2 - d));
            }
            n2 = n4;
        }
        return 0.0;
    }

    @Override
    public void getSlope(double object, double[] dArray) {
        int n;
        Object object2;
        double[] dArray2 = this.mT;
        int n2 = dArray2.length;
        Object object3 = this.mY;
        int n3 = 0;
        int n4 = object3[0].length;
        if (object <= dArray2[0]) {
            object2 = dArray2[0];
        } else {
            n = n2 - 1;
            object2 = object;
            if (object >= dArray2[n]) {
                object2 = dArray2[n];
            }
        }
        n = 0;
        while (n < n2 - 1) {
            object3 = this.mT;
            int n5 = n + 1;
            if (object2 <= object3[n5]) {
                object = object3[n5];
                object2 = object3[n];
                Object object4 = object3[n];
                while (n3 < n4) {
                    object3 = this.mY;
                    object4 = object3[n][n3];
                    dArray[n3] = (object3[n5][n3] - object4) / (object - object2);
                    ++n3;
                }
                break;
            }
            n = n5;
        }
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }
}

