/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.CurveFit;
import java.util.Arrays;

public class MonotonicCurveFit
extends CurveFit {
    private static final String TAG = "MonotonicCurveFit";
    private boolean mExtrapolate = true;
    double[] mSlopeTemp;
    private double[] mT;
    private double[][] mTangent;
    private double[][] mY;

    public MonotonicCurveFit(double[] dArray, double[][] dArray2) {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray2[0].length;
        this.mSlopeTemp = new double[n5];
        int n6 = n4 - 1;
        double[][] dArray3 = new double[n6][n5];
        double[][] dArray4 = new double[n4][n5];
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = 0;
            while (n2 < n6) {
                n = n2 + 1;
                d2 = dArray[n];
                d = dArray[n2];
                dArray3[n2][n3] = (dArray2[n][n3] - dArray2[n2][n3]) / (d2 - d);
                dArray4[n2][n3] = n2 == 0 ? dArray3[n2][n3] : (dArray3[n2 - 1][n3] + dArray3[n2][n3]) * 0.5;
                n2 = n;
            }
            dArray4[n6][n3] = dArray3[n4 - 2][n3];
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (dArray3[n3][n2] == 0.0) {
                    dArray4[n3][n2] = 0.0;
                    dArray4[n3 + 1][n2] = 0.0;
                    continue;
                }
                d = dArray4[n3][n2] / dArray3[n3][n2];
                n = n3 + 1;
                d2 = dArray4[n][n2] / dArray3[n3][n2];
                double d3 = Math.hypot(d, d2);
                if (!(d3 > 9.0)) continue;
                d3 = 3.0 / d3;
                dArray4[n3][n2] = d * d3 * dArray3[n3][n2];
                dArray4[n][n2] = d3 * d2 * dArray3[n3][n2];
            }
        }
        this.mT = dArray;
        this.mY = dArray2;
        this.mTangent = dArray4;
    }

    public static MonotonicCurveFit buildWave(String string2) {
        double[] dArray = new double[string2.length() / 2];
        int n = string2.indexOf(40) + 1;
        int n2 = string2.indexOf(44, n);
        int n3 = 0;
        while (n2 != -1) {
            dArray[n3] = Double.parseDouble(string2.substring(n, n2).trim());
            n = n2 + 1;
            n2 = string2.indexOf(44, n);
            ++n3;
        }
        dArray[n3] = Double.parseDouble(string2.substring(n, string2.indexOf(41, n)).trim());
        return MonotonicCurveFit.buildWave(Arrays.copyOf(dArray, n3 + 1));
    }

    private static MonotonicCurveFit buildWave(double[] dArray) {
        int n = dArray.length * 3 - 2;
        int n2 = dArray.length - 1;
        double d = 1.0 / (double)n2;
        double[][] dArray2 = new double[n][1];
        double[] dArray3 = new double[n];
        for (n = 0; n < dArray.length; ++n) {
            double d2;
            double d3 = dArray[n];
            int n3 = n + n2;
            dArray2[n3][0] = d3;
            dArray3[n3] = d2 = (double)n * d;
            if (n <= 0) continue;
            n3 = n2 * 2 + n;
            dArray2[n3][0] = d3 + 1.0;
            dArray3[n3] = d2 + 1.0;
            n3 = n - 1;
            dArray2[n3][0] = d3 - 1.0 - d;
            dArray3[n3] = d2 - 1.0 - d;
        }
        return new MonotonicCurveFit(dArray3, dArray2);
    }

    private static double diff(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 * d2;
        double d8 = d2 * 6.0;
        double d9 = 3.0 * d;
        return -6.0 * d7 * d4 + d8 * d4 + 6.0 * d7 * d3 - d8 * d3 + d9 * d6 * d7 + d9 * d5 * d7 - 2.0 * d * d6 * d2 - 4.0 * d * d5 * d2 + d * d5;
    }

    private static double interpolate(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 * d2;
        double d8 = d7 * d2;
        double d9 = 3.0 * d7;
        double d10 = d * d6;
        d6 = d * d5;
        return -2.0 * d8 * d4 + d9 * d4 + d8 * 2.0 * d3 - d9 * d3 + d3 + d10 * d8 + d8 * d6 - d10 * d7 - d * 2.0 * d5 * d7 + d6 * d2;
    }

    @Override
    public double getPos(double d, int n) {
        int n2;
        Object object = this.mT;
        int n3 = ((double[])object).length;
        boolean bl = this.mExtrapolate;
        int n4 = 0;
        if (bl) {
            if (d <= object[0]) {
                return this.mY[0][n] + (d - object[0]) * this.getSlope(object[0], n);
            }
            n2 = n3 - 1;
            if (d >= object[n2]) {
                return this.mY[n2][n] + (d - object[n2]) * this.getSlope(object[n2], n);
            }
        } else {
            if (d <= object[0]) {
                return this.mY[0][n];
            }
            n2 = n3 - 1;
            if (d >= object[n2]) {
                return this.mY[n2][n];
            }
        }
        while (n4 < n3 - 1) {
            object = this.mT;
            if (d == object[n4]) {
                return this.mY[n4][n];
            }
            n2 = n4 + 1;
            if (d < object[n2]) {
                double d2 = object[n2] - object[n4];
                double d3 = (d - object[n4]) / d2;
                object = this.mY;
                void var13_10 = object[n4][n];
                d = object[n2][n];
                object = this.mTangent;
                return MonotonicCurveFit.interpolate(d2, d3, (double)var13_10, d, (double)object[n4][n], (double)object[n2][n]);
            }
            n4 = n2;
        }
        return 0.0;
    }

    @Override
    public void getPos(double d, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = this.mT;
        int n3 = dArray2.length;
        Object object = this.mY;
        int n4 = 0;
        int n5 = 0;
        int n6 = object[0].length;
        if (this.mExtrapolate) {
            if (d <= dArray2[0]) {
                this.getSlope(dArray2[0], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[0][n2] + (d - this.mT[0]) * this.mSlopeTemp[n2];
                }
                return;
            }
            n4 = n3 - 1;
            if (d >= dArray2[n4]) {
                this.getSlope(dArray2[n4], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[n4][n2] + (d - this.mT[n4]) * this.mSlopeTemp[n2];
                }
                return;
            }
        } else {
            if (d <= dArray2[0]) {
                for (n2 = 0; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[0][n2];
                }
                return;
            }
            n = n3 - 1;
            if (d >= dArray2[n]) {
                for (n2 = n4; n2 < n6; ++n2) {
                    dArray[n2] = this.mY[n][n2];
                }
                return;
            }
        }
        n2 = 0;
        while (n2 < n3 - 1) {
            if (d == this.mT[n2]) {
                for (n4 = 0; n4 < n6; ++n4) {
                    dArray[n4] = this.mY[n2][n4];
                }
            }
            if (d < (object = (Object)this.mT)[n = n2 + 1]) {
                reference var12_11 = object[n] - object[n2];
                double d2 = (d - object[n2]) / var12_11;
                for (n4 = n5; n4 < n6; ++n4) {
                    object = this.mY;
                    double d3 = object[n2][n4];
                    d = object[n][n4];
                    object = this.mTangent;
                    dArray[n4] = MonotonicCurveFit.interpolate((double)var12_11, d2, d3, d, object[n2][n4], object[n][n4]);
                }
                return;
            }
            n2 = n;
        }
    }

    @Override
    public void getPos(double d, float[] fArray) {
        int n;
        int n2;
        Object object = this.mT;
        int n3 = ((double[])object).length;
        double[][] dArray = this.mY;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray[0].length;
        if (this.mExtrapolate) {
            if (d <= object[0]) {
                this.getSlope(object[0], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    fArray[n2] = (float)(this.mY[0][n2] + (d - this.mT[0]) * this.mSlopeTemp[n2]);
                }
                return;
            }
            n4 = n3 - 1;
            if (d >= object[n4]) {
                this.getSlope(object[n4], this.mSlopeTemp);
                for (n2 = 0; n2 < n6; ++n2) {
                    fArray[n2] = (float)(this.mY[n4][n2] + (d - this.mT[n4]) * this.mSlopeTemp[n2]);
                }
                return;
            }
        } else {
            if (d <= object[0]) {
                for (n2 = 0; n2 < n6; ++n2) {
                    fArray[n2] = (float)this.mY[0][n2];
                }
                return;
            }
            n = n3 - 1;
            if (d >= object[n]) {
                for (n2 = n4; n2 < n6; ++n2) {
                    fArray[n2] = (float)this.mY[n][n2];
                }
                return;
            }
        }
        n2 = 0;
        while (n2 < n3 - 1) {
            if (d == this.mT[n2]) {
                for (n4 = 0; n4 < n6; ++n4) {
                    fArray[n4] = (float)this.mY[n2][n4];
                }
            }
            if (d < (object = this.mT)[n = n2 + 1]) {
                double d2 = object[n] - object[n2];
                double d3 = (d - object[n2]) / d2;
                for (n4 = n5; n4 < n6; ++n4) {
                    object = this.mY;
                    void var16_13 = object[n2][n4];
                    d = object[n][n4];
                    object = this.mTangent;
                    fArray[n4] = (float)MonotonicCurveFit.interpolate(d2, d3, (double)var16_13, d, (double)object[n2][n4], (double)object[n][n4]);
                }
                return;
            }
            n2 = n;
        }
    }

    @Override
    public double getSlope(double d, int n) {
        int n2;
        Object object = this.mT;
        int n3 = ((double[])object).length;
        int n4 = 0;
        if (d < object[0]) {
            d = object[0];
        } else {
            n2 = n3 - 1;
            if (d >= object[n2]) {
                d = object[n2];
            }
        }
        while (n4 < n3 - 1) {
            object = this.mT;
            n2 = n4 + 1;
            if (d <= object[n2]) {
                double d2 = object[n2] - object[n4];
                d = (d - object[n4]) / d2;
                object = this.mY;
                void var10_8 = object[n4][n];
                void var12_9 = object[n2][n];
                object = this.mTangent;
                return MonotonicCurveFit.diff(d2, d, (double)var10_8, (double)var12_9, (double)object[n4][n], (double)object[n2][n]) / d2;
            }
            n4 = n2;
        }
        return 0.0;
    }

    @Override
    public void getSlope(double d, double[] dArray) {
        int n;
        double[] dArray2 = this.mT;
        int n2 = dArray2.length;
        Object object = this.mY;
        int n3 = 0;
        int n4 = object[0].length;
        if (d <= dArray2[0]) {
            d = dArray2[0];
        } else {
            n = n2 - 1;
            if (d >= dArray2[n]) {
                d = dArray2[n];
            }
        }
        n = 0;
        while (n < n2 - 1) {
            object = this.mT;
            int n5 = n + 1;
            if (d <= object[n5]) {
                reference var11_10 = object[n5] - object[n];
                double d2 = (d - object[n]) / var11_10;
                while (n3 < n4) {
                    object = this.mY;
                    d = object[n][n3];
                    double d3 = object[n5][n3];
                    object = this.mTangent;
                    dArray[n3] = MonotonicCurveFit.diff((double)var11_10, d2, d, d3, object[n][n3], object[n5][n3]) / var11_10;
                    ++n3;
                }
                break;
            }
            n = n5;
        }
    }

    @Override
    public double[] getTimePoints() {
        return this.mT;
    }
}

