/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.MonotonicCurveFit;
import java.util.Arrays;

public class Oscillator {
    public static final int BOUNCE = 6;
    public static final int COS_WAVE = 5;
    public static final int CUSTOM = 7;
    public static final int REVERSE_SAW_WAVE = 4;
    public static final int SAW_WAVE = 3;
    public static final int SIN_WAVE = 0;
    public static final int SQUARE_WAVE = 1;
    public static String TAG = "Oscillator";
    public static final int TRIANGLE_WAVE = 2;
    double PI2;
    double[] mArea;
    MonotonicCurveFit mCustomCurve;
    String mCustomType;
    private boolean mNormalized = false;
    float[] mPeriod = new float[0];
    double[] mPosition = new double[0];
    int mType;

    public Oscillator() {
        this.PI2 = Math.PI * 2;
    }

    public void addPoint(double d, float f) {
        int n;
        int n2 = this.mPeriod.length + 1;
        int n3 = n = Arrays.binarySearch(this.mPosition, d);
        if (n < 0) {
            n3 = -n - 1;
        }
        this.mPosition = Arrays.copyOf(this.mPosition, n2);
        this.mPeriod = Arrays.copyOf(this.mPeriod, n2);
        this.mArea = new double[n2];
        double[] dArray = this.mPosition;
        System.arraycopy(dArray, n3, dArray, n3 + 1, n2 - n3 - 1);
        this.mPosition[n3] = d;
        this.mPeriod[n3] = f;
        this.mNormalized = false;
    }

    double getDP(double d) {
        double d2;
        double d3 = 0.0;
        if (d <= 0.0) {
            d2 = 1.0E-5;
        } else {
            d2 = d;
            if (d >= 1.0) {
                d2 = 0.999999;
            }
        }
        int n = Arrays.binarySearch(this.mPosition, d2);
        if (n > 0) {
            return 0.0;
        }
        d = d3;
        if (n != 0) {
            n = -n - 1;
            float[] fArray = this.mPeriod;
            float f = fArray[n];
            int n2 = n - 1;
            d = f - fArray[n2];
            double[] dArray = this.mPosition;
            d /= dArray[n] - dArray[n2];
            d = (double)fArray[n2] - d * dArray[n2] + d2 * d;
        }
        return d;
    }

    double getP(double d) {
        double d2;
        double d3 = 1.0;
        if (d < 0.0) {
            d2 = 0.0;
        } else {
            d2 = d;
            if (d > 1.0) {
                d2 = 1.0;
            }
        }
        int n = Arrays.binarySearch(this.mPosition, d2);
        if (n > 0) {
            d = d3;
        } else if (n != 0) {
            int n2 = -n - 1;
            float[] fArray = this.mPeriod;
            float f = fArray[n2];
            n = n2 - 1;
            d = f - fArray[n];
            double[] dArray = this.mPosition;
            d /= dArray[n2] - dArray[n];
            d = this.mArea[n] + ((double)fArray[n] - dArray[n] * d) * (d2 - dArray[n]) + d * (d2 * d2 - dArray[n] * dArray[n]) / 2.0;
        } else {
            d = 0.0;
        }
        return d;
    }

    public double getSlope(double d, double d2, double d3) {
        d2 += this.getP(d);
        d = this.getDP(d) + d3;
        switch (this.mType) {
            default: {
                d3 = this.PI2;
                return d * d3 * Math.cos(d3 * d2);
            }
            case 7: {
                return this.mCustomCurve.getSlope(d2 % 1.0, 0);
            }
            case 6: {
                return d * 4.0 * ((d2 * 4.0 + 2.0) % 4.0 - 2.0);
            }
            case 5: {
                d3 = this.PI2;
                return -d3 * d * Math.sin(d3 * d2);
            }
            case 4: {
                return -d * 2.0;
            }
            case 3: {
                return d * 2.0;
            }
            case 2: {
                return d * 4.0 * Math.signum((d2 * 4.0 + 3.0) % 4.0 - 2.0);
            }
            case 1: 
        }
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getValue(double d, double d2) {
        d = this.getP(d) + d2;
        switch (this.mType) {
            default: {
                return Math.sin(this.PI2 * d);
            }
            case 7: {
                return this.mCustomCurve.getPos(d % 1.0, 0);
            }
            case 6: {
                d = 1.0 - Math.abs(d * 4.0 % 4.0 - 2.0);
                d *= d;
                return 1.0 - d;
            }
            case 5: {
                return Math.cos(this.PI2 * (d2 + d));
            }
            case 4: {
                d = (d * 2.0 + 1.0) % 2.0;
                return 1.0 - d;
            }
            case 3: {
                return (d * 2.0 + 1.0) % 2.0 - 1.0;
            }
            case 2: {
                d = Math.abs((d * 4.0 + 1.0) % 4.0 - 2.0);
                return 1.0 - d;
            }
            case 1: 
        }
        return Math.signum(0.5 - d % 1.0);
    }

    public void normalize() {
        float f;
        int n;
        Object[] objectArray;
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < (objectArray = this.mPeriod).length; ++n2) {
            d += (double)objectArray[n2];
        }
        double d2 = 0.0;
        for (n2 = 1; n2 < (objectArray = this.mPeriod).length; ++n2) {
            n = n2 - 1;
            f = (objectArray[n] + objectArray[n2]) / 2.0f;
            objectArray = this.mPosition;
            d2 += (objectArray[n2] - objectArray[n]) * (double)f;
        }
        for (n2 = 0; n2 < (objectArray = this.mPeriod).length; ++n2) {
            objectArray[n2] = (float)((double)objectArray[n2] * (d / d2));
        }
        this.mArea[0] = 0.0;
        for (n2 = 1; n2 < (objectArray = this.mPeriod).length; ++n2) {
            n = n2 - 1;
            f = (objectArray[n] + objectArray[n2]) / 2.0f;
            objectArray = this.mPosition;
            d2 = objectArray[n2];
            d = objectArray[n];
            objectArray = this.mArea;
            objectArray[n2] = objectArray[n] + (d2 - d) * (double)f;
        }
        this.mNormalized = true;
    }

    public void setType(int n, String string2) {
        this.mType = n;
        this.mCustomType = string2;
        if (string2 != null) {
            this.mCustomCurve = MonotonicCurveFit.buildWave(string2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("pos =");
        stringBuilder.append(Arrays.toString(this.mPosition));
        stringBuilder.append(" period=");
        stringBuilder.append(Arrays.toString(this.mPeriod));
        return stringBuilder.toString();
    }
}

