/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import androidx.constraintlayout.core.motion.utils.TypedValues$AttributesType$_CC;
import androidx.constraintlayout.core.state.WidgetFrame;
import java.text.DecimalFormat;
import java.util.Arrays;

public abstract class SplineSet {
    private static final String TAG = "SplineSet";
    private int count;
    protected CurveFit mCurveFit;
    protected int[] mTimePoints = new int[10];
    private String mType;
    protected float[] mValues = new float[10];

    public static SplineSet makeCustomSpline(String string2, KeyFrameArray.CustomArray customArray) {
        return new CustomSet(string2, customArray);
    }

    public static SplineSet makeCustomSplineSet(String string2, KeyFrameArray.CustomVar customVar) {
        return new CustomSpline(string2, customVar);
    }

    public static SplineSet makeSpline(String string2, long l) {
        return new CoreSpline(string2, l);
    }

    public float get(float f) {
        return (float)this.mCurveFit.getPos((double)f, 0);
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    public float getSlope(float f) {
        return (float)this.mCurveFit.getSlope((double)f, 0);
    }

    public void setPoint(int n, float f) {
        Object[] objectArray = this.mTimePoints;
        if (objectArray.length < this.count + 1) {
            this.mTimePoints = Arrays.copyOf(objectArray, objectArray.length * 2);
            objectArray = this.mValues;
            this.mValues = Arrays.copyOf((float[])objectArray, objectArray.length * 2);
        }
        objectArray = this.mTimePoints;
        int n2 = this.count;
        objectArray[n2] = n;
        this.mValues[n2] = f;
        this.count = n2 + 1;
    }

    public void setProperty(TypedValues typedValues, float f) {
        typedValues.setValue(TypedValues$AttributesType$_CC.getId(this.mType), this.get(f));
    }

    public void setType(String string2) {
        this.mType = string2;
    }

    public void setup(int n) {
        Object[] objectArray;
        int n2 = this.count;
        if (n2 == 0) {
            return;
        }
        Sort.doubleQuickSort(this.mTimePoints, this.mValues, 0, n2 - 1);
        int n3 = 1;
        for (n2 = 1; n2 < this.count; ++n2) {
            objectArray = this.mTimePoints;
            int n4 = n3;
            if (objectArray[n2 - 1] != objectArray[n2]) {
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        objectArray = new double[n3];
        double[][] dArray = new double[n3][1];
        n3 = 0;
        for (n2 = 0; n2 < this.count; ++n2) {
            int[] nArray;
            if (n2 > 0 && (nArray = this.mTimePoints)[n2] == nArray[n2 - 1]) continue;
            objectArray[n3] = (int)((double)this.mTimePoints[n2] * 0.01);
            dArray[n3][0] = this.mValues[n2];
            ++n3;
        }
        this.mCurveFit = CurveFit.get(n, objectArray, dArray);
    }

    public String toString() {
        String string2 = this.mType;
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        for (int i = 0; i < this.count; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("[");
            stringBuilder.append(this.mTimePoints[i]);
            stringBuilder.append(" , ");
            stringBuilder.append(decimalFormat.format(this.mValues[i]));
            stringBuilder.append("] ");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private static class CoreSpline
    extends SplineSet {
        long start;
        String type;

        public CoreSpline(String string2, long l) {
            this.type = string2;
            this.start = l;
        }

        @Override
        public void setProperty(TypedValues typedValues, float f) {
            typedValues.setValue(typedValues.getId(this.type), this.get(f));
        }
    }

    public static class CustomSet
    extends SplineSet {
        String mAttributeName;
        KeyFrameArray.CustomArray mConstraintAttributeList;
        float[] mTempValues;

        public CustomSet(String string2, KeyFrameArray.CustomArray customArray) {
            this.mAttributeName = string2.split(",")[1];
            this.mConstraintAttributeList = customArray;
        }

        @Override
        public void setPoint(int n, float f) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
        }

        public void setPoint(int n, CustomAttribute customAttribute) {
            this.mConstraintAttributeList.append(n, customAttribute);
        }

        public void setProperty(WidgetFrame widgetFrame, float f) {
            this.mCurveFit.getPos((double)f, this.mTempValues);
            widgetFrame.setCustomValue(this.mConstraintAttributeList.valueAt(0), this.mTempValues);
        }

        @Override
        public void setup(int n) {
            int n2 = this.mConstraintAttributeList.size();
            int n3 = this.mConstraintAttributeList.valueAt(0).numberOfInterpolatedValues();
            double[] dArray = new double[n2];
            this.mTempValues = new float[n3];
            double[][] dArray2 = new double[n2][n3];
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.mConstraintAttributeList.keyAt(n3);
                Object object = this.mConstraintAttributeList.valueAt(n3);
                dArray[n3] = (double)n4 * 0.01;
                ((CustomAttribute)object).getValuesToInterpolate(this.mTempValues);
                for (n4 = 0; n4 < ((Object)(object = (Object)this.mTempValues)).length; ++n4) {
                    dArray2[n3][n4] = (double)object[n4];
                }
            }
            this.mCurveFit = CurveFit.get(n, dArray, dArray2);
        }
    }

    public static class CustomSpline
    extends SplineSet {
        String mAttributeName;
        KeyFrameArray.CustomVar mConstraintAttributeList;
        float[] mTempValues;

        public CustomSpline(String string2, KeyFrameArray.CustomVar customVar) {
            this.mAttributeName = string2.split(",")[1];
            this.mConstraintAttributeList = customVar;
        }

        @Override
        public void setPoint(int n, float f) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
        }

        public void setPoint(int n, CustomVariable customVariable) {
            this.mConstraintAttributeList.append(n, customVariable);
        }

        public void setProperty(MotionWidget motionWidget, float f) {
            this.mCurveFit.getPos((double)f, this.mTempValues);
            this.mConstraintAttributeList.valueAt(0).setInterpolatedValue(motionWidget, this.mTempValues);
        }

        @Override
        public void setProperty(TypedValues typedValues, float f) {
            this.setProperty((MotionWidget)typedValues, f);
        }

        @Override
        public void setup(int n) {
            int n2 = this.mConstraintAttributeList.size();
            int n3 = this.mConstraintAttributeList.valueAt(0).numberOfInterpolatedValues();
            double[] dArray = new double[n2];
            this.mTempValues = new float[n3];
            double[][] dArray2 = new double[n2][n3];
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.mConstraintAttributeList.keyAt(n3);
                Object object = this.mConstraintAttributeList.valueAt(n3);
                dArray[n3] = (double)n4 * 0.01;
                ((CustomVariable)object).getValuesToInterpolate(this.mTempValues);
                for (n4 = 0; n4 < ((Object)(object = (Object)this.mTempValues)).length; ++n4) {
                    dArray2[n3][n4] = (double)object[n4];
                }
            }
            this.mCurveFit = CurveFit.get(n, dArray, dArray2);
        }
    }

    private static class Sort {
        private Sort() {
        }

        static void doubleQuickSort(int[] nArray, float[] fArray, int n, int n2) {
            int[] nArray2 = new int[nArray.length + 10];
            nArray2[0] = n2;
            nArray2[1] = n;
            n = 2;
            while (n > 0) {
                int n3 = nArray2[--n];
                n2 = n - 1;
                int n4 = nArray2[n2];
                n = n2;
                if (n3 >= n4) continue;
                int n5 = Sort.partition(nArray, fArray, n3, n4);
                n = n2 + 1;
                nArray2[n2] = n5 - 1;
                n2 = n + 1;
                nArray2[n] = n3;
                n3 = n2 + 1;
                nArray2[n2] = n4;
                n = n3 + 1;
                nArray2[n3] = n5 + 1;
            }
        }

        private static int partition(int[] nArray, float[] fArray, int n, int n2) {
            int n3 = nArray[n2];
            int n4 = n;
            while (n < n2) {
                int n5 = n4;
                if (nArray[n] <= n3) {
                    Sort.swap(nArray, fArray, n4, n);
                    n5 = n4 + 1;
                }
                ++n;
                n4 = n5;
            }
            Sort.swap(nArray, fArray, n4, n2);
            return n4;
        }

        private static void swap(int[] nArray, float[] fArray, int n, int n2) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
        }
    }
}

