/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.StopEngine;
import java.io.PrintStream;
import java.io.Serializable;

public class SpringStopEngine
implements StopEngine {
    private static final double UNSET = Double.MAX_VALUE;
    private int mBoundaryMode = 0;
    double mDamping = 0.5;
    private boolean mInitialized = false;
    private float mLastTime;
    private double mLastVelocity;
    private float mMass;
    private float mPos;
    private double mStiffness;
    private float mStopThreshold;
    private double mTargetPos;
    private float mV;

    private void compute(double d) {
        double d2 = this.mStiffness;
        double d3 = this.mDamping;
        int n = (int)(9.0 / (Math.sqrt(d2 / (double)this.mMass) * d * 4.0) + 1.0);
        double d4 = d / (double)n;
        d = d3;
        for (int i = 0; i < n; ++i) {
            float f = this.mPos;
            double d5 = f;
            d3 = this.mTargetPos;
            double d6 = -d2;
            float f2 = this.mV;
            double d7 = f2;
            float f3 = this.mMass;
            d6 = (d6 * (d5 - d3) - d7 * d) / (double)f3;
            d6 = (double)f2 + d6 * d4 / 2.0;
            d6 = (-((double)f + d4 * d6 / 2.0 - d3) * d2 - d6 * d) / (double)f3 * d4;
            d5 = f2;
            d3 = d6 / 2.0;
            this.mV = f2 = (float)((double)f2 + d6);
            this.mPos = f = (float)((double)f + (d5 + d3) * d4);
            int n2 = this.mBoundaryMode;
            if (n2 <= 0) continue;
            if (f < 0.0f && (n2 & 1) == 1) {
                this.mPos = -f;
                this.mV = -f2;
            }
            if (!((f = this.mPos) > 1.0f) || (n2 & 2) != 2) continue;
            this.mPos = 2.0f - f;
            this.mV = -this.mV;
        }
    }

    @Override
    public String debug(String string2, float f) {
        return null;
    }

    public float getAcceleration() {
        double d = this.mStiffness;
        double d2 = this.mDamping;
        double d3 = this.mPos;
        double d4 = this.mTargetPos;
        return (float)(-d * (d3 - d4) - d2 * (double)this.mV) / this.mMass;
    }

    @Override
    public float getInterpolation(float f) {
        this.compute(f - this.mLastTime);
        this.mLastTime = f;
        return this.mPos;
    }

    @Override
    public float getVelocity() {
        return 0.0f;
    }

    @Override
    public float getVelocity(float f) {
        return this.mV;
    }

    @Override
    public boolean isStopped() {
        double d = this.mV;
        double d2 = this.mStiffness;
        double d3 = (double)this.mPos - this.mTargetPos;
        boolean bl = Math.sqrt((d * d * (double)this.mMass + d2 * d3 * d3) / d2) <= (double)this.mStopThreshold;
        return bl;
    }

    void log(String string2) {
        Serializable serializable = new Throwable().getStackTrace()[1];
        Appendable appendable = new StringBuilder();
        ((StringBuilder)appendable).append(".(");
        ((StringBuilder)appendable).append(((StackTraceElement)serializable).getFileName());
        ((StringBuilder)appendable).append(":");
        ((StringBuilder)appendable).append(((StackTraceElement)serializable).getLineNumber());
        ((StringBuilder)appendable).append(") ");
        ((StringBuilder)appendable).append(((StackTraceElement)serializable).getMethodName());
        ((StringBuilder)appendable).append("() ");
        String string3 = ((StringBuilder)appendable).toString();
        appendable = System.out;
        serializable = new StringBuilder();
        ((StringBuilder)serializable).append(string3);
        ((StringBuilder)serializable).append(string2);
        ((PrintStream)appendable).println(((StringBuilder)serializable).toString());
    }

    public void springConfig(float f, float f2, float f3, float f4, float f5, float f6, float f7, int n) {
        this.mTargetPos = f2;
        this.mDamping = f6;
        this.mInitialized = false;
        this.mPos = f;
        this.mLastVelocity = f3;
        this.mStiffness = f5;
        this.mMass = f4;
        this.mStopThreshold = f7;
        this.mBoundaryMode = n;
        this.mLastTime = 0.0f;
    }
}

