/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.KeyFrameArray;
import java.io.PrintStream;
import java.text.DecimalFormat;

public abstract class TimeCycleSplineSet {
    protected static final int CURVE_OFFSET = 2;
    protected static final int CURVE_PERIOD = 1;
    protected static final int CURVE_VALUE = 0;
    private static final String TAG = "SplineSet";
    protected static float VAL_2PI = (float)Math.PI * 2;
    protected int count;
    protected float last_cycle;
    protected long last_time;
    protected float[] mCache;
    protected boolean mContinue = false;
    protected CurveFit mCurveFit;
    protected int[] mTimePoints = new int[10];
    protected String mType;
    protected float[][] mValues = new float[10][3];
    protected int mWaveShape = 0;

    public TimeCycleSplineSet() {
        this.mCache = new float[3];
        this.last_cycle = Float.NaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected float calcWave(float f) {
        switch (this.mWaveShape) {
            default: {
                return (float)Math.sin(f * VAL_2PI);
            }
            case 6: {
                f = 1.0f - Math.abs(f * 4.0f % 4.0f - 2.0f);
                f *= f;
                return 1.0f - f;
            }
            case 5: {
                return (float)Math.cos(f * VAL_2PI);
            }
            case 4: {
                f = (f * 2.0f + 1.0f) % 2.0f;
                return 1.0f - f;
            }
            case 3: {
                return (f * 2.0f + 1.0f) % 2.0f - 1.0f;
            }
            case 2: {
                f = Math.abs(f);
                return 1.0f - f;
            }
            case 1: 
        }
        return Math.signum(f * VAL_2PI);
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    public void setPoint(int n, float f, float f2, int n2, float f3) {
        Object object = this.mTimePoints;
        int n3 = this.count++;
        object[n3] = n;
        object = this.mValues;
        object[n3][0] = f;
        object[n3][1] = f2;
        object[n3][2] = f3;
        this.mWaveShape = Math.max(this.mWaveShape, n2);
    }

    protected void setStartTime(long l) {
        this.last_time = l;
    }

    public void setType(String string2) {
        this.mType = string2;
    }

    public void setup(int n) {
        Object object;
        int n2;
        int n3 = this.count;
        if (n3 == 0) {
            PrintStream printStream = System.err;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error no points added to ");
            stringBuilder.append(this.mType);
            printStream.println(stringBuilder.toString());
            return;
        }
        Sort.doubleQuickSort(this.mTimePoints, this.mValues, 0, n3 - 1);
        n3 = 0;
        for (n2 = 1; n2 < ((int[])(object = this.mTimePoints)).length; ++n2) {
            int n4 = n3;
            if (object[n2] != object[n2 - 1]) {
                n4 = n3 + 1;
            }
            n3 = n4;
        }
        n2 = n3;
        if (n3 == 0) {
            n2 = 1;
        }
        double[] dArray = new double[n2];
        object = new double[n2][3];
        n2 = 0;
        for (n3 = 0; n3 < this.count; ++n3) {
            Object object2;
            if (n3 > 0 && (object2 = this.mTimePoints)[n3] == object2[n3 - 1]) continue;
            dArray[n2] = (double)this.mTimePoints[n3] * 0.01;
            int n5 = object[n2];
            object2 = this.mValues;
            n5[0] = (double)object2[n3][0];
            object[n2][1] = (double)object2[n3][1];
            object[n2][2] = (double)object2[n3][2];
            ++n2;
        }
        this.mCurveFit = CurveFit.get(n, dArray, (double[][])object);
    }

    public String toString() {
        String string2 = this.mType;
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        for (int i = 0; i < this.count; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("[");
            stringBuilder.append(this.mTimePoints[i]);
            stringBuilder.append(" , ");
            stringBuilder.append(decimalFormat.format(this.mValues[i]));
            stringBuilder.append("] ");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static class CustomSet
    extends TimeCycleSplineSet {
        String mAttributeName;
        float[] mCache;
        KeyFrameArray.CustomArray mConstraintAttributeList;
        float[] mTempValues;
        KeyFrameArray.FloatArray mWaveProperties = new KeyFrameArray.FloatArray();

        public CustomSet(String string2, KeyFrameArray.CustomArray customArray) {
            this.mAttributeName = string2.split(",")[1];
            this.mConstraintAttributeList = customArray;
        }

        @Override
        public void setPoint(int n, float f, float f2, int n2, float f3) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public void setPoint(int n, CustomAttribute customAttribute, float f, int n2, float f2) {
            this.mConstraintAttributeList.append(n, customAttribute);
            this.mWaveProperties.append(n, new float[]{f, f2});
            this.mWaveShape = Math.max(this.mWaveShape, n2);
        }

        public boolean setProperty(MotionWidget motionWidget, float f, long l, KeyCache keyCache) {
            this.mCurveFit.getPos((double)f, this.mTempValues);
            float[] fArray = this.mTempValues;
            float f2 = fArray[fArray.length - 2];
            f = fArray[fArray.length - 1];
            long l2 = this.last_time;
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = keyCache.getFloatValue(motionWidget, this.mAttributeName, 0);
                if (Float.isNaN(this.last_cycle)) {
                    this.last_cycle = 0.0f;
                }
            }
            this.last_cycle = (float)(((double)this.last_cycle + (double)(l - l2) * 1.0E-9 * (double)f2) % 1.0);
            this.last_time = l;
            float f3 = this.calcWave(this.last_cycle);
            this.mContinue = false;
            for (int i = 0; i < this.mCache.length; ++i) {
                boolean bl = this.mContinue;
                boolean bl2 = (double)this.mTempValues[i] != 0.0;
                this.mContinue = bl | bl2;
                this.mCache[i] = this.mTempValues[i] * f3 + f;
            }
            motionWidget.setInterpolatedValue(this.mConstraintAttributeList.valueAt(0), this.mCache);
            if (f2 != 0.0f) {
                this.mContinue = true;
            }
            return this.mContinue;
        }

        @Override
        public void setup(int n) {
            int n2 = this.mConstraintAttributeList.size();
            int n3 = this.mConstraintAttributeList.valueAt(0).numberOfInterpolatedValues();
            double[] dArray = new double[n2];
            int n4 = n3 + 2;
            this.mTempValues = new float[n4];
            this.mCache = new float[n3];
            double[][] dArray2 = new double[n2][n4];
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = this.mConstraintAttributeList.keyAt(n4);
                Object object = this.mConstraintAttributeList.valueAt(n4);
                float[] fArray = this.mWaveProperties.valueAt(n4);
                dArray[n4] = (double)n5 * 0.01;
                ((CustomAttribute)object).getValuesToInterpolate(this.mTempValues);
                for (n5 = 0; n5 < ((Object)(object = (Object)this.mTempValues)).length; ++n5) {
                    dArray2[n4][n5] = (double)object[n5];
                }
                dArray2[n4][n3] = fArray[0];
                dArray2[n4][n3 + 1] = fArray[1];
            }
            this.mCurveFit = CurveFit.get(n, dArray, dArray2);
        }
    }

    public static class CustomVarSet
    extends TimeCycleSplineSet {
        String mAttributeName;
        float[] mCache;
        KeyFrameArray.CustomVar mConstraintAttributeList;
        float[] mTempValues;
        KeyFrameArray.FloatArray mWaveProperties = new KeyFrameArray.FloatArray();

        public CustomVarSet(String string2, KeyFrameArray.CustomVar customVar) {
            this.mAttributeName = string2.split(",")[1];
            this.mConstraintAttributeList = customVar;
        }

        @Override
        public void setPoint(int n, float f, float f2, int n2, float f3) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public void setPoint(int n, CustomVariable customVariable, float f, int n2, float f2) {
            this.mConstraintAttributeList.append(n, customVariable);
            this.mWaveProperties.append(n, new float[]{f, f2});
            this.mWaveShape = Math.max(this.mWaveShape, n2);
        }

        public boolean setProperty(MotionWidget motionWidget, float f, long l, KeyCache keyCache) {
            this.mCurveFit.getPos((double)f, this.mTempValues);
            float[] fArray = this.mTempValues;
            float f2 = fArray[fArray.length - 2];
            float f3 = fArray[fArray.length - 1];
            long l2 = this.last_time;
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = keyCache.getFloatValue(motionWidget, this.mAttributeName, 0);
                if (Float.isNaN(this.last_cycle)) {
                    this.last_cycle = 0.0f;
                }
            }
            this.last_cycle = (float)(((double)this.last_cycle + (double)(l - l2) * 1.0E-9 * (double)f2) % 1.0);
            this.last_time = l;
            f = this.calcWave(this.last_cycle);
            this.mContinue = false;
            for (int i = 0; i < this.mCache.length; ++i) {
                boolean bl = this.mContinue;
                boolean bl2 = (double)this.mTempValues[i] != 0.0;
                this.mContinue = bl | bl2;
                this.mCache[i] = this.mTempValues[i] * f + f3;
            }
            this.mConstraintAttributeList.valueAt(0).setInterpolatedValue(motionWidget, this.mCache);
            if (f2 != 0.0f) {
                this.mContinue = true;
            }
            return this.mContinue;
        }

        @Override
        public void setup(int n) {
            int n2 = this.mConstraintAttributeList.size();
            int n3 = this.mConstraintAttributeList.valueAt(0).numberOfInterpolatedValues();
            double[] dArray = new double[n2];
            int n4 = n3 + 2;
            this.mTempValues = new float[n4];
            this.mCache = new float[n3];
            double[][] dArray2 = new double[n2][n4];
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = this.mConstraintAttributeList.keyAt(n4);
                Object object = this.mConstraintAttributeList.valueAt(n4);
                float[] fArray = this.mWaveProperties.valueAt(n4);
                dArray[n4] = (double)n5 * 0.01;
                ((CustomVariable)object).getValuesToInterpolate(this.mTempValues);
                for (n5 = 0; n5 < ((Object)(object = (Object)this.mTempValues)).length; ++n5) {
                    dArray2[n4][n5] = (double)object[n5];
                }
                dArray2[n4][n3] = fArray[0];
                dArray2[n4][n3 + 1] = fArray[1];
            }
            this.mCurveFit = CurveFit.get(n, dArray, dArray2);
        }
    }

    protected static class Sort {
        protected Sort() {
        }

        static void doubleQuickSort(int[] nArray, float[][] fArray, int n, int n2) {
            int[] nArray2 = new int[nArray.length + 10];
            nArray2[0] = n2;
            nArray2[1] = n;
            n = 2;
            while (n > 0) {
                int n3 = nArray2[--n];
                n2 = n - 1;
                int n4 = nArray2[n2];
                n = n2;
                if (n3 >= n4) continue;
                int n5 = Sort.partition(nArray, fArray, n3, n4);
                n = n2 + 1;
                nArray2[n2] = n5 - 1;
                n2 = n + 1;
                nArray2[n] = n3;
                n3 = n2 + 1;
                nArray2[n2] = n4;
                n = n3 + 1;
                nArray2[n3] = n5 + 1;
            }
        }

        private static int partition(int[] nArray, float[][] fArray, int n, int n2) {
            int n3 = nArray[n2];
            int n4 = n;
            while (n < n2) {
                int n5 = n4;
                if (nArray[n] <= n3) {
                    Sort.swap(nArray, fArray, n4, n);
                    n5 = n4 + 1;
                }
                ++n;
                n4 = n5;
            }
            Sort.swap(nArray, fArray, n4, n2);
            return n4;
        }

        private static void swap(int[] objectArray, float[][] fArray, int n, int n2) {
            int n3 = objectArray[n];
            objectArray[n] = objectArray[n2];
            objectArray[n2] = n3;
            objectArray = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = objectArray;
        }
    }
}

