/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

public class Utils {
    static DebugHandle ourHandle;

    private static int clamp(int n) {
        n = (n & n >> 31) - 255;
        return (n & n >> 31) + 255;
    }

    public static void log(String string2) {
        Object object = new Throwable().getStackTrace()[1];
        Object object2 = ((StackTraceElement)object).getMethodName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)object2);
        stringBuilder.append("                  ");
        object2 = stringBuilder.toString().substring(0, 17);
        String string3 = "    ".substring(Integer.toString(((StackTraceElement)object).getLineNumber()).length());
        stringBuilder = new StringBuilder();
        stringBuilder.append(".(");
        stringBuilder.append(((StackTraceElement)object).getFileName());
        stringBuilder.append(":");
        stringBuilder.append(((StackTraceElement)object).getLineNumber());
        stringBuilder.append(")");
        stringBuilder.append(string3);
        stringBuilder.append((String)object2);
        object = stringBuilder.toString();
        object2 = System.out;
        stringBuilder = new StringBuilder();
        stringBuilder.append((String)object);
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        ((PrintStream)object2).println(stringBuilder.toString());
        object2 = ourHandle;
        if (object2 != null) {
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)object);
            stringBuilder.append(" ");
            stringBuilder.append(string2);
            object2.message(stringBuilder.toString());
        }
    }

    public static void log(String string2, String string3) {
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" : ");
        stringBuilder.append(string3);
        printStream.println(stringBuilder.toString());
    }

    public static void logStack(String string2, int n) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n2 = stackTraceElementArray.length;
        int n3 = 1;
        n2 = Math.min(n, n2 - 1);
        String string3 = " ";
        for (n = n3; n <= n2; ++n) {
            Object object = stackTraceElementArray[n];
            object = new StringBuilder();
            ((StringBuilder)object).append(".(");
            ((StringBuilder)object).append(stackTraceElementArray[n].getFileName());
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(stackTraceElementArray[n].getLineNumber());
            ((StringBuilder)object).append(") ");
            ((StringBuilder)object).append(stackTraceElementArray[n].getMethodName());
            object = ((StringBuilder)object).toString();
            Appendable appendable = new StringBuilder();
            ((StringBuilder)appendable).append(string3);
            ((StringBuilder)appendable).append(" ");
            string3 = ((StringBuilder)appendable).toString();
            appendable = System.out;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            stringBuilder.append((String)object);
            stringBuilder.append(string3);
            ((PrintStream)appendable).println(stringBuilder.toString());
        }
    }

    public static void loge(String string2, String string3) {
        PrintStream printStream = System.err;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" : ");
        stringBuilder.append(string3);
        printStream.println(stringBuilder.toString());
    }

    public static int rgbaTocColor(float f, float f2, float f3, float f4) {
        int n = Utils.clamp((int)(f * 255.0f));
        int n2 = Utils.clamp((int)(f2 * 255.0f));
        int n3 = Utils.clamp((int)(f3 * 255.0f));
        return n << 16 | Utils.clamp((int)(f4 * 255.0f)) << 24 | n2 << 8 | n3;
    }

    public static void setDebugHandle(DebugHandle debugHandle) {
        ourHandle = debugHandle;
    }

    public static void socketSend(String string2) {
        try {
            Closeable closeable = new Socket("127.0.0.1", 5327);
            closeable = ((Socket)closeable).getOutputStream();
            ((OutputStream)closeable).write(string2.getBytes());
            ((OutputStream)closeable).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getInterpolatedColor(float[] fArray) {
        int n = Utils.clamp((int)((float)Math.pow(fArray[0], 0.45454545454545453) * 255.0f));
        int n2 = Utils.clamp((int)((float)Math.pow(fArray[1], 0.45454545454545453) * 255.0f));
        int n3 = Utils.clamp((int)((float)Math.pow(fArray[2], 0.45454545454545453) * 255.0f));
        return Utils.clamp((int)(fArray[3] * 255.0f)) << 24 | n << 16 | n2 << 8 | n3;
    }

    public static interface DebugHandle {
        public void message(String var1);
    }
}

