/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParser;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.parser.CLString;
import androidx.constraintlayout.core.parser.CLToken;
import java.io.PrintStream;
import java.util.ArrayList;

public class CLContainer
extends CLElement {
    ArrayList<CLElement> mElements = new ArrayList();

    public CLContainer(char[] cArray) {
        super(cArray);
    }

    public static CLElement allocate(char[] cArray) {
        return new CLContainer(cArray);
    }

    public void add(CLElement cLElement) {
        this.mElements.add(cLElement);
        if (CLParser.DEBUG) {
            PrintStream printStream = System.out;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("added element ");
            stringBuilder.append(cLElement);
            stringBuilder.append(" to ");
            stringBuilder.append(this);
            printStream.println(stringBuilder.toString());
        }
    }

    public CLElement get(int n) throws CLParsingException {
        if (n >= 0 && n < this.mElements.size()) {
            return this.mElements.get(n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no element at index ");
        stringBuilder.append(n);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public CLElement get(String string2) throws CLParsingException {
        for (CLKey cLKey : this.mElements) {
            if (!cLKey.content().equals(string2)) continue;
            return cLKey.getValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no element for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">");
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public CLArray getArray(int n) throws CLParsingException {
        Object object = this.get(n);
        if (object instanceof CLArray) {
            return (CLArray)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("no array at index ");
        ((StringBuilder)object).append(n);
        throw new CLParsingException(((StringBuilder)object).toString(), this);
    }

    public CLArray getArray(String string2) throws CLParsingException {
        CLElement cLElement = this.get(string2);
        if (cLElement instanceof CLArray) {
            return (CLArray)cLElement;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no array found for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">, found [");
        stringBuilder.append(cLElement.getStrClass());
        stringBuilder.append("] : ");
        stringBuilder.append(cLElement);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public CLArray getArrayOrNull(String object) {
        if ((object = this.getOrNull((String)object)) instanceof CLArray) {
            return (CLArray)object;
        }
        return null;
    }

    public boolean getBoolean(int n) throws CLParsingException {
        Object object = this.get(n);
        if (object instanceof CLToken) {
            return ((CLToken)object).getBoolean();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("no boolean at index ");
        ((StringBuilder)object).append(n);
        throw new CLParsingException(((StringBuilder)object).toString(), this);
    }

    public boolean getBoolean(String string2) throws CLParsingException {
        CLElement cLElement = this.get(string2);
        if (cLElement instanceof CLToken) {
            return ((CLToken)cLElement).getBoolean();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no boolean found for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">, found [");
        stringBuilder.append(cLElement.getStrClass());
        stringBuilder.append("] : ");
        stringBuilder.append(cLElement);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public float getFloat(int n) throws CLParsingException {
        Object object = this.get(n);
        if (object != null) {
            return ((CLElement)object).getFloat();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("no float at index ");
        ((StringBuilder)object).append(n);
        throw new CLParsingException(((StringBuilder)object).toString(), this);
    }

    public float getFloat(String string2) throws CLParsingException {
        CLElement cLElement = this.get(string2);
        if (cLElement != null) {
            return cLElement.getFloat();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no float found for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">, found [");
        stringBuilder.append(cLElement.getStrClass());
        stringBuilder.append("] : ");
        stringBuilder.append(cLElement);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public float getFloatOrNaN(String object) {
        if ((object = this.getOrNull((String)object)) instanceof CLNumber) {
            return ((CLElement)object).getFloat();
        }
        return Float.NaN;
    }

    public int getInt(int n) throws CLParsingException {
        Object object = this.get(n);
        if (object != null) {
            return ((CLElement)object).getInt();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("no int at index ");
        ((StringBuilder)object).append(n);
        throw new CLParsingException(((StringBuilder)object).toString(), this);
    }

    public int getInt(String string2) throws CLParsingException {
        CLElement cLElement = this.get(string2);
        if (cLElement != null) {
            return cLElement.getInt();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no int found for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">, found [");
        stringBuilder.append(cLElement.getStrClass());
        stringBuilder.append("] : ");
        stringBuilder.append(cLElement);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public CLObject getObject(int n) throws CLParsingException {
        Object object = this.get(n);
        if (object instanceof CLObject) {
            return (CLObject)object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("no object at index ");
        ((StringBuilder)object).append(n);
        throw new CLParsingException(((StringBuilder)object).toString(), this);
    }

    public CLObject getObject(String string2) throws CLParsingException {
        CLElement cLElement = this.get(string2);
        if (cLElement instanceof CLObject) {
            return (CLObject)cLElement;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no object found for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">, found [");
        stringBuilder.append(cLElement.getStrClass());
        stringBuilder.append("] : ");
        stringBuilder.append(cLElement);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public CLObject getObjectOrNull(String object) {
        if ((object = this.getOrNull((String)object)) instanceof CLObject) {
            return (CLObject)object;
        }
        return null;
    }

    public CLElement getOrNull(int n) {
        if (n >= 0 && n < this.mElements.size()) {
            return this.mElements.get(n);
        }
        return null;
    }

    public CLElement getOrNull(String string2) {
        for (CLKey cLKey : this.mElements) {
            if (!cLKey.content().equals(string2)) continue;
            return cLKey.getValue();
        }
        return null;
    }

    public String getString(int n) throws CLParsingException {
        Object object = this.get(n);
        if (object instanceof CLString) {
            return ((CLElement)object).content();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("no string at index ");
        ((StringBuilder)object).append(n);
        throw new CLParsingException(((StringBuilder)object).toString(), this);
    }

    public String getString(String string2) throws CLParsingException {
        CLElement cLElement = this.get(string2);
        if (cLElement instanceof CLString) {
            return cLElement.content();
        }
        String string3 = null;
        if (cLElement != null) {
            string3 = cLElement.getStrClass();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("no string found for key <");
        stringBuilder.append(string2);
        stringBuilder.append(">, found [");
        stringBuilder.append(string3);
        stringBuilder.append("] : ");
        stringBuilder.append(cLElement);
        throw new CLParsingException(stringBuilder.toString(), this);
    }

    public String getStringOrNull(int n) {
        CLElement cLElement = this.getOrNull(n);
        if (cLElement instanceof CLString) {
            return cLElement.content();
        }
        return null;
    }

    public String getStringOrNull(String object) {
        if ((object = this.getOrNull((String)object)) instanceof CLString) {
            return ((CLElement)object).content();
        }
        return null;
    }

    public boolean has(String string2) {
        for (CLElement cLElement : this.mElements) {
            if (!(cLElement instanceof CLKey) || !((CLKey)cLElement).content().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> names() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CLElement cLElement : this.mElements) {
            if (!(cLElement instanceof CLKey)) continue;
            arrayList.add(((CLKey)cLElement).content());
        }
        return arrayList;
    }

    public void put(String object, CLElement cLElement) {
        for (CLKey cLKey : this.mElements) {
            if (!cLKey.content().equals(object)) continue;
            cLKey.set(cLElement);
            return;
        }
        object = (CLKey)CLKey.allocate((String)object, cLElement);
        this.mElements.add((CLElement)object);
    }

    public void putNumber(String string2, float f) {
        this.put(string2, new CLNumber(f));
    }

    public void remove(String object) {
        ArrayList<CLElement> arrayList = new ArrayList<CLElement>();
        for (CLElement cLElement : this.mElements) {
            if (!((CLKey)cLElement).content().equals(object)) continue;
            arrayList.add(cLElement);
        }
        for (CLElement cLElement : arrayList) {
            this.mElements.remove(cLElement);
        }
    }

    public int size() {
        return this.mElements.size();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CLElement cLElement : this.mElements) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(cLElement);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(super.toString());
        stringBuilder2.append(" = <");
        stringBuilder2.append((Object)stringBuilder);
        stringBuilder2.append(" >");
        return stringBuilder2.toString();
    }
}

