/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.Reference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.helpers.Facade;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstraintReference
implements Reference {
    private Object key;
    float mAlpha;
    Object mBaselineToBaseline = null;
    Object mBaselineToBottom = null;
    Object mBaselineToTop = null;
    protected Object mBottomToBottom = null;
    protected Object mBottomToTop = null;
    private float mCircularAngle;
    Object mCircularConstraint = null;
    private float mCircularDistance;
    private ConstraintWidget mConstraintWidget;
    private HashMap<String, Integer> mCustomColors;
    private HashMap<String, Float> mCustomFloats;
    protected Object mEndToEnd = null;
    protected Object mEndToStart = null;
    Facade mFacade = null;
    float mHorizontalBias = 0.5f;
    int mHorizontalChainStyle = 0;
    float mHorizontalChainWeight = -1.0f;
    Dimension mHorizontalDimension;
    State.Constraint mLast = null;
    protected Object mLeftToLeft = null;
    protected Object mLeftToRight = null;
    int mMarginBaseline = 0;
    int mMarginBaselineGone = 0;
    int mMarginBottom = 0;
    int mMarginBottomGone = 0;
    protected int mMarginEnd = 0;
    int mMarginEndGone = 0;
    protected int mMarginLeft = 0;
    int mMarginLeftGone = 0;
    protected int mMarginRight = 0;
    int mMarginRightGone = 0;
    protected int mMarginStart = 0;
    int mMarginStartGone = 0;
    int mMarginTop = 0;
    int mMarginTopGone = 0;
    float mPivotX = Float.NaN;
    float mPivotY = Float.NaN;
    protected Object mRightToLeft = null;
    protected Object mRightToRight = null;
    float mRotationX = Float.NaN;
    float mRotationY = Float.NaN;
    float mRotationZ = Float.NaN;
    float mScaleX;
    float mScaleY;
    protected Object mStartToEnd = null;
    protected Object mStartToStart = null;
    final State mState;
    String mTag = null;
    protected Object mTopToBottom = null;
    protected Object mTopToTop = null;
    float mTranslationX = Float.NaN;
    float mTranslationY = Float.NaN;
    float mTranslationZ = Float.NaN;
    float mVerticalBias = 0.5f;
    int mVerticalChainStyle = 0;
    float mVerticalChainWeight = -1.0f;
    Dimension mVerticalDimension;
    private Object mView;
    int mVisibility = 0;

    public ConstraintReference(State state) {
        this.mAlpha = Float.NaN;
        this.mScaleX = Float.NaN;
        this.mScaleY = Float.NaN;
        this.mHorizontalDimension = Dimension.Fixed(Dimension.WRAP_DIMENSION);
        this.mVerticalDimension = Dimension.Fixed(Dimension.WRAP_DIMENSION);
        this.mCustomColors = new HashMap();
        this.mCustomFloats = new HashMap();
        this.mState = state;
    }

    private void applyConnection(ConstraintWidget constraintWidget, Object object, State.Constraint constraint) {
        if ((object = this.getTarget(object)) == null) {
            return;
        }
        int n = 1.$SwitchMap$androidx$constraintlayout$core$state$State$Constraint[constraint.ordinal()];
        switch (1.$SwitchMap$androidx$constraintlayout$core$state$State$Constraint[constraint.ordinal()]) {
            default: {
                break;
            }
            case 16: {
                constraintWidget.connectCircularConstraint((ConstraintWidget)object, this.mCircularAngle, (int)this.mCircularDistance);
                break;
            }
            case 15: {
                constraintWidget.immediateConnect(ConstraintAnchor.Type.BASELINE, (ConstraintWidget)object, ConstraintAnchor.Type.BASELINE, this.mMarginBaseline, this.mMarginBaselineGone);
                break;
            }
            case 14: {
                constraintWidget.immediateConnect(ConstraintAnchor.Type.BASELINE, (ConstraintWidget)object, ConstraintAnchor.Type.TOP, this.mMarginBaseline, this.mMarginBaselineGone);
                break;
            }
            case 13: {
                constraintWidget.immediateConnect(ConstraintAnchor.Type.BASELINE, (ConstraintWidget)object, ConstraintAnchor.Type.BOTTOM, this.mMarginBaseline, this.mMarginBaselineGone);
                break;
            }
            case 12: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.BOTTOM), this.mMarginBottom, this.mMarginBottomGone, false);
                break;
            }
            case 11: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.TOP), this.mMarginBottom, this.mMarginBottomGone, false);
                break;
            }
            case 10: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.TOP).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.BOTTOM), this.mMarginTop, this.mMarginTopGone, false);
                break;
            }
            case 9: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.TOP).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.TOP), this.mMarginTop, this.mMarginTopGone, false);
                break;
            }
            case 8: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.RIGHT), this.mMarginEnd, this.mMarginEndGone, false);
                break;
            }
            case 7: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.LEFT), this.mMarginEnd, this.mMarginEndGone, false);
                break;
            }
            case 6: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.RIGHT), this.mMarginStart, this.mMarginStartGone, false);
                break;
            }
            case 5: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.LEFT), this.mMarginStart, this.mMarginStartGone, false);
                break;
            }
            case 4: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.RIGHT), this.mMarginRight, this.mMarginRightGone, false);
                break;
            }
            case 3: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.LEFT), this.mMarginRight, this.mMarginRightGone, false);
                break;
            }
            case 2: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.RIGHT), this.mMarginLeft, this.mMarginLeftGone, false);
                break;
            }
            case 1: {
                constraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).connect(((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.LEFT), this.mMarginLeft, this.mMarginLeftGone, false);
            }
        }
    }

    private void dereference() {
        this.mLeftToLeft = this.get(this.mLeftToLeft);
        this.mLeftToRight = this.get(this.mLeftToRight);
        this.mRightToLeft = this.get(this.mRightToLeft);
        this.mRightToRight = this.get(this.mRightToRight);
        this.mStartToStart = this.get(this.mStartToStart);
        this.mStartToEnd = this.get(this.mStartToEnd);
        this.mEndToStart = this.get(this.mEndToStart);
        this.mEndToEnd = this.get(this.mEndToEnd);
        this.mTopToTop = this.get(this.mTopToTop);
        this.mTopToBottom = this.get(this.mTopToBottom);
        this.mBottomToTop = this.get(this.mBottomToTop);
        this.mBottomToBottom = this.get(this.mBottomToBottom);
        this.mBaselineToBaseline = this.get(this.mBaselineToBaseline);
        this.mBaselineToTop = this.get(this.mBaselineToTop);
        this.mBaselineToBottom = this.get(this.mBaselineToBottom);
    }

    private Object get(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = object;
        if (!(object instanceof ConstraintReference)) {
            object2 = this.mState.reference(object);
        }
        return object2;
    }

    private ConstraintWidget getTarget(Object object) {
        if (object instanceof Reference) {
            return ((Reference)object).getConstraintWidget();
        }
        return null;
    }

    public void addCustomColor(String string2, int n) {
        this.mCustomColors.put(string2, n);
    }

    public void addCustomFloat(String string2, float f) {
        if (this.mCustomFloats == null) {
            this.mCustomFloats = new HashMap();
        }
        this.mCustomFloats.put(string2, Float.valueOf(f));
    }

    public ConstraintReference alpha(float f) {
        this.mAlpha = f;
        return this;
    }

    @Override
    public void apply() {
        float f;
        if (this.mConstraintWidget == null) {
            return;
        }
        Object object = this.mFacade;
        if (object != null) {
            object.apply();
        }
        this.mHorizontalDimension.apply(this.mState, this.mConstraintWidget, 0);
        this.mVerticalDimension.apply(this.mState, this.mConstraintWidget, 1);
        this.dereference();
        this.applyConnection(this.mConstraintWidget, this.mLeftToLeft, State.Constraint.LEFT_TO_LEFT);
        this.applyConnection(this.mConstraintWidget, this.mLeftToRight, State.Constraint.LEFT_TO_RIGHT);
        this.applyConnection(this.mConstraintWidget, this.mRightToLeft, State.Constraint.RIGHT_TO_LEFT);
        this.applyConnection(this.mConstraintWidget, this.mRightToRight, State.Constraint.RIGHT_TO_RIGHT);
        this.applyConnection(this.mConstraintWidget, this.mStartToStart, State.Constraint.START_TO_START);
        this.applyConnection(this.mConstraintWidget, this.mStartToEnd, State.Constraint.START_TO_END);
        this.applyConnection(this.mConstraintWidget, this.mEndToStart, State.Constraint.END_TO_START);
        this.applyConnection(this.mConstraintWidget, this.mEndToEnd, State.Constraint.END_TO_END);
        this.applyConnection(this.mConstraintWidget, this.mTopToTop, State.Constraint.TOP_TO_TOP);
        this.applyConnection(this.mConstraintWidget, this.mTopToBottom, State.Constraint.TOP_TO_BOTTOM);
        this.applyConnection(this.mConstraintWidget, this.mBottomToTop, State.Constraint.BOTTOM_TO_TOP);
        this.applyConnection(this.mConstraintWidget, this.mBottomToBottom, State.Constraint.BOTTOM_TO_BOTTOM);
        this.applyConnection(this.mConstraintWidget, this.mBaselineToBaseline, State.Constraint.BASELINE_TO_BASELINE);
        this.applyConnection(this.mConstraintWidget, this.mBaselineToTop, State.Constraint.BASELINE_TO_TOP);
        this.applyConnection(this.mConstraintWidget, this.mBaselineToBottom, State.Constraint.BASELINE_TO_BOTTOM);
        this.applyConnection(this.mConstraintWidget, this.mCircularConstraint, State.Constraint.CIRCULAR_CONSTRAINT);
        int n = this.mHorizontalChainStyle;
        if (n != 0) {
            this.mConstraintWidget.setHorizontalChainStyle(n);
        }
        if ((n = this.mVerticalChainStyle) != 0) {
            this.mConstraintWidget.setVerticalChainStyle(n);
        }
        if ((f = this.mHorizontalChainWeight) != -1.0f) {
            this.mConstraintWidget.setHorizontalWeight(f);
        }
        if ((f = this.mVerticalChainWeight) != -1.0f) {
            this.mConstraintWidget.setVerticalWeight(f);
        }
        this.mConstraintWidget.setHorizontalBiasPercent(this.mHorizontalBias);
        this.mConstraintWidget.setVerticalBiasPercent(this.mVerticalBias);
        this.mConstraintWidget.frame.pivotX = this.mPivotX;
        this.mConstraintWidget.frame.pivotY = this.mPivotY;
        this.mConstraintWidget.frame.rotationX = this.mRotationX;
        this.mConstraintWidget.frame.rotationY = this.mRotationY;
        this.mConstraintWidget.frame.rotationZ = this.mRotationZ;
        this.mConstraintWidget.frame.translationX = this.mTranslationX;
        this.mConstraintWidget.frame.translationY = this.mTranslationY;
        this.mConstraintWidget.frame.translationZ = this.mTranslationZ;
        this.mConstraintWidget.frame.scaleX = this.mScaleX;
        this.mConstraintWidget.frame.scaleY = this.mScaleY;
        this.mConstraintWidget.frame.alpha = this.mAlpha;
        this.mConstraintWidget.frame.visibility = this.mVisibility;
        this.mConstraintWidget.setVisibility(this.mVisibility);
        object = this.mCustomColors;
        if (object != null) {
            for (String string2 : ((HashMap)object).keySet()) {
                object = this.mCustomColors.get(string2);
                this.mConstraintWidget.frame.setCustomAttribute(string2, 902, (Integer)object);
            }
        }
        if ((object = this.mCustomFloats) != null) {
            for (String string3 : ((HashMap)object).keySet()) {
                f = this.mCustomFloats.get(string3).floatValue();
                this.mConstraintWidget.frame.setCustomAttribute(string3, 901, f);
            }
        }
    }

    public ConstraintReference baseline() {
        this.mLast = State.Constraint.BASELINE_TO_BASELINE;
        return this;
    }

    public ConstraintReference baselineToBaseline(Object object) {
        this.mLast = State.Constraint.BASELINE_TO_BASELINE;
        this.mBaselineToBaseline = object;
        return this;
    }

    public ConstraintReference baselineToBottom(Object object) {
        this.mLast = State.Constraint.BASELINE_TO_BOTTOM;
        this.mBaselineToBottom = object;
        return this;
    }

    public ConstraintReference baselineToTop(Object object) {
        this.mLast = State.Constraint.BASELINE_TO_TOP;
        this.mBaselineToTop = object;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public ConstraintReference bias(float var1_1) {
        if (this.mLast == null) {
            return this;
        }
        var2_2 = 1.$SwitchMap$androidx$constraintlayout$core$state$State$Constraint[this.mLast.ordinal()];
        if (var2_2 == 17) ** GOTO lbl-1000
        if (var2_2 == 18) ** GOTO lbl-1000
        switch (var2_2) {
            default: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: lbl-1000:
            // 2 sources

            {
                this.mVerticalBias = var1_1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: lbl-1000:
            // 2 sources

            {
                this.mHorizontalBias = var1_1;
            }
        }
        return this;
    }

    public ConstraintReference bottom() {
        this.mLast = this.mBottomToTop != null ? State.Constraint.BOTTOM_TO_TOP : State.Constraint.BOTTOM_TO_BOTTOM;
        return this;
    }

    public ConstraintReference bottomToBottom(Object object) {
        this.mLast = State.Constraint.BOTTOM_TO_BOTTOM;
        this.mBottomToBottom = object;
        return this;
    }

    public ConstraintReference bottomToTop(Object object) {
        this.mLast = State.Constraint.BOTTOM_TO_TOP;
        this.mBottomToTop = object;
        return this;
    }

    public ConstraintReference centerHorizontally(Object object) {
        this.mStartToStart = object = this.get(object);
        this.mEndToEnd = object;
        this.mLast = State.Constraint.CENTER_HORIZONTALLY;
        this.mHorizontalBias = 0.5f;
        return this;
    }

    public ConstraintReference centerVertically(Object object) {
        this.mTopToTop = object = this.get(object);
        this.mBottomToBottom = object;
        this.mLast = State.Constraint.CENTER_VERTICALLY;
        this.mVerticalBias = 0.5f;
        return this;
    }

    public ConstraintReference circularConstraint(Object object, float f, float f2) {
        this.mCircularConstraint = this.get(object);
        this.mCircularAngle = f;
        this.mCircularDistance = f2;
        this.mLast = State.Constraint.CIRCULAR_CONSTRAINT;
        return this;
    }

    public ConstraintReference clear() {
        if (this.mLast != null) {
            switch (1.$SwitchMap$androidx$constraintlayout$core$state$State$Constraint[this.mLast.ordinal()]) {
                default: {
                    break;
                }
                case 16: {
                    this.mCircularConstraint = null;
                    break;
                }
                case 15: {
                    this.mBaselineToBaseline = null;
                    break;
                }
                case 11: 
                case 12: {
                    this.mBottomToTop = null;
                    this.mBottomToBottom = null;
                    this.mMarginBottom = 0;
                    this.mMarginBottomGone = 0;
                    break;
                }
                case 9: 
                case 10: {
                    this.mTopToTop = null;
                    this.mTopToBottom = null;
                    this.mMarginTop = 0;
                    this.mMarginTopGone = 0;
                    break;
                }
                case 7: 
                case 8: {
                    this.mEndToStart = null;
                    this.mEndToEnd = null;
                    this.mMarginEnd = 0;
                    this.mMarginEndGone = 0;
                    break;
                }
                case 5: 
                case 6: {
                    this.mStartToStart = null;
                    this.mStartToEnd = null;
                    this.mMarginStart = 0;
                    this.mMarginStartGone = 0;
                    break;
                }
                case 3: 
                case 4: {
                    this.mRightToLeft = null;
                    this.mRightToRight = null;
                    this.mMarginRight = 0;
                    this.mMarginRightGone = 0;
                    break;
                }
                case 1: 
                case 2: {
                    this.mLeftToLeft = null;
                    this.mLeftToRight = null;
                    this.mMarginLeft = 0;
                    this.mMarginLeftGone = 0;
                    break;
                }
            }
        } else {
            this.mLeftToLeft = null;
            this.mLeftToRight = null;
            this.mMarginLeft = 0;
            this.mRightToLeft = null;
            this.mRightToRight = null;
            this.mMarginRight = 0;
            this.mStartToStart = null;
            this.mStartToEnd = null;
            this.mMarginStart = 0;
            this.mEndToStart = null;
            this.mEndToEnd = null;
            this.mMarginEnd = 0;
            this.mTopToTop = null;
            this.mTopToBottom = null;
            this.mMarginTop = 0;
            this.mBottomToTop = null;
            this.mBottomToBottom = null;
            this.mMarginBottom = 0;
            this.mBaselineToBaseline = null;
            this.mCircularConstraint = null;
            this.mHorizontalBias = 0.5f;
            this.mVerticalBias = 0.5f;
            this.mMarginLeftGone = 0;
            this.mMarginRightGone = 0;
            this.mMarginStartGone = 0;
            this.mMarginEndGone = 0;
            this.mMarginTopGone = 0;
            this.mMarginBottomGone = 0;
        }
        return this;
    }

    public ConstraintReference clearHorizontal() {
        this.start().clear();
        this.end().clear();
        this.left().clear();
        this.right().clear();
        return this;
    }

    public ConstraintReference clearVertical() {
        this.top().clear();
        this.baseline().clear();
        this.bottom().clear();
        return this;
    }

    public ConstraintWidget createConstraintWidget() {
        return new ConstraintWidget(this.getWidth().getValue(), this.getHeight().getValue());
    }

    public ConstraintReference end() {
        this.mLast = this.mEndToStart != null ? State.Constraint.END_TO_START : State.Constraint.END_TO_END;
        return this;
    }

    public ConstraintReference endToEnd(Object object) {
        this.mLast = State.Constraint.END_TO_END;
        this.mEndToEnd = object;
        return this;
    }

    public ConstraintReference endToStart(Object object) {
        this.mLast = State.Constraint.END_TO_START;
        this.mEndToStart = object;
        return this;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    @Override
    public ConstraintWidget getConstraintWidget() {
        if (this.mConstraintWidget == null) {
            ConstraintWidget constraintWidget;
            this.mConstraintWidget = constraintWidget = this.createConstraintWidget();
            constraintWidget.setCompanionWidget(this.mView);
        }
        return this.mConstraintWidget;
    }

    @Override
    public Facade getFacade() {
        return this.mFacade;
    }

    public Dimension getHeight() {
        return this.mVerticalDimension;
    }

    public int getHorizontalChainStyle() {
        return this.mHorizontalChainStyle;
    }

    public float getHorizontalChainWeight() {
        return this.mHorizontalChainWeight;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public float getPivotX() {
        return this.mPivotX;
    }

    public float getPivotY() {
        return this.mPivotY;
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public float getRotationZ() {
        return this.mRotationZ;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public String getTag() {
        return this.mTag;
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public float getTranslationZ() {
        return this.mTranslationZ;
    }

    public int getVerticalChainStyle(int n) {
        return this.mVerticalChainStyle;
    }

    public float getVerticalChainWeight() {
        return this.mVerticalChainWeight;
    }

    public Object getView() {
        return this.mView;
    }

    public Dimension getWidth() {
        return this.mHorizontalDimension;
    }

    public ConstraintReference height(Dimension dimension) {
        return this.setHeight(dimension);
    }

    public ConstraintReference horizontalBias(float f) {
        this.mHorizontalBias = f;
        return this;
    }

    public ConstraintReference left() {
        this.mLast = this.mLeftToLeft != null ? State.Constraint.LEFT_TO_LEFT : State.Constraint.LEFT_TO_RIGHT;
        return this;
    }

    public ConstraintReference leftToLeft(Object object) {
        this.mLast = State.Constraint.LEFT_TO_LEFT;
        this.mLeftToLeft = object;
        return this;
    }

    public ConstraintReference leftToRight(Object object) {
        this.mLast = State.Constraint.LEFT_TO_RIGHT;
        this.mLeftToRight = object;
        return this;
    }

    public ConstraintReference margin(int n) {
        if (this.mLast != null) {
            switch (1.$SwitchMap$androidx$constraintlayout$core$state$State$Constraint[this.mLast.ordinal()]) {
                default: {
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    this.mMarginBaseline = n;
                }
                case 16: {
                    this.mCircularDistance = n;
                    break;
                }
                case 11: 
                case 12: {
                    this.mMarginBottom = n;
                    break;
                }
                case 9: 
                case 10: {
                    this.mMarginTop = n;
                    break;
                }
                case 7: 
                case 8: {
                    this.mMarginEnd = n;
                    break;
                }
                case 5: 
                case 6: {
                    this.mMarginStart = n;
                    break;
                }
                case 3: 
                case 4: {
                    this.mMarginRight = n;
                    break;
                }
                case 1: 
                case 2: {
                    this.mMarginLeft = n;
                    break;
                }
            }
        } else {
            this.mMarginLeft = n;
            this.mMarginRight = n;
            this.mMarginStart = n;
            this.mMarginEnd = n;
            this.mMarginTop = n;
            this.mMarginBottom = n;
        }
        return this;
    }

    public ConstraintReference margin(Object object) {
        return this.margin(this.mState.convertDimension(object));
    }

    public ConstraintReference marginGone(int n) {
        if (this.mLast != null) {
            switch (1.$SwitchMap$androidx$constraintlayout$core$state$State$Constraint[this.mLast.ordinal()]) {
                default: {
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    this.mMarginBaselineGone = n;
                    break;
                }
                case 11: 
                case 12: {
                    this.mMarginBottomGone = n;
                    break;
                }
                case 9: 
                case 10: {
                    this.mMarginTopGone = n;
                    break;
                }
                case 7: 
                case 8: {
                    this.mMarginEndGone = n;
                    break;
                }
                case 5: 
                case 6: {
                    this.mMarginStartGone = n;
                    break;
                }
                case 3: 
                case 4: {
                    this.mMarginRightGone = n;
                    break;
                }
                case 1: 
                case 2: {
                    this.mMarginLeftGone = n;
                    break;
                }
            }
        } else {
            this.mMarginLeftGone = n;
            this.mMarginRightGone = n;
            this.mMarginStartGone = n;
            this.mMarginEndGone = n;
            this.mMarginTopGone = n;
            this.mMarginBottomGone = n;
        }
        return this;
    }

    public ConstraintReference marginGone(Object object) {
        return this.marginGone(this.mState.convertDimension(object));
    }

    public ConstraintReference pivotX(float f) {
        this.mPivotX = f;
        return this;
    }

    public ConstraintReference pivotY(float f) {
        this.mPivotY = f;
        return this;
    }

    public ConstraintReference right() {
        this.mLast = this.mRightToLeft != null ? State.Constraint.RIGHT_TO_LEFT : State.Constraint.RIGHT_TO_RIGHT;
        return this;
    }

    public ConstraintReference rightToLeft(Object object) {
        this.mLast = State.Constraint.RIGHT_TO_LEFT;
        this.mRightToLeft = object;
        return this;
    }

    public ConstraintReference rightToRight(Object object) {
        this.mLast = State.Constraint.RIGHT_TO_RIGHT;
        this.mRightToRight = object;
        return this;
    }

    public ConstraintReference rotationX(float f) {
        this.mRotationX = f;
        return this;
    }

    public ConstraintReference rotationY(float f) {
        this.mRotationY = f;
        return this;
    }

    public ConstraintReference rotationZ(float f) {
        this.mRotationZ = f;
        return this;
    }

    public ConstraintReference scaleX(float f) {
        this.mScaleX = f;
        return this;
    }

    public ConstraintReference scaleY(float f) {
        this.mScaleY = f;
        return this;
    }

    @Override
    public void setConstraintWidget(ConstraintWidget constraintWidget) {
        if (constraintWidget == null) {
            return;
        }
        this.mConstraintWidget = constraintWidget;
        constraintWidget.setCompanionWidget(this.mView);
    }

    public void setFacade(Facade facade) {
        this.mFacade = facade;
        if (facade != null) {
            this.setConstraintWidget(facade.getConstraintWidget());
        }
    }

    public ConstraintReference setHeight(Dimension dimension) {
        this.mVerticalDimension = dimension;
        return this;
    }

    public void setHorizontalChainStyle(int n) {
        this.mHorizontalChainStyle = n;
    }

    public void setHorizontalChainWeight(float f) {
        this.mHorizontalChainWeight = f;
    }

    @Override
    public void setKey(Object object) {
        this.key = object;
    }

    public void setTag(String string2) {
        this.mTag = string2;
    }

    public void setVerticalChainStyle(int n) {
        this.mVerticalChainStyle = n;
    }

    public void setVerticalChainWeight(float f) {
        this.mVerticalChainWeight = f;
    }

    public void setView(Object object) {
        this.mView = object;
        ConstraintWidget constraintWidget = this.mConstraintWidget;
        if (constraintWidget != null) {
            constraintWidget.setCompanionWidget(object);
        }
    }

    public ConstraintReference setWidth(Dimension dimension) {
        this.mHorizontalDimension = dimension;
        return this;
    }

    public ConstraintReference start() {
        this.mLast = this.mStartToStart != null ? State.Constraint.START_TO_START : State.Constraint.START_TO_END;
        return this;
    }

    public ConstraintReference startToEnd(Object object) {
        this.mLast = State.Constraint.START_TO_END;
        this.mStartToEnd = object;
        return this;
    }

    public ConstraintReference startToStart(Object object) {
        this.mLast = State.Constraint.START_TO_START;
        this.mStartToStart = object;
        return this;
    }

    public ConstraintReference top() {
        this.mLast = this.mTopToTop != null ? State.Constraint.TOP_TO_TOP : State.Constraint.TOP_TO_BOTTOM;
        return this;
    }

    public ConstraintReference topToBottom(Object object) {
        this.mLast = State.Constraint.TOP_TO_BOTTOM;
        this.mTopToBottom = object;
        return this;
    }

    public ConstraintReference topToTop(Object object) {
        this.mLast = State.Constraint.TOP_TO_TOP;
        this.mTopToTop = object;
        return this;
    }

    public ConstraintReference translationX(float f) {
        this.mTranslationX = f;
        return this;
    }

    public ConstraintReference translationY(float f) {
        this.mTranslationY = f;
        return this;
    }

    public ConstraintReference translationZ(float f) {
        this.mTranslationZ = f;
        return this;
    }

    public void validate() throws IncorrectConstraintException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mLeftToLeft != null && this.mLeftToRight != null) {
            arrayList.add("LeftToLeft and LeftToRight both defined");
        }
        if (this.mRightToLeft != null && this.mRightToRight != null) {
            arrayList.add("RightToLeft and RightToRight both defined");
        }
        if (this.mStartToStart != null && this.mStartToEnd != null) {
            arrayList.add("StartToStart and StartToEnd both defined");
        }
        if (this.mEndToStart != null && this.mEndToEnd != null) {
            arrayList.add("EndToStart and EndToEnd both defined");
        }
        if (!(this.mLeftToLeft == null && this.mLeftToRight == null && this.mRightToLeft == null && this.mRightToRight == null || this.mStartToStart == null && this.mStartToEnd == null && this.mEndToStart == null && this.mEndToEnd == null)) {
            arrayList.add("Both left/right and start/end constraints defined");
        }
        if (arrayList.size() <= 0) {
            return;
        }
        throw new IncorrectConstraintException(arrayList);
    }

    public ConstraintReference verticalBias(float f) {
        this.mVerticalBias = f;
        return this;
    }

    public ConstraintReference visibility(int n) {
        this.mVisibility = n;
        return this;
    }

    public ConstraintReference width(Dimension dimension) {
        return this.setWidth(dimension);
    }

    public static interface ConstraintReferenceFactory {
        public ConstraintReference create(State var1);
    }

    static class IncorrectConstraintException
    extends Exception {
        private final ArrayList<String> mErrors;

        public IncorrectConstraintException(ArrayList<String> arrayList) {
            this.mErrors = arrayList;
        }

        public ArrayList<String> getErrors() {
            return this.mErrors;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("IncorrectConstraintException: ");
            stringBuilder.append(this.mErrors.toString());
            return stringBuilder.toString();
        }
    }
}

