/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.state.RegistryCallback;
import java.util.HashMap;
import java.util.Set;

public class Registry {
    private static final Registry sRegistry = new Registry();
    private HashMap<String, RegistryCallback> mCallbacks = new HashMap();

    public static Registry getInstance() {
        return sRegistry;
    }

    public String currentContent(String object) {
        if ((object = this.mCallbacks.get(object)) != null) {
            return object.currentMotionScene();
        }
        return null;
    }

    public String currentLayoutInformation(String object) {
        if ((object = this.mCallbacks.get(object)) != null) {
            return object.currentLayoutInformation();
        }
        return null;
    }

    public long getLastModified(String object) {
        if ((object = this.mCallbacks.get(object)) != null) {
            return object.getLastModified();
        }
        return Long.MAX_VALUE;
    }

    public Set<String> getLayoutList() {
        return this.mCallbacks.keySet();
    }

    public void register(String string2, RegistryCallback registryCallback) {
        this.mCallbacks.put(string2, registryCallback);
    }

    public void setDrawDebug(String object, int n) {
        if ((object = this.mCallbacks.get(object)) != null) {
            object.setDrawDebug(n);
        }
    }

    public void setLayoutInformationMode(String object, int n) {
        if ((object = this.mCallbacks.get(object)) != null) {
            object.setLayoutInformationMode(n);
        }
    }

    public void unregister(String string2, RegistryCallback registryCallback) {
        this.mCallbacks.remove(string2);
    }

    public void updateContent(String object, String string2) {
        if ((object = this.mCallbacks.get(object)) != null) {
            object.onNewMotionScene(string2);
        }
    }

    public void updateDimensions(String object, int n, int n2) {
        if ((object = this.mCallbacks.get(object)) != null) {
            object.onDimensions(n, n2);
        }
    }

    public void updateProgress(String object, float f) {
        if ((object = this.mCallbacks.get(object)) != null) {
            object.onProgress(f);
        }
    }
}

