/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.motion.CustomAttribute;
import androidx.constraintlayout.core.motion.CustomVariable;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.state.Transition;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Set;

public class WidgetFrame {
    private static final boolean OLD_SYSTEM = true;
    public static float phone_orientation = Float.NaN;
    public float alpha;
    public int bottom = 0;
    public float interpolatedPos;
    public int left = 0;
    public final HashMap<String, CustomVariable> mCustom;
    public String name = null;
    public float pivotX = Float.NaN;
    public float pivotY = Float.NaN;
    public int right = 0;
    public float rotationX = Float.NaN;
    public float rotationY = Float.NaN;
    public float rotationZ = Float.NaN;
    public float scaleX;
    public float scaleY;
    public int top = 0;
    public float translationX = Float.NaN;
    public float translationY = Float.NaN;
    public float translationZ = Float.NaN;
    public int visibility = 0;
    public ConstraintWidget widget = null;

    public WidgetFrame() {
        this.scaleX = Float.NaN;
        this.scaleY = Float.NaN;
        this.alpha = Float.NaN;
        this.interpolatedPos = Float.NaN;
        this.mCustom = new HashMap();
    }

    public WidgetFrame(WidgetFrame widgetFrame) {
        this.scaleX = Float.NaN;
        this.scaleY = Float.NaN;
        this.alpha = Float.NaN;
        this.interpolatedPos = Float.NaN;
        this.mCustom = new HashMap();
        this.widget = widgetFrame.widget;
        this.left = widgetFrame.left;
        this.top = widgetFrame.top;
        this.right = widgetFrame.right;
        this.bottom = widgetFrame.bottom;
        this.updateAttributes(widgetFrame);
    }

    public WidgetFrame(ConstraintWidget constraintWidget) {
        this.scaleX = Float.NaN;
        this.scaleY = Float.NaN;
        this.alpha = Float.NaN;
        this.interpolatedPos = Float.NaN;
        this.mCustom = new HashMap();
        this.widget = constraintWidget;
    }

    private static void add(StringBuilder stringBuilder, String string2, float f) {
        if (Float.isNaN(f)) {
            return;
        }
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(f);
        stringBuilder.append(",\n");
    }

    private static void add(StringBuilder stringBuilder, String string2, int n) {
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(n);
        stringBuilder.append(",\n");
    }

    private static float interpolate(float f, float f2, float f3, float f4) {
        boolean bl = Float.isNaN(f);
        boolean bl2 = Float.isNaN(f2);
        if (bl && bl2) {
            return Float.NaN;
        }
        if (bl) {
            f = f3;
        }
        if (bl2) {
            f2 = f3;
        }
        return f + f4 * (f2 - f);
    }

    public static void interpolate(int n, int n2, WidgetFrame widgetFrame, WidgetFrame widgetFrame2, WidgetFrame widgetFrame3, Transition object, float f) {
        Object object2;
        Object object3;
        float f2 = 100.0f * f;
        int n3 = (int)f2;
        int n4 = widgetFrame2.left;
        int n5 = widgetFrame2.top;
        int n6 = widgetFrame3.left;
        int n7 = widgetFrame3.top;
        int n8 = widgetFrame2.right;
        int n9 = widgetFrame2.bottom;
        int n10 = widgetFrame3.right - n6;
        int n11 = widgetFrame3.bottom - n7;
        float f3 = widgetFrame2.alpha;
        float f4 = widgetFrame3.alpha;
        if (widgetFrame2.visibility == 8) {
            n4 = (int)((float)n4 - (float)n10 / 2.0f);
            n5 = (int)((float)n5 - (float)n11 / 2.0f);
            if (Float.isNaN(f3)) {
                n9 = n11;
                n8 = n10;
                f3 = 0.0f;
            } else {
                n8 = n10;
                n9 = n11;
            }
        } else {
            n8 -= n4;
            n9 -= n5;
        }
        float f5 = f4;
        int n12 = n6;
        int n13 = n7;
        if (widgetFrame3.visibility == 8) {
            int n14 = (int)((float)n6 - (float)n8 / 2.0f);
            int n15 = (int)((float)n7 - (float)n9 / 2.0f);
            boolean bl = Float.isNaN(f4);
            n6 = n8;
            n7 = n9;
            f5 = f4;
            n12 = n14;
            n13 = n15;
            n11 = n7;
            n10 = n6;
            if (bl) {
                f5 = 0.0f;
                n10 = n6;
                n11 = n7;
                n13 = n15;
                n12 = n14;
            }
        }
        f4 = f3;
        if (Float.isNaN(f3)) {
            f4 = f3;
            if (!Float.isNaN(f5)) {
                f4 = 1.0f;
            }
        }
        f3 = f5;
        if (!Float.isNaN(f4)) {
            f3 = f5;
            if (Float.isNaN(f5)) {
                f3 = 1.0f;
            }
        }
        f5 = widgetFrame2.visibility == 4 ? 0.0f : f4;
        if (widgetFrame3.visibility == 4) {
            f3 = 0.0f;
        }
        if (widgetFrame.widget != null && ((Transition)object).hasPositionKeyframes()) {
            object3 = ((Transition)object).findPreviousPosition(widgetFrame.widget.stringId, n3);
            object = object2 = ((Transition)object).findNextPosition(widgetFrame.widget.stringId, n3);
            if (object3 == object2) {
                object = null;
            }
            if (object3 != null) {
                n4 = (int)(((Transition.KeyPosition)object3).x * (float)n);
                f4 = ((Transition.KeyPosition)object3).y;
                n5 = (int)(f4 * (float)n2);
                n7 = ((Transition.KeyPosition)object3).frame;
            } else {
                n7 = 0;
            }
            if (object != null) {
                n12 = (int)(((Transition.KeyPosition)object).x * (float)n);
                n13 = (int)(((Transition.KeyPosition)object).y * (float)n2);
                n = ((Transition.KeyPosition)object).frame;
            } else {
                n = 100;
            }
            f4 = (f2 - (float)n7) / (float)(n - n7);
        } else {
            f4 = f;
        }
        widgetFrame.widget = widgetFrame2.widget;
        widgetFrame.left = n = (int)((float)n4 + (float)(n12 - n4) * f4);
        widgetFrame.top = n2 = (int)((float)n5 + f4 * (float)(n13 - n5));
        f4 = 1.0f - f;
        n8 = (int)((float)n8 * f4 + (float)n10 * f);
        n9 = (int)(f4 * (float)n9 + (float)n11 * f);
        widgetFrame.right = n + n8;
        widgetFrame.bottom = n2 + n9;
        widgetFrame.pivotX = WidgetFrame.interpolate(widgetFrame2.pivotX, widgetFrame3.pivotX, 0.5f, f);
        widgetFrame.pivotY = WidgetFrame.interpolate(widgetFrame2.pivotY, widgetFrame3.pivotY, 0.5f, f);
        widgetFrame.rotationX = WidgetFrame.interpolate(widgetFrame2.rotationX, widgetFrame3.rotationX, 0.0f, f);
        widgetFrame.rotationY = WidgetFrame.interpolate(widgetFrame2.rotationY, widgetFrame3.rotationY, 0.0f, f);
        widgetFrame.rotationZ = WidgetFrame.interpolate(widgetFrame2.rotationZ, widgetFrame3.rotationZ, 0.0f, f);
        widgetFrame.scaleX = WidgetFrame.interpolate(widgetFrame2.scaleX, widgetFrame3.scaleX, 1.0f, f);
        widgetFrame.scaleY = WidgetFrame.interpolate(widgetFrame2.scaleY, widgetFrame3.scaleY, 1.0f, f);
        widgetFrame.translationX = WidgetFrame.interpolate(widgetFrame2.translationX, widgetFrame3.translationX, 0.0f, f);
        widgetFrame.translationY = WidgetFrame.interpolate(widgetFrame2.translationY, widgetFrame3.translationY, 0.0f, f);
        widgetFrame.translationZ = WidgetFrame.interpolate(widgetFrame2.translationZ, widgetFrame3.translationZ, 0.0f, f);
        widgetFrame.alpha = WidgetFrame.interpolate(f5, f3, 1.0f, f);
        object = widgetFrame3.mCustom.keySet();
        widgetFrame.mCustom.clear();
        object = object.iterator();
        while (object.hasNext()) {
            Object object4 = (String)object.next();
            if (!widgetFrame2.mCustom.containsKey(object4)) continue;
            object3 = widgetFrame2.mCustom.get(object4);
            object2 = widgetFrame3.mCustom.get(object4);
            CustomVariable customVariable = new CustomVariable((CustomVariable)object3);
            widgetFrame.mCustom.put((String)object4, customVariable);
            if (((CustomVariable)object3).numberOfInterpolatedValues() == 1) {
                customVariable.setValue(Float.valueOf(WidgetFrame.interpolate(((CustomVariable)object3).getValueToInterpolate(), ((CustomVariable)object2).getValueToInterpolate(), 0.0f, f)));
                continue;
            }
            n2 = ((CustomVariable)object3).numberOfInterpolatedValues();
            float[] fArray = new float[n2];
            object4 = new float[n2];
            ((CustomVariable)object3).getValuesToInterpolate(fArray);
            ((CustomVariable)object2).getValuesToInterpolate((float[])object4);
            for (n = 0; n < n2; ++n) {
                fArray[n] = WidgetFrame.interpolate(fArray[n], (float)object4[n], 0.0f, f);
                customVariable.setValue(fArray);
            }
        }
    }

    private void serializeAnchor(StringBuilder stringBuilder, ConstraintAnchor.Type object) {
        ConstraintAnchor constraintAnchor = this.widget.getAnchor((ConstraintAnchor.Type)((Object)object));
        if (constraintAnchor != null && constraintAnchor.mTarget != null) {
            stringBuilder.append("Anchor");
            stringBuilder.append(object.name());
            stringBuilder.append(": ['");
            String string2 = constraintAnchor.mTarget.getOwner().stringId;
            object = string2;
            if (string2 == null) {
                object = "#PARENT";
            }
            stringBuilder.append((String)object);
            stringBuilder.append("', '");
            stringBuilder.append(constraintAnchor.mTarget.getType().name());
            stringBuilder.append("', '");
            stringBuilder.append(constraintAnchor.mMargin);
            stringBuilder.append("'],\n");
        }
    }

    public void addCustomColor(String string2, int n) {
        this.setCustomAttribute(string2, 902, n);
    }

    public void addCustomFloat(String string2, float f) {
        this.setCustomAttribute(string2, 901, f);
    }

    public float centerX() {
        int n = this.left;
        return (float)n + (float)(this.right - n) / 2.0f;
    }

    public float centerY() {
        int n = this.top;
        return (float)n + (float)(this.bottom - n) / 2.0f;
    }

    public CustomVariable getCustomAttribute(String string2) {
        return this.mCustom.get(string2);
    }

    public Set<String> getCustomAttributeNames() {
        return this.mCustom.keySet();
    }

    public int getCustomColor(String string2) {
        if (this.mCustom.containsKey(string2)) {
            return this.mCustom.get(string2).getColorValue();
        }
        return -21880;
    }

    public float getCustomFloat(String string2) {
        if (this.mCustom.containsKey(string2)) {
            return this.mCustom.get(string2).getFloatValue();
        }
        return Float.NaN;
    }

    public String getId() {
        ConstraintWidget constraintWidget = this.widget;
        if (constraintWidget == null) {
            return "unknown";
        }
        return constraintWidget.stringId;
    }

    public int height() {
        return Math.max(0, this.bottom - this.top);
    }

    public boolean isDefaultTransform() {
        boolean bl = Float.isNaN(this.rotationX) && Float.isNaN(this.rotationY) && Float.isNaN(this.rotationZ) && Float.isNaN(this.translationX) && Float.isNaN(this.translationY) && Float.isNaN(this.translationZ) && Float.isNaN(this.scaleX) && Float.isNaN(this.scaleY) && Float.isNaN(this.alpha);
        return bl;
    }

    void logv(String string2) {
        Object object = new Throwable().getStackTrace()[1];
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(".(");
        ((StringBuilder)charSequence).append(((StackTraceElement)object).getFileName());
        ((StringBuilder)charSequence).append(":");
        ((StringBuilder)charSequence).append(((StackTraceElement)object).getLineNumber());
        ((StringBuilder)charSequence).append(") ");
        ((StringBuilder)charSequence).append(((StackTraceElement)object).getMethodName());
        charSequence = ((StringBuilder)charSequence).toString();
        object = new StringBuilder();
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(this.hashCode() % 1000);
        object = ((StringBuilder)object).toString();
        if (this.widget != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("/");
            ((StringBuilder)charSequence).append(this.widget.hashCode() % 1000);
            object = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append("/NULL");
            object = ((StringBuilder)charSequence).toString();
        }
        PrintStream printStream = System.out;
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)object);
        ((StringBuilder)charSequence).append(" ");
        ((StringBuilder)charSequence).append(string2);
        printStream.println(((StringBuilder)charSequence).toString());
    }

    void parseCustom(CLElement cLElement) throws CLParsingException {
        CLObject cLObject = (CLObject)cLElement;
        int n = cLObject.size();
        for (int i = 0; i < n; ++i) {
            cLElement = (CLKey)cLObject.get(i);
            cLElement.content();
            CLElement cLElement2 = ((CLKey)cLElement).getValue();
            String string2 = cLElement2.content();
            if (string2.matches("#[0-9a-fA-F]+")) {
                int n2 = Integer.parseInt(string2.substring(1), 16);
                this.setCustomAttribute(cLElement.content(), 902, n2);
                continue;
            }
            if (cLElement2 instanceof CLNumber) {
                this.setCustomAttribute(cLElement.content(), 901, cLElement2.getFloat());
                continue;
            }
            this.setCustomAttribute(cLElement.content(), 903, string2);
        }
    }

    void printCustomAttributes() {
        Object object = new Throwable().getStackTrace()[1];
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append(".(");
        ((StringBuilder)object2).append(((StackTraceElement)object).getFileName());
        ((StringBuilder)object2).append(":");
        ((StringBuilder)object2).append(((StackTraceElement)object).getLineNumber());
        ((StringBuilder)object2).append(") ");
        ((StringBuilder)object2).append(((StackTraceElement)object).getMethodName());
        object = ((StringBuilder)object2).toString();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append(" ");
        ((StringBuilder)object2).append(this.hashCode() % 1000);
        object = ((StringBuilder)object2).toString();
        if (this.widget != null) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append("/");
            ((StringBuilder)object2).append(this.widget.hashCode() % 1000);
            ((StringBuilder)object2).append(" ");
            object = ((StringBuilder)object2).toString();
        } else {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append("/NULL ");
            object = ((StringBuilder)object2).toString();
        }
        object2 = this.mCustom;
        if (object2 != null) {
            for (String string2 : ((HashMap)object2).keySet()) {
                PrintStream printStream = System.out;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)object);
                stringBuilder.append(this.mCustom.get(string2).toString());
                printStream.println(stringBuilder.toString());
            }
        }
    }

    public StringBuilder serialize(StringBuilder stringBuilder) {
        return this.serialize(stringBuilder, false);
    }

    public StringBuilder serialize(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("{\n");
        WidgetFrame.add(stringBuilder, "left", this.left);
        WidgetFrame.add(stringBuilder, "top", this.top);
        WidgetFrame.add(stringBuilder, "right", this.right);
        WidgetFrame.add(stringBuilder, "bottom", this.bottom);
        WidgetFrame.add(stringBuilder, "pivotX", this.pivotX);
        WidgetFrame.add(stringBuilder, "pivotY", this.pivotY);
        WidgetFrame.add(stringBuilder, "rotationX", this.rotationX);
        WidgetFrame.add(stringBuilder, "rotationY", this.rotationY);
        WidgetFrame.add(stringBuilder, "rotationZ", this.rotationZ);
        WidgetFrame.add(stringBuilder, "translationX", this.translationX);
        WidgetFrame.add(stringBuilder, "translationY", this.translationY);
        WidgetFrame.add(stringBuilder, "translationZ", this.translationZ);
        WidgetFrame.add(stringBuilder, "scaleX", this.scaleX);
        WidgetFrame.add(stringBuilder, "scaleY", this.scaleY);
        WidgetFrame.add(stringBuilder, "alpha", this.alpha);
        WidgetFrame.add(stringBuilder, "visibility", this.visibility);
        WidgetFrame.add(stringBuilder, "interpolatedPos", this.interpolatedPos);
        if (this.widget != null) {
            ConstraintAnchor.Type[] object = ConstraintAnchor.Type.values();
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                this.serializeAnchor(stringBuilder, object[i]);
            }
        }
        if (bl) {
            WidgetFrame.add(stringBuilder, "phone_orientation", phone_orientation);
        }
        if (bl) {
            WidgetFrame.add(stringBuilder, "phone_orientation", phone_orientation);
        }
        if (this.mCustom.size() != 0) {
            stringBuilder.append("custom : {\n");
            block8: for (String string2 : this.mCustom.keySet()) {
                CustomVariable customVariable = this.mCustom.get(string2);
                stringBuilder.append(string2);
                stringBuilder.append(": ");
                switch (customVariable.getType()) {
                    default: {
                        continue block8;
                    }
                    case 904: {
                        stringBuilder.append("'");
                        stringBuilder.append(customVariable.getBooleanValue());
                        stringBuilder.append("',\n");
                        continue block8;
                    }
                    case 903: {
                        stringBuilder.append("'");
                        stringBuilder.append(customVariable.getStringValue());
                        stringBuilder.append("',\n");
                        continue block8;
                    }
                    case 902: {
                        stringBuilder.append("'");
                        stringBuilder.append(CustomVariable.colorString(customVariable.getIntegerValue()));
                        stringBuilder.append("',\n");
                        continue block8;
                    }
                    case 901: 
                    case 905: {
                        stringBuilder.append(customVariable.getFloatValue());
                        stringBuilder.append(",\n");
                        continue block8;
                    }
                    case 900: 
                }
                stringBuilder.append(customVariable.getIntegerValue());
                stringBuilder.append(",\n");
            }
            stringBuilder.append("}\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder;
    }

    public void setCustomAttribute(String string2, int n, float f) {
        if (this.mCustom.containsKey(string2)) {
            this.mCustom.get(string2).setFloatValue(f);
        } else {
            this.mCustom.put(string2, new CustomVariable(string2, n, f));
        }
    }

    public void setCustomAttribute(String string2, int n, int n2) {
        if (this.mCustom.containsKey(string2)) {
            this.mCustom.get(string2).setIntValue(n2);
        } else {
            this.mCustom.put(string2, new CustomVariable(string2, n, n2));
        }
    }

    public void setCustomAttribute(String string2, int n, String string3) {
        if (this.mCustom.containsKey(string2)) {
            this.mCustom.get(string2).setStringValue(string3);
        } else {
            this.mCustom.put(string2, new CustomVariable(string2, n, string3));
        }
    }

    public void setCustomAttribute(String string2, int n, boolean bl) {
        if (this.mCustom.containsKey(string2)) {
            this.mCustom.get(string2).setBooleanValue(bl);
        } else {
            this.mCustom.put(string2, new CustomVariable(string2, n, bl));
        }
    }

    public void setCustomValue(CustomAttribute customAttribute, float[] fArray) {
    }

    public boolean setValue(String string2, CLElement cLElement) throws CLParsingException {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 642850769: {
                if (!string2.equals("interpolatedPos")) break;
                n2 = 17;
                break;
            }
            case 108511772: {
                if (!string2.equals("right")) break;
                n2 = 16;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 15;
                break;
            }
            case 3317767: {
                if (!string2.equals("left")) break;
                n2 = 14;
                break;
            }
            case 115029: {
                if (!string2.equals("top")) break;
                n2 = 13;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 12;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 11;
                break;
            }
            case -987906985: {
                if (!string2.equals("pivotY")) break;
                n2 = 10;
                break;
            }
            case -987906986: {
                if (!string2.equals("pivotX")) break;
                n2 = 9;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 8;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 7;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 6;
                break;
            }
            case -1249320804: {
                if (!string2.equals("rotationZ")) break;
                n2 = 5;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 4;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 3;
                break;
            }
            case -1349088399: {
                if (!string2.equals("custom")) break;
                n2 = 2;
                break;
            }
            case -1383228885: {
                if (!string2.equals("bottom")) break;
                n2 = 1;
                break;
            }
            case -1881940865: {
                if (!string2.equals("phone_orientation")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return false;
            }
            case 17: {
                this.interpolatedPos = cLElement.getFloat();
                break;
            }
            case 16: {
                this.right = cLElement.getInt();
                break;
            }
            case 15: {
                this.alpha = cLElement.getFloat();
                break;
            }
            case 14: {
                this.left = cLElement.getInt();
                break;
            }
            case 13: {
                this.top = cLElement.getInt();
                break;
            }
            case 12: {
                this.scaleY = cLElement.getFloat();
                break;
            }
            case 11: {
                this.scaleX = cLElement.getFloat();
                break;
            }
            case 10: {
                this.pivotY = cLElement.getFloat();
                break;
            }
            case 9: {
                this.pivotX = cLElement.getFloat();
                break;
            }
            case 8: {
                this.translationZ = cLElement.getFloat();
                break;
            }
            case 7: {
                this.translationY = cLElement.getFloat();
                break;
            }
            case 6: {
                this.translationX = cLElement.getFloat();
                break;
            }
            case 5: {
                this.rotationZ = cLElement.getFloat();
                break;
            }
            case 4: {
                this.rotationY = cLElement.getFloat();
                break;
            }
            case 3: {
                this.rotationX = cLElement.getFloat();
                break;
            }
            case 2: {
                this.parseCustom(cLElement);
                break;
            }
            case 1: {
                this.bottom = cLElement.getInt();
                break;
            }
            case 0: {
                phone_orientation = cLElement.getFloat();
            }
        }
        return true;
    }

    public WidgetFrame update() {
        ConstraintWidget constraintWidget = this.widget;
        if (constraintWidget != null) {
            this.left = constraintWidget.getLeft();
            this.top = this.widget.getTop();
            this.right = this.widget.getRight();
            this.bottom = this.widget.getBottom();
            this.updateAttributes(this.widget.frame);
        }
        return this;
    }

    public WidgetFrame update(ConstraintWidget constraintWidget) {
        if (constraintWidget == null) {
            return this;
        }
        this.widget = constraintWidget;
        this.update();
        return this;
    }

    public void updateAttributes(WidgetFrame object2) {
        this.pivotX = ((WidgetFrame)object2).pivotX;
        this.pivotY = ((WidgetFrame)object2).pivotY;
        this.rotationX = ((WidgetFrame)object2).rotationX;
        this.rotationY = ((WidgetFrame)object2).rotationY;
        this.rotationZ = ((WidgetFrame)object2).rotationZ;
        this.translationX = ((WidgetFrame)object2).translationX;
        this.translationY = ((WidgetFrame)object2).translationY;
        this.translationZ = ((WidgetFrame)object2).translationZ;
        this.scaleX = ((WidgetFrame)object2).scaleX;
        this.scaleY = ((WidgetFrame)object2).scaleY;
        this.alpha = ((WidgetFrame)object2).alpha;
        this.visibility = ((WidgetFrame)object2).visibility;
        this.mCustom.clear();
        if (object2 != null) {
            for (CustomVariable customVariable : ((WidgetFrame)object2).mCustom.values()) {
                this.mCustom.put(customVariable.getName(), customVariable.copy());
            }
        }
    }

    public int width() {
        return Math.max(0, this.right - this.left);
    }
}

