/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.HelperWidget;
import java.util.HashMap;

public class Barrier
extends HelperWidget {
    public static final int BOTTOM = 3;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    private static final boolean USE_RELAX_GONE = false;
    private static final boolean USE_RESOLUTION = true;
    private boolean mAllowsGoneWidget = true;
    private int mBarrierType = 0;
    private int mMargin = 0;
    boolean resolved = false;

    public Barrier() {
    }

    public Barrier(String string2) {
        this.setDebugName(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addToSolver(LinearSystem linearSystem, boolean bl) {
        int n;
        int n2;
        Object object;
        ConstraintAnchor constraintAnchor;
        int n3;
        block13: {
            this.mListAnchors[0] = this.mLeft;
            this.mListAnchors[2] = this.mTop;
            this.mListAnchors[1] = this.mRight;
            this.mListAnchors[3] = this.mBottom;
            for (n3 = 0; n3 < this.mListAnchors.length; ++n3) {
                this.mListAnchors[n3].mSolverVariable = linearSystem.createObjectVariable(this.mListAnchors[n3]);
            }
            n3 = this.mBarrierType;
            if (n3 < 0) return;
            if (n3 >= 4) return;
            constraintAnchor = this.mListAnchors[this.mBarrierType];
            if (!this.resolved) {
                this.allSolved();
            }
            if (this.resolved) {
                this.resolved = false;
                n3 = this.mBarrierType;
                if (n3 != 0 && n3 != 1) {
                    if (n3 != 2) {
                        if (n3 != 3) return;
                    }
                    linearSystem.addEquality(this.mTop.mSolverVariable, this.mY);
                    linearSystem.addEquality(this.mBottom.mSolverVariable, this.mY);
                    return;
                }
                linearSystem.addEquality(this.mLeft.mSolverVariable, this.mX);
                linearSystem.addEquality(this.mRight.mSolverVariable, this.mX);
                return;
            }
            for (n3 = 0; n3 < this.mWidgetsCount; ++n3) {
                object = this.mWidgets[n3];
                if (!this.mAllowsGoneWidget && !((ConstraintWidget)object).allowedInBarrier() || ((n2 = this.mBarrierType) != 0 && n2 != 1 || ((ConstraintWidget)object).getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || ((ConstraintWidget)object).mLeft.mTarget == null || ((ConstraintWidget)object).mRight.mTarget == null) && ((n2 = this.mBarrierType) != 2 && n2 != 3 || ((ConstraintWidget)object).getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || ((ConstraintWidget)object).mTop.mTarget == null || ((ConstraintWidget)object).mBottom.mTarget == null)) continue;
                bl = true;
                break block13;
            }
            bl = false;
        }
        n3 = !this.mLeft.hasCenteredDependents() && !this.mRight.hasCenteredDependents() ? 0 : 1;
        n2 = !this.mTop.hasCenteredDependents() && !this.mBottom.hasCenteredDependents() ? 0 : 1;
        n2 = !bl && ((n = this.mBarrierType) == 0 && n3 != 0 || n == 2 && n2 != 0 || n == 1 && n3 != 0 || n == 3 && n2 != 0) ? 1 : 0;
        n3 = 5;
        if (n2 == 0) {
            n3 = 4;
        }
        for (n2 = 0; n2 < this.mWidgetsCount; ++n2) {
            ConstraintWidget constraintWidget = this.mWidgets[n2];
            if (!this.mAllowsGoneWidget && !constraintWidget.allowedInBarrier()) continue;
            constraintWidget.mListAnchors[this.mBarrierType].mSolverVariable = object = linearSystem.createObjectVariable(constraintWidget.mListAnchors[this.mBarrierType]);
            n = constraintWidget.mListAnchors[this.mBarrierType].mTarget != null && constraintWidget.mListAnchors[this.mBarrierType].mTarget.mOwner == this ? constraintWidget.mListAnchors[this.mBarrierType].mMargin + 0 : 0;
            int n4 = this.mBarrierType;
            if (n4 != 0 && n4 != 2) {
                linearSystem.addGreaterBarrier(constraintAnchor.mSolverVariable, (SolverVariable)object, this.mMargin + n, bl);
            } else {
                linearSystem.addLowerBarrier(constraintAnchor.mSolverVariable, (SolverVariable)object, this.mMargin - n, bl);
            }
            linearSystem.addEquality(constraintAnchor.mSolverVariable, (SolverVariable)object, this.mMargin + n, n3);
        }
        n3 = this.mBarrierType;
        if (n3 == 0) {
            linearSystem.addEquality(this.mRight.mSolverVariable, this.mLeft.mSolverVariable, 0, 8);
            linearSystem.addEquality(this.mLeft.mSolverVariable, this.mParent.mRight.mSolverVariable, 0, 4);
            linearSystem.addEquality(this.mLeft.mSolverVariable, this.mParent.mLeft.mSolverVariable, 0, 0);
            return;
        }
        if (n3 == 1) {
            linearSystem.addEquality(this.mLeft.mSolverVariable, this.mRight.mSolverVariable, 0, 8);
            linearSystem.addEquality(this.mLeft.mSolverVariable, this.mParent.mLeft.mSolverVariable, 0, 4);
            linearSystem.addEquality(this.mLeft.mSolverVariable, this.mParent.mRight.mSolverVariable, 0, 0);
            return;
        }
        if (n3 == 2) {
            linearSystem.addEquality(this.mBottom.mSolverVariable, this.mTop.mSolverVariable, 0, 8);
            linearSystem.addEquality(this.mTop.mSolverVariable, this.mParent.mBottom.mSolverVariable, 0, 4);
            linearSystem.addEquality(this.mTop.mSolverVariable, this.mParent.mTop.mSolverVariable, 0, 0);
            return;
        }
        if (n3 != 3) return;
        linearSystem.addEquality(this.mTop.mSolverVariable, this.mBottom.mSolverVariable, 0, 8);
        linearSystem.addEquality(this.mTop.mSolverVariable, this.mParent.mTop.mSolverVariable, 0, 4);
        linearSystem.addEquality(this.mTop.mSolverVariable, this.mParent.mBottom.mSolverVariable, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean allSolved() {
        int n;
        int n2;
        ConstraintWidget constraintWidget;
        int n3;
        int n4 = 0;
        int n5 = 1;
        for (n3 = 0; n3 < this.mWidgetsCount; ++n3) {
            block26: {
                block27: {
                    block28: {
                        block25: {
                            constraintWidget = this.mWidgets[n3];
                            if (this.mAllowsGoneWidget || constraintWidget.allowedInBarrier()) break block25;
                            n2 = n5;
                            break block26;
                        }
                        n2 = this.mBarrierType;
                        if ((n2 == 0 || n2 == 1) && !constraintWidget.isResolvedHorizontally()) break block27;
                        n = this.mBarrierType;
                        if (n == 2) break block28;
                        n2 = n5;
                        if (n != 3) break block26;
                    }
                    n2 = n5;
                    if (constraintWidget.isResolvedVertically()) break block26;
                }
                n2 = 0;
            }
            n5 = n2;
        }
        if (n5 != 0 && this.mWidgetsCount > 0) {
            n5 = 0;
            n = 0;
        } else {
            return false;
        }
        while (n4 < this.mWidgetsCount) {
            constraintWidget = this.mWidgets[n4];
            if (this.mAllowsGoneWidget || constraintWidget.allowedInBarrier()) {
                int n6;
                n2 = n5;
                n3 = n;
                if (n == 0) {
                    n3 = this.mBarrierType;
                    if (n3 == 0) {
                        n5 = constraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).getFinalValue();
                    } else if (n3 == 1) {
                        n5 = constraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).getFinalValue();
                    } else if (n3 == 2) {
                        n5 = constraintWidget.getAnchor(ConstraintAnchor.Type.TOP).getFinalValue();
                    } else if (n3 == 3) {
                        n5 = constraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).getFinalValue();
                    }
                    n3 = 1;
                    n2 = n5;
                }
                if ((n6 = this.mBarrierType) == 0) {
                    n5 = Math.min(n2, constraintWidget.getAnchor(ConstraintAnchor.Type.LEFT).getFinalValue());
                    n = n3;
                } else if (n6 == 1) {
                    n5 = Math.max(n2, constraintWidget.getAnchor(ConstraintAnchor.Type.RIGHT).getFinalValue());
                    n = n3;
                } else if (n6 == 2) {
                    n5 = Math.min(n2, constraintWidget.getAnchor(ConstraintAnchor.Type.TOP).getFinalValue());
                    n = n3;
                } else {
                    n5 = n2;
                    n = n3;
                    if (n6 == 3) {
                        n5 = Math.max(n2, constraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).getFinalValue());
                        n = n3;
                    }
                }
            }
            ++n4;
        }
        n5 += this.mMargin;
        n3 = this.mBarrierType;
        if (n3 != 0 && n3 != 1) {
            this.setFinalVertical(n5, n5);
        } else {
            this.setFinalHorizontal(n5, n5);
        }
        this.resolved = true;
        return true;
    }

    @Override
    public boolean allowedInBarrier() {
        return true;
    }

    @Deprecated
    public boolean allowsGoneWidget() {
        return this.mAllowsGoneWidget;
    }

    @Override
    public void copy(ConstraintWidget constraintWidget, HashMap<ConstraintWidget, ConstraintWidget> hashMap) {
        super.copy(constraintWidget, hashMap);
        constraintWidget = (Barrier)constraintWidget;
        this.mBarrierType = ((Barrier)constraintWidget).mBarrierType;
        this.mAllowsGoneWidget = ((Barrier)constraintWidget).mAllowsGoneWidget;
        this.mMargin = ((Barrier)constraintWidget).mMargin;
    }

    public boolean getAllowsGoneWidget() {
        return this.mAllowsGoneWidget;
    }

    public int getBarrierType() {
        return this.mBarrierType;
    }

    public int getMargin() {
        return this.mMargin;
    }

    public int getOrientation() {
        int n = this.mBarrierType;
        if (n != 0 && n != 1) {
            if (n != 2 && n != 3) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isResolvedHorizontally() {
        return this.resolved;
    }

    @Override
    public boolean isResolvedVertically() {
        return this.resolved;
    }

    protected void markWidgets() {
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget constraintWidget = this.mWidgets[i];
            if (!this.mAllowsGoneWidget && !constraintWidget.allowedInBarrier()) continue;
            int n = this.mBarrierType;
            if (n != 0 && n != 1) {
                if (n != 2 && n != 3) continue;
                constraintWidget.setInBarrier(1, true);
                continue;
            }
            constraintWidget.setInBarrier(0, true);
        }
    }

    public void setAllowsGoneWidget(boolean bl) {
        this.mAllowsGoneWidget = bl;
    }

    public void setBarrierType(int n) {
        this.mBarrierType = n;
    }

    public void setMargin(int n) {
        this.mMargin = n;
    }

    @Override
    public String toString() {
        CharSequence charSequence;
        CharSequence charSequence2 = new StringBuilder();
        ((StringBuilder)charSequence2).append("[Barrier] ");
        ((StringBuilder)charSequence2).append(this.getDebugName());
        ((StringBuilder)charSequence2).append(" {");
        charSequence2 = ((StringBuilder)charSequence2).toString();
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget constraintWidget = this.mWidgets[i];
            charSequence = charSequence2;
            if (i > 0) {
                charSequence = new StringBuilder();
                charSequence.append((String)charSequence2);
                charSequence.append(", ");
                charSequence = charSequence.toString();
            }
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append(constraintWidget.getDebugName());
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        charSequence = new StringBuilder();
        charSequence.append((String)charSequence2);
        charSequence.append("}");
        return charSequence.toString();
    }
}

