/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.Chain;
import androidx.constraintlayout.core.widgets.ChainHead;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import androidx.constraintlayout.core.widgets.WidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.DependencyGraph;
import androidx.constraintlayout.core.widgets.analyzer.Direct;
import androidx.constraintlayout.core.widgets.analyzer.Grouping;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ConstraintWidgetContainer
extends WidgetContainer {
    private static final boolean DEBUG = false;
    static final boolean DEBUG_GRAPH = false;
    private static final boolean DEBUG_LAYOUT = false;
    private static final int MAX_ITERATIONS = 8;
    static int myCounter;
    private WeakReference<ConstraintAnchor> horizontalWrapMax = null;
    private WeakReference<ConstraintAnchor> horizontalWrapMin = null;
    BasicMeasure mBasicMeasureSolver = new BasicMeasure(this);
    int mDebugSolverPassCount = 0;
    public DependencyGraph mDependencyGraph = new DependencyGraph(this);
    public boolean mGroupsWrapOptimized = false;
    private boolean mHeightMeasuredTooSmall = false;
    ChainHead[] mHorizontalChainsArray;
    public int mHorizontalChainsSize = 0;
    public boolean mHorizontalWrapOptimized = false;
    private boolean mIsRtl = false;
    public BasicMeasure.Measure mMeasure;
    protected BasicMeasure.Measurer mMeasurer = null;
    public Metrics mMetrics;
    private int mOptimizationLevel = 257;
    int mPaddingBottom;
    int mPaddingLeft;
    int mPaddingRight;
    int mPaddingTop;
    public boolean mSkipSolver = false;
    protected LinearSystem mSystem = new LinearSystem();
    ChainHead[] mVerticalChainsArray = new ChainHead[4];
    public int mVerticalChainsSize = 0;
    public boolean mVerticalWrapOptimized = false;
    private boolean mWidthMeasuredTooSmall = false;
    public int mWrapFixedHeight = 0;
    public int mWrapFixedWidth = 0;
    private int pass;
    private WeakReference<ConstraintAnchor> verticalWrapMax = null;
    private WeakReference<ConstraintAnchor> verticalWrapMin = null;
    HashSet<ConstraintWidget> widgetsToAdd;

    public ConstraintWidgetContainer() {
        this.mHorizontalChainsArray = new ChainHead[4];
        this.widgetsToAdd = new HashSet();
        this.mMeasure = new BasicMeasure.Measure();
    }

    public ConstraintWidgetContainer(int n, int n2) {
        super(n, n2);
        this.mHorizontalChainsArray = new ChainHead[4];
        this.widgetsToAdd = new HashSet();
        this.mMeasure = new BasicMeasure.Measure();
    }

    public ConstraintWidgetContainer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.mHorizontalChainsArray = new ChainHead[4];
        this.widgetsToAdd = new HashSet();
        this.mMeasure = new BasicMeasure.Measure();
    }

    public ConstraintWidgetContainer(String string2, int n, int n2) {
        super(n, n2);
        this.mHorizontalChainsArray = new ChainHead[4];
        this.widgetsToAdd = new HashSet();
        this.mMeasure = new BasicMeasure.Measure();
        this.setDebugName(string2);
    }

    private void addHorizontalChain(ConstraintWidget constraintWidget) {
        int n = this.mHorizontalChainsSize;
        ChainHead[] chainHeadArray = this.mHorizontalChainsArray;
        if (n + 1 >= chainHeadArray.length) {
            this.mHorizontalChainsArray = Arrays.copyOf(chainHeadArray, chainHeadArray.length * 2);
        }
        this.mHorizontalChainsArray[this.mHorizontalChainsSize] = new ChainHead(constraintWidget, 0, this.isRtl());
        ++this.mHorizontalChainsSize;
    }

    private void addMaxWrap(ConstraintAnchor object, SolverVariable solverVariable) {
        object = this.mSystem.createObjectVariable(object);
        this.mSystem.addGreaterThan(solverVariable, (SolverVariable)object, 0, 5);
    }

    private void addMinWrap(ConstraintAnchor object, SolverVariable solverVariable) {
        object = this.mSystem.createObjectVariable(object);
        this.mSystem.addGreaterThan((SolverVariable)object, solverVariable, 0, 5);
    }

    private void addVerticalChain(ConstraintWidget constraintWidget) {
        int n = this.mVerticalChainsSize;
        ChainHead[] chainHeadArray = this.mVerticalChainsArray;
        if (n + 1 >= chainHeadArray.length) {
            this.mVerticalChainsArray = Arrays.copyOf(chainHeadArray, chainHeadArray.length * 2);
        }
        this.mVerticalChainsArray[this.mVerticalChainsSize] = new ChainHead(constraintWidget, 1, this.isRtl());
        ++this.mVerticalChainsSize;
    }

    public static boolean measure(int n, ConstraintWidget constraintWidget, BasicMeasure.Measurer measurer, BasicMeasure.Measure measure, int n2) {
        if (measurer == null) {
            return false;
        }
        if (constraintWidget.getVisibility() != 8 && !(constraintWidget instanceof Guideline) && !(constraintWidget instanceof Barrier)) {
            measure.horizontalBehavior = constraintWidget.getHorizontalDimensionBehaviour();
            measure.verticalBehavior = constraintWidget.getVerticalDimensionBehaviour();
            measure.horizontalDimension = constraintWidget.getWidth();
            measure.verticalDimension = constraintWidget.getHeight();
            measure.measuredNeedsSolverPass = false;
            measure.measureStrategy = n2;
            n2 = measure.horizontalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
            n = measure.verticalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
            boolean bl = n2 != 0 && constraintWidget.mDimensionRatio > 0.0f;
            boolean bl2 = n != 0 && constraintWidget.mDimensionRatio > 0.0f;
            int n3 = n2;
            if (n2 != 0) {
                n3 = n2;
                if (constraintWidget.hasDanglingDimension(0)) {
                    n3 = n2;
                    if (constraintWidget.mMatchConstraintDefaultWidth == 0) {
                        n3 = n2;
                        if (!bl) {
                            measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                            if (n != 0 && constraintWidget.mMatchConstraintDefaultHeight == 0) {
                                measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                            }
                            n3 = 0;
                        }
                    }
                }
            }
            n2 = n;
            if (n != 0) {
                n2 = n;
                if (constraintWidget.hasDanglingDimension(1)) {
                    n2 = n;
                    if (constraintWidget.mMatchConstraintDefaultHeight == 0) {
                        n2 = n;
                        if (!bl2) {
                            measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                            if (n3 != 0 && constraintWidget.mMatchConstraintDefaultWidth == 0) {
                                measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                            }
                            n2 = 0;
                        }
                    }
                }
            }
            if (constraintWidget.isResolvedHorizontally()) {
                measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                n3 = 0;
            }
            if (constraintWidget.isResolvedVertically()) {
                measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                n2 = 0;
            }
            if (bl) {
                if (constraintWidget.mResolvedMatchConstraintDefault[0] == 4) {
                    measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                } else if (n2 == 0) {
                    if (measure.verticalBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                        n = measure.verticalDimension;
                    } else {
                        measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                        measurer.measure(constraintWidget, measure);
                        n = measure.measuredHeight;
                    }
                    measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                    measure.horizontalDimension = (int)(constraintWidget.getDimensionRatio() * (float)n);
                }
            }
            if (bl2) {
                if (constraintWidget.mResolvedMatchConstraintDefault[1] == 4) {
                    measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                } else if (n3 == 0) {
                    if (measure.horizontalBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                        n = measure.horizontalDimension;
                    } else {
                        measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                        measurer.measure(constraintWidget, measure);
                        n = measure.measuredWidth;
                    }
                    measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                    measure.verticalDimension = constraintWidget.getDimensionRatioSide() == -1 ? (int)((float)n / constraintWidget.getDimensionRatio()) : (int)(constraintWidget.getDimensionRatio() * (float)n);
                }
            }
            measurer.measure(constraintWidget, measure);
            constraintWidget.setWidth(measure.measuredWidth);
            constraintWidget.setHeight(measure.measuredHeight);
            constraintWidget.setHasBaseline(measure.measuredHasBaseline);
            constraintWidget.setBaselineDistance(measure.measuredBaseline);
            measure.measureStrategy = BasicMeasure.Measure.SELF_DIMENSIONS;
            return measure.measuredNeedsSolverPass;
        }
        measure.measuredWidth = 0;
        measure.measuredHeight = 0;
        return false;
    }

    private void resetChains() {
        this.mHorizontalChainsSize = 0;
        this.mVerticalChainsSize = 0;
    }

    void addChain(ConstraintWidget constraintWidget, int n) {
        if (n == 0) {
            this.addHorizontalChain(constraintWidget);
        } else if (n == 1) {
            this.addVerticalChain(constraintWidget);
        }
    }

    public boolean addChildrenToSolver(LinearSystem linearSystem) {
        Object object;
        Object object2;
        int n;
        boolean bl = this.optimizeFor(64);
        this.addToSolver(linearSystem, bl);
        int n2 = this.mChildren.size();
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            object2 = (ConstraintWidget)this.mChildren.get(n);
            ((ConstraintWidget)object2).setInBarrier(0, false);
            ((ConstraintWidget)object2).setInBarrier(1, false);
            if (!(object2 instanceof Barrier)) continue;
            bl2 = true;
        }
        if (bl2) {
            for (n = 0; n < n2; ++n) {
                object2 = (ConstraintWidget)this.mChildren.get(n);
                if (!(object2 instanceof Barrier)) continue;
                ((Barrier)object2).markWidgets();
            }
        }
        this.widgetsToAdd.clear();
        for (n = 0; n < n2; ++n) {
            object2 = (ConstraintWidget)this.mChildren.get(n);
            if (!((ConstraintWidget)object2).addFirst()) continue;
            if (object2 instanceof VirtualLayout) {
                this.widgetsToAdd.add((ConstraintWidget)object2);
                continue;
            }
            ((ConstraintWidget)object2).addToSolver(linearSystem, bl);
        }
        while (this.widgetsToAdd.size() > 0) {
            n = this.widgetsToAdd.size();
            object = this.widgetsToAdd.iterator();
            while (object.hasNext()) {
                object2 = (VirtualLayout)((ConstraintWidget)object.next());
                if (!((VirtualLayout)object2).contains(this.widgetsToAdd)) continue;
                ((ConstraintWidget)object2).addToSolver(linearSystem, bl);
                this.widgetsToAdd.remove(object2);
                break;
            }
            if (n != this.widgetsToAdd.size()) continue;
            object2 = this.widgetsToAdd.iterator();
            while (object2.hasNext()) {
                ((ConstraintWidget)object2.next()).addToSolver(linearSystem, bl);
            }
            this.widgetsToAdd.clear();
        }
        if (LinearSystem.USE_DEPENDENCY_ORDERING) {
            object = new HashSet();
            for (n = 0; n < n2; ++n) {
                object2 = (ConstraintWidget)this.mChildren.get(n);
                if (((ConstraintWidget)object2).addFirst()) continue;
                ((HashSet)object).add(object2);
            }
            n = this.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT ? 0 : 1;
            this.addChildrenToSolverByDependency(this, linearSystem, (HashSet<ConstraintWidget>)object, n, false);
            object2 = ((HashSet)object).iterator();
            while (object2.hasNext()) {
                object = (ConstraintWidget)object2.next();
                Optimizer.checkMatchParent(this, linearSystem, (ConstraintWidget)object);
                ((ConstraintWidget)object).addToSolver(linearSystem, bl);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                object = (ConstraintWidget)this.mChildren.get(n);
                if (object instanceof ConstraintWidgetContainer) {
                    ConstraintWidget.DimensionBehaviour dimensionBehaviour = ((ConstraintWidget)object).mListDimensionBehaviors[0];
                    object2 = ((ConstraintWidget)object).mListDimensionBehaviors[1];
                    if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        ((ConstraintWidget)object).setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    }
                    if (object2 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        ((ConstraintWidget)object).setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    }
                    ((ConstraintWidget)object).addToSolver(linearSystem, bl);
                    if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        ((ConstraintWidget)object).setHorizontalDimensionBehaviour(dimensionBehaviour);
                    }
                    if (object2 != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) continue;
                    ((ConstraintWidget)object).setVerticalDimensionBehaviour((ConstraintWidget.DimensionBehaviour)((Object)object2));
                    continue;
                }
                Optimizer.checkMatchParent(this, linearSystem, (ConstraintWidget)object);
                if (((ConstraintWidget)object).addFirst()) continue;
                ((ConstraintWidget)object).addToSolver(linearSystem, bl);
            }
        }
        if (this.mHorizontalChainsSize > 0) {
            Chain.applyChainConstraints(this, linearSystem, null, 0);
        }
        if (this.mVerticalChainsSize > 0) {
            Chain.applyChainConstraints(this, linearSystem, null, 1);
        }
        return true;
    }

    public void addHorizontalWrapMaxVariable(ConstraintAnchor constraintAnchor) {
        WeakReference<ConstraintAnchor> weakReference = this.horizontalWrapMax;
        if (weakReference == null || weakReference.get() == null || constraintAnchor.getFinalValue() > ((ConstraintAnchor)this.horizontalWrapMax.get()).getFinalValue()) {
            this.horizontalWrapMax = new WeakReference<ConstraintAnchor>(constraintAnchor);
        }
    }

    public void addHorizontalWrapMinVariable(ConstraintAnchor constraintAnchor) {
        WeakReference<ConstraintAnchor> weakReference = this.horizontalWrapMin;
        if (weakReference == null || weakReference.get() == null || constraintAnchor.getFinalValue() > ((ConstraintAnchor)this.horizontalWrapMin.get()).getFinalValue()) {
            this.horizontalWrapMin = new WeakReference<ConstraintAnchor>(constraintAnchor);
        }
    }

    void addVerticalWrapMaxVariable(ConstraintAnchor constraintAnchor) {
        WeakReference<ConstraintAnchor> weakReference = this.verticalWrapMax;
        if (weakReference == null || weakReference.get() == null || constraintAnchor.getFinalValue() > ((ConstraintAnchor)this.verticalWrapMax.get()).getFinalValue()) {
            this.verticalWrapMax = new WeakReference<ConstraintAnchor>(constraintAnchor);
        }
    }

    void addVerticalWrapMinVariable(ConstraintAnchor constraintAnchor) {
        WeakReference<ConstraintAnchor> weakReference = this.verticalWrapMin;
        if (weakReference == null || weakReference.get() == null || constraintAnchor.getFinalValue() > ((ConstraintAnchor)this.verticalWrapMin.get()).getFinalValue()) {
            this.verticalWrapMin = new WeakReference<ConstraintAnchor>(constraintAnchor);
        }
    }

    public void defineTerminalWidgets() {
        this.mDependencyGraph.defineTerminalWidgets(this.getHorizontalDimensionBehaviour(), this.getVerticalDimensionBehaviour());
    }

    public boolean directMeasure(boolean bl) {
        return this.mDependencyGraph.directMeasure(bl);
    }

    public boolean directMeasureSetup(boolean bl) {
        return this.mDependencyGraph.directMeasureSetup(bl);
    }

    public boolean directMeasureWithOrientation(boolean bl, int n) {
        return this.mDependencyGraph.directMeasureWithOrientation(bl, n);
    }

    public void fillMetrics(Metrics metrics) {
        this.mMetrics = metrics;
        this.mSystem.fillMetrics(metrics);
    }

    public ArrayList<Guideline> getHorizontalGuidelines() {
        ArrayList<Guideline> arrayList = new ArrayList<Guideline>();
        int n = this.mChildren.size();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget constraintWidget = (ConstraintWidget)this.mChildren.get(i);
            if (!(constraintWidget instanceof Guideline) || ((Guideline)(constraintWidget = (Guideline)constraintWidget)).getOrientation() != 0) continue;
            arrayList.add((Guideline)constraintWidget);
        }
        return arrayList;
    }

    public BasicMeasure.Measurer getMeasurer() {
        return this.mMeasurer;
    }

    public int getOptimizationLevel() {
        return this.mOptimizationLevel;
    }

    @Override
    public void getSceneString(StringBuilder stringBuilder) {
        Object object = new StringBuilder();
        ((StringBuilder)object).append(this.stringId);
        ((StringBuilder)object).append(":{\n");
        stringBuilder.append(((StringBuilder)object).toString());
        object = new StringBuilder();
        ((StringBuilder)object).append("  actualWidth:");
        ((StringBuilder)object).append(this.mWidth);
        stringBuilder.append(((StringBuilder)object).toString());
        stringBuilder.append("\n");
        object = new StringBuilder();
        ((StringBuilder)object).append("  actualHeight:");
        ((StringBuilder)object).append(this.mHeight);
        stringBuilder.append(((StringBuilder)object).toString());
        stringBuilder.append("\n");
        object = this.getChildren().iterator();
        while (object.hasNext()) {
            ((ConstraintWidget)object.next()).getSceneString(stringBuilder);
            stringBuilder.append(",\n");
        }
        stringBuilder.append("}");
    }

    public LinearSystem getSystem() {
        return this.mSystem;
    }

    @Override
    public String getType() {
        return "ConstraintLayout";
    }

    public ArrayList<Guideline> getVerticalGuidelines() {
        ArrayList<Guideline> arrayList = new ArrayList<Guideline>();
        int n = this.mChildren.size();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget constraintWidget = (ConstraintWidget)this.mChildren.get(i);
            if (!(constraintWidget instanceof Guideline) || ((Guideline)(constraintWidget = (Guideline)constraintWidget)).getOrientation() != 1) continue;
            arrayList.add((Guideline)constraintWidget);
        }
        return arrayList;
    }

    public boolean handlesInternalConstraints() {
        return false;
    }

    public void invalidateGraph() {
        this.mDependencyGraph.invalidateGraph();
    }

    public void invalidateMeasures() {
        this.mDependencyGraph.invalidateMeasures();
    }

    public boolean isHeightMeasuredTooSmall() {
        return this.mHeightMeasuredTooSmall;
    }

    public boolean isRtl() {
        return this.mIsRtl;
    }

    public boolean isWidthMeasuredTooSmall() {
        return this.mWidthMeasuredTooSmall;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void layout() {
        this.mX = 0;
        this.mY = 0;
        this.mWidthMeasuredTooSmall = false;
        this.mHeightMeasuredTooSmall = false;
        var1_1 = this.mChildren.size();
        var2_2 = Math.max(0, this.getWidth());
        var3_3 = Math.max(0, this.getHeight());
        var4_4 = this.mListDimensionBehaviors[1];
        var5_5 = this.mListDimensionBehaviors[0];
        var6_6 = this.mMetrics;
        if (var6_6 != null) {
            ++var6_6.layouts;
        }
        if (this.pass == 0 && Optimizer.enabled(this.mOptimizationLevel, 1)) {
            Direct.solvingPass(this, this.getMeasurer());
            for (var7_7 = 0; var7_7 < var1_1; ++var7_7) {
                var6_6 = (ConstraintWidget)this.mChildren.get(var7_7);
                if (!var6_6.isMeasureRequested() || var6_6 instanceof Guideline || var6_6 instanceof Barrier || var6_6 instanceof VirtualLayout || var6_6.isInVirtualLayout()) continue;
                var8_8 = var6_6.getDimensionBehaviour(0);
                var9_9 = var6_6.getDimensionBehaviour(1);
                var10_10 = var8_8 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && var6_6.mMatchConstraintDefaultWidth != 1 && var9_9 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && var6_6.mMatchConstraintDefaultHeight != 1 ? 1 : 0;
                if (var10_10 != 0) continue;
                var8_8 = new BasicMeasure.Measure();
                ConstraintWidgetContainer.measure(0, (ConstraintWidget)var6_6, this.mMeasurer, (BasicMeasure.Measure)var8_8, BasicMeasure.Measure.SELF_DIMENSIONS);
            }
        }
        if (var1_1 > 2 && (var5_5 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || var4_4 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) && Optimizer.enabled(this.mOptimizationLevel, 1024) && Grouping.simpleSolvingPass(this, this.getMeasurer())) {
            var7_7 = var2_2;
            if (var5_5 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (var2_2 < this.getWidth() && var2_2 > 0) {
                    this.setWidth(var2_2);
                    this.mWidthMeasuredTooSmall = true;
                    var7_7 = var2_2;
                } else {
                    var7_7 = this.getWidth();
                }
            }
            var2_2 = var3_3;
            if (var4_4 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (var3_3 < this.getHeight() && var3_3 > 0) {
                    this.setHeight(var3_3);
                    this.mHeightMeasuredTooSmall = true;
                    var2_2 = var3_3;
                } else {
                    var2_2 = this.getHeight();
                }
            }
            var10_10 = var7_7;
            var7_7 = 1;
            var11_11 = var2_2;
        } else {
            var7_7 = 0;
            var11_11 = var3_3;
            var10_10 = var2_2;
        }
        var2_2 = !this.optimizeFor(64) && !this.optimizeFor(128) ? 0 : 1;
        this.mSystem.graphOptimizer = false;
        this.mSystem.newgraphOptimizer = false;
        if (this.mOptimizationLevel != 0 && var2_2 != 0) {
            this.mSystem.newgraphOptimizer = true;
        }
        var6_6 = this.mChildren;
        var12_12 = this.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || this.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        this.resetChains();
        for (var2_2 = 0; var2_2 < var1_1; ++var2_2) {
            var8_8 = (ConstraintWidget)this.mChildren.get(var2_2);
            if (!(var8_8 instanceof WidgetContainer)) continue;
            ((WidgetContainer)var8_8).layout();
        }
        var13_13 = this.optimizeFor(64);
        var2_2 = 0;
        var14_14 = true;
        while (var14_14) {
            block59: {
                block58: {
                    block57: {
                        block56: {
                            block55: {
                                var15_15 = var2_2 + 1;
                                var16_16 = var14_14;
                                this.mSystem.reset();
                                var16_16 = var14_14;
                                this.resetChains();
                                var16_16 = var14_14;
                                this.createObjectVariables(this.mSystem);
                                for (var2_2 = 0; var2_2 < var1_1; ++var2_2) {
                                    var16_16 = var14_14;
                                    ((ConstraintWidget)this.mChildren.get(var2_2)).createObjectVariables(this.mSystem);
                                    continue;
                                }
                                var16_16 = var14_14;
                                var16_16 = var14_14 = this.addChildrenToSolver(this.mSystem);
                                var8_8 = this.verticalWrapMin;
                                if (var8_8 == null) break block55;
                                var16_16 = var14_14;
                                if (var8_8.get() == null) break block55;
                                var16_16 = var14_14;
                                this.addMinWrap((ConstraintAnchor)this.verticalWrapMin.get(), this.mSystem.createObjectVariable(this.mTop));
                                var16_16 = var14_14;
                                this.verticalWrapMin = null;
                            }
                            var16_16 = var14_14;
                            var8_8 = this.verticalWrapMax;
                            if (var8_8 == null) break block56;
                            var16_16 = var14_14;
                            if (var8_8.get() == null) break block56;
                            var16_16 = var14_14;
                            this.addMaxWrap((ConstraintAnchor)this.verticalWrapMax.get(), this.mSystem.createObjectVariable(this.mBottom));
                            var16_16 = var14_14;
                            this.verticalWrapMax = null;
                        }
                        var16_16 = var14_14;
                        var8_8 = this.horizontalWrapMin;
                        if (var8_8 == null) break block57;
                        var16_16 = var14_14;
                        if (var8_8.get() == null) break block57;
                        var16_16 = var14_14;
                        this.addMinWrap((ConstraintAnchor)this.horizontalWrapMin.get(), this.mSystem.createObjectVariable(this.mLeft));
                        var16_16 = var14_14;
                        this.horizontalWrapMin = null;
                    }
                    var16_16 = var14_14;
                    var8_8 = this.horizontalWrapMax;
                    if (var8_8 == null) break block58;
                    var16_16 = var14_14;
                    if (var8_8.get() == null) break block58;
                    var16_16 = var14_14;
                    this.addMaxWrap((ConstraintAnchor)this.horizontalWrapMax.get(), this.mSystem.createObjectVariable(this.mRight));
                    var16_16 = var14_14;
                    this.horizontalWrapMax = null;
                }
                var16_16 = var14_14;
                if (!var14_14) break block59;
                var16_16 = var14_14;
                try {
                    this.mSystem.minimize();
                    var16_16 = var14_14;
                }
                catch (Exception var17_17) {
                    var17_17.printStackTrace();
                    var8_8 = System.out;
                    var9_9 = new StringBuilder();
                    var9_9.append("EXCEPTION : ");
                    var9_9.append(var17_17);
                    var8_8.println(var9_9.toString());
                }
            }
            if (var16_16) {
                var16_16 = this.updateChildrenFromSolver(this.mSystem, Optimizer.flags);
            } else {
                this.updateFromSolver(this.mSystem, var13_13);
                for (var2_2 = 0; var2_2 < var1_1; ++var2_2) {
                    ((ConstraintWidget)this.mChildren.get(var2_2)).updateFromSolver(this.mSystem, var13_13);
                }
                var16_16 = false;
            }
            if (var12_12 && var15_15 < 8 && Optimizer.flags[2]) {
                var2_2 = 0;
                var3_3 = 0;
                for (var18_18 = 0; var18_18 < var1_1; ++var18_18) {
                    var8_8 = (ConstraintWidget)this.mChildren.get(var18_18);
                    var3_3 = Math.max(var3_3, var8_8.mX + var8_8.getWidth());
                    var2_2 = Math.max(var2_2, var8_8.mY + var8_8.getHeight());
                }
                var18_18 = Math.max(this.mMinWidth, var3_3);
                var3_3 = Math.max(this.mMinHeight, var2_2);
                var2_2 = var7_7;
                var14_14 = var16_16;
                if (var5_5 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    var2_2 = var7_7;
                    var14_14 = var16_16;
                    if (this.getWidth() < var18_18) {
                        this.setWidth(var18_18);
                        this.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                        var2_2 = 1;
                        var14_14 = true;
                    }
                }
                var7_7 = var2_2;
                var16_16 = var14_14;
                if (var4_4 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    var7_7 = var2_2;
                    var16_16 = var14_14;
                    if (this.getHeight() < var3_3) {
                        this.setHeight(var3_3);
                        this.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                        var7_7 = 1;
                        var16_16 = true;
                    }
                }
            }
            if ((var2_2 = Math.max(this.mMinWidth, this.getWidth())) > this.getWidth()) {
                this.setWidth(var2_2);
                this.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.FIXED;
                var7_7 = 1;
                var16_16 = true;
            }
            if ((var2_2 = Math.max(this.mMinHeight, this.getHeight())) > this.getHeight()) {
                this.setHeight(var2_2);
                this.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.FIXED;
                var7_7 = 1;
                var16_16 = true;
            }
            var2_2 = var7_7;
            var19_19 = var16_16;
            if (var7_7 != 0) ** GOTO lbl-1000
            var3_3 = var7_7;
            var14_14 = var16_16;
            if (this.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                var3_3 = var7_7;
                var14_14 = var16_16;
                if (var10_10 > 0) {
                    var3_3 = var7_7;
                    var14_14 = var16_16;
                    if (this.getWidth() > var10_10) {
                        this.mWidthMeasuredTooSmall = true;
                        this.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.FIXED;
                        this.setWidth(var10_10);
                        var3_3 = 1;
                        var14_14 = true;
                    }
                }
            }
            var2_2 = var3_3;
            var19_19 = var14_14;
            if (this.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) ** GOTO lbl-1000
            var2_2 = var3_3;
            var19_19 = var14_14;
            if (var11_11 <= 0) ** GOTO lbl-1000
            var2_2 = var3_3;
            var19_19 = var14_14;
            if (this.getHeight() > var11_11) {
                this.mHeightMeasuredTooSmall = true;
                this.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.FIXED;
                this.setHeight(var11_11);
                var16_16 = true;
                var7_7 = 1;
            } else lbl-1000:
            // 4 sources

            {
                var16_16 = var19_19;
                var7_7 = var2_2;
            }
            var14_14 = var15_15 > 8 ? false : var16_16;
            var2_2 = var15_15;
        }
        var8_8 = (ArrayList)var6_6;
        this.mChildren = var6_6;
        if (var7_7 != 0) {
            this.mListDimensionBehaviors[0] = var5_5;
            this.mListDimensionBehaviors[1] = var4_4;
        }
        this.resetSolverVariables(this.mSystem.getCache());
    }

    public long measure(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.mPaddingLeft = n8;
        this.mPaddingTop = n9;
        return this.mBasicMeasureSolver.solverMeasure(this, n, n8, n9, n2, n3, n4, n5, n6, n7);
    }

    public boolean optimizeFor(int n) {
        boolean bl = (this.mOptimizationLevel & n) == n;
        return bl;
    }

    @Override
    public void reset() {
        this.mSystem.reset();
        this.mPaddingLeft = 0;
        this.mPaddingRight = 0;
        this.mPaddingTop = 0;
        this.mPaddingBottom = 0;
        this.mSkipSolver = false;
        super.reset();
    }

    public void setMeasurer(BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
        this.mDependencyGraph.setMeasurer(measurer);
    }

    public void setOptimizationLevel(int n) {
        this.mOptimizationLevel = n;
        LinearSystem.USE_DEPENDENCY_ORDERING = this.optimizeFor(512);
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.mPaddingLeft = n;
        this.mPaddingTop = n2;
        this.mPaddingRight = n3;
        this.mPaddingBottom = n4;
    }

    public void setPass(int n) {
        this.pass = n;
    }

    public void setRtl(boolean bl) {
        this.mIsRtl = bl;
    }

    public boolean updateChildrenFromSolver(LinearSystem linearSystem, boolean[] object) {
        object[2] = false;
        boolean bl = this.optimizeFor(64);
        this.updateFromSolver(linearSystem, bl);
        int n = this.mChildren.size();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            object = (ConstraintWidget)this.mChildren.get(i);
            ((ConstraintWidget)object).updateFromSolver(linearSystem, bl);
            if (!((ConstraintWidget)object).hasDimensionOverride()) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void updateFromRuns(boolean bl, boolean bl2) {
        super.updateFromRuns(bl, bl2);
        int n = this.mChildren.size();
        for (int i = 0; i < n; ++i) {
            ((ConstraintWidget)this.mChildren.get(i)).updateFromRuns(bl, bl2);
        }
    }

    public void updateHierarchy() {
        this.mBasicMeasureSolver.updateHierarchy(this);
    }
}

