/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Flow
extends VirtualLayout {
    public static final int HORIZONTAL_ALIGN_CENTER = 2;
    public static final int HORIZONTAL_ALIGN_END = 1;
    public static final int HORIZONTAL_ALIGN_START = 0;
    public static final int VERTICAL_ALIGN_BASELINE = 3;
    public static final int VERTICAL_ALIGN_BOTTOM = 1;
    public static final int VERTICAL_ALIGN_CENTER = 2;
    public static final int VERTICAL_ALIGN_TOP = 0;
    public static final int WRAP_ALIGNED = 2;
    public static final int WRAP_CHAIN = 1;
    public static final int WRAP_CHAIN_NEW = 3;
    public static final int WRAP_NONE = 0;
    private ConstraintWidget[] mAlignedBiggestElementsInCols = null;
    private ConstraintWidget[] mAlignedBiggestElementsInRows = null;
    private int[] mAlignedDimensions = null;
    private ArrayList<WidgetsList> mChainList = new ArrayList();
    private ConstraintWidget[] mDisplayedWidgets;
    private int mDisplayedWidgetsCount = 0;
    private float mFirstHorizontalBias = 0.5f;
    private int mFirstHorizontalStyle = -1;
    private float mFirstVerticalBias = 0.5f;
    private int mFirstVerticalStyle = -1;
    private int mHorizontalAlign = 2;
    private float mHorizontalBias = 0.5f;
    private int mHorizontalGap = 0;
    private int mHorizontalStyle = -1;
    private float mLastHorizontalBias = 0.5f;
    private int mLastHorizontalStyle = -1;
    private float mLastVerticalBias = 0.5f;
    private int mLastVerticalStyle = -1;
    private int mMaxElementsWrap = -1;
    private int mOrientation = 0;
    private int mVerticalAlign = 2;
    private float mVerticalBias = 0.5f;
    private int mVerticalGap = 0;
    private int mVerticalStyle = -1;
    private int mWrapMode = 0;

    static /* synthetic */ int access$1000(Flow flow) {
        return flow.mFirstHorizontalStyle;
    }

    static /* synthetic */ float access$1100(Flow flow) {
        return flow.mFirstHorizontalBias;
    }

    static /* synthetic */ int access$1200(Flow flow) {
        return flow.mLastHorizontalStyle;
    }

    static /* synthetic */ float access$1300(Flow flow) {
        return flow.mLastHorizontalBias;
    }

    static /* synthetic */ float access$1400(Flow flow) {
        return flow.mVerticalBias;
    }

    static /* synthetic */ int access$1500(Flow flow) {
        return flow.mFirstVerticalStyle;
    }

    static /* synthetic */ float access$1600(Flow flow) {
        return flow.mFirstVerticalBias;
    }

    static /* synthetic */ int access$1700(Flow flow) {
        return flow.mLastVerticalStyle;
    }

    static /* synthetic */ float access$1800(Flow flow) {
        return flow.mLastVerticalBias;
    }

    static /* synthetic */ int access$1900(Flow flow) {
        return flow.mHorizontalAlign;
    }

    static /* synthetic */ int access$600(Flow flow) {
        return flow.mVerticalStyle;
    }

    static /* synthetic */ int access$700(Flow flow) {
        return flow.mVerticalAlign;
    }

    static /* synthetic */ int access$800(Flow flow) {
        return flow.mHorizontalStyle;
    }

    static /* synthetic */ float access$900(Flow flow) {
        return flow.mHorizontalBias;
    }

    private void createAlignedConstraints(boolean bl) {
        if (this.mAlignedDimensions != null && this.mAlignedBiggestElementsInCols != null && this.mAlignedBiggestElementsInRows != null) {
            Object object;
            Object object2;
            int n;
            int n2;
            for (n2 = 0; n2 < this.mDisplayedWidgetsCount; ++n2) {
                this.mDisplayedWidgets[n2].resetAnchors();
            }
            Object object3 = this.mAlignedDimensions;
            int n3 = object3[0];
            int n4 = object3[1];
            object3 = null;
            float f = this.mHorizontalBias;
            for (n2 = 0; n2 < n3; ++n2) {
                if (bl) {
                    n = n3 - n2 - 1;
                    f = 1.0f - this.mHorizontalBias;
                } else {
                    n = n2;
                }
                object2 = this.mAlignedBiggestElementsInCols[n];
                object = object3;
                if (object2 != null) {
                    if (((ConstraintWidget)object2).getVisibility() == 8) {
                        object = object3;
                    } else {
                        if (n2 == 0) {
                            ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mLeft, this.mLeft, this.getPaddingLeft());
                            ((ConstraintWidget)object2).setHorizontalChainStyle(this.mHorizontalStyle);
                            ((ConstraintWidget)object2).setHorizontalBiasPercent(f);
                        }
                        if (n2 == n3 - 1) {
                            ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mRight, this.mRight, this.getPaddingRight());
                        }
                        if (n2 > 0 && object3 != null) {
                            ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mLeft, object3.mRight, this.mHorizontalGap);
                            object3.connect(object3.mRight, ((ConstraintWidget)object2).mLeft, 0);
                        }
                        object = object2;
                    }
                }
                object3 = object;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                object2 = this.mAlignedBiggestElementsInRows[n2];
                object = object3;
                if (object2 != null) {
                    if (((ConstraintWidget)object2).getVisibility() == 8) {
                        object = object3;
                    } else {
                        if (n2 == 0) {
                            ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mTop, this.mTop, this.getPaddingTop());
                            ((ConstraintWidget)object2).setVerticalChainStyle(this.mVerticalStyle);
                            ((ConstraintWidget)object2).setVerticalBiasPercent(this.mVerticalBias);
                        }
                        if (n2 == n4 - 1) {
                            ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mBottom, this.mBottom, this.getPaddingBottom());
                        }
                        if (n2 > 0 && object3 != null) {
                            ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mTop, object3.mBottom, this.mVerticalGap);
                            object3.connect(object3.mBottom, ((ConstraintWidget)object2).mTop, 0);
                        }
                        object = object2;
                    }
                }
                object3 = object;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    int n5 = n * n3 + n2;
                    if (this.mOrientation == 1) {
                        n5 = n2 * n4 + n;
                    }
                    if (n5 >= ((int[])(object3 = (Object)this.mDisplayedWidgets)).length || (object2 = (Object)object3[n5]) == null || ((ConstraintWidget)object2).getVisibility() == 8) continue;
                    object3 = this.mAlignedBiggestElementsInCols[n2];
                    object = this.mAlignedBiggestElementsInRows[n];
                    if (object2 != object3) {
                        ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mLeft, object3.mLeft, 0);
                        ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mRight, object3.mRight, 0);
                    }
                    if (object2 == object) continue;
                    ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mTop, object.mTop, 0);
                    ((ConstraintWidget)object2).connect(((ConstraintWidget)object2).mBottom, object.mBottom, 0);
                }
            }
        }
    }

    private final int getWidgetHeight(ConstraintWidget constraintWidget, int n) {
        if (constraintWidget == null) {
            return 0;
        }
        if (constraintWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            if (constraintWidget.mMatchConstraintDefaultHeight == 0) {
                return 0;
            }
            if (constraintWidget.mMatchConstraintDefaultHeight == 2) {
                if ((n = (int)(constraintWidget.mMatchConstraintPercentHeight * (float)n)) != constraintWidget.getHeight()) {
                    constraintWidget.setMeasureRequested(true);
                    this.measure(constraintWidget, constraintWidget.getHorizontalDimensionBehaviour(), constraintWidget.getWidth(), ConstraintWidget.DimensionBehaviour.FIXED, n);
                }
                return n;
            }
            if (constraintWidget.mMatchConstraintDefaultHeight == 1) {
                return constraintWidget.getHeight();
            }
            if (constraintWidget.mMatchConstraintDefaultHeight == 3) {
                return (int)((float)constraintWidget.getWidth() * constraintWidget.mDimensionRatio + 0.5f);
            }
        }
        return constraintWidget.getHeight();
    }

    private final int getWidgetWidth(ConstraintWidget constraintWidget, int n) {
        if (constraintWidget == null) {
            return 0;
        }
        if (constraintWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            if (constraintWidget.mMatchConstraintDefaultWidth == 0) {
                return 0;
            }
            if (constraintWidget.mMatchConstraintDefaultWidth == 2) {
                if ((n = (int)(constraintWidget.mMatchConstraintPercentWidth * (float)n)) != constraintWidget.getWidth()) {
                    constraintWidget.setMeasureRequested(true);
                    this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, n, constraintWidget.getVerticalDimensionBehaviour(), constraintWidget.getHeight());
                }
                return n;
            }
            if (constraintWidget.mMatchConstraintDefaultWidth == 1) {
                return constraintWidget.getWidth();
            }
            if (constraintWidget.mMatchConstraintDefaultWidth == 3) {
                return (int)((float)constraintWidget.getHeight() * constraintWidget.mDimensionRatio + 0.5f);
            }
        }
        return constraintWidget.getWidth();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void measureAligned(ConstraintWidget[] var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5) {
        block35: {
            if (var3_3 == 0) {
                var7_7 = var6_6 = this.mMaxElementsWrap;
                if (var6_6 <= 0) {
                    var6_6 = 0;
                    var8_8 = 0;
                    var9_9 = 0;
                    while (true) {
                        var7_7 = var6_6;
                        if (var8_8 >= var2_2) break;
                        var7_7 = var9_9;
                        if (var8_8 > 0) {
                            var7_7 = var9_9 + this.mHorizontalGap;
                        }
                        if ((var10_10 /* !! */  = var1_1 /* !! */ [var8_8]) == null) {
                            var9_9 = var7_7;
                        } else {
                            var9_9 = var7_7 + this.getWidgetWidth((ConstraintWidget)var10_10 /* !! */ , var4_4);
                            if (var9_9 > var4_4) {
                                var7_7 = var6_6;
                                break;
                            }
                            ++var6_6;
                        }
                        ++var8_8;
                    }
                }
                var9_9 = var7_7;
                var6_6 = 0;
            } else {
                var7_7 = var6_6 = this.mMaxElementsWrap;
                if (var6_6 <= 0) {
                    var6_6 = 0;
                    var8_8 = 0;
                    var9_9 = 0;
                    while (true) {
                        var7_7 = var6_6;
                        if (var8_8 >= var2_2) break;
                        var7_7 = var9_9;
                        if (var8_8 > 0) {
                            var7_7 = var9_9 + this.mVerticalGap;
                        }
                        if ((var10_10 /* !! */  = var1_1 /* !! */ [var8_8]) == null) {
                            var9_9 = var7_7;
                        } else {
                            var9_9 = var7_7 + this.getWidgetHeight((ConstraintWidget)var10_10 /* !! */ , var4_4);
                            if (var9_9 > var4_4) {
                                var7_7 = var6_6;
                                break;
                            }
                            ++var6_6;
                        }
                        ++var8_8;
                    }
                }
                var9_9 = 0;
                var6_6 = var7_7;
            }
            if (this.mAlignedDimensions == null) {
                this.mAlignedDimensions = new int[2];
            }
            if (var6_6 != 0) break block35;
            var11_11 = var6_6;
            var12_12 = var9_9;
            if (var3_3 == 1) ** GOTO lbl59
        }
        if (var9_9 == 0 && var3_3 == 0) {
            var12_12 = var9_9;
            var11_11 = var6_6;
lbl59:
            // 6 sources

            while (true) {
                var13_13 = true;
                var6_6 = var11_11;
                var9_9 = var12_12;
                break;
            }
        } else {
            var13_13 = false;
        }
        while (!var13_13) {
            block36: {
                if (var3_3 == 0) {
                    var6_6 = (int)Math.ceil((float)var2_2 / (float)var9_9);
                } else {
                    var9_9 = (int)Math.ceil((float)var2_2 / (float)var6_6);
                }
                var10_10 /* !! */  = this.mAlignedBiggestElementsInCols;
                if (var10_10 /* !! */  != null && var10_10 /* !! */ .length >= var9_9) {
                    Arrays.fill(var10_10 /* !! */ , null);
                } else {
                    this.mAlignedBiggestElementsInCols = new ConstraintWidget[var9_9];
                }
                var10_10 /* !! */  = this.mAlignedBiggestElementsInRows;
                if (var10_10 /* !! */  != null && var10_10 /* !! */ .length >= var6_6) {
                    Arrays.fill(var10_10 /* !! */ , null);
                } else {
                    this.mAlignedBiggestElementsInRows = new ConstraintWidget[var6_6];
                }
                for (var7_7 = 0; var7_7 < var9_9; ++var7_7) {
                    for (var8_8 = 0; var8_8 < var6_6; ++var8_8) {
                        var12_12 = var8_8 * var9_9 + var7_7;
                        if (var3_3 == 1) {
                            var12_12 = var7_7 * var6_6 + var8_8;
                        }
                        if (var12_12 >= var1_1 /* !! */ .length || (var10_10 /* !! */  = var1_1 /* !! */ [var12_12]) == null) continue;
                        var12_12 = this.getWidgetWidth((ConstraintWidget)var10_10 /* !! */ , var4_4);
                        var14_14 = this.mAlignedBiggestElementsInCols;
                        if (var14_14[var7_7] == null || var14_14[var7_7].getWidth() < var12_12) {
                            this.mAlignedBiggestElementsInCols[var7_7] = var10_10 /* !! */ ;
                        }
                        var12_12 = this.getWidgetHeight((ConstraintWidget)var10_10 /* !! */ , var4_4);
                        var14_14 = this.mAlignedBiggestElementsInRows;
                        if (var14_14[var8_8] != null && var14_14[var8_8].getHeight() >= var12_12) continue;
                        this.mAlignedBiggestElementsInRows[var8_8] = var10_10 /* !! */ ;
                    }
                }
                var7_7 = 0;
                for (var8_8 = 0; var8_8 < var9_9; ++var8_8) {
                    var10_10 /* !! */  = this.mAlignedBiggestElementsInCols[var8_8];
                    var12_12 = var7_7;
                    if (var10_10 /* !! */  != null) {
                        var12_12 = var7_7;
                        if (var8_8 > 0) {
                            var12_12 = var7_7 + this.mHorizontalGap;
                        }
                        var12_12 += this.getWidgetWidth((ConstraintWidget)var10_10 /* !! */ , var4_4);
                    }
                    var7_7 = var12_12;
                }
                var8_8 = 0;
                for (var12_12 = 0; var12_12 < var6_6; ++var12_12) {
                    var10_10 /* !! */  = this.mAlignedBiggestElementsInRows[var12_12];
                    var11_11 = var8_8;
                    if (var10_10 /* !! */  != null) {
                        var11_11 = var8_8;
                        if (var12_12 > 0) {
                            var11_11 = var8_8 + this.mVerticalGap;
                        }
                        var11_11 += this.getWidgetHeight((ConstraintWidget)var10_10 /* !! */ , var4_4);
                    }
                    var8_8 = var11_11;
                }
                var5_5[0] = var7_7;
                var5_5[1] = var8_8;
                if (var3_3 != 0) break block36;
                var11_11 = var6_6;
                var12_12 = var9_9;
                if (var7_7 <= var4_4) ** GOTO lbl59
                var11_11 = var6_6;
                var12_12 = var9_9;
                if (var9_9 <= 1) ** GOTO lbl59
                --var9_9;
                continue;
            }
            var11_11 = var6_6;
            var12_12 = var9_9;
            if (var8_8 <= var4_4) ** GOTO lbl59
            var11_11 = var6_6;
            var12_12 = var9_9;
            if (var6_6 > 1) ** break;
            ** continue;
            --var6_6;
        }
        var1_1 /* !! */  = (ConstraintWidget[])this.mAlignedDimensions;
        var1_1 /* !! */ [0] = (ConstraintWidget)var9_9;
        var1_1 /* !! */ [1] = (ConstraintWidget)var6_6;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void measureChainWrap(ConstraintWidget[] var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5) {
        if (var2_2 == 0) {
            return;
        }
        this.mChainList.clear();
        var6_6 = new WidgetsList(var3_3, this.mLeft, this.mTop, this.mRight, this.mBottom, var4_4);
        this.mChainList.add((WidgetsList)var6_6);
        if (var3_3 == 0) {
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = 0;
            var10_10 = var6_6;
            while (true) {
                var11_11 = var7_7;
                if (var9_9 < var2_2) {
                    var12_12 = var1_1 /* !! */ [var9_9];
                    var13_13 = this.getWidgetWidth((ConstraintWidget)var12_12, var4_4);
                    var11_11 = var7_7;
                    if (var12_12.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        var11_11 = var7_7 + 1;
                    }
                    var7_7 = (var8_8 == var4_4 || this.mHorizontalGap + var8_8 + var13_13 > var4_4) && WidgetsList.access$2000((WidgetsList)var10_10) != null ? 1 : 0;
                    var14_14 = var7_7;
                    if (var7_7 == 0) {
                        var14_14 = var7_7;
                        if (var9_9 > 0) {
                            var15_15 = this.mMaxElementsWrap;
                            var14_14 = var7_7;
                            if (var15_15 > 0) {
                                var14_14 = var7_7;
                                if (var9_9 % var15_15 == 0) {
                                    var14_14 = 1;
                                }
                            }
                        }
                    }
                    if (var14_14 != 0) {
                        var6_6 = new WidgetsList(var3_3, this.mLeft, this.mTop, this.mRight, this.mBottom, var4_4);
                        var6_6.setStartIndex(var9_9);
                        this.mChainList.add((WidgetsList)var6_6);
                        while (true) {
                            var8_8 = var13_13;
                            break;
                        }
                    } else {
                        var6_6 = var10_10;
                        if (var9_9 <= 0) ** continue;
                        var8_8 += this.mHorizontalGap + var13_13;
                        var6_6 = var10_10;
                    }
                    var6_6.add((ConstraintWidget)var12_12);
                    ++var9_9;
                    var7_7 = var11_11;
                    var10_10 = var6_6;
                    continue;
                }
                break;
            }
        } else {
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = 0;
            while (true) {
                var11_11 = var7_7;
                if (var9_9 >= var2_2) break;
                var12_12 = var1_1 /* !! */ [var9_9];
                var13_13 = this.getWidgetHeight((ConstraintWidget)var12_12, var4_4);
                var11_11 = var7_7;
                if (var12_12.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    var11_11 = var7_7 + 1;
                }
                var7_7 = (var8_8 == var4_4 || this.mVerticalGap + var8_8 + var13_13 > var4_4) && WidgetsList.access$2000((WidgetsList)var6_6) != null ? 1 : 0;
                var14_14 = var7_7;
                if (var7_7 == 0) {
                    var14_14 = var7_7;
                    if (var9_9 > 0) {
                        var15_15 = this.mMaxElementsWrap;
                        var14_14 = var7_7;
                        if (var15_15 > 0) {
                            var14_14 = var7_7;
                            if (var9_9 % var15_15 == 0) {
                                var14_14 = 1;
                            }
                        }
                    }
                }
                if (var14_14 != 0) {
                    var10_10 = new WidgetsList(var3_3, this.mLeft, this.mTop, this.mRight, this.mBottom, var4_4);
                    var10_10.setStartIndex(var9_9);
                    this.mChainList.add((WidgetsList)var10_10);
                    while (true) {
                        var8_8 = var13_13;
                        var6_6 = var10_10;
                        break;
                    }
                } else {
                    var10_10 = var6_6;
                    if (var9_9 <= 0) ** continue;
                    var8_8 += this.mVerticalGap + var13_13;
                }
                var6_6.add((ConstraintWidget)var12_12);
                ++var9_9;
                var7_7 = var11_11;
            }
        }
        var16_16 = this.mChainList.size();
        var1_1 /* !! */  = this.mLeft;
        var12_12 = this.mTop;
        var6_6 = this.mRight;
        var10_10 = this.mBottom;
        var8_8 = this.getPaddingLeft();
        var9_9 = this.getPaddingTop();
        var13_13 = this.getPaddingRight();
        var14_14 = this.getPaddingBottom();
        var2_2 = this.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && this.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT ? 0 : 1;
        if (var11_11 > 0 && var2_2 != 0) {
            for (var2_2 = 0; var2_2 < var16_16; ++var2_2) {
                var17_17 = this.mChainList.get(var2_2);
                if (var3_3 == 0) {
                    var17_17.measureMatchConstraints(var4_4 - var17_17.getWidth());
                    continue;
                }
                var17_17.measureMatchConstraints(var4_4 - var17_17.getHeight());
            }
        }
        var11_11 = 0;
        var15_15 = 0;
        for (var2_2 = 0; var2_2 < var16_16; ++var2_2) {
            var18_18 = this.mChainList.get(var2_2);
            if (var3_3 == 0) {
                if (var2_2 < var16_16 - 1) {
                    var10_10 = WidgetsList.access$2000((WidgetsList)this.mChainList.get((int)(var2_2 + 1))).mTop;
                    var7_7 = 0;
                } else {
                    var10_10 = this.mBottom;
                    var7_7 = this.getPaddingBottom();
                }
                var17_17 = WidgetsList.access$2000((WidgetsList)var18_18).mBottom;
                var18_18.setup(var3_3, (ConstraintAnchor)var1_1 /* !! */ , (ConstraintAnchor)var12_12, (ConstraintAnchor)var6_6, (ConstraintAnchor)var10_10, var8_8, var9_9, var13_13, var7_7, var4_4);
                var9_9 = Math.max(var15_15, var18_18.getWidth());
                var11_11 = var14_14 = var11_11 + var18_18.getHeight();
                if (var2_2 > 0) {
                    var11_11 = var14_14 + this.mVerticalGap;
                }
                var12_12 = var17_17;
                var15_15 = 0;
                var14_14 = var7_7;
                var7_7 = var9_9;
                var9_9 = var15_15;
            } else {
                var13_13 = var2_2;
                if (var13_13 < var16_16 - 1) {
                    var6_6 = WidgetsList.access$2000((WidgetsList)this.mChainList.get((int)(var13_13 + 1))).mLeft;
                    var7_7 = 0;
                } else {
                    var6_6 = this.mRight;
                    var7_7 = this.getPaddingRight();
                }
                var17_17 = WidgetsList.access$2000((WidgetsList)var18_18).mRight;
                var18_18.setup(var3_3, (ConstraintAnchor)var1_1 /* !! */ , (ConstraintAnchor)var12_12, (ConstraintAnchor)var6_6, (ConstraintAnchor)var10_10, var8_8, var9_9, var7_7, var14_14, var4_4);
                var8_8 = var15_15 + var18_18.getWidth();
                var15_15 = Math.max(var11_11, var18_18.getHeight());
                var11_11 = var8_8;
                if (var13_13 > 0) {
                    var11_11 = var8_8 + this.mHorizontalGap;
                }
                var8_8 = var15_15;
                var13_13 = var7_7;
                var1_1 /* !! */  = var17_17;
                var15_15 = 0;
                var7_7 = var11_11;
                var11_11 = var8_8;
                var8_8 = var15_15;
            }
            var15_15 = var7_7;
        }
        var5_5[0] = var15_15;
        var5_5[1] = var11_11;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void measureChainWrap_new(ConstraintWidget[] var1_1, int var2_2, int var3_3, int var4_4, int[] var5_5) {
        if (var2_2 == 0) {
            return;
        }
        this.mChainList.clear();
        var6_6 = new WidgetsList(var3_3, this.mLeft, this.mTop, this.mRight, this.mBottom, var4_4);
        this.mChainList.add((WidgetsList)var6_6);
        if (var3_3 == 0) {
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = 0;
            var10_10 = 0;
            while (true) {
                var11_11 = var8_8;
                if (var10_10 < var2_2) {
                    var12_12 = var7_7 + 1;
                    var13_13 = var1_1 /* !! */ [var10_10];
                    var7_7 = this.getWidgetWidth((ConstraintWidget)var13_13, var4_4);
                    var11_11 = var8_8;
                    if (var13_13.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        var11_11 = var8_8 + 1;
                    }
                    var8_8 = (var9_9 == var4_4 || this.mHorizontalGap + var9_9 + var7_7 > var4_4) && WidgetsList.access$2000((WidgetsList)var6_6) != null ? 1 : 0;
                    var14_14 = var8_8;
                    if (var8_8 == 0) {
                        var14_14 = var8_8;
                        if (var10_10 > 0) {
                            var15_15 = this.mMaxElementsWrap;
                            var14_14 = var8_8;
                            if (var15_15 > 0) {
                                var14_14 = var8_8;
                                if (var12_12 > var15_15) {
                                    var14_14 = 1;
                                }
                            }
                        }
                    }
                    if (var14_14 != 0) {
                        var6_6 = new WidgetsList(var3_3, this.mLeft, this.mTop, this.mRight, this.mBottom, var4_4);
                        var6_6.setStartIndex(var10_10);
                        this.mChainList.add((WidgetsList)var6_6);
                        var8_8 = var12_12;
                        var9_9 = var7_7;
                    } else {
                        var9_9 = var10_10 > 0 ? (var9_9 += this.mHorizontalGap + var7_7) : var7_7;
                        var8_8 = 0;
                    }
                    var6_6.add((ConstraintWidget)var13_13);
                    ++var10_10;
                    var7_7 = var8_8;
                    var8_8 = var11_11;
                    continue;
                }
                break;
            }
        } else {
            var10_10 = 0;
            var8_8 = 0;
            var9_9 = 0;
            var13_13 = var6_6;
            while (true) {
                var11_11 = var8_8;
                if (var9_9 >= var2_2) break;
                var16_16 = var1_1 /* !! */ [var9_9];
                var14_14 = this.getWidgetHeight((ConstraintWidget)var16_16, var4_4);
                var11_11 = var8_8;
                if (var16_16.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    var11_11 = var8_8 + 1;
                }
                var8_8 = (var10_10 == var4_4 || this.mVerticalGap + var10_10 + var14_14 > var4_4) && WidgetsList.access$2000((WidgetsList)var13_13) != null ? 1 : 0;
                var7_7 = var8_8;
                if (var8_8 == 0) {
                    var7_7 = var8_8;
                    if (var9_9 > 0) {
                        var12_12 = this.mMaxElementsWrap;
                        var7_7 = var8_8;
                        if (var12_12 > 0) {
                            var7_7 = var8_8;
                            if (var12_12 < 0) {
                                var7_7 = 1;
                            }
                        }
                    }
                }
                if (var7_7 != 0) {
                    var6_6 = new WidgetsList(var3_3, this.mLeft, this.mTop, this.mRight, this.mBottom, var4_4);
                    var6_6.setStartIndex(var9_9);
                    this.mChainList.add((WidgetsList)var6_6);
                    while (true) {
                        var8_8 = var14_14;
                        break;
                    }
                } else {
                    var6_6 = var13_13;
                    if (var9_9 <= 0) ** continue;
                    var8_8 = var10_10 + (this.mVerticalGap + var14_14);
                    var6_6 = var13_13;
                }
                var6_6.add((ConstraintWidget)var16_16);
                ++var9_9;
                var10_10 = var8_8;
                var8_8 = var11_11;
                var13_13 = var6_6;
            }
        }
        var15_15 = this.mChainList.size();
        var1_1 /* !! */  = this.mLeft;
        var16_16 = this.mTop;
        var6_6 = this.mRight;
        var13_13 = this.mBottom;
        var9_9 = this.getPaddingLeft();
        var10_10 = this.getPaddingTop();
        var14_14 = this.getPaddingRight();
        var7_7 = this.getPaddingBottom();
        var2_2 = this.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && this.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT ? 0 : 1;
        if (var11_11 > 0 && var2_2 != 0) {
            for (var2_2 = 0; var2_2 < var15_15; ++var2_2) {
                var17_17 = this.mChainList.get(var2_2);
                if (var3_3 == 0) {
                    var17_17.measureMatchConstraints(var4_4 - var17_17.getWidth());
                    continue;
                }
                var17_17.measureMatchConstraints(var4_4 - var17_17.getHeight());
            }
        }
        var11_11 = 0;
        var12_12 = 0;
        for (var2_2 = 0; var2_2 < var15_15; ++var2_2) {
            var18_18 = this.mChainList.get(var2_2);
            if (var3_3 == 0) {
                if (var2_2 < var15_15 - 1) {
                    var13_13 = WidgetsList.access$2000((WidgetsList)this.mChainList.get((int)(var2_2 + 1))).mTop;
                    var8_8 = 0;
                } else {
                    var13_13 = this.mBottom;
                    var8_8 = this.getPaddingBottom();
                }
                var17_17 = WidgetsList.access$2000((WidgetsList)var18_18).mBottom;
                var18_18.setup(var3_3, (ConstraintAnchor)var1_1 /* !! */ , (ConstraintAnchor)var16_16, (ConstraintAnchor)var6_6, (ConstraintAnchor)var13_13, var9_9, var10_10, var14_14, var8_8, var4_4);
                var10_10 = Math.max(var12_12, var18_18.getWidth());
                var11_11 = var7_7 = var11_11 + var18_18.getHeight();
                if (var2_2 > 0) {
                    var11_11 = var7_7 + this.mVerticalGap;
                }
                var16_16 = var17_17;
                var12_12 = 0;
                var7_7 = var8_8;
                var8_8 = var10_10;
                var10_10 = var12_12;
            } else {
                var14_14 = var2_2;
                if (var14_14 < var15_15 - 1) {
                    var6_6 = WidgetsList.access$2000((WidgetsList)this.mChainList.get((int)(var14_14 + 1))).mLeft;
                    var8_8 = 0;
                } else {
                    var6_6 = this.mRight;
                    var8_8 = this.getPaddingRight();
                }
                var17_17 = WidgetsList.access$2000((WidgetsList)var18_18).mRight;
                var18_18.setup(var3_3, (ConstraintAnchor)var1_1 /* !! */ , (ConstraintAnchor)var16_16, (ConstraintAnchor)var6_6, (ConstraintAnchor)var13_13, var9_9, var10_10, var8_8, var7_7, var4_4);
                var9_9 = var12_12 + var18_18.getWidth();
                var12_12 = Math.max(var11_11, var18_18.getHeight());
                var11_11 = var9_9;
                if (var14_14 > 0) {
                    var11_11 = var9_9 + this.mHorizontalGap;
                }
                var9_9 = var12_12;
                var14_14 = var8_8;
                var1_1 /* !! */  = var17_17;
                var12_12 = 0;
                var8_8 = var11_11;
                var11_11 = var9_9;
                var9_9 = var12_12;
            }
            var12_12 = var8_8;
        }
        var5_5[0] = var12_12;
        var5_5[1] = var11_11;
    }

    private void measureNoWrap(ConstraintWidget[] constraintWidgetArray, int n, int n2, int n3, int[] nArray) {
        WidgetsList widgetsList;
        if (n == 0) {
            return;
        }
        if (this.mChainList.size() == 0) {
            widgetsList = new WidgetsList(n2, this.mLeft, this.mTop, this.mRight, this.mBottom, n3);
            this.mChainList.add(widgetsList);
        } else {
            widgetsList = this.mChainList.get(0);
            widgetsList.clear();
            ConstraintAnchor constraintAnchor = this.mLeft;
            ConstraintAnchor constraintAnchor2 = this.mTop;
            ConstraintAnchor constraintAnchor3 = this.mRight;
            ConstraintAnchor constraintAnchor4 = this.mBottom;
            int n4 = this.getPaddingLeft();
            int n5 = this.getPaddingTop();
            int n6 = this.getPaddingRight();
            int n7 = this.getPaddingBottom();
            widgetsList.setup(n2, constraintAnchor, constraintAnchor2, constraintAnchor3, constraintAnchor4, n4, n5, n6, n7, n3);
        }
        for (n2 = 0; n2 < n; ++n2) {
            widgetsList.add(constraintWidgetArray[n2]);
        }
        nArray[0] = widgetsList.getWidth();
        nArray[1] = widgetsList.getHeight();
    }

    @Override
    public void addToSolver(LinearSystem object, boolean bl) {
        super.addToSolver((LinearSystem)object, bl);
        bl = this.getParent() != null && ((ConstraintWidgetContainer)this.getParent()).isRtl();
        int n = this.mWrapMode;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        int n2 = this.mChainList.size();
                        for (n = 0; n < n2; ++n) {
                            object = this.mChainList.get(n);
                            boolean bl2 = n == n2 - 1;
                            ((WidgetsList)object).createConstraints(bl, n, bl2);
                        }
                    }
                } else {
                    this.createAlignedConstraints(bl);
                }
            } else {
                int n3 = this.mChainList.size();
                for (n = 0; n < n3; ++n) {
                    object = this.mChainList.get(n);
                    boolean bl3 = n == n3 - 1;
                    ((WidgetsList)object).createConstraints(bl, n, bl3);
                }
            }
        } else if (this.mChainList.size() > 0) {
            this.mChainList.get(0).createConstraints(bl, 0, true);
        }
        this.needsCallbackFromSolver(false);
    }

    @Override
    public void copy(ConstraintWidget constraintWidget, HashMap<ConstraintWidget, ConstraintWidget> hashMap) {
        super.copy(constraintWidget, hashMap);
        constraintWidget = (Flow)constraintWidget;
        this.mHorizontalStyle = ((Flow)constraintWidget).mHorizontalStyle;
        this.mVerticalStyle = ((Flow)constraintWidget).mVerticalStyle;
        this.mFirstHorizontalStyle = ((Flow)constraintWidget).mFirstHorizontalStyle;
        this.mFirstVerticalStyle = ((Flow)constraintWidget).mFirstVerticalStyle;
        this.mLastHorizontalStyle = ((Flow)constraintWidget).mLastHorizontalStyle;
        this.mLastVerticalStyle = ((Flow)constraintWidget).mLastVerticalStyle;
        this.mHorizontalBias = ((Flow)constraintWidget).mHorizontalBias;
        this.mVerticalBias = ((Flow)constraintWidget).mVerticalBias;
        this.mFirstHorizontalBias = ((Flow)constraintWidget).mFirstHorizontalBias;
        this.mFirstVerticalBias = ((Flow)constraintWidget).mFirstVerticalBias;
        this.mLastHorizontalBias = ((Flow)constraintWidget).mLastHorizontalBias;
        this.mLastVerticalBias = ((Flow)constraintWidget).mLastVerticalBias;
        this.mHorizontalGap = ((Flow)constraintWidget).mHorizontalGap;
        this.mVerticalGap = ((Flow)constraintWidget).mVerticalGap;
        this.mHorizontalAlign = ((Flow)constraintWidget).mHorizontalAlign;
        this.mVerticalAlign = ((Flow)constraintWidget).mVerticalAlign;
        this.mWrapMode = ((Flow)constraintWidget).mWrapMode;
        this.mMaxElementsWrap = ((Flow)constraintWidget).mMaxElementsWrap;
        this.mOrientation = ((Flow)constraintWidget).mOrientation;
    }

    public float getMaxElementsWrap() {
        return this.mMaxElementsWrap;
    }

    @Override
    public void measure(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.mWidgetsCount > 0 && !this.measureChildren()) {
            this.setMeasure(0, 0);
            this.needsCallbackFromSolver(false);
            return;
        }
        int n7 = this.getPaddingLeft();
        int n8 = this.getPaddingRight();
        int n9 = this.getPaddingTop();
        int n10 = this.getPaddingBottom();
        int[] nArray = new int[2];
        int n11 = n2 - n7 - n8;
        int n12 = this.mOrientation;
        if (n12 == 1) {
            n11 = n4 - n9 - n10;
        }
        if (n12 == 0) {
            if (this.mHorizontalStyle == -1) {
                this.mHorizontalStyle = 0;
            }
            if (this.mVerticalStyle == -1) {
                this.mVerticalStyle = 0;
            }
        } else {
            if (this.mHorizontalStyle == -1) {
                this.mHorizontalStyle = 0;
            }
            if (this.mVerticalStyle == -1) {
                this.mVerticalStyle = 0;
            }
        }
        ConstraintWidget[] constraintWidgetArray = this.mWidgets;
        n12 = 0;
        for (n6 = 0; n6 < this.mWidgetsCount; ++n6) {
            n5 = n12;
            if (this.mWidgets[n6].getVisibility() == 8) {
                n5 = n12 + 1;
            }
            n12 = n5;
        }
        n6 = this.mWidgetsCount;
        if (n12 > 0) {
            constraintWidgetArray = new ConstraintWidget[this.mWidgetsCount - n12];
            n12 = 0;
            for (n6 = 0; n6 < this.mWidgetsCount; ++n6) {
                ConstraintWidget constraintWidget = this.mWidgets[n6];
                n5 = n12;
                if (constraintWidget.getVisibility() != 8) {
                    constraintWidgetArray[n12] = constraintWidget;
                    n5 = n12 + 1;
                }
                n12 = n5;
            }
            n6 = n12;
        }
        this.mDisplayedWidgets = constraintWidgetArray;
        this.mDisplayedWidgetsCount = n6;
        n12 = this.mWrapMode;
        if (n12 != 0) {
            if (n12 != 1) {
                if (n12 != 2) {
                    if (n12 == 3) {
                        this.measureChainWrap_new(constraintWidgetArray, n6, this.mOrientation, n11, nArray);
                    }
                } else {
                    this.measureAligned(constraintWidgetArray, n6, this.mOrientation, n11, nArray);
                }
            } else {
                this.measureChainWrap(constraintWidgetArray, n6, this.mOrientation, n11, nArray);
            }
        } else {
            this.measureNoWrap(constraintWidgetArray, n6, this.mOrientation, n11, nArray);
        }
        boolean bl = true;
        n11 = nArray[0] + n7 + n8;
        n12 = nArray[1] + n9 + n10;
        n = n == 0x40000000 ? n2 : (n == Integer.MIN_VALUE ? Math.min(n11, n2) : (n == 0 ? n11 : 0));
        n2 = n3 == 0x40000000 ? n4 : (n3 == Integer.MIN_VALUE ? Math.min(n12, n4) : (n3 == 0 ? n12 : 0));
        this.setMeasure(n, n2);
        this.setWidth(n);
        this.setHeight(n2);
        if (this.mWidgetsCount <= 0) {
            bl = false;
        }
        this.needsCallbackFromSolver(bl);
    }

    public void setFirstHorizontalBias(float f) {
        this.mFirstHorizontalBias = f;
    }

    public void setFirstHorizontalStyle(int n) {
        this.mFirstHorizontalStyle = n;
    }

    public void setFirstVerticalBias(float f) {
        this.mFirstVerticalBias = f;
    }

    public void setFirstVerticalStyle(int n) {
        this.mFirstVerticalStyle = n;
    }

    public void setHorizontalAlign(int n) {
        this.mHorizontalAlign = n;
    }

    public void setHorizontalBias(float f) {
        this.mHorizontalBias = f;
    }

    public void setHorizontalGap(int n) {
        this.mHorizontalGap = n;
    }

    public void setHorizontalStyle(int n) {
        this.mHorizontalStyle = n;
    }

    public void setLastHorizontalBias(float f) {
        this.mLastHorizontalBias = f;
    }

    public void setLastHorizontalStyle(int n) {
        this.mLastHorizontalStyle = n;
    }

    public void setLastVerticalBias(float f) {
        this.mLastVerticalBias = f;
    }

    public void setLastVerticalStyle(int n) {
        this.mLastVerticalStyle = n;
    }

    public void setMaxElementsWrap(int n) {
        this.mMaxElementsWrap = n;
    }

    public void setOrientation(int n) {
        this.mOrientation = n;
    }

    public void setVerticalAlign(int n) {
        this.mVerticalAlign = n;
    }

    public void setVerticalBias(float f) {
        this.mVerticalBias = f;
    }

    public void setVerticalGap(int n) {
        this.mVerticalGap = n;
    }

    public void setVerticalStyle(int n) {
        this.mVerticalStyle = n;
    }

    public void setWrapMode(int n) {
        this.mWrapMode = n;
    }

    private class WidgetsList {
        private ConstraintWidget biggest = null;
        int biggestDimension = 0;
        private ConstraintAnchor mBottom;
        private int mCount = 0;
        private int mHeight = 0;
        private ConstraintAnchor mLeft;
        private int mMax = 0;
        private int mNbMatchConstraintsWidgets = 0;
        private int mOrientation = 0;
        private int mPaddingBottom = 0;
        private int mPaddingLeft = 0;
        private int mPaddingRight = 0;
        private int mPaddingTop = 0;
        private ConstraintAnchor mRight;
        private int mStartIndex = 0;
        private ConstraintAnchor mTop;
        private int mWidth = 0;

        public WidgetsList(int n, ConstraintAnchor constraintAnchor, ConstraintAnchor constraintAnchor2, ConstraintAnchor constraintAnchor3, ConstraintAnchor constraintAnchor4, int n2) {
            this.mOrientation = n;
            this.mLeft = constraintAnchor;
            this.mTop = constraintAnchor2;
            this.mRight = constraintAnchor3;
            this.mBottom = constraintAnchor4;
            this.mPaddingLeft = Flow.this.getPaddingLeft();
            this.mPaddingTop = Flow.this.getPaddingTop();
            this.mPaddingRight = Flow.this.getPaddingRight();
            this.mPaddingBottom = Flow.this.getPaddingBottom();
            this.mMax = n2;
        }

        static /* synthetic */ ConstraintWidget access$2000(WidgetsList widgetsList) {
            return widgetsList.biggest;
        }

        private void recomputeDimensions() {
            this.mWidth = 0;
            this.mHeight = 0;
            this.biggest = null;
            this.biggestDimension = 0;
            int n = this.mCount;
            for (int i = 0; i < n && this.mStartIndex + i < Flow.this.mDisplayedWidgetsCount; ++i) {
                int n2;
                int n3;
                ConstraintWidget constraintWidget = Flow.this.mDisplayedWidgets[this.mStartIndex + i];
                if (this.mOrientation == 0) {
                    n3 = constraintWidget.getWidth();
                    n2 = Flow.this.mHorizontalGap;
                    if (constraintWidget.getVisibility() == 8) {
                        n2 = 0;
                    }
                    this.mWidth += n3 + n2;
                    n2 = Flow.this.getWidgetHeight(constraintWidget, this.mMax);
                    if (this.biggest != null && this.biggestDimension >= n2) continue;
                    this.biggest = constraintWidget;
                    this.biggestDimension = n2;
                    this.mHeight = n2;
                    continue;
                }
                n3 = Flow.this.getWidgetWidth(constraintWidget, this.mMax);
                int n4 = Flow.this.getWidgetHeight(constraintWidget, this.mMax);
                n2 = Flow.this.mVerticalGap;
                if (constraintWidget.getVisibility() == 8) {
                    n2 = 0;
                }
                this.mHeight += n4 + n2;
                if (this.biggest != null && this.biggestDimension >= n3) continue;
                this.biggest = constraintWidget;
                this.biggestDimension = n3;
                this.mWidth = n3;
            }
        }

        public void add(ConstraintWidget constraintWidget) {
            int n = this.mOrientation;
            int n2 = 0;
            int n3 = 0;
            if (n == 0) {
                n = Flow.this.getWidgetWidth(constraintWidget, this.mMax);
                if (constraintWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    ++this.mNbMatchConstraintsWidgets;
                    n = 0;
                }
                n2 = Flow.this.mHorizontalGap;
                if (constraintWidget.getVisibility() == 8) {
                    n2 = n3;
                }
                this.mWidth += n + n2;
                n = Flow.this.getWidgetHeight(constraintWidget, this.mMax);
                if (this.biggest == null || this.biggestDimension < n) {
                    this.biggest = constraintWidget;
                    this.biggestDimension = n;
                    this.mHeight = n;
                }
            } else {
                int n4 = Flow.this.getWidgetWidth(constraintWidget, this.mMax);
                n = Flow.this.getWidgetHeight(constraintWidget, this.mMax);
                if (constraintWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    ++this.mNbMatchConstraintsWidgets;
                    n = 0;
                }
                n3 = Flow.this.mVerticalGap;
                if (constraintWidget.getVisibility() != 8) {
                    n2 = n3;
                }
                this.mHeight += n + n2;
                if (this.biggest == null || this.biggestDimension < n4) {
                    this.biggest = constraintWidget;
                    this.biggestDimension = n4;
                    this.mWidth = n4;
                }
            }
            ++this.mCount;
        }

        public void clear() {
            this.biggestDimension = 0;
            this.biggest = null;
            this.mWidth = 0;
            this.mHeight = 0;
            this.mStartIndex = 0;
            this.mCount = 0;
            this.mNbMatchConstraintsWidgets = 0;
        }

        /*
         * Unable to fully structure code
         */
        public void createConstraints(boolean var1_1, int var2_2, boolean var3_3) {
            block67: {
                var4_4 = this.mCount;
                for (var5_5 = 0; var5_5 < var4_4 && this.mStartIndex + var5_5 < Flow.access$400(Flow.this); ++var5_5) {
                    var6_6 = Flow.access$500(Flow.this)[this.mStartIndex + var5_5];
                    if (var6_6 == null) continue;
                    var6_6.resetAnchors();
                }
                if (var4_4 == 0 || this.biggest == null) break block67;
                var7_7 = var3_3 != false && var2_2 == 0;
                var8_8 = -1;
                var9_9 = -1;
                for (var5_5 = 0; var5_5 < var4_4 && this.mStartIndex + (var10_10 = var1_1 != false ? var4_4 - 1 - var5_5 : var5_5) < Flow.access$400(Flow.this); ++var5_5) {
                    var6_6 = Flow.access$500(Flow.this)[this.mStartIndex + var10_10];
                    var11_11 = var8_8;
                    var10_10 = var9_9;
                    if (var6_6 != null) {
                        var11_11 = var8_8;
                        var10_10 = var9_9;
                        if (var6_6.getVisibility() == 0) {
                            var9_9 = var8_8;
                            if (var8_8 == -1) {
                                var9_9 = var5_5;
                            }
                            var10_10 = var5_5;
                            var11_11 = var9_9;
                        }
                    }
                    var8_8 = var11_11;
                    var9_9 = var10_10;
                }
                var12_12 = null;
                var6_6 = null;
                if (this.mOrientation == 0) {
                    var13_13 = this.biggest;
                    var13_13.setVerticalChainStyle(Flow.access$600(Flow.this));
                    var5_5 = var10_10 = this.mPaddingTop;
                    if (var2_2 > 0) {
                        var5_5 = var10_10 + Flow.access$100(Flow.this);
                    }
                    var13_13.mTop.connect(this.mTop, var5_5);
                    if (var3_3) {
                        var13_13.mBottom.connect(this.mBottom, this.mPaddingBottom);
                    }
                    if (var2_2 > 0) {
                        this.mTop.mOwner.mBottom.connect(var13_13.mTop, 0);
                    }
                    if (Flow.access$700(Flow.this) == 3 && !var13_13.hasBaseline()) {
                        for (var2_2 = 0; var2_2 < var4_4 && this.mStartIndex + (var5_5 = var1_1 != false ? var4_4 - 1 - var2_2 : var2_2) < Flow.access$400(Flow.this); ++var2_2) {
                            var12_12 = Flow.access$500(Flow.this)[this.mStartIndex + var5_5];
                            if (!var12_12.hasBaseline()) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        var12_12 = var13_13;
                    }
                    for (var5_5 = 0; var5_5 < var4_4 && this.mStartIndex + (var2_2 = var1_1 != false ? var4_4 - 1 - var5_5 : var5_5) < Flow.access$400(Flow.this); ++var5_5) {
                        var14_14 = Flow.access$500(Flow.this)[this.mStartIndex + var2_2];
                        if (var14_14 == null) continue;
                        if (var5_5 == 0) {
                            var14_14.connect(var14_14.mLeft, this.mLeft, this.mPaddingLeft);
                        }
                        if (var2_2 == 0) {
                            var10_10 = Flow.access$800(Flow.this);
                            var16_18 = var15_16 = Flow.access$900(Flow.this);
                            if (var1_1) {
                                var16_18 = 1.0f - var15_16;
                            }
                            if (this.mStartIndex == 0 && Flow.access$1000(Flow.this) != -1) {
                                var2_2 = Flow.access$1000(Flow.this);
                                if (var1_1) {
                                    var16_18 = Flow.access$1100(Flow.this);
lbl64:
                                    // 2 sources

                                    while (true) {
                                        var16_18 = 1.0f - var16_18;
                                        break;
                                    }
                                } else {
                                    var16_18 = Flow.access$1100(Flow.this);
                                }
lbl68:
                                // 3 sources

                                while (true) {
                                    var15_16 = var16_18;
                                    break;
                                }
                            } else {
                                var2_2 = var10_10;
                                var15_16 = var16_18;
                                if (var3_3) {
                                    var2_2 = var10_10;
                                    var15_16 = var16_18;
                                    if (Flow.access$1200(Flow.this) != -1) {
                                        var2_2 = Flow.access$1200(Flow.this);
                                        if (var1_1) {
                                            var16_18 = Flow.access$1300(Flow.this);
                                            ** continue;
                                        }
                                        var16_18 = Flow.access$1300(Flow.this);
                                        ** continue;
                                    }
                                }
                            }
                            var14_14.setHorizontalChainStyle(var2_2);
                            var14_14.setHorizontalBiasPercent(var15_16);
                        }
                        if (var5_5 == var4_4 - 1) {
                            var14_14.connect(var14_14.mRight, this.mRight, this.mPaddingRight);
                        }
                        if (var6_6 != null) {
                            var14_14.mLeft.connect(var6_6.mRight, Flow.access$000(Flow.this));
                            if (var5_5 == var8_8) {
                                var14_14.mLeft.setGoneMargin(this.mPaddingLeft);
                            }
                            var6_6.mRight.connect(var14_14.mLeft, 0);
                            if (var5_5 == var9_9 + 1) {
                                var6_6.mRight.setGoneMargin(this.mPaddingRight);
                            }
                        }
                        var6_6 = var14_14;
                        if (var14_14 == var13_13) continue;
                        if (Flow.access$700(Flow.this) == 3 && var12_12.hasBaseline() && var14_14 != var12_12 && var14_14.hasBaseline()) {
                            var14_14.mBaseline.connect(var12_12.mBaseline, 0);
                            var6_6 = var14_14;
                            continue;
                        }
                        var2_2 = Flow.access$700(Flow.this);
                        if (var2_2 != 0) {
                            if (var2_2 != 1) {
                                if (var7_7) {
                                    var14_14.mTop.connect(this.mTop, this.mPaddingTop);
                                    var14_14.mBottom.connect(this.mBottom, this.mPaddingBottom);
                                    var6_6 = var14_14;
                                    continue;
                                }
                                var14_14.mTop.connect(var13_13.mTop, 0);
                                var14_14.mBottom.connect(var13_13.mBottom, 0);
                                var6_6 = var14_14;
                                continue;
                            }
                            var14_14.mBottom.connect(var13_13.mBottom, 0);
                            var6_6 = var14_14;
                            continue;
                        }
                        var14_14.mTop.connect(var13_13.mTop, 0);
                        var6_6 = var14_14;
                    }
                } else {
                    var14_15 = this.biggest;
                    var14_15.setHorizontalChainStyle(Flow.access$800(Flow.this));
                    var5_5 = var10_10 = this.mPaddingLeft;
                    if (var2_2 > 0) {
                        var5_5 = var10_10 + Flow.access$000(Flow.this);
                    }
                    if (var1_1) {
                        var14_15.mRight.connect(this.mRight, var5_5);
                        if (var3_3) {
                            var14_15.mLeft.connect(this.mLeft, this.mPaddingRight);
                        }
                        if (var2_2 > 0) {
                            this.mRight.mOwner.mLeft.connect(var14_15.mRight, 0);
                        }
                    } else {
                        var14_15.mLeft.connect(this.mLeft, var5_5);
                        if (var3_3) {
                            var14_15.mRight.connect(this.mRight, this.mPaddingRight);
                        }
                        if (var2_2 > 0) {
                            this.mLeft.mOwner.mRight.connect(var14_15.mLeft, 0);
                        }
                    }
                    var6_6 = var12_12;
                    for (var5_5 = 0; var5_5 < var4_4 && this.mStartIndex + var5_5 < Flow.access$400(Flow.this); ++var5_5) {
                        var12_12 = Flow.access$500(Flow.this)[this.mStartIndex + var5_5];
                        if (var12_12 == null) continue;
                        if (var5_5 == 0) {
                            var12_12.connect(var12_12.mTop, this.mTop, this.mPaddingTop);
                            var10_10 = Flow.access$600(Flow.this);
                            var15_17 = Flow.access$1400(Flow.this);
                            if (this.mStartIndex == 0 && Flow.access$1500(Flow.this) != -1) {
                                var2_2 = Flow.access$1500(Flow.this);
                                var16_19 = Flow.access$1600(Flow.this);
                            } else {
                                var2_2 = var10_10;
                                var16_19 = var15_17;
                                if (var3_3) {
                                    var2_2 = var10_10;
                                    var16_19 = var15_17;
                                    if (Flow.access$1700(Flow.this) != -1) {
                                        var2_2 = Flow.access$1700(Flow.this);
                                        var16_19 = Flow.access$1800(Flow.this);
                                    }
                                }
                            }
                            var12_12.setVerticalChainStyle(var2_2);
                            var12_12.setVerticalBiasPercent(var16_19);
                        }
                        if (var5_5 == var4_4 - 1) {
                            var12_12.connect(var12_12.mBottom, this.mBottom, this.mPaddingBottom);
                        }
                        if (var6_6 != null) {
                            var12_12.mTop.connect(var6_6.mBottom, Flow.access$100(Flow.this));
                            if (var5_5 == var8_8) {
                                var12_12.mTop.setGoneMargin(this.mPaddingTop);
                            }
                            var6_6.mBottom.connect(var12_12.mTop, 0);
                            if (var5_5 == var9_9 + 1) {
                                var6_6.mBottom.setGoneMargin(this.mPaddingBottom);
                            }
                        }
                        if (var12_12 != var14_15) {
                            if (var1_1) {
                                var2_2 = Flow.access$1900(Flow.this);
                                if (var2_2 != 0) {
                                    if (var2_2 != 1) {
                                        if (var2_2 == 2) {
                                            var12_12.mLeft.connect(var14_15.mLeft, 0);
                                            var12_12.mRight.connect(var14_15.mRight, 0);
                                        }
                                    } else {
                                        var12_12.mLeft.connect(var14_15.mLeft, 0);
                                    }
                                } else {
                                    var12_12.mRight.connect(var14_15.mRight, 0);
                                }
                            } else {
                                var2_2 = Flow.access$1900(Flow.this);
                                if (var2_2 != 0) {
                                    if (var2_2 != 1) {
                                        if (var2_2 == 2) {
                                            if (var7_7) {
                                                var12_12.mLeft.connect(this.mLeft, this.mPaddingLeft);
                                                var12_12.mRight.connect(this.mRight, this.mPaddingRight);
                                            } else {
                                                var12_12.mLeft.connect(var14_15.mLeft, 0);
                                                var12_12.mRight.connect(var14_15.mRight, 0);
                                            }
                                        }
                                    } else {
                                        var12_12.mRight.connect(var14_15.mRight, 0);
                                    }
                                } else {
                                    var12_12.mLeft.connect(var14_15.mLeft, 0);
                                }
                            }
                        }
                        var6_6 = var12_12;
                    }
                }
            }
        }

        public int getHeight() {
            if (this.mOrientation == 1) {
                return this.mHeight - Flow.this.mVerticalGap;
            }
            return this.mHeight;
        }

        public int getWidth() {
            if (this.mOrientation == 0) {
                return this.mWidth - Flow.this.mHorizontalGap;
            }
            return this.mWidth;
        }

        public void measureMatchConstraints(int n) {
            int n2 = this.mNbMatchConstraintsWidgets;
            if (n2 == 0) {
                return;
            }
            int n3 = this.mCount;
            n2 = n / n2;
            for (n = 0; n < n3 && this.mStartIndex + n < Flow.this.mDisplayedWidgetsCount; ++n) {
                ConstraintWidget constraintWidget = Flow.this.mDisplayedWidgets[this.mStartIndex + n];
                if (this.mOrientation == 0) {
                    if (constraintWidget == null || constraintWidget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || constraintWidget.mMatchConstraintDefaultWidth != 0) continue;
                    Flow.this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, n2, constraintWidget.getVerticalDimensionBehaviour(), constraintWidget.getHeight());
                    continue;
                }
                if (constraintWidget == null || constraintWidget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || constraintWidget.mMatchConstraintDefaultHeight != 0) continue;
                Flow.this.measure(constraintWidget, constraintWidget.getHorizontalDimensionBehaviour(), constraintWidget.getWidth(), ConstraintWidget.DimensionBehaviour.FIXED, n2);
            }
            this.recomputeDimensions();
        }

        public void setStartIndex(int n) {
            this.mStartIndex = n;
        }

        public void setup(int n, ConstraintAnchor constraintAnchor, ConstraintAnchor constraintAnchor2, ConstraintAnchor constraintAnchor3, ConstraintAnchor constraintAnchor4, int n2, int n3, int n4, int n5, int n6) {
            this.mOrientation = n;
            this.mLeft = constraintAnchor;
            this.mTop = constraintAnchor2;
            this.mRight = constraintAnchor3;
            this.mBottom = constraintAnchor4;
            this.mPaddingLeft = n2;
            this.mPaddingTop = n3;
            this.mPaddingRight = n4;
            this.mPaddingBottom = n5;
            this.mMax = n6;
        }
    }
}

