/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.Grouping;
import androidx.constraintlayout.core.widgets.analyzer.WidgetGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class HelperWidget
extends ConstraintWidget
implements Helper {
    public ConstraintWidget[] mWidgets = new ConstraintWidget[4];
    public int mWidgetsCount = 0;

    @Override
    public void add(ConstraintWidget constraintWidget) {
        if (constraintWidget != this && constraintWidget != null) {
            int n = this.mWidgetsCount;
            ConstraintWidget[] constraintWidgetArray = this.mWidgets;
            if (n + 1 > constraintWidgetArray.length) {
                this.mWidgets = Arrays.copyOf(constraintWidgetArray, constraintWidgetArray.length * 2);
            }
            constraintWidgetArray = this.mWidgets;
            n = this.mWidgetsCount;
            constraintWidgetArray[n] = constraintWidget;
            this.mWidgetsCount = n + 1;
        }
    }

    public void addDependents(ArrayList<WidgetGroup> arrayList, int n, WidgetGroup widgetGroup) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= this.mWidgetsCount) break;
            widgetGroup.add(this.mWidgets[n3]);
            ++n3;
        }
        for (int i = n2; i < this.mWidgetsCount; ++i) {
            Grouping.findDependents(this.mWidgets[i], n, arrayList, widgetGroup);
        }
    }

    @Override
    public void copy(ConstraintWidget constraintWidget, HashMap<ConstraintWidget, ConstraintWidget> hashMap) {
        super.copy(constraintWidget, hashMap);
        constraintWidget = (HelperWidget)constraintWidget;
        this.mWidgetsCount = 0;
        int n = ((HelperWidget)constraintWidget).mWidgetsCount;
        for (int i = 0; i < n; ++i) {
            this.add(hashMap.get(((HelperWidget)constraintWidget).mWidgets[i]));
        }
    }

    public int findGroupInDependents(int n) {
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget constraintWidget = this.mWidgets[i];
            if (n == 0 && constraintWidget.horizontalGroup != -1) {
                return constraintWidget.horizontalGroup;
            }
            if (n != 1 || constraintWidget.verticalGroup == -1) continue;
            return constraintWidget.verticalGroup;
        }
        return -1;
    }

    @Override
    public void removeAllIds() {
        this.mWidgetsCount = 0;
        Arrays.fill(this.mWidgets, null);
    }

    @Override
    public void updateConstraints(ConstraintWidgetContainer constraintWidgetContainer) {
    }
}

