/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import java.util.ArrayList;

public class BasicMeasure {
    public static final int AT_MOST = Integer.MIN_VALUE;
    private static final boolean DEBUG = false;
    public static final int EXACTLY = 0x40000000;
    public static final int FIXED = -3;
    public static final int MATCH_PARENT = -1;
    private static final int MODE_SHIFT = 30;
    public static final int UNSPECIFIED = 0;
    public static final int WRAP_CONTENT = -2;
    private ConstraintWidgetContainer constraintWidgetContainer;
    private Measure mMeasure;
    private final ArrayList<ConstraintWidget> mVariableDimensionsWidgets = new ArrayList();

    public BasicMeasure(ConstraintWidgetContainer constraintWidgetContainer) {
        this.mMeasure = new Measure();
        this.constraintWidgetContainer = constraintWidgetContainer;
    }

    private boolean measure(Measurer measurer, ConstraintWidget constraintWidget, int n) {
        this.mMeasure.horizontalBehavior = constraintWidget.getHorizontalDimensionBehaviour();
        this.mMeasure.verticalBehavior = constraintWidget.getVerticalDimensionBehaviour();
        this.mMeasure.horizontalDimension = constraintWidget.getWidth();
        this.mMeasure.verticalDimension = constraintWidget.getHeight();
        this.mMeasure.measuredNeedsSolverPass = false;
        this.mMeasure.measureStrategy = n;
        boolean bl = this.mMeasure.horizontalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        n = this.mMeasure.verticalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
        bl = bl && constraintWidget.mDimensionRatio > 0.0f;
        n = n != 0 && constraintWidget.mDimensionRatio > 0.0f ? 1 : 0;
        if (bl && constraintWidget.mResolvedMatchConstraintDefault[0] == 4) {
            this.mMeasure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
        }
        if (n != 0 && constraintWidget.mResolvedMatchConstraintDefault[1] == 4) {
            this.mMeasure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
        }
        measurer.measure(constraintWidget, this.mMeasure);
        constraintWidget.setWidth(this.mMeasure.measuredWidth);
        constraintWidget.setHeight(this.mMeasure.measuredHeight);
        constraintWidget.setHasBaseline(this.mMeasure.measuredHasBaseline);
        constraintWidget.setBaselineDistance(this.mMeasure.measuredBaseline);
        this.mMeasure.measureStrategy = Measure.SELF_DIMENSIONS;
        return this.mMeasure.measuredNeedsSolverPass;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void measureChildren(ConstraintWidgetContainer var1_1) {
        var2_2 = var1_1.mChildren.size();
        var3_3 = var1_1.optimizeFor(64);
        var4_4 = var1_1.getMeasurer();
        for (var5_5 = 0; var5_5 < var2_2; ++var5_5) {
            block11: {
                var6_6 = (ConstraintWidget)var1_1.mChildren.get(var5_5);
                if (var6_6 instanceof Guideline || var6_6 instanceof Barrier || var6_6.isInVirtualLayout() || var3_3 && var6_6.horizontalRun != null && var6_6.verticalRun != null && var6_6.horizontalRun.dimension.resolved && var6_6.verticalRun.dimension.resolved) continue;
                var7_7 = var6_6.getDimensionBehaviour(0);
                var8_8 = true;
                var9_9 /* !! */  = var6_6.getDimensionBehaviour(1);
                var10_10 = var7_7 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && var6_6.mMatchConstraintDefaultWidth != 1 && var9_9 /* !! */  == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && var6_6.mMatchConstraintDefaultHeight != 1;
                var11_11 = var10_10;
                if (var10_10) ** GOTO lbl-1000
                var11_11 = var10_10;
                if (!var1_1.optimizeFor(1)) ** GOTO lbl-1000
                var11_11 = var10_10;
                if (var6_6 instanceof VirtualLayout) ** GOTO lbl-1000
                var11_11 = var10_10;
                if (var7_7 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    var11_11 = var10_10;
                    if (var6_6.mMatchConstraintDefaultWidth == 0) {
                        var11_11 = var10_10;
                        if (var9_9 /* !! */  != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            var11_11 = var10_10;
                            if (!var6_6.isInHorizontalChain()) {
                                var11_11 = true;
                            }
                        }
                    }
                }
                var10_10 = var11_11;
                if (var9_9 /* !! */  == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    var10_10 = var11_11;
                    if (var6_6.mMatchConstraintDefaultHeight == 0) {
                        var10_10 = var11_11;
                        if (var7_7 != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            var10_10 = var11_11;
                            if (!var6_6.isInHorizontalChain()) {
                                var10_10 = true;
                            }
                        }
                    }
                }
                if (var7_7 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block11;
                var11_11 = var10_10;
                if (var9_9 /* !! */  != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) ** GOTO lbl-1000
            }
            var11_11 = var10_10;
            if (var6_6.mDimensionRatio > 0.0f) {
                var10_10 = var8_8;
            } else lbl-1000:
            // 5 sources

            {
                var10_10 = var11_11;
            }
            if (var10_10) continue;
            this.measure(var4_4, var6_6, Measure.SELF_DIMENSIONS);
            if (var1_1.mMetrics == null) continue;
            var9_9 /* !! */  = var1_1.mMetrics;
            ++var9_9 /* !! */ .measuredWidgets;
        }
        var4_4.didMeasures();
    }

    private void solveLinearSystem(ConstraintWidgetContainer constraintWidgetContainer, String string2, int n, int n2, int n3) {
        int n4 = constraintWidgetContainer.getMinWidth();
        int n5 = constraintWidgetContainer.getMinHeight();
        constraintWidgetContainer.setMinWidth(0);
        constraintWidgetContainer.setMinHeight(0);
        constraintWidgetContainer.setWidth(n2);
        constraintWidgetContainer.setHeight(n3);
        constraintWidgetContainer.setMinWidth(n4);
        constraintWidgetContainer.setMinHeight(n5);
        this.constraintWidgetContainer.setPass(n);
        this.constraintWidgetContainer.layout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public long solverMeasure(ConstraintWidgetContainer constraintWidgetContainer, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        Object object;
        Measurer measurer = constraintWidgetContainer.getMeasurer();
        n9 = constraintWidgetContainer.mChildren.size();
        int n11 = constraintWidgetContainer.getWidth();
        int n12 = constraintWidgetContainer.getHeight();
        boolean bl = Optimizer.enabled(n, 128);
        n = !bl && !Optimizer.enabled(n, 64) ? 0 : 1;
        n3 = n;
        if (n != 0) {
            n2 = 0;
            while (true) {
                n3 = n;
                if (n2 >= n9) break;
                object = (ConstraintWidget)constraintWidgetContainer.mChildren.get(n2);
                n3 = ((ConstraintWidget)object).getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
                n8 = ((ConstraintWidget)object).getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
                n3 = n3 != 0 && n8 != 0 && ((ConstraintWidget)object).getDimensionRatio() > 0.0f ? 1 : 0;
                if (((ConstraintWidget)object).isInHorizontalChain() && n3 != 0 || ((ConstraintWidget)object).isInVerticalChain() && n3 != 0 || object instanceof VirtualLayout || ((ConstraintWidget)object).isInHorizontalChain() || ((ConstraintWidget)object).isInVerticalChain()) {
                    n3 = 0;
                    break;
                }
                ++n2;
            }
        }
        if (n3 != 0 && LinearSystem.sMetrics != null) {
            object = LinearSystem.sMetrics;
            ++((Metrics)object).measures;
        }
        if ((n10 = n3 & (n = n4 == 0x40000000 && n6 == 0x40000000 || bl ? 1 : 0)) != 0) {
            boolean bl2;
            n = Math.min(constraintWidgetContainer.getMaxWidth(), n5);
            n2 = Math.min(constraintWidgetContainer.getMaxHeight(), n7);
            if (n4 == 0x40000000 && constraintWidgetContainer.getWidth() != n) {
                constraintWidgetContainer.setWidth(n);
                constraintWidgetContainer.invalidateGraph();
            }
            if (n6 == 0x40000000 && constraintWidgetContainer.getHeight() != n2) {
                constraintWidgetContainer.setHeight(n2);
                constraintWidgetContainer.invalidateGraph();
            }
            if (n4 == 0x40000000 && n6 == 0x40000000) {
                bl2 = constraintWidgetContainer.directMeasure(bl);
                n = 2;
            } else {
                bl2 = constraintWidgetContainer.directMeasureSetup(bl);
                if (n4 == 0x40000000) {
                    bl2 &= constraintWidgetContainer.directMeasureWithOrientation(bl, 0);
                    n = 1;
                } else {
                    n = 0;
                }
                if (n6 == 0x40000000) {
                    bl2 = constraintWidgetContainer.directMeasureWithOrientation(bl, 1) & bl2;
                    ++n;
                }
            }
            bl = bl2;
            n2 = n;
            if (bl2) {
                bl = n4 == 0x40000000;
                boolean bl3 = n6 == 0x40000000;
                constraintWidgetContainer.updateFromRuns(bl, bl3);
                bl = bl2;
                n2 = n;
            }
        } else {
            bl = false;
            n2 = 0;
        }
        if (!bl || n2 != 2) {
            n3 = constraintWidgetContainer.getOptimizationLevel();
            if (n9 > 0) {
                this.measureChildren(constraintWidgetContainer);
            }
            this.updateHierarchy(constraintWidgetContainer);
            n7 = this.mVariableDimensionsWidgets.size();
            if (n9 > 0) {
                this.solveLinearSystem(constraintWidgetContainer, "First pass", 0, n11, n12);
            }
            if (n7 > 0) {
                int n13;
                int n14;
                int n15;
                Object object2;
                n8 = constraintWidgetContainer.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT ? 1 : 0;
                n9 = constraintWidgetContainer.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT ? 1 : 0;
                n2 = Math.max(constraintWidgetContainer.getWidth(), this.constraintWidgetContainer.getMinWidth());
                n = Math.max(constraintWidgetContainer.getHeight(), this.constraintWidgetContainer.getMinHeight());
                n4 = 0;
                for (n6 = 0; n6 < n7; ++n6) {
                    object2 = this.mVariableDimensionsWidgets.get(n6);
                    if (!(object2 instanceof VirtualLayout)) {
                        n5 = n4;
                    } else {
                        n15 = ((ConstraintWidget)object2).getWidth();
                        n14 = ((ConstraintWidget)object2).getHeight();
                        n5 = this.measure(measurer, (ConstraintWidget)object2, Measure.TRY_GIVEN_DIMENSIONS) | n4;
                        if (constraintWidgetContainer.mMetrics != null) {
                            object = constraintWidgetContainer.mMetrics;
                            ++((Metrics)object).measuredMatchWidgets;
                        }
                        n4 = ((ConstraintWidget)object2).getWidth();
                        n13 = ((ConstraintWidget)object2).getHeight();
                        if (n4 != n15) {
                            ((ConstraintWidget)object2).setWidth(n4);
                            n4 = n2;
                            if (n8 != 0) {
                                n4 = n2;
                                if (((ConstraintWidget)object2).getRight() > n2) {
                                    n4 = Math.max(n2, ((ConstraintWidget)object2).getRight() + ((ConstraintWidget)object2).getAnchor(ConstraintAnchor.Type.RIGHT).getMargin());
                                }
                            }
                            n5 = 1;
                            n2 = n4;
                        }
                        n4 = n;
                        if (n13 != n14) {
                            ((ConstraintWidget)object2).setHeight(n13);
                            n4 = n;
                            if (n9 != 0) {
                                n4 = n;
                                if (((ConstraintWidget)object2).getBottom() > n) {
                                    n4 = Math.max(n, ((ConstraintWidget)object2).getBottom() + ((ConstraintWidget)object2).getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin());
                                }
                            }
                            n5 = 1;
                        }
                        n5 |= ((VirtualLayout)object2).needSolverPass();
                        n = n4;
                    }
                    n4 = n5;
                }
                n14 = 0;
                n6 = n4;
                n4 = n7;
                n5 = n10;
                while (n14 < 2) {
                    for (n10 = 0; n10 < n4; ++n10) {
                        object = this.mVariableDimensionsWidgets.get(n10);
                        if (object instanceof Helper && !(object instanceof VirtualLayout) || object instanceof Guideline || ((ConstraintWidget)object).getVisibility() == 8 || n5 != 0 && ((ConstraintWidget)object).horizontalRun.dimension.resolved && ((ConstraintWidget)object).verticalRun.dimension.resolved || object instanceof VirtualLayout) {
                            n13 = n2;
                            n7 = n6;
                        } else {
                            int n16 = ((ConstraintWidget)object).getWidth();
                            n15 = ((ConstraintWidget)object).getHeight();
                            n13 = ((ConstraintWidget)object).getBaselineDistance();
                            n7 = Measure.TRY_GIVEN_DIMENSIONS;
                            if (n14 == 1) {
                                n7 = Measure.USE_GIVEN_DIMENSIONS;
                            }
                            n7 = this.measure(measurer, (ConstraintWidget)object, n7) | n6;
                            if (constraintWidgetContainer.mMetrics != null) {
                                object2 = constraintWidgetContainer.mMetrics;
                                ++((Metrics)object2).measuredMatchWidgets;
                            }
                            int n17 = ((ConstraintWidget)object).getWidth();
                            int n18 = ((ConstraintWidget)object).getHeight();
                            n6 = n2;
                            if (n17 != n16) {
                                ((ConstraintWidget)object).setWidth(n17);
                                n6 = n2;
                                if (n8 != 0) {
                                    n6 = n2;
                                    if (((ConstraintWidget)object).getRight() > n2) {
                                        n6 = Math.max(n2, ((ConstraintWidget)object).getRight() + ((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.RIGHT).getMargin());
                                    }
                                }
                                n7 = 1;
                            }
                            n2 = n;
                            if (n18 != n15) {
                                ((ConstraintWidget)object).setHeight(n18);
                                n2 = n;
                                if (n9 != 0) {
                                    n2 = n;
                                    if (((ConstraintWidget)object).getBottom() > n) {
                                        n2 = Math.max(n, ((ConstraintWidget)object).getBottom() + ((ConstraintWidget)object).getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin());
                                    }
                                }
                                n7 = 1;
                            }
                            if (((ConstraintWidget)object).hasBaseline() && n13 != ((ConstraintWidget)object).getBaselineDistance()) {
                                n7 = 1;
                                n13 = n6;
                                n = n2;
                            } else {
                                n = n2;
                                n13 = n6;
                            }
                        }
                        n2 = n13;
                        n6 = n7;
                    }
                    if (n6 == 0) break;
                    this.solveLinearSystem(constraintWidgetContainer, "intermediate pass", ++n14, n11, n12);
                    n6 = 0;
                }
            }
            constraintWidgetContainer.setOptimizationLevel(n3);
        }
        return 0L;
    }

    public void updateHierarchy(ConstraintWidgetContainer constraintWidgetContainer) {
        this.mVariableDimensionsWidgets.clear();
        int n = constraintWidgetContainer.mChildren.size();
        for (int i = 0; i < n; ++i) {
            ConstraintWidget constraintWidget = (ConstraintWidget)constraintWidgetContainer.mChildren.get(i);
            if (constraintWidget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && constraintWidget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            this.mVariableDimensionsWidgets.add(constraintWidget);
        }
        constraintWidgetContainer.invalidateGraph();
    }

    public static class Measure {
        public static int SELF_DIMENSIONS = 0;
        public static int TRY_GIVEN_DIMENSIONS = 1;
        public static int USE_GIVEN_DIMENSIONS = 2;
        public ConstraintWidget.DimensionBehaviour horizontalBehavior;
        public int horizontalDimension;
        public int measureStrategy;
        public int measuredBaseline;
        public boolean measuredHasBaseline;
        public int measuredHeight;
        public boolean measuredNeedsSolverPass;
        public int measuredWidth;
        public ConstraintWidget.DimensionBehaviour verticalBehavior;
        public int verticalDimension;
    }

    public static interface Measurer {
        public void didMeasures();

        public void measure(ConstraintWidget var1, Measure var2);
    }
}

