/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.GuidelineReference;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DependencyGraph {
    private static final boolean USE_GROUPS = true;
    private ConstraintWidgetContainer container;
    private ConstraintWidgetContainer mContainer;
    ArrayList<RunGroup> mGroups;
    private BasicMeasure.Measure mMeasure;
    private BasicMeasure.Measurer mMeasurer = null;
    private boolean mNeedBuildGraph = true;
    private boolean mNeedRedoMeasures = true;
    private ArrayList<WidgetRun> mRuns = new ArrayList();
    private ArrayList<RunGroup> runGroups = new ArrayList();

    public DependencyGraph(ConstraintWidgetContainer constraintWidgetContainer) {
        this.mMeasure = new BasicMeasure.Measure();
        this.mGroups = new ArrayList();
        this.container = constraintWidgetContainer;
        this.mContainer = constraintWidgetContainer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyGroup(DependencyNode object, int n, int n2, DependencyNode dependencyNode, ArrayList<RunGroup> arrayList, RunGroup object2) {
        WidgetRun widgetRun = ((DependencyNode)object).run;
        if (widgetRun.runGroup != null) return;
        if (widgetRun == this.container.horizontalRun) return;
        if (widgetRun == this.container.verticalRun) {
            return;
        }
        object = object2;
        if (object2 == null) {
            object = new RunGroup(widgetRun, n2);
            arrayList.add((RunGroup)object);
        }
        widgetRun.runGroup = object;
        ((RunGroup)object).add(widgetRun);
        for (Dependency dependency : widgetRun.start.dependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependency, n, 0, dependencyNode, arrayList, (RunGroup)object);
        }
        for (Dependency dependency : widgetRun.end.dependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependency, n, 1, dependencyNode, arrayList, (RunGroup)object);
        }
        if (n == 1 && widgetRun instanceof VerticalWidgetRun) {
            for (Dependency dependency : ((VerticalWidgetRun)widgetRun).baseline.dependencies) {
                if (!(dependency instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependency, n, 2, dependencyNode, arrayList, (RunGroup)object);
            }
        }
        for (DependencyNode dependencyNode2 : widgetRun.start.targets) {
            if (dependencyNode2 == dependencyNode) {
                ((RunGroup)object).dual = true;
            }
            this.applyGroup(dependencyNode2, n, 0, dependencyNode, arrayList, (RunGroup)object);
        }
        for (DependencyNode dependencyNode3 : widgetRun.end.targets) {
            if (dependencyNode3 == dependencyNode) {
                ((RunGroup)object).dual = true;
            }
            this.applyGroup(dependencyNode3, n, 1, dependencyNode, arrayList, (RunGroup)object);
        }
        if (n != 1) return;
        if (!(widgetRun instanceof VerticalWidgetRun)) return;
        Iterator<DependencyNode> iterator = ((VerticalWidgetRun)widgetRun).baseline.targets.iterator();
        while (iterator.hasNext()) {
            DependencyNode dependencyNode4 = iterator.next();
            this.applyGroup(dependencyNode4, n, 2, dependencyNode, arrayList, (RunGroup)object);
        }
    }

    private boolean basicMeasureWidgets(ConstraintWidgetContainer constraintWidgetContainer) {
        for (ConstraintWidget constraintWidget : constraintWidgetContainer.mChildren) {
            int n;
            int n2;
            int n3;
            ConstraintWidget.DimensionBehaviour dimensionBehaviour;
            ConstraintWidget.DimensionBehaviour dimensionBehaviour2;
            ConstraintWidget.DimensionBehaviour dimensionBehaviour3;
            block37: {
                block38: {
                    dimensionBehaviour3 = constraintWidget.mListDimensionBehaviors[0];
                    dimensionBehaviour2 = constraintWidget.mListDimensionBehaviors[1];
                    if (constraintWidget.getVisibility() == 8) {
                        constraintWidget.measured = true;
                        continue;
                    }
                    if (constraintWidget.mMatchConstraintPercentWidth < 1.0f && dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        constraintWidget.mMatchConstraintDefaultWidth = 2;
                    }
                    if (constraintWidget.mMatchConstraintPercentHeight < 1.0f && dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        constraintWidget.mMatchConstraintDefaultHeight = 2;
                    }
                    if (constraintWidget.getDimensionRatio() > 0.0f) {
                        if (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.FIXED)) {
                            constraintWidget.mMatchConstraintDefaultWidth = 3;
                        } else if (dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.FIXED)) {
                            constraintWidget.mMatchConstraintDefaultHeight = 3;
                        } else if (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            if (constraintWidget.mMatchConstraintDefaultWidth == 0) {
                                constraintWidget.mMatchConstraintDefaultWidth = 3;
                            }
                            if (constraintWidget.mMatchConstraintDefaultHeight == 0) {
                                constraintWidget.mMatchConstraintDefaultHeight = 3;
                            }
                        }
                    }
                    dimensionBehaviour = dimensionBehaviour3;
                    if (dimensionBehaviour3 != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block37;
                    dimensionBehaviour = dimensionBehaviour3;
                    if (constraintWidget.mMatchConstraintDefaultWidth != 1) break block37;
                    if (constraintWidget.mLeft.mTarget == null) break block38;
                    dimensionBehaviour = dimensionBehaviour3;
                    if (constraintWidget.mRight.mTarget != null) break block37;
                }
                dimensionBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            dimensionBehaviour3 = dimensionBehaviour;
            dimensionBehaviour = dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && constraintWidget.mMatchConstraintDefaultHeight == 1 && (constraintWidget.mTop.mTarget == null || constraintWidget.mBottom.mTarget == null) ? ConstraintWidget.DimensionBehaviour.WRAP_CONTENT : dimensionBehaviour2;
            constraintWidget.horizontalRun.dimensionBehavior = dimensionBehaviour3;
            constraintWidget.horizontalRun.matchConstraintsType = constraintWidget.mMatchConstraintDefaultWidth;
            constraintWidget.verticalRun.dimensionBehavior = dimensionBehaviour;
            constraintWidget.verticalRun.matchConstraintsType = constraintWidget.mMatchConstraintDefaultHeight;
            if (dimensionBehaviour3 != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && dimensionBehaviour3 != ConstraintWidget.DimensionBehaviour.FIXED && dimensionBehaviour3 != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || dimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && dimensionBehaviour != ConstraintWidget.DimensionBehaviour.FIXED && dimensionBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                float f;
                float f2;
                if (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || dimensionBehaviour == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    if (constraintWidget.mMatchConstraintDefaultWidth == 3) {
                        if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                            this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                        }
                        n3 = constraintWidget.getHeight();
                        n2 = (int)((float)n3 * constraintWidget.mDimensionRatio + 0.5f);
                        this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, n2, ConstraintWidget.DimensionBehaviour.FIXED, n3);
                        constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                        constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                        constraintWidget.measured = true;
                        continue;
                    }
                    if (constraintWidget.mMatchConstraintDefaultWidth == 1) {
                        this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, dimensionBehaviour, 0);
                        constraintWidget.horizontalRun.dimension.wrapValue = constraintWidget.getWidth();
                        continue;
                    }
                    if (constraintWidget.mMatchConstraintDefaultWidth == 2) {
                        if (constraintWidgetContainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                            n3 = (int)(constraintWidget.mMatchConstraintPercentWidth * (float)constraintWidgetContainer.getWidth() + 0.5f);
                            n2 = constraintWidget.getHeight();
                            this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, n3, dimensionBehaviour, n2);
                            constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                            constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                            constraintWidget.measured = true;
                            continue;
                        }
                    } else if (constraintWidget.mListAnchors[0].mTarget == null || constraintWidget.mListAnchors[1].mTarget == null) {
                        this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, dimensionBehaviour, 0);
                        constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                        constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                        constraintWidget.measured = true;
                        continue;
                    }
                }
                if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    if (constraintWidget.mMatchConstraintDefaultHeight == 3) {
                        if (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                            this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                        }
                        n2 = constraintWidget.getWidth();
                        f = f2 = constraintWidget.mDimensionRatio;
                        if (constraintWidget.getDimensionRatioSide() == -1) {
                            f = 1.0f / f2;
                        }
                        n3 = (int)((float)n2 * f + 0.5f);
                        this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, n2, ConstraintWidget.DimensionBehaviour.FIXED, n3);
                        constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                        constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                        constraintWidget.measured = true;
                        continue;
                    }
                    if (constraintWidget.mMatchConstraintDefaultHeight == 1) {
                        this.measure(constraintWidget, dimensionBehaviour3, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                        constraintWidget.verticalRun.dimension.wrapValue = constraintWidget.getHeight();
                        continue;
                    }
                    if (constraintWidget.mMatchConstraintDefaultHeight == 2) {
                        if (constraintWidgetContainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                            f = constraintWidget.mMatchConstraintPercentHeight;
                            n2 = constraintWidget.getWidth();
                            n3 = (int)(f * (float)constraintWidgetContainer.getHeight() + 0.5f);
                            this.measure(constraintWidget, dimensionBehaviour3, n2, ConstraintWidget.DimensionBehaviour.FIXED, n3);
                            constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                            constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                            constraintWidget.measured = true;
                            continue;
                        }
                    } else if (constraintWidget.mListAnchors[2].mTarget == null || constraintWidget.mListAnchors[3].mTarget == null) {
                        this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, dimensionBehaviour, 0);
                        constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                        constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                        constraintWidget.measured = true;
                        continue;
                    }
                }
                if (dimensionBehaviour3 != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || dimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
                if (constraintWidget.mMatchConstraintDefaultWidth != 1 && constraintWidget.mMatchConstraintDefaultHeight != 1) {
                    if (constraintWidget.mMatchConstraintDefaultHeight != 2 || constraintWidget.mMatchConstraintDefaultWidth != 2 || constraintWidgetContainer.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
                    f2 = constraintWidget.mMatchConstraintPercentWidth;
                    f = constraintWidget.mMatchConstraintPercentHeight;
                    n3 = (int)(f2 * (float)constraintWidgetContainer.getWidth() + 0.5f);
                    n2 = (int)(f * (float)constraintWidgetContainer.getHeight() + 0.5f);
                    this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, n3, ConstraintWidget.DimensionBehaviour.FIXED, n2);
                    constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                    constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                    constraintWidget.measured = true;
                    continue;
                }
                this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                constraintWidget.horizontalRun.dimension.wrapValue = constraintWidget.getWidth();
                constraintWidget.verticalRun.dimension.wrapValue = constraintWidget.getHeight();
                continue;
            }
            n3 = constraintWidget.getWidth();
            if (dimensionBehaviour3 == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                n = constraintWidgetContainer.getWidth();
                n3 = constraintWidget.mLeft.mMargin;
                n2 = constraintWidget.mRight.mMargin;
                dimensionBehaviour3 = ConstraintWidget.DimensionBehaviour.FIXED;
                n3 = n - n3 - n2;
            }
            n2 = constraintWidget.getHeight();
            if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                n2 = constraintWidgetContainer.getHeight();
                int n4 = constraintWidget.mTop.mMargin;
                n = constraintWidget.mBottom.mMargin;
                dimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
                n2 = n2 - n4 - n;
            }
            this.measure(constraintWidget, dimensionBehaviour3, n3, dimensionBehaviour, n2);
            constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
            constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
            constraintWidget.measured = true;
        }
        return false;
    }

    private int computeWrap(ConstraintWidgetContainer constraintWidgetContainer, int n) {
        int n2 = this.mGroups.size();
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l = Math.max(l, this.mGroups.get(i).computeWrapSize(constraintWidgetContainer, n));
        }
        return (int)l;
    }

    private void displayGraph() {
        Object object = this.mRuns.iterator();
        CharSequence charSequence = "digraph {\n";
        while (object.hasNext()) {
            charSequence = this.generateDisplayGraph(object.next(), (String)charSequence);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append((String)charSequence);
        ((StringBuilder)object).append("\n}\n");
        object = ((StringBuilder)object).toString();
        PrintStream printStream = System.out;
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("content:<<\n");
        ((StringBuilder)charSequence).append((String)object);
        ((StringBuilder)charSequence).append("\n>>");
        printStream.println(((StringBuilder)charSequence).toString());
    }

    private void findGroup(WidgetRun object, int n, ArrayList<RunGroup> arrayList) {
        for (Dependency dependency : ((WidgetRun)((Object)object)).start.dependencies) {
            if (dependency instanceof DependencyNode) {
                this.applyGroup((DependencyNode)dependency, n, 0, ((WidgetRun)((Object)object)).end, arrayList, null);
                continue;
            }
            if (!(dependency instanceof WidgetRun)) continue;
            this.applyGroup(((WidgetRun)dependency).start, n, 0, ((WidgetRun)((Object)object)).end, arrayList, null);
        }
        for (Dependency dependency : ((WidgetRun)((Object)object)).end.dependencies) {
            if (dependency instanceof DependencyNode) {
                this.applyGroup((DependencyNode)dependency, n, 1, ((WidgetRun)((Object)object)).start, arrayList, null);
                continue;
            }
            if (!(dependency instanceof WidgetRun)) continue;
            this.applyGroup(((WidgetRun)dependency).end, n, 1, ((WidgetRun)((Object)object)).start, arrayList, null);
        }
        if (n == 1) {
            for (Dependency dependency : ((VerticalWidgetRun)((Object)object)).baseline.dependencies) {
                if (!(dependency instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependency, n, 2, null, arrayList, null);
            }
        }
    }

    private String generateChainDisplayGraph(ChainRun object, String string2) {
        int n = ((ChainRun)object).orientation;
        StringBuilder stringBuilder = new StringBuilder("subgraph ");
        stringBuilder.append("cluster_");
        stringBuilder.append(((ChainRun)object).widget.getDebugName());
        if (n == 0) {
            stringBuilder.append("_h");
        } else {
            stringBuilder.append("_v");
        }
        stringBuilder.append(" {\n");
        Object object2 = ((ChainRun)object).widgets.iterator();
        object = "";
        while (object2.hasNext()) {
            WidgetRun widgetRun = object2.next();
            stringBuilder.append(widgetRun.widget.getDebugName());
            if (n == 0) {
                stringBuilder.append("_HORIZONTAL");
            } else {
                stringBuilder.append("_VERTICAL");
            }
            stringBuilder.append(";\n");
            object = this.generateDisplayGraph(widgetRun, (String)object);
        }
        stringBuilder.append("}\n");
        object2 = new StringBuilder();
        ((StringBuilder)object2).append(string2);
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append((Object)stringBuilder);
        return ((StringBuilder)object2).toString();
    }

    private String generateDisplayGraph(WidgetRun widgetRun, String string2) {
        DependencyNode dependencyNode = widgetRun.start;
        DependencyNode dependencyNode2 = widgetRun.end;
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (!(widgetRun instanceof HelperReferences) && dependencyNode.dependencies.isEmpty() && dependencyNode2.dependencies.isEmpty() & dependencyNode.targets.isEmpty() && dependencyNode2.targets.isEmpty()) {
            return string2;
        }
        stringBuilder.append(this.nodeDefinition(widgetRun));
        boolean bl = this.isCenteredConnection(dependencyNode, dependencyNode2);
        Object object = this.generateDisplayNode(dependencyNode2, bl, this.generateDisplayNode(dependencyNode, bl, string2));
        boolean bl2 = widgetRun instanceof VerticalWidgetRun;
        string2 = object;
        if (bl2) {
            string2 = this.generateDisplayNode(((VerticalWidgetRun)widgetRun).baseline, bl, (String)object);
        }
        if (!(widgetRun instanceof HorizontalWidgetRun || (bl = widgetRun instanceof ChainRun) && ((ChainRun)widgetRun).orientation == 0)) {
            if (bl2 || bl && ((ChainRun)widgetRun).orientation == 1) {
                object = widgetRun.widget.getVerticalDimensionBehaviour();
                if (object != ConstraintWidget.DimensionBehaviour.FIXED && object != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    if (object == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widgetRun.widget.getDimensionRatio() > 0.0f) {
                        stringBuilder.append("\n");
                        stringBuilder.append(widgetRun.widget.getDebugName());
                        stringBuilder.append("_VERTICAL -> ");
                        stringBuilder.append(widgetRun.widget.getDebugName());
                        stringBuilder.append("_HORIZONTAL;\n");
                    }
                } else if (!dependencyNode.targets.isEmpty() && dependencyNode2.targets.isEmpty()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(dependencyNode2.name());
                    stringBuilder.append(" -> ");
                    stringBuilder.append(dependencyNode.name());
                    stringBuilder.append("\n");
                } else if (dependencyNode.targets.isEmpty() && !dependencyNode2.targets.isEmpty()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(dependencyNode.name());
                    stringBuilder.append(" -> ");
                    stringBuilder.append(dependencyNode2.name());
                    stringBuilder.append("\n");
                }
            }
        } else {
            object = widgetRun.widget.getHorizontalDimensionBehaviour();
            if (object != ConstraintWidget.DimensionBehaviour.FIXED && object != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (object == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widgetRun.widget.getDimensionRatio() > 0.0f) {
                    stringBuilder.append("\n");
                    stringBuilder.append(widgetRun.widget.getDebugName());
                    stringBuilder.append("_HORIZONTAL -> ");
                    stringBuilder.append(widgetRun.widget.getDebugName());
                    stringBuilder.append("_VERTICAL;\n");
                }
            } else if (!dependencyNode.targets.isEmpty() && dependencyNode2.targets.isEmpty()) {
                stringBuilder.append("\n");
                stringBuilder.append(dependencyNode2.name());
                stringBuilder.append(" -> ");
                stringBuilder.append(dependencyNode.name());
                stringBuilder.append("\n");
            } else if (dependencyNode.targets.isEmpty() && !dependencyNode2.targets.isEmpty()) {
                stringBuilder.append("\n");
                stringBuilder.append(dependencyNode.name());
                stringBuilder.append(" -> ");
                stringBuilder.append(dependencyNode2.name());
                stringBuilder.append("\n");
            }
        }
        if (widgetRun instanceof ChainRun) {
            return this.generateChainDisplayGraph((ChainRun)widgetRun, string2);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String generateDisplayNode(DependencyNode dependencyNode, boolean bl, String object2) {
        StringBuilder stringBuilder = new StringBuilder((String)object2);
        for (DependencyNode dependencyNode2 : dependencyNode.targets) {
            void var3_20;
            CharSequence charSequence;
            block9: {
                void var3_18;
                void var3_14;
                block8: {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("\n");
                    ((StringBuilder)charSequence).append(dependencyNode.name());
                    charSequence = ((StringBuilder)charSequence).toString();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append((String)charSequence);
                    stringBuilder2.append(" -> ");
                    stringBuilder2.append(dependencyNode2.name());
                    charSequence = stringBuilder2.toString();
                    if (dependencyNode.margin > 0 || bl) break block8;
                    CharSequence charSequence2 = charSequence;
                    if (!(dependencyNode.run instanceof HelperReferences)) break block9;
                }
                StringBuilder stringBuilder3 = new StringBuilder();
                stringBuilder3.append((String)charSequence);
                stringBuilder3.append("[");
                CharSequence charSequence3 = charSequence = stringBuilder3.toString();
                if (dependencyNode.margin > 0) {
                    StringBuilder stringBuilder4 = new StringBuilder();
                    stringBuilder4.append((String)charSequence);
                    stringBuilder4.append("label=\"");
                    stringBuilder4.append(dependencyNode.margin);
                    stringBuilder4.append("\"");
                    CharSequence charSequence4 = charSequence = stringBuilder4.toString();
                    if (bl) {
                        StringBuilder stringBuilder5 = new StringBuilder();
                        stringBuilder5.append((String)charSequence);
                        stringBuilder5.append(",");
                        String string2 = stringBuilder5.toString();
                    }
                }
                charSequence = var3_14;
                if (bl) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)var3_14);
                    ((StringBuilder)charSequence).append(" style=dashed ");
                    charSequence = ((StringBuilder)charSequence).toString();
                }
                CharSequence charSequence5 = charSequence;
                if (dependencyNode.run instanceof HelperReferences) {
                    StringBuilder stringBuilder6 = new StringBuilder();
                    stringBuilder6.append((String)charSequence);
                    stringBuilder6.append(" style=bold,color=gray ");
                    String string3 = stringBuilder6.toString();
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)var3_18);
                ((StringBuilder)charSequence).append("]");
                String string4 = ((StringBuilder)charSequence).toString();
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)var3_20);
            ((StringBuilder)charSequence).append("\n");
            stringBuilder.append(((StringBuilder)charSequence).toString());
        }
        return stringBuilder.toString();
    }

    private boolean isCenteredConnection(DependencyNode dependencyNode, DependencyNode object) {
        Iterator<DependencyNode> iterator = dependencyNode.targets.iterator();
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            if (iterator.next() == object) continue;
            ++n;
        }
        object = ((DependencyNode)object).targets.iterator();
        int n2 = 0;
        while (object.hasNext()) {
            if ((DependencyNode)object.next() == dependencyNode) continue;
            ++n2;
        }
        boolean bl2 = bl;
        if (n > 0) {
            bl2 = bl;
            if (n2 > 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private void measure(ConstraintWidget constraintWidget, ConstraintWidget.DimensionBehaviour dimensionBehaviour, int n, ConstraintWidget.DimensionBehaviour dimensionBehaviour2, int n2) {
        this.mMeasure.horizontalBehavior = dimensionBehaviour;
        this.mMeasure.verticalBehavior = dimensionBehaviour2;
        this.mMeasure.horizontalDimension = n;
        this.mMeasure.verticalDimension = n2;
        this.mMeasurer.measure(constraintWidget, this.mMeasure);
        constraintWidget.setWidth(this.mMeasure.measuredWidth);
        constraintWidget.setHeight(this.mMeasure.measuredHeight);
        constraintWidget.setHasBaseline(this.mMeasure.measuredHasBaseline);
        constraintWidget.setBaselineDistance(this.mMeasure.measuredBaseline);
    }

    private String nodeDefinition(WidgetRun widgetRun) {
        boolean bl = widgetRun instanceof VerticalWidgetRun;
        String string2 = widgetRun.widget.getDebugName();
        StringBuilder stringBuilder = new StringBuilder(string2);
        Object object = widgetRun.widget;
        object = !bl ? object.getHorizontalDimensionBehaviour() : object.getVerticalDimensionBehaviour();
        RunGroup runGroup = widgetRun.runGroup;
        if (!bl) {
            stringBuilder.append("_HORIZONTAL");
        } else {
            stringBuilder.append("_VERTICAL");
        }
        stringBuilder.append(" [shape=none, label=<");
        stringBuilder.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">");
        stringBuilder.append("  <TR>");
        if (!bl) {
            stringBuilder.append("    <TD ");
            if (widgetRun.start.resolved) {
                stringBuilder.append(" BGCOLOR=\"green\"");
            }
            stringBuilder.append(" PORT=\"LEFT\" BORDER=\"1\">L</TD>");
        } else {
            stringBuilder.append("    <TD ");
            if (widgetRun.start.resolved) {
                stringBuilder.append(" BGCOLOR=\"green\"");
            }
            stringBuilder.append(" PORT=\"TOP\" BORDER=\"1\">T</TD>");
        }
        stringBuilder.append("    <TD BORDER=\"1\" ");
        if (widgetRun.dimension.resolved && !widgetRun.widget.measured) {
            stringBuilder.append(" BGCOLOR=\"green\" ");
        } else if (widgetRun.dimension.resolved) {
            stringBuilder.append(" BGCOLOR=\"lightgray\" ");
        } else if (widgetRun.widget.measured) {
            stringBuilder.append(" BGCOLOR=\"yellow\" ");
        }
        if (object == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            stringBuilder.append("style=\"dashed\"");
        }
        stringBuilder.append(">");
        stringBuilder.append(string2);
        if (runGroup != null) {
            stringBuilder.append(" [");
            stringBuilder.append(runGroup.groupIndex + 1);
            stringBuilder.append("/");
            stringBuilder.append(RunGroup.index);
            stringBuilder.append("]");
        }
        stringBuilder.append(" </TD>");
        if (!bl) {
            stringBuilder.append("    <TD ");
            if (widgetRun.end.resolved) {
                stringBuilder.append(" BGCOLOR=\"green\"");
            }
            stringBuilder.append(" PORT=\"RIGHT\" BORDER=\"1\">R</TD>");
        } else {
            stringBuilder.append("    <TD ");
            if (((VerticalWidgetRun)widgetRun).baseline.resolved) {
                stringBuilder.append(" BGCOLOR=\"green\"");
            }
            stringBuilder.append(" PORT=\"BASELINE\" BORDER=\"1\">b</TD>");
            stringBuilder.append("    <TD ");
            if (widgetRun.end.resolved) {
                stringBuilder.append(" BGCOLOR=\"green\"");
            }
            stringBuilder.append(" PORT=\"BOTTOM\" BORDER=\"1\">B</TD>");
        }
        stringBuilder.append("  </TR></TABLE>");
        stringBuilder.append(">];\n");
        return stringBuilder.toString();
    }

    public void buildGraph() {
        this.buildGraph(this.mRuns);
        this.mGroups.clear();
        RunGroup.index = 0;
        this.findGroup(this.container.horizontalRun, 0, this.mGroups);
        this.findGroup(this.container.verticalRun, 1, this.mGroups);
        this.mNeedBuildGraph = false;
    }

    public void buildGraph(ArrayList<WidgetRun> object) {
        ((ArrayList)object).clear();
        this.mContainer.horizontalRun.clear();
        this.mContainer.verticalRun.clear();
        ((ArrayList)object).add((WidgetRun)this.mContainer.horizontalRun);
        ((ArrayList)object).add((WidgetRun)this.mContainer.verticalRun);
        Iterator iterator = this.mContainer.mChildren.iterator();
        HashSet<ChainRun> hashSet = null;
        while (iterator.hasNext()) {
            HashSet<ChainRun> hashSet2;
            ConstraintWidget constraintWidget = (ConstraintWidget)iterator.next();
            if (constraintWidget instanceof Guideline) {
                ((ArrayList)object).add((WidgetRun)new GuidelineReference(constraintWidget));
                continue;
            }
            if (constraintWidget.isInHorizontalChain()) {
                if (constraintWidget.horizontalChainRun == null) {
                    constraintWidget.horizontalChainRun = new ChainRun(constraintWidget, 0);
                }
                hashSet2 = hashSet;
                if (hashSet == null) {
                    hashSet2 = new HashSet();
                }
                hashSet2.add(constraintWidget.horizontalChainRun);
                hashSet = hashSet2;
            } else {
                ((ArrayList)object).add((WidgetRun)constraintWidget.horizontalRun);
            }
            if (constraintWidget.isInVerticalChain()) {
                if (constraintWidget.verticalChainRun == null) {
                    constraintWidget.verticalChainRun = new ChainRun(constraintWidget, 1);
                }
                hashSet2 = hashSet;
                if (hashSet == null) {
                    hashSet2 = new HashSet<ChainRun>();
                }
                hashSet2.add(constraintWidget.verticalChainRun);
            } else {
                ((ArrayList)object).add(constraintWidget.verticalRun);
                hashSet2 = hashSet;
            }
            hashSet = hashSet2;
            if (!(constraintWidget instanceof HelperWidget)) continue;
            ((ArrayList)object).add(new HelperReferences(constraintWidget));
            hashSet = hashSet2;
        }
        if (hashSet != null) {
            ((ArrayList)object).addAll(hashSet);
        }
        hashSet = ((ArrayList)object).iterator();
        while (hashSet.hasNext()) {
            hashSet.next().clear();
        }
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            hashSet = (WidgetRun)object.next();
            if (((WidgetRun)((Object)hashSet)).widget == this.mContainer) continue;
            ((WidgetRun)((Object)hashSet)).apply();
        }
    }

    public void defineTerminalWidgets(ConstraintWidget.DimensionBehaviour dimensionBehaviour, ConstraintWidget.DimensionBehaviour dimensionBehaviour2) {
        if (this.mNeedBuildGraph) {
            this.buildGraph();
            Iterator object2 = this.container.mChildren.iterator();
            boolean bl = false;
            while (object2.hasNext()) {
                ConstraintWidget constraintWidget = (ConstraintWidget)object2.next();
                constraintWidget.isTerminalWidget[0] = true;
                constraintWidget.isTerminalWidget[1] = true;
                if (!(constraintWidget instanceof Barrier)) continue;
                bl = true;
            }
            if (!bl) {
                for (RunGroup runGroup : this.mGroups) {
                    boolean bl2 = dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    boolean bl3 = dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    runGroup.defineTerminalWidgets(bl2, bl3);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean directMeasure(boolean bl) {
        ConstraintWidget.DimensionBehaviour dimensionBehaviour;
        ConstraintWidget.DimensionBehaviour dimensionBehaviour2;
        block15: {
            WidgetRun widgetRun2;
            Iterator<WidgetRun> iterator;
            int n;
            boolean bl2 = true;
            int n2 = bl & 1;
            if (this.mNeedBuildGraph || this.mNeedRedoMeasures) {
                for (ConstraintWidget constraintWidget : this.container.mChildren) {
                    constraintWidget.ensureWidgetRuns();
                    constraintWidget.measured = false;
                    constraintWidget.horizontalRun.reset();
                    constraintWidget.verticalRun.reset();
                }
                this.container.ensureWidgetRuns();
                this.container.measured = false;
                this.container.horizontalRun.reset();
                this.container.verticalRun.reset();
                this.mNeedRedoMeasures = false;
            }
            if (this.basicMeasureWidgets(this.mContainer)) {
                return false;
            }
            this.container.setX(0);
            this.container.setY(0);
            dimensionBehaviour2 = this.container.getDimensionBehaviour(0);
            dimensionBehaviour = this.container.getDimensionBehaviour(1);
            if (this.mNeedBuildGraph) {
                this.buildGraph();
            }
            int n3 = this.container.getX();
            int n4 = this.container.getY();
            this.container.horizontalRun.start.resolve(n3);
            this.container.verticalRun.start.resolve(n4);
            this.measureWidgets();
            if (dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                block14: {
                    n = n2;
                    if (n2 != 0) {
                        iterator = this.mRuns.iterator();
                        do {
                            n = n2;
                            if (!iterator.hasNext()) break block14;
                        } while (iterator.next().supportsWrapComputation());
                        n = 0;
                    }
                }
                if (n != 0 && dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.container.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    iterator = this.container;
                    ((ConstraintWidget)((Object)iterator)).setWidth(this.computeWrap((ConstraintWidgetContainer)((Object)iterator), 0));
                    this.container.horizontalRun.dimension.resolve(this.container.getWidth());
                }
                if (n != 0 && dimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.container.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    iterator = this.container;
                    ((ConstraintWidget)((Object)iterator)).setHeight(this.computeWrap((ConstraintWidgetContainer)((Object)iterator), 1));
                    this.container.verticalRun.dimension.resolve(this.container.getHeight());
                }
            }
            if (this.container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.FIXED && this.container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                n = 0;
            } else {
                n = this.container.getWidth() + n3;
                this.container.horizontalRun.end.resolve(n);
                this.container.horizontalRun.dimension.resolve(n - n3);
                this.measureWidgets();
                if (this.container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    n = this.container.getHeight() + n4;
                    this.container.verticalRun.end.resolve(n);
                    this.container.verticalRun.dimension.resolve(n - n4);
                }
                this.measureWidgets();
                n = 1;
            }
            for (WidgetRun widgetRun2 : this.mRuns) {
                if (widgetRun2.widget == this.container && !widgetRun2.resolved) continue;
                widgetRun2.applyToWidget();
            }
            iterator = this.mRuns.iterator();
            do {
                bl = bl2;
                if (!iterator.hasNext()) break block15;
                widgetRun2 = iterator.next();
            } while (n == 0 && widgetRun2.widget == this.container || widgetRun2.start.resolved && (widgetRun2.end.resolved || widgetRun2 instanceof GuidelineReference) && (widgetRun2.dimension.resolved || widgetRun2 instanceof ChainRun || widgetRun2 instanceof GuidelineReference));
            bl = false;
        }
        this.container.setHorizontalDimensionBehaviour(dimensionBehaviour2);
        this.container.setVerticalDimensionBehaviour(dimensionBehaviour);
        return bl;
    }

    public boolean directMeasureSetup(boolean bl) {
        if (this.mNeedBuildGraph) {
            for (ConstraintWidget constraintWidget : this.container.mChildren) {
                constraintWidget.ensureWidgetRuns();
                constraintWidget.measured = false;
                constraintWidget.horizontalRun.dimension.resolved = false;
                constraintWidget.horizontalRun.resolved = false;
                constraintWidget.horizontalRun.reset();
                constraintWidget.verticalRun.dimension.resolved = false;
                constraintWidget.verticalRun.resolved = false;
                constraintWidget.verticalRun.reset();
            }
            this.container.ensureWidgetRuns();
            this.container.measured = false;
            this.container.horizontalRun.dimension.resolved = false;
            this.container.horizontalRun.resolved = false;
            this.container.horizontalRun.reset();
            this.container.verticalRun.dimension.resolved = false;
            this.container.verticalRun.resolved = false;
            this.container.verticalRun.reset();
            this.buildGraph();
        }
        if (this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.container.setX(0);
        this.container.setY(0);
        this.container.horizontalRun.start.resolve(0);
        this.container.verticalRun.start.resolve(0);
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean directMeasureWithOrientation(boolean var1_1, int var2_2) {
        block13: {
            block14: {
                var3_3 = true;
                var4_4 = var1_1 & 1;
                var5_5 = this.container.getDimensionBehaviour(0);
                var6_6 = this.container.getDimensionBehaviour(1);
                var7_7 = this.container.getX();
                var8_8 = this.container.getY();
                if (var4_4 != 0 && (var5_5 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || var6_6 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
                    block12: {
                        var9_9 = this.mRuns.iterator();
                        do {
                            var10_10 = var4_4;
                            if (!var9_9.hasNext()) break block12;
                            var11_11 = var9_9.next();
                        } while (var11_11.orientation != var2_2 || var11_11.supportsWrapComputation());
                        var10_10 = 0;
                    }
                    if (var2_2 == 0) {
                        if (var10_10 != 0 && var5_5 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                            this.container.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                            var9_9 = this.container;
                            var9_9.setWidth(this.computeWrap((ConstraintWidgetContainer)var9_9, 0));
                            this.container.horizontalRun.dimension.resolve(this.container.getWidth());
                        }
                    } else if (var10_10 != 0 && var6_6 == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.container.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                        var9_9 = this.container;
                        var9_9.setHeight(this.computeWrap((ConstraintWidgetContainer)var9_9, 1));
                        this.container.verticalRun.dimension.resolve(this.container.getHeight());
                    }
                }
                if (var2_2 != 0) break block14;
                if (this.container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.FIXED && this.container.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) ** GOTO lbl-1000
                var10_10 = this.container.getWidth() + var7_7;
                this.container.horizontalRun.end.resolve(var10_10);
                this.container.horizontalRun.dimension.resolve(var10_10 - var7_7);
                ** GOTO lbl41
            }
            if (this.container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED && this.container.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) lbl-1000:
            // 2 sources

            {
                var10_10 = 0;
            } else {
                var10_10 = this.container.getHeight() + var8_8;
                this.container.verticalRun.end.resolve(var10_10);
                this.container.verticalRun.dimension.resolve(var10_10 - var8_8);
lbl41:
                // 2 sources

                var10_10 = 1;
            }
            this.measureWidgets();
            for (Object var9_9 : this.mRuns) {
                if (var9_9.orientation != var2_2 || var9_9.widget == this.container && !var9_9.resolved) continue;
                var9_9.applyToWidget();
            }
            var11_11 = this.mRuns.iterator();
            while (true) {
                var1_1 = var3_3;
                if (!var11_11.hasNext()) break block13;
                var9_9 = var11_11.next();
                if (var9_9.orientation != var2_2 || var10_10 == 0 && var9_9.widget == this.container) continue;
                if (!var9_9.start.resolved) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        var1_1 = false;
                        break block13;
                        break;
                    }
                }
                if (!var9_9.end.resolved || !(var9_9 instanceof ChainRun) && !var9_9.dimension.resolved) break;
            }
            ** while (true)
        }
        this.container.setHorizontalDimensionBehaviour(var5_5);
        this.container.setVerticalDimensionBehaviour(var6_6);
        return var1_1;
    }

    public void invalidateGraph() {
        this.mNeedBuildGraph = true;
    }

    public void invalidateMeasures() {
        this.mNeedRedoMeasures = true;
    }

    public void measureWidgets() {
        for (ConstraintWidget constraintWidget : this.container.mChildren) {
            boolean bl;
            int n;
            ConstraintWidget.DimensionBehaviour dimensionBehaviour;
            Object object;
            block14: {
                block13: {
                    if (constraintWidget.measured) continue;
                    object = constraintWidget.mListDimensionBehaviors;
                    boolean bl2 = false;
                    dimensionBehaviour = object[0];
                    object = constraintWidget.mListDimensionBehaviors[1];
                    n = constraintWidget.mMatchConstraintDefaultWidth;
                    int n2 = constraintWidget.mMatchConstraintDefaultHeight;
                    n = dimensionBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && (dimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || n != 1) ? 0 : 1;
                    if (object == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) break block13;
                    bl = bl2;
                    if (object != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block14;
                    bl = bl2;
                    if (n2 != 1) break block14;
                }
                bl = true;
            }
            boolean bl3 = constraintWidget.horizontalRun.dimension.resolved;
            boolean bl4 = constraintWidget.verticalRun.dimension.resolved;
            if (bl3 && bl4) {
                this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, constraintWidget.horizontalRun.dimension.value, ConstraintWidget.DimensionBehaviour.FIXED, constraintWidget.verticalRun.dimension.value);
                constraintWidget.measured = true;
            } else if (bl3 && bl) {
                this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.FIXED, constraintWidget.horizontalRun.dimension.value, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, constraintWidget.verticalRun.dimension.value);
                if (object == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    constraintWidget.verticalRun.dimension.wrapValue = constraintWidget.getHeight();
                } else {
                    constraintWidget.verticalRun.dimension.resolve(constraintWidget.getHeight());
                    constraintWidget.measured = true;
                }
            } else if (bl4 && n != 0) {
                this.measure(constraintWidget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, constraintWidget.horizontalRun.dimension.value, ConstraintWidget.DimensionBehaviour.FIXED, constraintWidget.verticalRun.dimension.value);
                if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    constraintWidget.horizontalRun.dimension.wrapValue = constraintWidget.getWidth();
                } else {
                    constraintWidget.horizontalRun.dimension.resolve(constraintWidget.getWidth());
                    constraintWidget.measured = true;
                }
            }
            if (!constraintWidget.measured || constraintWidget.verticalRun.baselineDimension == null) continue;
            constraintWidget.verticalRun.baselineDimension.resolve(constraintWidget.getBaselineDistance());
        }
    }

    public void setMeasurer(BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
    }
}

