/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.Iterator;

class RunGroup {
    public static final int BASELINE = 2;
    public static final int END = 1;
    public static final int START = 0;
    public static int index;
    int direction;
    public boolean dual = false;
    WidgetRun firstRun = null;
    int groupIndex = 0;
    WidgetRun lastRun = null;
    public int position = 0;
    ArrayList<WidgetRun> runs = new ArrayList();

    public RunGroup(WidgetRun widgetRun, int n) {
        int n2;
        this.groupIndex = n2 = index;
        index = n2 + 1;
        this.firstRun = widgetRun;
        this.lastRun = widgetRun;
        this.direction = n;
    }

    private boolean defineTerminalWidget(WidgetRun widgetRun, int n) {
        Object object;
        if (!widgetRun.widget.isTerminalWidget[n]) {
            return false;
        }
        for (Dependency dependency : widgetRun.start.dependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            object = (DependencyNode)dependency;
            if (((DependencyNode)object).run == widgetRun || object != ((DependencyNode)object).run.start) continue;
            if (widgetRun instanceof ChainRun) {
                Iterator<WidgetRun> iterator = ((ChainRun)widgetRun).widgets.iterator();
                while (iterator.hasNext()) {
                    this.defineTerminalWidget(iterator.next(), n);
                }
            } else if (!(widgetRun instanceof HelperReferences)) {
                widgetRun.widget.isTerminalWidget[n] = false;
            }
            this.defineTerminalWidget(((DependencyNode)object).run, n);
        }
        for (Dependency dependency : widgetRun.end.dependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            DependencyNode dependencyNode = (DependencyNode)dependency;
            if (dependencyNode.run == widgetRun || dependencyNode != dependencyNode.run.start) continue;
            if (widgetRun instanceof ChainRun) {
                object = ((ChainRun)widgetRun).widgets.iterator();
                while (object.hasNext()) {
                    this.defineTerminalWidget((WidgetRun)object.next(), n);
                }
            } else if (!(widgetRun instanceof HelperReferences)) {
                widgetRun.widget.isTerminalWidget[n] = false;
            }
            this.defineTerminalWidget(dependencyNode.run, n);
        }
        return false;
    }

    private long traverseEnd(DependencyNode dependencyNode, long l) {
        long l2;
        WidgetRun widgetRun = dependencyNode.run;
        if (widgetRun instanceof HelperReferences) {
            return l;
        }
        int n = dependencyNode.dependencies.size();
        long l3 = l;
        for (int i = 0; i < n; ++i) {
            Dependency dependency = dependencyNode.dependencies.get(i);
            l2 = l3;
            if (dependency instanceof DependencyNode) {
                dependency = (DependencyNode)dependency;
                l2 = ((DependencyNode)dependency).run == widgetRun ? l3 : Math.min(l3, this.traverseEnd((DependencyNode)dependency, (long)((DependencyNode)dependency).margin + l));
            }
            l3 = l2;
        }
        l2 = l3;
        if (dependencyNode == widgetRun.end) {
            l2 = widgetRun.getWrapDimension();
            dependencyNode = widgetRun.start;
            l -= l2;
            l2 = Math.min(Math.min(l3, this.traverseEnd(dependencyNode, l)), l - (long)widgetRun.start.margin);
        }
        return l2;
    }

    private long traverseStart(DependencyNode dependencyNode, long l) {
        long l2;
        WidgetRun widgetRun = dependencyNode.run;
        if (widgetRun instanceof HelperReferences) {
            return l;
        }
        int n = dependencyNode.dependencies.size();
        long l3 = l;
        for (int i = 0; i < n; ++i) {
            Dependency dependency = dependencyNode.dependencies.get(i);
            l2 = l3;
            if (dependency instanceof DependencyNode) {
                dependency = (DependencyNode)dependency;
                l2 = ((DependencyNode)dependency).run == widgetRun ? l3 : Math.max(l3, this.traverseStart((DependencyNode)dependency, (long)((DependencyNode)dependency).margin + l));
            }
            l3 = l2;
        }
        l2 = l3;
        if (dependencyNode == widgetRun.start) {
            l2 = widgetRun.getWrapDimension();
            dependencyNode = widgetRun.end;
            l += l2;
            l2 = Math.max(Math.max(l3, this.traverseStart(dependencyNode, l)), l - (long)widgetRun.end.margin);
        }
        return l2;
    }

    public void add(WidgetRun widgetRun) {
        this.runs.add(widgetRun);
        this.lastRun = widgetRun;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long computeWrapSize(ConstraintWidgetContainer object, int n) {
        long l;
        void var3_6;
        WidgetRun widgetRun = this.firstRun;
        boolean bl = widgetRun instanceof ChainRun;
        long l2 = 0L;
        if (bl ? ((ChainRun)widgetRun).orientation != n : (n == 0 ? !(widgetRun instanceof HorizontalWidgetRun) : !(widgetRun instanceof VerticalWidgetRun))) {
            return 0L;
        }
        if (n == 0) {
            DependencyNode dependencyNode = ((ConstraintWidgetContainer)object).horizontalRun.start;
        } else {
            DependencyNode dependencyNode = ((ConstraintWidgetContainer)object).verticalRun.start;
        }
        object = n == 0 ? ((ConstraintWidgetContainer)object).horizontalRun.end : ((ConstraintWidgetContainer)object).verticalRun.end;
        boolean bl2 = this.firstRun.start.targets.contains(var3_6);
        bl = this.firstRun.end.targets.contains(object);
        long l3 = this.firstRun.getWrapDimension();
        if (bl2 && bl) {
            float f;
            long l4;
            l = this.traverseStart(this.firstRun.start, 0L);
            long l5 = this.traverseEnd(this.firstRun.end, 0L);
            l = l4 = l - l3;
            if (l4 >= (long)(-this.firstRun.end.margin)) {
                l = l4 + (long)this.firstRun.end.margin;
            }
            l4 = l5 = -l5 - l3 - (long)this.firstRun.start.margin;
            if (l5 >= (long)this.firstRun.start.margin) {
                l4 = l5 - (long)this.firstRun.start.margin;
            }
            if ((f = this.firstRun.widget.getBiasPercent(n)) > 0.0f) {
                l2 = (long)((float)l4 / f + (float)l / (1.0f - f));
            }
            float f2 = l2;
            l = (long)(f2 * f + 0.5f);
            l4 = (long)(f2 * (1.0f - f) + 0.5f);
            l = (long)this.firstRun.start.margin + (l + l3 + l4);
            n = this.firstRun.end.margin;
        } else {
            if (bl2) {
                return Math.max(this.traverseStart(this.firstRun.start, this.firstRun.start.margin), (long)this.firstRun.start.margin + l3);
            }
            if (bl) {
                l = this.traverseEnd(this.firstRun.end, this.firstRun.end.margin);
                long l6 = -this.firstRun.end.margin;
                return Math.max(-l, l6 + l3);
            }
            l = (long)this.firstRun.start.margin + this.firstRun.getWrapDimension();
            n = this.firstRun.end.margin;
        }
        l -= (long)n;
        return l;
    }

    public void defineTerminalWidgets(boolean bl, boolean bl2) {
        WidgetRun widgetRun;
        if (bl && (widgetRun = this.firstRun) instanceof HorizontalWidgetRun) {
            this.defineTerminalWidget(widgetRun, 0);
        }
        if (bl2 && (widgetRun = this.firstRun) instanceof VerticalWidgetRun) {
            this.defineTerminalWidget(widgetRun, 1);
        }
    }
}

