/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.helper.widget.Carousel$$ExternalSyntheticLambda0;
import androidx.constraintlayout.motion.widget.MotionHelper;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Carousel
extends MotionHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "Carousel";
    public static final int TOUCH_UP_CARRY_ON = 2;
    public static final int TOUCH_UP_IMMEDIATE_STOP = 1;
    private int backwardTransition = -1;
    private float dampening = 0.9f;
    private int emptyViewBehavior = 4;
    private int firstViewReference = -1;
    private int forwardTransition = -1;
    private boolean infiniteCarousel = false;
    private Adapter mAdapter = null;
    private int mAnimateTargetDelay = 200;
    private int mIndex = 0;
    int mLastStartId = -1;
    private final ArrayList<View> mList = new ArrayList();
    private MotionLayout mMotionLayout;
    private int mPreviousIndex = 0;
    private int mTargetIndex = -1;
    Runnable mUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            Carousel.this.mMotionLayout.setProgress(0.0f);
            Carousel.this.updateItems();
            Carousel.this.mAdapter.onNewItem(Carousel.this.mIndex);
            float f = Carousel.this.mMotionLayout.getVelocity();
            if (Carousel.this.touchUpMode == 2 && f > Carousel.this.velocityThreshold && Carousel.this.mIndex < Carousel.this.mAdapter.count() - 1) {
                float f2 = Carousel.this.dampening;
                if (Carousel.this.mIndex == 0 && Carousel.this.mPreviousIndex > Carousel.this.mIndex) {
                    return;
                }
                if (Carousel.this.mIndex == Carousel.this.mAdapter.count() - 1 && Carousel.this.mPreviousIndex < Carousel.this.mIndex) {
                    return;
                }
                Carousel.this.mMotionLayout.post(new Runnable(f * f2){
                    final /* synthetic */ float val$v;
                    {
                        this.val$v = f;
                    }

                    @Override
                    public void run() {
                        Carousel.this.mMotionLayout.touchAnimateTo(5, 1.0f, this.val$v);
                    }
                });
            }
        }
    };
    private int nextState = -1;
    private int previousState = -1;
    private int startIndex = 0;
    private int touchUpMode = 1;
    private float velocityThreshold = 2.0f;

    public Carousel(Context context) {
        super(context);
    }

    public Carousel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public Carousel(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet);
    }

    private void enableAllTransitions(boolean bl) {
        Iterator<MotionScene.Transition> iterator = this.mMotionLayout.getDefinedTransitions().iterator();
        while (iterator.hasNext()) {
            iterator.next().setEnabled(bl);
        }
    }

    private boolean enableTransition(int n, boolean bl) {
        if (n == -1) {
            return false;
        }
        Object object = this.mMotionLayout;
        if (object == null) {
            return false;
        }
        if ((object = ((MotionLayout)object).getTransition(n)) == null) {
            return false;
        }
        if (bl == ((MotionScene.Transition)object).isEnabled()) {
            return false;
        }
        ((MotionScene.Transition)object).setEnabled(bl);
        return true;
    }

    private void init(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            context = context.obtainStyledAttributes(attributeSet, R.styleable.Carousel);
            int n = context.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = context.getIndex(i);
                if (n2 == R.styleable.Carousel_carousel_firstView) {
                    this.firstViewReference = context.getResourceId(n2, this.firstViewReference);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_backwardTransition) {
                    this.backwardTransition = context.getResourceId(n2, this.backwardTransition);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_forwardTransition) {
                    this.forwardTransition = context.getResourceId(n2, this.forwardTransition);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_emptyViewsBehavior) {
                    this.emptyViewBehavior = context.getInt(n2, this.emptyViewBehavior);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_previousState) {
                    this.previousState = context.getResourceId(n2, this.previousState);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_nextState) {
                    this.nextState = context.getResourceId(n2, this.nextState);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_touchUp_dampeningFactor) {
                    this.dampening = context.getFloat(n2, this.dampening);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_touchUpMode) {
                    this.touchUpMode = context.getInt(n2, this.touchUpMode);
                    continue;
                }
                if (n2 == R.styleable.Carousel_carousel_touchUp_velocityThreshold) {
                    this.velocityThreshold = context.getFloat(n2, this.velocityThreshold);
                    continue;
                }
                if (n2 != R.styleable.Carousel_carousel_infinite) continue;
                this.infiniteCarousel = context.getBoolean(n2, this.infiniteCarousel);
            }
            context.recycle();
        }
    }

    private void updateItems() {
        int n;
        Adapter adapter = this.mAdapter;
        if (adapter == null) {
            return;
        }
        if (this.mMotionLayout == null) {
            return;
        }
        if (adapter.count() == 0) {
            return;
        }
        int n2 = this.mList.size();
        for (int i = 0; i < n2; ++i) {
            View view = this.mList.get(i);
            int n3 = this.mIndex + i - this.startIndex;
            if (this.infiniteCarousel) {
                if (n3 < 0) {
                    n = this.emptyViewBehavior;
                    if (n != 4) {
                        this.updateViewVisibility(view, n);
                    } else {
                        this.updateViewVisibility(view, 0);
                    }
                    if (n3 % this.mAdapter.count() == 0) {
                        this.mAdapter.populate(view, 0);
                        continue;
                    }
                    adapter = this.mAdapter;
                    adapter.populate(view, adapter.count() + n3 % this.mAdapter.count());
                    continue;
                }
                if (n3 >= this.mAdapter.count()) {
                    if (n3 == this.mAdapter.count()) {
                        n = 0;
                    } else {
                        n = n3;
                        if (n3 > this.mAdapter.count()) {
                            n = n3 % this.mAdapter.count();
                        }
                    }
                    n3 = this.emptyViewBehavior;
                    if (n3 != 4) {
                        this.updateViewVisibility(view, n3);
                    } else {
                        this.updateViewVisibility(view, 0);
                    }
                    this.mAdapter.populate(view, n);
                    continue;
                }
                this.updateViewVisibility(view, 0);
                this.mAdapter.populate(view, n3);
                continue;
            }
            if (n3 < 0) {
                this.updateViewVisibility(view, this.emptyViewBehavior);
                continue;
            }
            if (n3 >= this.mAdapter.count()) {
                this.updateViewVisibility(view, this.emptyViewBehavior);
                continue;
            }
            this.updateViewVisibility(view, 0);
            this.mAdapter.populate(view, n3);
        }
        n = this.mTargetIndex;
        if (n != -1 && n != this.mIndex) {
            this.mMotionLayout.post(new Carousel$$ExternalSyntheticLambda0(this));
        } else if (n == this.mIndex) {
            this.mTargetIndex = -1;
        }
        if (this.backwardTransition != -1 && this.forwardTransition != -1) {
            if (this.infiniteCarousel) {
                return;
            }
            n = this.mAdapter.count();
            if (this.mIndex == 0) {
                this.enableTransition(this.backwardTransition, false);
            } else {
                this.enableTransition(this.backwardTransition, true);
                this.mMotionLayout.setTransition(this.backwardTransition);
            }
            if (this.mIndex == n - 1) {
                this.enableTransition(this.forwardTransition, false);
            } else {
                this.enableTransition(this.forwardTransition, true);
                this.mMotionLayout.setTransition(this.forwardTransition);
            }
            return;
        }
        Log.w((String)TAG, (String)"No backward or forward transitions defined for Carousel!");
    }

    private boolean updateViewVisibility(int n, View view, int n2) {
        Object object = this.mMotionLayout.getConstraintSet(n);
        if (object == null) {
            return false;
        }
        if ((object = ((ConstraintSet)object).getConstraint(view.getId())) == null) {
            return false;
        }
        ((ConstraintSet.Constraint)object).propertySet.mVisibilityMode = 1;
        view.setVisibility(n2);
        return true;
    }

    private boolean updateViewVisibility(View view, int n) {
        Object object = this.mMotionLayout;
        if (object == null) {
            return false;
        }
        object = ((MotionLayout)object).getConstraintSetIds();
        boolean bl = false;
        for (int i = 0; i < ((Object)object).length; ++i) {
            bl |= this.updateViewVisibility((int)object[i], view, n);
        }
        return bl;
    }

    public int getCount() {
        Adapter adapter = this.mAdapter;
        if (adapter != null) {
            return adapter.count();
        }
        return 0;
    }

    public int getCurrentIndex() {
        return this.mIndex;
    }

    public void jumpToIndex(int n) {
        this.mIndex = Math.max(0, Math.min(this.getCount() - 1, n));
        this.refresh();
    }

    public /* synthetic */ void lambda$updateItems$0$androidx-constraintlayout-helper-widget-Carousel() {
        this.mMotionLayout.setTransitionDuration(this.mAnimateTargetDelay);
        if (this.mTargetIndex < this.mIndex) {
            this.mMotionLayout.transitionToState(this.previousState, this.mAnimateTargetDelay);
        } else {
            this.mMotionLayout.transitionToState(this.nextState, this.mAnimateTargetDelay);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getParent() instanceof MotionLayout) {
            Object object;
            MotionLayout motionLayout = (MotionLayout)this.getParent();
            for (int i = 0; i < this.mCount; ++i) {
                int n = this.mIds[i];
                object = motionLayout.getViewById(n);
                if (this.firstViewReference == n) {
                    this.startIndex = i;
                }
                this.mList.add((View)object);
            }
            this.mMotionLayout = motionLayout;
            if (this.touchUpMode == 2) {
                object = motionLayout.getTransition(this.forwardTransition);
                if (object != null) {
                    ((MotionScene.Transition)object).setOnTouchUp(5);
                }
                if ((object = this.mMotionLayout.getTransition(this.backwardTransition)) != null) {
                    ((MotionScene.Transition)object).setOnTouchUp(5);
                }
            }
            this.updateItems();
        }
    }

    @Override
    public void onTransitionChange(MotionLayout motionLayout, int n, int n2, float f) {
        this.mLastStartId = n;
    }

    @Override
    public void onTransitionCompleted(MotionLayout motionLayout, int n) {
        int n2;
        this.mPreviousIndex = n2 = this.mIndex;
        if (n == this.nextState) {
            this.mIndex = n2 + 1;
        } else if (n == this.previousState) {
            this.mIndex = n2 - 1;
        }
        if (this.infiniteCarousel) {
            if (this.mIndex >= this.mAdapter.count()) {
                this.mIndex = 0;
            }
            if (this.mIndex < 0) {
                this.mIndex = this.mAdapter.count() - 1;
            }
        } else {
            if (this.mIndex >= this.mAdapter.count()) {
                this.mIndex = this.mAdapter.count() - 1;
            }
            if (this.mIndex < 0) {
                this.mIndex = 0;
            }
        }
        if (this.mPreviousIndex != this.mIndex) {
            this.mMotionLayout.post(this.mUpdateRunnable);
        }
    }

    public void refresh() {
        int n = this.mList.size();
        for (int i = 0; i < n; ++i) {
            View view = this.mList.get(i);
            if (this.mAdapter.count() == 0) {
                this.updateViewVisibility(view, this.emptyViewBehavior);
                continue;
            }
            this.updateViewVisibility(view, 0);
        }
        this.mMotionLayout.rebuildScene();
        this.updateItems();
    }

    public void setAdapter(Adapter adapter) {
        this.mAdapter = adapter;
    }

    public void transitionToIndex(int n, int n2) {
        this.mTargetIndex = Math.max(0, Math.min(this.getCount() - 1, n));
        this.mAnimateTargetDelay = n2 = Math.max(0, n2);
        this.mMotionLayout.setTransitionDuration(n2);
        if (n < this.mIndex) {
            this.mMotionLayout.transitionToState(this.previousState, this.mAnimateTargetDelay);
        } else {
            this.mMotionLayout.transitionToState(this.nextState, this.mAnimateTargetDelay);
        }
    }

    public static interface Adapter {
        public int count();

        public void onNewItem(int var1);

        public void populate(View var1, int var2);
    }
}

