/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import androidx.constraintlayout.widget.VirtualLayout;
import java.util.Arrays;

public class CircularFlow
extends VirtualLayout {
    private static float DEFAULT_ANGLE = 0.0f;
    private static int DEFAULT_RADIUS = 0;
    private static final String TAG = "CircularFlow";
    private float[] mAngles;
    ConstraintLayout mContainer;
    private int mCountAngle;
    private int mCountRadius;
    private int[] mRadius;
    private String mReferenceAngles;
    private Float mReferenceDefaultAngle;
    private Integer mReferenceDefaultRadius;
    private String mReferenceRadius;
    int mViewCenter;

    public CircularFlow(Context context) {
        super(context);
    }

    public CircularFlow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public CircularFlow(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    private void addAngle(String string2) {
        if (string2 != null && string2.length() != 0) {
            if (this.myContext == null) {
                return;
            }
            float[] fArray = this.mAngles;
            if (fArray == null) {
                return;
            }
            if (this.mCountAngle + 1 > fArray.length) {
                this.mAngles = Arrays.copyOf(fArray, fArray.length + 1);
            }
            this.mAngles[this.mCountAngle] = Integer.parseInt(string2);
            ++this.mCountAngle;
        }
    }

    private void addRadius(String string2) {
        if (string2 != null && string2.length() != 0) {
            if (this.myContext == null) {
                return;
            }
            int[] nArray = this.mRadius;
            if (nArray == null) {
                return;
            }
            if (this.mCountRadius + 1 > nArray.length) {
                this.mRadius = Arrays.copyOf(nArray, nArray.length + 1);
            }
            this.mRadius[this.mCountRadius] = (int)((float)Integer.parseInt(string2) * this.myContext.getResources().getDisplayMetrics().density);
            ++this.mCountRadius;
        }
    }

    private void anchorReferences() {
        this.mContainer = (ConstraintLayout)this.getParent();
        for (int i = 0; i < this.mCount; ++i) {
            View view = this.mContainer.getViewById(this.mIds[i]);
            if (view == null) continue;
            int n = DEFAULT_RADIUS;
            float f = DEFAULT_ANGLE;
            Object object = this.mRadius;
            if (object != null && i < ((int[])object).length) {
                n = object[i];
            } else {
                object = this.mReferenceDefaultRadius;
                if (object != null && object.intValue() != -1) {
                    ++this.mCountRadius;
                    if (this.mRadius == null) {
                        this.mRadius = new int[1];
                    }
                    object = this.getRadius();
                    this.mRadius = object;
                    object[this.mCountRadius - 1] = n;
                } else {
                    object = new StringBuilder();
                    object.append("Added radius to view with id: ");
                    object.append((String)this.mMap.get(view.getId()));
                    Log.e((String)TAG, (String)object.toString());
                }
            }
            object = this.mAngles;
            if (object != null && i < ((int[])object).length) {
                f = object[i];
            } else {
                object = this.mReferenceDefaultAngle;
                if (object != null && object.floatValue() != -1.0f) {
                    ++this.mCountAngle;
                    if (this.mAngles == null) {
                        this.mAngles = new float[1];
                    }
                    object = this.getAngles();
                    this.mAngles = object;
                    object[this.mCountAngle - 1] = f;
                } else {
                    object = new StringBuilder();
                    object.append("Added angle to view with id: ");
                    object.append((String)this.mMap.get(view.getId()));
                    Log.e((String)TAG, (String)object.toString());
                }
            }
            object = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            object.circleAngle = f;
            object.circleConstraint = this.mViewCenter;
            object.circleRadius = n;
            view.setLayoutParams((ViewGroup.LayoutParams)object);
        }
        this.applyLayoutFeatures();
    }

    private float[] removeAngle(float[] fArray, int n) {
        float[] fArray2 = fArray;
        if (fArray != null) {
            fArray2 = fArray;
            if (n >= 0) {
                fArray2 = n >= this.mCountAngle ? fArray : CircularFlow.removeElementFromArray(fArray, n);
            }
        }
        return fArray2;
    }

    public static float[] removeElementFromArray(float[] fArray, int n) {
        float[] fArray2 = new float[fArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (i == n) continue;
            fArray2[n2] = fArray[i];
            ++n2;
        }
        return fArray2;
    }

    public static int[] removeElementFromArray(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == n) continue;
            nArray2[n2] = nArray[i];
            ++n2;
        }
        return nArray2;
    }

    private int[] removeRadius(int[] nArray, int n) {
        int[] nArray2 = nArray;
        if (nArray != null) {
            nArray2 = nArray;
            if (n >= 0) {
                nArray2 = n >= this.mCountRadius ? nArray : CircularFlow.removeElementFromArray(nArray, n);
            }
        }
        return nArray2;
    }

    private void setAngles(String string2) {
        if (string2 == null) {
            return;
        }
        int n = 0;
        this.mCountAngle = 0;
        while (true) {
            int n2;
            if ((n2 = string2.indexOf(44, n)) == -1) {
                this.addAngle(string2.substring(n).trim());
                return;
            }
            this.addAngle(string2.substring(n, n2).trim());
            n = n2 + 1;
        }
    }

    private void setRadius(String string2) {
        if (string2 == null) {
            return;
        }
        int n = 0;
        this.mCountRadius = 0;
        while (true) {
            int n2;
            if ((n2 = string2.indexOf(44, n)) == -1) {
                this.addRadius(string2.substring(n).trim());
                return;
            }
            this.addRadius(string2.substring(n, n2).trim());
            n = n2 + 1;
        }
    }

    public void addViewToCircularFlow(View object, int n, float f) {
        if (this.containsId(object.getId())) {
            return;
        }
        this.addView((View)object);
        ++this.mCountAngle;
        object = this.getAngles();
        this.mAngles = (float[])object;
        object[this.mCountAngle - 1] = (View)f;
        ++this.mCountRadius;
        object = this.getRadius();
        this.mRadius = (int[])object;
        object[this.mCountRadius - 1] = (View)((int)((float)n * this.myContext.getResources().getDisplayMetrics().density));
        this.anchorReferences();
    }

    public float[] getAngles() {
        return Arrays.copyOf(this.mAngles, this.mCountAngle);
    }

    public int[] getRadius() {
        return Arrays.copyOf(this.mRadius, this.mCountRadius);
    }

    @Override
    protected void init(AttributeSet attributeSet) {
        super.init(attributeSet);
        if (attributeSet != null) {
            attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ConstraintLayout_Layout);
            int n = attributeSet.getIndexCount();
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2 = attributeSet.getIndex(i);
                if (n2 == R.styleable.ConstraintLayout_Layout_circularflow_viewCenter) {
                    this.mViewCenter = attributeSet.getResourceId(n2, 0);
                    continue;
                }
                if (n2 == R.styleable.ConstraintLayout_Layout_circularflow_angles) {
                    object = attributeSet.getString(n2);
                    this.mReferenceAngles = object;
                    this.setAngles((String)object);
                    continue;
                }
                if (n2 == R.styleable.ConstraintLayout_Layout_circularflow_radiusInDP) {
                    object = attributeSet.getString(n2);
                    this.mReferenceRadius = object;
                    this.setRadius((String)object);
                    continue;
                }
                if (n2 == R.styleable.ConstraintLayout_Layout_circularflow_defaultAngle) {
                    this.mReferenceDefaultAngle = object = Float.valueOf(attributeSet.getFloat(n2, DEFAULT_ANGLE));
                    this.setDefaultAngle(((Float)object).floatValue());
                    continue;
                }
                if (n2 != R.styleable.ConstraintLayout_Layout_circularflow_defaultRadius) continue;
                this.mReferenceDefaultRadius = object = Integer.valueOf(attributeSet.getDimensionPixelSize(n2, DEFAULT_RADIUS));
                this.setDefaultRadius((Integer)object);
            }
            attributeSet.recycle();
        }
    }

    public boolean isUpdatable(View view) {
        boolean bl = this.containsId(view.getId());
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        if (this.indexFromId(view.getId()) != -1) {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Object object = this.mReferenceAngles;
        if (object != null) {
            this.mAngles = new float[1];
            this.setAngles((String)object);
        }
        if ((object = this.mReferenceRadius) != null) {
            this.mRadius = new int[1];
            this.setRadius((String)object);
        }
        if ((object = this.mReferenceDefaultAngle) != null) {
            this.setDefaultAngle(((Float)object).floatValue());
        }
        if ((object = this.mReferenceDefaultRadius) != null) {
            this.setDefaultRadius((Integer)object);
        }
        this.anchorReferences();
    }

    @Override
    public int removeView(View object) {
        int n = super.removeView((View)object);
        if (n == -1) {
            return n;
        }
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone(this.mContainer);
        constraintSet.clear(object.getId(), 8);
        constraintSet.applyTo(this.mContainer);
        object = this.mAngles;
        if (n < ((View)object).length) {
            this.mAngles = this.removeAngle((float[])object, n);
            --this.mCountAngle;
        }
        if (n < ((View)(object = (Object)this.mRadius)).length) {
            this.mRadius = this.removeRadius((int[])object, n);
            --this.mCountRadius;
        }
        this.anchorReferences();
        return n;
    }

    public void setDefaultAngle(float f) {
        DEFAULT_ANGLE = f;
    }

    public void setDefaultRadius(int n) {
        DEFAULT_RADIUS = n;
    }

    public void updateAngle(View object, float f) {
        if (!this.isUpdatable((View)object)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("It was not possible to update angle to view with id: ");
            stringBuilder.append(object.getId());
            Log.e((String)TAG, (String)stringBuilder.toString());
            return;
        }
        int n = this.indexFromId(object.getId());
        if (n > this.mAngles.length) {
            return;
        }
        object = this.getAngles();
        this.mAngles = (float[])object;
        object[n] = (View)f;
        this.anchorReferences();
    }

    public void updateRadius(View object, int n) {
        if (!this.isUpdatable((View)object)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("It was not possible to update radius to view with id: ");
            stringBuilder.append(object.getId());
            Log.e((String)TAG, (String)stringBuilder.toString());
            return;
        }
        int n2 = this.indexFromId(object.getId());
        if (n2 > this.mRadius.length) {
            return;
        }
        object = this.getRadius();
        this.mRadius = (int[])object;
        object[n2] = (View)((int)((float)n * this.myContext.getResources().getDisplayMetrics().density));
        this.anchorReferences();
    }

    public void updateReference(View object, int n, float f) {
        if (!this.isUpdatable((View)object)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("It was not possible to update radius and angle to view with id: ");
            stringBuilder.append(object.getId());
            Log.e((String)TAG, (String)stringBuilder.toString());
            return;
        }
        int n2 = this.indexFromId(object.getId());
        if (this.getAngles().length > n2) {
            object = this.getAngles();
            this.mAngles = (float[])object;
            object[n2] = (View)f;
        }
        if (this.getRadius().length > n2) {
            object = this.getRadius();
            this.mRadius = (int[])object;
            object[n2] = (View)((int)((float)n * this.myContext.getResources().getDisplayMetrics().density));
        }
        this.anchorReferences();
    }
}

