/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.KeyAttributes;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionHelper;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;

public class MotionEffect
extends MotionHelper {
    public static final int AUTO = -1;
    public static final int EAST = 2;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final String TAG = "FadeMove";
    private static final int UNSET = -1;
    public static final int WEST = 3;
    private int fadeMove = -1;
    private float motionEffectAlpha = 0.1f;
    private int motionEffectEnd = 50;
    private int motionEffectStart = 49;
    private boolean motionEffectStrictMove = true;
    private int motionEffectTranslationX = 0;
    private int motionEffectTranslationY = 0;
    private int viewTransitionId = -1;

    public MotionEffect(Context context) {
        super(context);
    }

    public MotionEffect(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public MotionEffect(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            int n;
            context = context.obtainStyledAttributes(attributeSet, R.styleable.MotionEffect);
            int n2 = context.getIndexCount();
            for (n = 0; n < n2; ++n) {
                int n3 = context.getIndex(n);
                if (n3 == R.styleable.MotionEffect_motionEffect_start) {
                    this.motionEffectStart = n3 = context.getInt(n3, this.motionEffectStart);
                    this.motionEffectStart = Math.max(Math.min(n3, 99), 0);
                    continue;
                }
                if (n3 == R.styleable.MotionEffect_motionEffect_end) {
                    this.motionEffectEnd = n3 = context.getInt(n3, this.motionEffectEnd);
                    this.motionEffectEnd = Math.max(Math.min(n3, 99), 0);
                    continue;
                }
                if (n3 == R.styleable.MotionEffect_motionEffect_translationX) {
                    this.motionEffectTranslationX = context.getDimensionPixelOffset(n3, this.motionEffectTranslationX);
                    continue;
                }
                if (n3 == R.styleable.MotionEffect_motionEffect_translationY) {
                    this.motionEffectTranslationY = context.getDimensionPixelOffset(n3, this.motionEffectTranslationY);
                    continue;
                }
                if (n3 == R.styleable.MotionEffect_motionEffect_alpha) {
                    this.motionEffectAlpha = context.getFloat(n3, this.motionEffectAlpha);
                    continue;
                }
                if (n3 == R.styleable.MotionEffect_motionEffect_move) {
                    this.fadeMove = context.getInt(n3, this.fadeMove);
                    continue;
                }
                if (n3 == R.styleable.MotionEffect_motionEffect_strict) {
                    this.motionEffectStrictMove = context.getBoolean(n3, this.motionEffectStrictMove);
                    continue;
                }
                if (n3 != R.styleable.MotionEffect_motionEffect_viewTransition) continue;
                this.viewTransitionId = context.getResourceId(n3, this.viewTransitionId);
            }
            n = this.motionEffectStart;
            n2 = this.motionEffectEnd;
            if (n == n2) {
                if (n > 0) {
                    this.motionEffectStart = n - 1;
                } else {
                    this.motionEffectEnd = n2 + 1;
                }
            }
            context.recycle();
        }
    }

    @Override
    public boolean isDecorator() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPreSetup(MotionLayout object, HashMap<View, MotionController> hashMap) {
        int n;
        float f;
        float f2;
        MotionController motionController;
        KeyAttributes keyAttributes;
        KeyAttributes keyAttributes2;
        KeyAttributes keyAttributes3;
        View[] viewArray = this.getViews((ConstraintLayout)this.getParent());
        if (viewArray == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append(Debug.getLoc());
            ((StringBuilder)object).append(" views = null");
            Log.v((String)TAG, (String)((StringBuilder)object).toString());
            return;
        }
        KeyAttributes keyAttributes4 = new KeyAttributes();
        KeyAttributes keyAttributes5 = new KeyAttributes();
        keyAttributes4.setValue("alpha", Float.valueOf(this.motionEffectAlpha));
        keyAttributes5.setValue("alpha", Float.valueOf(this.motionEffectAlpha));
        keyAttributes4.setFramePosition(this.motionEffectStart);
        keyAttributes5.setFramePosition(this.motionEffectEnd);
        KeyPosition keyPosition = new KeyPosition();
        keyPosition.setFramePosition(this.motionEffectStart);
        keyPosition.setType(0);
        keyPosition.setValue("percentX", 0);
        keyPosition.setValue("percentY", 0);
        KeyPosition keyPosition2 = new KeyPosition();
        keyPosition2.setFramePosition(this.motionEffectEnd);
        keyPosition2.setType(0);
        keyPosition2.setValue("percentX", 1);
        keyPosition2.setValue("percentY", 1);
        int n2 = this.motionEffectTranslationX;
        KeyAttributes keyAttributes6 = null;
        if (n2 > 0) {
            keyAttributes3 = new KeyAttributes();
            keyAttributes2 = new KeyAttributes();
            keyAttributes3.setValue("translationX", this.motionEffectTranslationX);
            keyAttributes3.setFramePosition(this.motionEffectEnd);
            keyAttributes2.setValue("translationX", 0);
            keyAttributes2.setFramePosition(this.motionEffectEnd - 1);
        } else {
            keyAttributes2 = keyAttributes3 = null;
        }
        if (this.motionEffectTranslationY > 0) {
            keyAttributes6 = new KeyAttributes();
            keyAttributes = new KeyAttributes();
            keyAttributes6.setValue("translationY", this.motionEffectTranslationY);
            keyAttributes6.setFramePosition(this.motionEffectEnd);
            keyAttributes.setValue("translationY", 0);
            keyAttributes.setFramePosition(this.motionEffectEnd - 1);
        } else {
            keyAttributes = null;
        }
        int n3 = n2 = this.fadeMove;
        if (n2 == -1) {
            int[] nArray = new int[4];
            for (n2 = 0; n2 < viewArray.length; ++n2) {
                motionController = hashMap.get(viewArray[n2]);
                if (motionController == null) continue;
                f2 = motionController.getFinalX() - motionController.getStartX();
                f = motionController.getFinalY() - motionController.getStartY();
                if (f < 0.0f) {
                    nArray[1] = nArray[1] + 1;
                }
                if (f > 0.0f) {
                    nArray[0] = nArray[0] + 1;
                }
                if (f2 > 0.0f) {
                    nArray[3] = nArray[3] + 1;
                }
                if (!(f2 < 0.0f)) continue;
                nArray[2] = nArray[2] + 1;
            }
            int n4 = nArray[0];
            n2 = 1;
            n = 0;
            while (true) {
                n3 = n;
                if (n2 >= 4) break;
                n3 = n4;
                if (n4 < nArray[n2]) {
                    n3 = nArray[n2];
                    n = n2;
                }
                ++n2;
                n4 = n3;
            }
        }
        n2 = 0;
        while (n2 < viewArray.length) {
            motionController = hashMap.get(viewArray[n2]);
            if (motionController != null) {
                f = motionController.getFinalX() - motionController.getStartX();
                f2 = motionController.getFinalY() - motionController.getStartY();
                n = (n3 == 0 ? f2 > 0.0f && (!this.motionEffectStrictMove || f == 0.0f) : (n3 == 1 ? f2 < 0.0f && (!this.motionEffectStrictMove || f == 0.0f) : (n3 == 2 ? f < 0.0f && (!this.motionEffectStrictMove || f2 == 0.0f) : n3 == 3 && f > 0.0f && (!this.motionEffectStrictMove || f2 == 0.0f)))) ? 0 : 1;
                if (n != 0) {
                    n = this.viewTransitionId;
                    if (n == -1) {
                        motionController.addKey(keyAttributes4);
                        motionController.addKey(keyAttributes5);
                        motionController.addKey(keyPosition);
                        motionController.addKey(keyPosition2);
                        if (this.motionEffectTranslationX > 0) {
                            motionController.addKey(keyAttributes3);
                            motionController.addKey(keyAttributes2);
                        }
                        if (this.motionEffectTranslationY > 0) {
                            motionController.addKey(keyAttributes6);
                            motionController.addKey(keyAttributes);
                        }
                    } else {
                        ((MotionLayout)object).applyViewTransition(n, motionController);
                    }
                }
            }
            ++n2;
        }
        return;
    }
}

