/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ViewOscillator
extends KeyCycleOscillator {
    private static final String TAG = "ViewOscillator";

    public static ViewOscillator makeSpline(String string2) {
        if (string2.startsWith("CUSTOM")) {
            return new CustomSet();
        }
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 156108012: {
                if (!string2.equals("waveOffset")) break;
                n = 13;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n = 12;
                break;
            }
            case 37232917: {
                if (!string2.equals("transitionPathRotate")) break;
                n = 11;
                break;
            }
            case -4379043: {
                if (!string2.equals("elevation")) break;
                n = 10;
                break;
            }
            case -40300674: {
                if (!string2.equals("rotation")) break;
                n = 9;
                break;
            }
            case -797520672: {
                if (!string2.equals("waveVariesBy")) break;
                n = 8;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n = 7;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n = 6;
                break;
            }
            case -1001078227: {
                if (!string2.equals("progress")) break;
                n = 5;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n = 4;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n = 3;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n = 2;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n = 1;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return null;
            }
            case 13: {
                return new AlphaSet();
            }
            case 12: {
                return new AlphaSet();
            }
            case 11: {
                return new PathRotateSet();
            }
            case 10: {
                return new ElevationSet();
            }
            case 9: {
                return new RotationSet();
            }
            case 8: {
                return new AlphaSet();
            }
            case 7: {
                return new ScaleYset();
            }
            case 6: {
                return new ScaleXset();
            }
            case 5: {
                return new ProgressSet();
            }
            case 4: {
                return new TranslationZset();
            }
            case 3: {
                return new TranslationYset();
            }
            case 2: {
                return new TranslationXset();
            }
            case 1: {
                return new RotationYset();
            }
            case 0: 
        }
        return new RotationXset();
    }

    public abstract void setProperty(View var1, float var2);

    static class AlphaSet
    extends ViewOscillator {
        AlphaSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setAlpha(this.get(f));
        }
    }

    static class CustomSet
    extends ViewOscillator {
        protected ConstraintAttribute mCustom;
        float[] value = new float[1];

        CustomSet() {
        }

        @Override
        protected void setCustom(Object object) {
            this.mCustom = (ConstraintAttribute)object;
        }

        @Override
        public void setProperty(View view, float f) {
            this.value[0] = this.get(f);
            CustomSupport.setInterpolatedValue(this.mCustom, view, this.value);
        }
    }

    static class ElevationSet
    extends ViewOscillator {
        ElevationSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(f));
            }
        }
    }

    public static class PathRotateSet
    extends ViewOscillator {
        public void setPathRotate(View view, float f, double d, double d2) {
            view.setRotation(this.get(f) + (float)Math.toDegrees(Math.atan2(d2, d)));
        }

        @Override
        public void setProperty(View view, float f) {
        }
    }

    static class ProgressSet
    extends ViewOscillator {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(f));
            } else {
                if (this.mNoMethod) {
                    return;
                }
                Method method = null;
                try {
                    Method method2;
                    method = method2 = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(f)));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Log.e((String)ViewOscillator.TAG, (String)"unable to setProgress", (Throwable)invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Log.e((String)ViewOscillator.TAG, (String)"unable to setProgress", (Throwable)illegalAccessException);
                    }
                }
            }
        }
    }

    static class RotationSet
    extends ViewOscillator {
        RotationSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setRotation(this.get(f));
        }
    }

    static class RotationXset
    extends ViewOscillator {
        RotationXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setRotationX(this.get(f));
        }
    }

    static class RotationYset
    extends ViewOscillator {
        RotationYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setRotationY(this.get(f));
        }
    }

    static class ScaleXset
    extends ViewOscillator {
        ScaleXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setScaleX(this.get(f));
        }
    }

    static class ScaleYset
    extends ViewOscillator {
        ScaleYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setScaleY(this.get(f));
        }
    }

    static class TranslationXset
    extends ViewOscillator {
        TranslationXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setTranslationX(this.get(f));
        }
    }

    static class TranslationYset
    extends ViewOscillator {
        TranslationYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setTranslationY(this.get(f));
        }
    }

    static class TranslationZset
    extends ViewOscillator {
        TranslationZset() {
        }

        @Override
        public void setProperty(View view, float f) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(f));
            }
        }
    }
}

