/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ViewSpline
extends SplineSet {
    private static final String TAG = "ViewSpline";

    public static ViewSpline makeCustomSpline(String string2, SparseArray<ConstraintAttribute> sparseArray) {
        return new CustomSet(string2, sparseArray);
    }

    public static ViewSpline makeSpline(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 156108012: {
                if (!string2.equals("waveOffset")) break;
                n2 = 15;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 14;
                break;
            }
            case 37232917: {
                if (!string2.equals("transitionPathRotate")) break;
                n2 = 13;
                break;
            }
            case -4379043: {
                if (!string2.equals("elevation")) break;
                n2 = 12;
                break;
            }
            case -40300674: {
                if (!string2.equals("rotation")) break;
                n2 = 11;
                break;
            }
            case -760884509: {
                if (!string2.equals("transformPivotY")) break;
                n2 = 10;
                break;
            }
            case -760884510: {
                if (!string2.equals("transformPivotX")) break;
                n2 = 9;
                break;
            }
            case -797520672: {
                if (!string2.equals("waveVariesBy")) break;
                n2 = 8;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 7;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 6;
                break;
            }
            case -1001078227: {
                if (!string2.equals("progress")) break;
                n2 = 5;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 4;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 3;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 2;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 1;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return null;
            }
            case 15: {
                return new AlphaSet();
            }
            case 14: {
                return new AlphaSet();
            }
            case 13: {
                return new PathRotate();
            }
            case 12: {
                return new ElevationSet();
            }
            case 11: {
                return new RotationSet();
            }
            case 10: {
                return new PivotYset();
            }
            case 9: {
                return new PivotXset();
            }
            case 8: {
                return new AlphaSet();
            }
            case 7: {
                return new ScaleYset();
            }
            case 6: {
                return new ScaleXset();
            }
            case 5: {
                return new ProgressSet();
            }
            case 4: {
                return new TranslationZset();
            }
            case 3: {
                return new TranslationYset();
            }
            case 2: {
                return new TranslationXset();
            }
            case 1: {
                return new RotationYset();
            }
            case 0: 
        }
        return new RotationXset();
    }

    public abstract void setProperty(View var1, float var2);

    static class AlphaSet
    extends ViewSpline {
        AlphaSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setAlpha(this.get(f));
        }
    }

    public static class CustomSet
    extends ViewSpline {
        String mAttributeName;
        SparseArray<ConstraintAttribute> mConstraintAttributeList;
        float[] mTempValues;

        public CustomSet(String string2, SparseArray<ConstraintAttribute> sparseArray) {
            this.mAttributeName = string2.split(",")[1];
            this.mConstraintAttributeList = sparseArray;
        }

        @Override
        public void setPoint(int n, float f) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
        }

        public void setPoint(int n, ConstraintAttribute constraintAttribute) {
            this.mConstraintAttributeList.append(n, (Object)constraintAttribute);
        }

        @Override
        public void setProperty(View view, float f) {
            this.mCurveFit.getPos((double)f, this.mTempValues);
            CustomSupport.setInterpolatedValue((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0), view, this.mTempValues);
        }

        @Override
        public void setup(int n) {
            int n2 = this.mConstraintAttributeList.size();
            int n3 = ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).numberOfInterpolatedValues();
            double[] dArray = new double[n2];
            this.mTempValues = new float[n3];
            double[][] dArray2 = new double[n2][n3];
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.mConstraintAttributeList.keyAt(n3);
                Object object = (ConstraintAttribute)this.mConstraintAttributeList.valueAt(n3);
                dArray[n3] = (double)n4 * 0.01;
                ((ConstraintAttribute)object).getValuesToInterpolate(this.mTempValues);
                for (n4 = 0; n4 < ((Object)(object = (Object)this.mTempValues)).length; ++n4) {
                    dArray2[n3][n4] = (double)object[n4];
                }
            }
            this.mCurveFit = CurveFit.get(n, dArray, dArray2);
        }
    }

    static class ElevationSet
    extends ViewSpline {
        ElevationSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(f));
            }
        }
    }

    public static class PathRotate
    extends ViewSpline {
        public void setPathRotate(View view, float f, double d, double d2) {
            view.setRotation(this.get(f) + (float)Math.toDegrees(Math.atan2(d2, d)));
        }

        @Override
        public void setProperty(View view, float f) {
        }
    }

    static class PivotXset
    extends ViewSpline {
        PivotXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setPivotX(this.get(f));
        }
    }

    static class PivotYset
    extends ViewSpline {
        PivotYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setPivotY(this.get(f));
        }
    }

    static class ProgressSet
    extends ViewSpline {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(f));
            } else {
                if (this.mNoMethod) {
                    return;
                }
                Method method = null;
                try {
                    Method method2;
                    method = method2 = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(f)));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Log.e((String)ViewSpline.TAG, (String)"unable to setProgress", (Throwable)invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Log.e((String)ViewSpline.TAG, (String)"unable to setProgress", (Throwable)illegalAccessException);
                    }
                }
            }
        }
    }

    static class RotationSet
    extends ViewSpline {
        RotationSet() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setRotation(this.get(f));
        }
    }

    static class RotationXset
    extends ViewSpline {
        RotationXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setRotationX(this.get(f));
        }
    }

    static class RotationYset
    extends ViewSpline {
        RotationYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setRotationY(this.get(f));
        }
    }

    static class ScaleXset
    extends ViewSpline {
        ScaleXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setScaleX(this.get(f));
        }
    }

    static class ScaleYset
    extends ViewSpline {
        ScaleYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setScaleY(this.get(f));
        }
    }

    static class TranslationXset
    extends ViewSpline {
        TranslationXset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setTranslationX(this.get(f));
        }
    }

    static class TranslationYset
    extends ViewSpline {
        TranslationYset() {
        }

        @Override
        public void setProperty(View view, float f) {
            view.setTranslationY(this.get(f));
        }
    }

    static class TranslationZset
    extends ViewSpline {
        TranslationZset() {
        }

        @Override
        public void setProperty(View view, float f) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(f));
            }
        }
    }
}

