/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ViewTimeCycle
extends TimeCycleSplineSet {
    private static final String TAG = "ViewTimeCycle";

    public static ViewTimeCycle makeCustomSpline(String string2, SparseArray<ConstraintAttribute> sparseArray) {
        return new CustomSet(string2, sparseArray);
    }

    public static ViewTimeCycle makeSpline(String object, long l) {
        ((String)object).hashCode();
        int n = ((String)object).hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 92909918: {
                if (!((String)object).equals("alpha")) break;
                n2 = 11;
                break;
            }
            case 37232917: {
                if (!((String)object).equals("transitionPathRotate")) break;
                n2 = 10;
                break;
            }
            case -4379043: {
                if (!((String)object).equals("elevation")) break;
                n2 = 9;
                break;
            }
            case -40300674: {
                if (!((String)object).equals("rotation")) break;
                n2 = 8;
                break;
            }
            case -908189617: {
                if (!((String)object).equals("scaleY")) break;
                n2 = 7;
                break;
            }
            case -908189618: {
                if (!((String)object).equals("scaleX")) break;
                n2 = 6;
                break;
            }
            case -1001078227: {
                if (!((String)object).equals("progress")) break;
                n2 = 5;
                break;
            }
            case -1225497655: {
                if (!((String)object).equals("translationZ")) break;
                n2 = 4;
                break;
            }
            case -1225497656: {
                if (!((String)object).equals("translationY")) break;
                n2 = 3;
                break;
            }
            case -1225497657: {
                if (!((String)object).equals("translationX")) break;
                n2 = 2;
                break;
            }
            case -1249320805: {
                if (!((String)object).equals("rotationY")) break;
                n2 = 1;
                break;
            }
            case -1249320806: {
                if (!((String)object).equals("rotationX")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                return null;
            }
            case 11: {
                object = new AlphaSet();
                break;
            }
            case 10: {
                object = new PathRotate();
                break;
            }
            case 9: {
                object = new ElevationSet();
                break;
            }
            case 8: {
                object = new RotationSet();
                break;
            }
            case 7: {
                object = new ScaleYset();
                break;
            }
            case 6: {
                object = new ScaleXset();
                break;
            }
            case 5: {
                object = new ProgressSet();
                break;
            }
            case 4: {
                object = new TranslationZset();
                break;
            }
            case 3: {
                object = new TranslationYset();
                break;
            }
            case 2: {
                object = new TranslationXset();
                break;
            }
            case 1: {
                object = new RotationYset();
                break;
            }
            case 0: {
                object = new RotationXset();
            }
        }
        ((TimeCycleSplineSet)object).setStartTime(l);
        return object;
    }

    public float get(float f, long l, View view, KeyCache keyCache) {
        this.mCurveFit.getPos((double)f, this.mCache);
        f = this.mCache[1];
        float f2 = f - 0.0f;
        float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
        if (f3 == false) {
            this.mContinue = false;
            return this.mCache[2];
        }
        if (Float.isNaN(this.last_cycle)) {
            this.last_cycle = keyCache.getFloatValue(view, this.mType, 0);
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = 0.0f;
            }
        }
        long l2 = this.last_time;
        this.last_cycle = (float)(((double)this.last_cycle + (double)(l - l2) * 1.0E-9 * (double)f) % 1.0);
        keyCache.setFloatValue(view, this.mType, 0, this.last_cycle);
        this.last_time = l;
        float f4 = this.mCache[0];
        float f5 = this.calcWave(this.last_cycle);
        f = this.mCache[2];
        boolean bl = f4 != 0.0f || f3 != false;
        this.mContinue = bl;
        return f5 * f4 + f;
    }

    public abstract boolean setProperty(View var1, float var2, long var3, KeyCache var5);

    static class AlphaSet
    extends ViewTimeCycle {
        AlphaSet() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setAlpha(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    public static class CustomSet
    extends ViewTimeCycle {
        String mAttributeName;
        float[] mCache;
        SparseArray<ConstraintAttribute> mConstraintAttributeList;
        float[] mTempValues;
        SparseArray<float[]> mWaveProperties = new SparseArray();

        public CustomSet(String string2, SparseArray<ConstraintAttribute> sparseArray) {
            this.mAttributeName = string2.split(",")[1];
            this.mConstraintAttributeList = sparseArray;
        }

        @Override
        public void setPoint(int n, float f, float f2, int n2, float f3) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute,...)");
        }

        public void setPoint(int n, ConstraintAttribute constraintAttribute, float f, int n2, float f2) {
            this.mConstraintAttributeList.append(n, (Object)constraintAttribute);
            this.mWaveProperties.append(n, (Object)new float[]{f, f2});
            this.mWaveShape = Math.max(this.mWaveShape, n2);
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            this.mCurveFit.getPos((double)f, this.mTempValues);
            float[] fArray = this.mTempValues;
            float f2 = fArray[fArray.length - 2];
            float f3 = fArray[fArray.length - 1];
            long l2 = this.last_time;
            if (Float.isNaN(this.last_cycle)) {
                this.last_cycle = keyCache.getFloatValue(view, this.mAttributeName, 0);
                if (Float.isNaN(this.last_cycle)) {
                    this.last_cycle = 0.0f;
                }
            }
            this.last_cycle = (float)(((double)this.last_cycle + (double)(l - l2) * 1.0E-9 * (double)f2) % 1.0);
            this.last_time = l;
            f = this.calcWave(this.last_cycle);
            this.mContinue = false;
            for (int i = 0; i < this.mCache.length; ++i) {
                boolean bl = this.mContinue;
                boolean bl2 = (double)this.mTempValues[i] != 0.0;
                this.mContinue = bl | bl2;
                this.mCache[i] = this.mTempValues[i] * f + f3;
            }
            CustomSupport.setInterpolatedValue((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0), view, this.mCache);
            if (f2 != 0.0f) {
                this.mContinue = true;
            }
            return this.mContinue;
        }

        @Override
        public void setup(int n) {
            int n2 = this.mConstraintAttributeList.size();
            int n3 = ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).numberOfInterpolatedValues();
            double[] dArray = new double[n2];
            int n4 = n3 + 2;
            this.mTempValues = new float[n4];
            this.mCache = new float[n3];
            double[][] dArray2 = new double[n2][n4];
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = this.mConstraintAttributeList.keyAt(n4);
                Object object = (ConstraintAttribute)this.mConstraintAttributeList.valueAt(n4);
                float[] fArray = (float[])this.mWaveProperties.valueAt(n4);
                dArray[n4] = (double)n5 * 0.01;
                ((ConstraintAttribute)object).getValuesToInterpolate(this.mTempValues);
                for (n5 = 0; n5 < ((Object)(object = (Object)this.mTempValues)).length; ++n5) {
                    dArray2[n4][n5] = (double)object[n5];
                }
                dArray2[n4][n3] = fArray[0];
                dArray2[n4][n3 + 1] = fArray[1];
            }
            this.mCurveFit = CurveFit.get(n, dArray, dArray2);
        }
    }

    static class ElevationSet
    extends ViewTimeCycle {
        ElevationSet() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(f, l, view, keyCache));
            }
            return this.mContinue;
        }
    }

    public static class PathRotate
    extends ViewTimeCycle {
        public boolean setPathRotate(View view, KeyCache keyCache, float f, long l, double d, double d2) {
            view.setRotation(this.get(f, l, view, keyCache) + (float)Math.toDegrees(Math.atan2(d2, d)));
            return this.mContinue;
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            return this.mContinue;
        }
    }

    static class ProgressSet
    extends ViewTimeCycle {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(f, l, view, keyCache));
            } else {
                if (this.mNoMethod) {
                    return false;
                }
                Method method = null;
                try {
                    Method method2;
                    method = method2 = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(f, l, view, keyCache)));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Log.e((String)ViewTimeCycle.TAG, (String)"unable to setProgress", (Throwable)invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Log.e((String)ViewTimeCycle.TAG, (String)"unable to setProgress", (Throwable)illegalAccessException);
                    }
                }
            }
            return this.mContinue;
        }
    }

    static class RotationSet
    extends ViewTimeCycle {
        RotationSet() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setRotation(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class RotationXset
    extends ViewTimeCycle {
        RotationXset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setRotationX(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class RotationYset
    extends ViewTimeCycle {
        RotationYset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setRotationY(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class ScaleXset
    extends ViewTimeCycle {
        ScaleXset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setScaleX(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class ScaleYset
    extends ViewTimeCycle {
        ScaleYset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setScaleY(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class TranslationXset
    extends ViewTimeCycle {
        TranslationXset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setTranslationX(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class TranslationYset
    extends ViewTimeCycle {
        TranslationYset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            view.setTranslationY(this.get(f, l, view, keyCache));
            return this.mContinue;
        }
    }

    static class TranslationZset
    extends ViewTimeCycle {
        TranslationZset() {
        }

        @Override
        public boolean setProperty(View view, float f, long l, KeyCache keyCache) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(f, l, view, keyCache));
            }
            return this.mContinue;
        }
    }
}

